/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.apps.common;

import com.ws.utilities.Resources;
import com.ws.utilities.cli.CLICommand;
import com.ws.utilities.cli.CLIOption;
import com.ws.utilities.cli.CommandLine;
import com.ws.utilities.cli.PasswordField;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;

public class WSICommandLine
extends CommandLine {
    private static final String PROMPT_PASSWORD = "Enter your password: ";
    private static final String KEYSTORE_PROMPT_PASSWORD = "Enter your KeyStore password: ";
    private static final String BUNDLE = "com.ws.wbem.apps.common.WSICommandLine";
    private final Resources res = new Resources("com.ws.wbem.apps.common.WSICommandLine");

    public WSICommandLine(String name) {
        super(name);
        this.setCopyright(this.res.loadString("COPYRIGHT"));
    }

    private void addCommand(String opt) {
        String CMD = "CMD_";
        String DESC = "_DESC";
        String VAL = "_VALUE";
        String val = "";
        try {
            val = this.res.loadString("CMD_" + opt.toUpperCase() + "_VALUE");
        }
        catch (Exception e) {
            val = null;
        }
        CLICommand cOpt = new CLICommand(this.res.loadString("CMD_" + opt.toUpperCase()), this.res.loadString("CMD_" + opt.toUpperCase() + "_DESC"));
        if (val != null && val.length() != 0 && !val.equals(" ")) {
            cOpt.setValue(val);
        }
        super.addCommand(cOpt);
    }

    private void addOption(String opt) {
        String OPT = "OPT_";
        String val = "";
        try {
            val = this.res.loadString("OPT_" + opt.toUpperCase() + "_VALUE");
        }
        catch (Exception e) {
            val = null;
        }
        CLIOption cOpt = new CLIOption(opt, this.res.loadString("OPT_" + opt.toUpperCase()), val != null);
        if (val != null && val.length() != 0 && !val.equals(" ")) {
            cOpt.setValue(val);
        }
        super.addOption(cOpt);
    }

    public void displayVersion() {
        Package apiP;
        System.out.println(this.getProgramName());
        Package commonP = Package.getPackage("com.ws.wbem.apps.common");
        if (commonP != null) {
            String commonVersionValue = commonP.getImplementationVersion();
            String commonProductValue = commonP.getImplementationTitle();
            System.out.println(commonProductValue + " " + commonVersionValue);
            System.out.println();
        }
        if ((apiP = Package.getPackage("javax.wbem")) != null) {
            String apiProductValue = apiP.getImplementationTitle();
            String apiVersionValue = apiP.getImplementationVersion();
            System.out.println(apiProductValue + " " + apiVersionValue);
            System.out.println();
        }
        System.exit(0);
    }

    public Subject getSubject() {
        Subject s = new Subject();
        UserPrincipal principal = new UserPrincipal(this.getOptionValue("u"));
        PasswordCredential cred = new PasswordCredential(this.getOptionValue("p"));
        s.getPrincipals().add((Principal)principal);
        s.getPrivateCredentials().add(cred);
        return s;
    }

    public void initClientSettings(WBEMClient cc) {
        if (this.isOptionSelected("ph")) {
            System.setProperty("http.proxyHost", this.getOptionValue("ph"));
        }
        if (this.isOptionSelected("pp")) {
            System.setProperty("http.proxyPort", this.getOptionValue("pp"));
        }
        cc.setProperty("javax.wbem.client.log.console.enabled", this.getOptionValue("d"));
        cc.setProperty("javax.wbem.client.ciphers", this.getOptionValue("sc"));
        cc.setProperty("javax.wbem.client.trustStore", this.getOptionValue("tf"));
        cc.setProperty("javax.wbem.client.keyStore", this.getOptionValue("kf"));
        cc.setProperty("javax.wbem.client.keyStorePassword", this.getOptionValue("kp"));
    }

    @Override
    public void parse(String[] args) {
        char[] password;
        super.parse(args);
        if (this.isOptionSelected("h")) {
            this.displayHelp();
            System.exit(0);
        }
        if (this.isOptionSelected("v")) {
            this.displayVersion();
            System.exit(0);
        }
        if (this.isOptionSelected("tf") && this.isOptionSelected("kf") && !this.isOptionSelected("kp")) {
            password = null;
            try {
                password = PasswordField.getPassword(System.in, KEYSTORE_PROMPT_PASSWORD);
            }
            catch (IOException ioe) {
                password = null;
            }
            this.setOptionValue("kp", password == null ? null : String.valueOf(password));
        }
        if (this.isOptionSelected("u") && !this.isOptionSelected("p")) {
            password = null;
            try {
                password = PasswordField.getPassword(System.in, PROMPT_PASSWORD);
            }
            catch (IOException ioe) {
                password = null;
            }
            this.setOptionValue("p", password == null ? null : String.valueOf(password));
        }
        for (int i = 0; i < this.numCommands(); ++i) {
            if (!this.isCommandRequired(i) || this.isCommandSet(i)) continue;
            this.displayHelp();
            System.exit(-1);
        }
    }

    public void setCommands(String[] cmds) {
        for (String cmd : cmds) {
            this.addCommand(cmd);
        }
    }

    public void setOptions(String[] opts) {
        for (String opt : opts) {
            this.addOption(opt);
        }
    }
}

