/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import com.ws.wbem.client.adapter.common.TLSInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.wbem.WBEMException;

public class HTTPServer {
    private final HttpServer theServer;

    public HTTPServer(TLSInfo tlsInfo) throws IOException, WBEMException {
        if (null != tlsInfo) {
            this.theServer = HttpsServer.create();
            HTTPTLSConfigurator config = new HTTPTLSConfigurator(tlsInfo);
            config.setConfigurator();
        } else {
            this.theServer = HttpServer.create();
        }
        this.theServer.setExecutor(this.createExecutor());
    }

    private Executor createExecutor() {
        int maxThreads;
        try {
            boolean override = Boolean.getBoolean("com.ws.jserver.debug.allowthreadoverride");
            maxThreads = Integer.parseInt(System.getProperty("com.ws.jserver.requestthreads", "100"));
            if (!override && maxThreads < 100) {
                maxThreads = 100;
            }
        }
        catch (NumberFormatException nfe) {
            maxThreads = 100;
        }
        return new ThreadPoolExecutor(1, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public int getPort() {
        InetSocketAddress addr = this.theServer.getAddress();
        return addr.getPort();
    }

    public void setURLHandler(String path, HttpHandler handler, Authenticator auth) {
        HttpContext ctx = this.theServer.createContext(path, handler);
        if (null != auth) {
            ctx.setAuthenticator(auth);
        }
    }

    public void start(String bindTo, int port) throws IllegalArgumentException, IOException {
        if (port < 0) {
            throw new IllegalArgumentException("Port value must be greater then -1");
        }
        InetSocketAddress serverData = null != bindTo ? new InetSocketAddress(bindTo, port) : new InetSocketAddress(port);
        this.theServer.bind(serverData, 1);
        this.theServer.start();
    }

    public void stop() {
        this.theServer.stop(1);
        ThreadPoolExecutor exec = (ThreadPoolExecutor)this.theServer.getExecutor();
        exec.shutdownNow();
    }

    private class HTTPTLSConfigurator {
        private final TLSInfo tlsInfo;

        private HTTPTLSConfigurator(TLSInfo info) {
            this.tlsInfo = info;
        }

        private void setConfigurator() throws IOException, WBEMException {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            String factoryInstance = KeyManagerFactory.getDefaultAlgorithm();
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(factoryInstance);
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(this.tlsInfo.getKeystoreFile()), null);
                kmf.init(ks, this.tlsInfo.getKeystorePassword().toCharArray());
                keyManagerArray = kmf.getKeyManagers();
            }
            catch (Exception e) {
                throw new IOException("Could not load keystore file \"" + this.tlsInfo.getKeystoreFile() + "\" or keystore " + "password is invalid.");
            }
            try {
                if (this.tlsInfo.getTruststoreFile() != null) {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(factoryInstance);
                    KeyStore ts = KeyStore.getInstance("JKS");
                    ts.load(new FileInputStream(this.tlsInfo.getTruststoreFile()), null);
                    tmf.init(ts);
                    trustManagerArray = tmf.getTrustManagers();
                }
            }
            catch (Exception e) {
                throw new IOException("Could not load truststore file \"" + this.tlsInfo.getTruststoreFile() + "\".");
            }
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(keyManagerArray, trustManagerArray, null);
                ((HttpsServer)HTTPServer.this.theServer).setHttpsConfigurator(new HttpsConfigurator(ctx){

                    @Override
                    public void configure(HttpsParameters params) {
                        String[] protocols;
                        String protocolStr;
                        SSLParameters sslparams = this.getSSLContext().getDefaultSSLParameters();
                        sslparams.setNeedClientAuth(HTTPTLSConfigurator.this.tlsInfo.isAuthRequired());
                        if (HTTPTLSConfigurator.this.tlsInfo.isAuthRequired() && HTTPTLSConfigurator.this.tlsInfo.needToValidateCertHostName()) {
                            sslparams.setEndpointIdentificationAlgorithm("HTTPS");
                        }
                        if (null != (protocolStr = System.getProperty("https.protocols")) && (protocols = protocolStr.split(",")).length > 0) {
                            sslparams.setProtocols(protocols);
                        }
                        sslparams.setCipherSuites(HTTPTLSConfigurator.this.tlsInfo.getCiphers());
                        params.setSSLParameters(sslparams);
                    }
                });
            }
            catch (Throwable t) {
                throw new WBEMException(1, "Unable to get SSLContext", null, t);
            }
        }
    }
}

