/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.util.Map;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseAccessRequestPacket;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseChapPasswordAttr;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadUtils;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusAttribute;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseUserNameAttr;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseChapRequest
extends SJbaseAccessRequestPacket {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseChapRequest";

    public static SJbaseAccessRequestPacket create(byte[] userId, byte[] password, Map<String, String> attributes) {
        String method = "create";
        logger.info(module, method, "", "start");
        SJbaseChapRequest reqPacket = new SJbaseChapRequest();
        SJbaseRadiusAttribute userNameAttr = SJbaseUserNameAttr.create(userId);
        byte[] chapChallenge = SJbaseRadUtils.generateCHAPChallenge();
        SJbaseChapPasswordAttr chapPasswordAttr = SJbaseChapPasswordAttr.create(password, chapChallenge);
        reqPacket.putAttribute(userNameAttr);
        reqPacket.putAttribute(chapPasswordAttr);
        reqPacket.putAttributes(attributes);
        reqPacket.setAuthenticator(chapChallenge);
        logger.info(module, method, "", "end");
        return reqPacket;
    }
}

