/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import sanproject.sn2.base.authentication.def.SJbaseHcsConst;
import sanproject.sn2.base.authentication.def.SJbaseRole;
import sanproject.sn2.base.authentication.def.SJbaseUserGroup;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSAuthUtility;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSCVAEInfoUtility;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSHttpsManager;
import sanproject.sn2.base.authentication.plugin.def.SJbaseBuiltIn;
import sanproject.sn2.base.authentication.plugin.def.SJbaseHcsDeviceType;
import sanproject.sn2.base.authentication.plugin.def.SJbaseHcsKind;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcTRLogUty;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyException;
import sanproject.sn2.generated.hcs.AclPermission;
import sanproject.sn2.generated.hcs.AclResourceGroup;
import sanproject.sn2.generated.hcs.AclUser;
import sanproject.sn2.generated.hcs.EchoCommand;
import sanproject.sn2.generated.hcs.HiCommandServerMessage;
import sanproject.sn2.generated.hcs.Response;
import sanproject.sn2.generated.hcs.ResultList;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;
import sanproject.sn2.sn2com.utility.SJsncVersionCheckUty;

public class SJbaseHCSAuthentication
implements SJbaseAuthenticationModulePluginInterface {
    public static final String AUTHNAME_HCS = "AuthExternalHCS";
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSAuthentication.class.getSimpleName();
    private final SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger("SN_HCS.log");
    private HashMap<String, Object> HcsObject = null;
    private String userName = null;
    private String password = null;
    private String[] groupIDs = null;
    private String[] roleIDs = null;
    private boolean[] resourceGrpMap = null;
    private boolean allRsg = false;
    private String globalSessionID = null;
    private Map<String, Object> hcsInfoMap = null;
    private List<AclResourceGroup> aclResourceGroupList = null;

    @Override
    public int authentication(String szUserName, String szPassword) {
        String LOG_SUBTITLE = "authentication";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authentication", "Start. - szUserName:" + szUserName);
        this.userName = szUserName;
        int result = 6;
        if (this.authExec(szUserName, szPassword)) {
            result = 0;
        }
        this.globalSessionID = UUID.randomUUID().toString().replaceAll("-", "");
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authentication", "End. - ret:" + result);
        return result;
    }

    @Override
    public String getUserName() {
        String LOG_SUBTITLE = "getUserName";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUserName", "Start.");
        String ret = this.userName;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUserName", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String[] getGroupID() {
        String LOG_SUBTITLE = "getGroupID";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getGroupID", "Start.");
        String[] ret = this.groupIDs;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getGroupID", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String[] getRoleID() {
        String LOG_SUBTITLE = "getRoleID";
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRoleID", "Start.");
        String[] ret = this.roleIDs;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRoleID", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        String LOG_SUBTITLE = "getResouecrGrpMap";
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getResouecrGrpMap", "Start.");
        boolean[] ret = this.resourceGrpMap;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getResouecrGrpMap", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public boolean isAllRSG() {
        String LOG_SUBTITLE = "isAllRSG";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "isAllRSG", "Start.");
        boolean ret = this.allRsg;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "isAllRSG", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String getSessionID() {
        String LOG_SUBTITLE = "getSessionID";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionID", "Start.");
        String ret = this.globalSessionID;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionID", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        String LOG_SUBTITLE = "getAuthSystemName";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthSystemName", "Start. - szSystem:" + szSystem);
        String authSystemName = null;
        authSystemName = AUTHNAME_HCS;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthSystemName", "End. - ret:" + authSystemName);
        return authSystemName;
    }

    @Override
    public HashMap<String, Object> getAuthObject() {
        String LOG_SUBTITLE = "getAuthObject";
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAuthObject", "Start.");
        HashMap<String, Object> retHcsObject = this.HcsObject;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAuthObject", "End.");
        return retHcsObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authExec(String user, String password) {
        String LOG_SUBTITLE = "authExec";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authExec", "Start. - user:" + user);
        boolean result = false;
        HttpURLConnection urlconn = null;
        try {
            this.hcsInfoMap = this.getHcsInfo();
            if (null == this.hcsInfoMap) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "hcsInfoMap is null.");
                boolean bl = result;
                return bl;
            }
            String ipAddress = SJbaseHCSAuthUtility.getHcsIp(this.hcsInfoMap);
            boolean hcsEnable = SJbaseHCSCVAEInfoUtility.checkEnabled(ipAddress);
            if (!hcsEnable) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "HCS is not enable. - hcsEnable:" + hcsEnable);
                boolean bl = result;
                return bl;
            }
            String urlStr = this.getHcsAuthUrl();
            if (null == urlStr) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "urlStr is null.");
                boolean bl = result;
                return bl;
            }
            String requestContents = SJbaseHCSAuthUtility.createRequestContents(user);
            if (null == requestContents) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "requestContents is null.");
                boolean bl = result;
                return bl;
            }
            SJbaseHCSHttpsManager httpsMgr = new SJbaseHCSHttpsManager();
            httpsMgr.init();
            String readTimeout = SJbaseHCSAuthUtility.getHcsReadTimeout(this.hcsInfoMap);
            try {
                urlconn = SJbaseHCSAuthUtility.connect(urlStr, requestContents, user, password, readTimeout);
            }
            catch (Exception ex) {
                String hcsIp = SJbaseHCSAuthUtility.getHcsIp(this.hcsInfoMap);
                String hcsPort = SJbaseHCSAuthUtility.getHcsPort(this.hcsInfoMap);
                String suminfo = String.format("Warning : Failed to connection. IP address=%s Port=%s.", hcsIp, hcsPort);
                SJcTRLogUty.error("External Authenticator", "TREXAU000009", suminfo);
                throw ex;
            }
            SJbaseHCSAuthUtility.send(urlconn, requestContents);
            HiCommandServerMessage responseMessage = SJbaseHCSAuthUtility.receive(urlconn);
            urlconn.disconnect();
            if (null == responseMessage) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "responseMessage is null.");
                boolean bl = result;
                return bl;
            }
            result = this.confirmContent(responseMessage, user);
            if (result) {
                result = this.setUserInfo(responseMessage, user);
                if (!result) {
                    this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "setUserInfo result:" + result);
                }
            } else {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "confirmContent result:" + result);
            }
        }
        catch (SocketTimeoutException sockTex) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "SocketTimeoutException occured.", sockTex);
            result = false;
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authExec", "Throwable occured.", th);
            result = false;
        }
        finally {
            if (urlconn != null) {
                urlconn.disconnect();
            }
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authExec", "End. - result:" + result);
        return result;
    }

    private boolean setUserInfo(HiCommandServerMessage responseMessage, String user) throws Throwable {
        String LOG_SUBTITLE = "setUserInfo";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setUserInfo", "Start.");
        boolean result = false;
        try {
            AclUser aclUser = responseMessage.getResponse().getResultList().getAclUser();
            this.setUserName(aclUser.getLoginID());
            if (SJbaseBuiltIn.BUILT_IN_USER.getValue().equals(aclUser.getBuiltIn())) {
                this.setBuiltInUserInfo();
                result = true;
                return result;
            }
            List<AclResourceGroup> aclResourceGroupList = this.getTargetResourceGroup();
            if (null == aclResourceGroupList || aclResourceGroupList.isEmpty()) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setUserInfo", "Target AclResourceGroup List is null or empty.");
                return result;
            }
            this.setRoleIDs(aclResourceGroupList);
            this.setAllRsg(aclResourceGroupList);
            this.setResourceGrpMap(aclResourceGroupList);
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setUserInfo", "Throwable occured.", th);
            return result;
        }
        result = true;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setUserInfo", "End.");
        return result;
    }

    private void setUserName(String user) {
        this.userName = user;
    }

    private List<AclResourceGroup> getTargetResourceGroup() throws Throwable {
        String LOG_SUBTITLE = "getTargetResourceGroup";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTargetResourceGroup", "Start.");
        if (null == this.aclResourceGroupList) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTargetResourceGroup", "this.aclResourceGroupList is null.");
            return null;
        }
        if (this.aclResourceGroupList.isEmpty()) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTargetResourceGroup", "this.aclResourceGroupList is empty.");
            return null;
        }
        ArrayList<AclResourceGroup> aclResourceGroupList = null;
        try {
            aclResourceGroupList = new ArrayList<AclResourceGroup>();
            for (AclResourceGroup aclResourceGroup : this.aclResourceGroupList) {
                BigInteger kind = aclResourceGroup.getKind();
                String deviceType = aclResourceGroup.getDeviceType();
                String deviceNumber = aclResourceGroup.getDeviceNumber();
                if (SJbaseHcsKind.ALL_RESOURCES.getNum().equals(kind)) {
                    aclResourceGroupList.add(aclResourceGroup);
                    continue;
                }
                if (SJbaseHcsKind.DEFAULT_RESOURCE_GROUP.getNum().equals(kind)) {
                    if (!this.equalsDeviceType(deviceType) || !this.equalsDeviceNumber(deviceNumber)) continue;
                    aclResourceGroupList.add(aclResourceGroup);
                    continue;
                }
                if (SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind)) {
                    if (!this.equalsDeviceType(deviceType) || !this.equalsDeviceNumber(deviceNumber)) continue;
                    aclResourceGroupList.add(aclResourceGroup);
                    continue;
                }
                if (SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind)) {
                    if (!this.equalsDeviceType(deviceType) || !this.equalsDeviceNumber(deviceNumber)) continue;
                    aclResourceGroupList.add(aclResourceGroup);
                    continue;
                }
                if (!SJbaseHcsKind.STORAGE_ARRAY_RESOURCE_GROUP.getNum().equals(kind)) continue;
            }
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTargetResourceGroup", "Throwable occured.");
            throw th;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTargetResourceGroup", "End. - aclResourceGroupList:" + this.getAclResourceGroupListString(aclResourceGroupList));
        return aclResourceGroupList;
    }

    private void setRoleIDs(List<AclResourceGroup> aclResourceGroupList) throws Throwable {
        String LOG_SUBTITLE = "setRoleIDs";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setRoleIDs", "Start.");
        try {
            ArrayList<AclPermission> aclPermissionList = new ArrayList<AclPermission>();
            ArrayList<String> stringPermissionList = new ArrayList<String>();
            for (AclResourceGroup aclResourceGroup : aclResourceGroupList) {
                for (AclPermission aclPermission : aclResourceGroup.getAclPermission()) {
                    if (stringPermissionList.contains(aclPermission.getName())) continue;
                    aclPermissionList.add(aclPermission);
                    stringPermissionList.add(aclPermission.getName());
                }
            }
            this.roleIDs = this.convAclPermissionToSnRoleId(aclPermissionList);
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setRoleIDs", "Throwable occured.");
            throw th;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setRoleIDs", "End.");
    }

    private void setAllRsg(List<AclResourceGroup> aclResourceGroupList) throws Throwable {
        String LOG_SUBTITLE = "setAllRsg";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setAllRsg", "Start.");
        try {
            for (AclResourceGroup aclResourceGroup : aclResourceGroupList) {
                BigInteger kind = aclResourceGroup.getKind();
                if (SJbaseHcsKind.ALL_RESOURCES.getNum().equals(kind)) {
                    this.allRsg = true;
                } else {
                    if (!SJbaseHcsKind.DEFAULT_RESOURCE_GROUP.getNum().equals(kind)) continue;
                    this.allRsg = true;
                }
                break;
            }
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setAllRsg", "Throwable occured.");
            throw th;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setAllRsg", "End. - allRsg:" + this.allRsg);
    }

    private void setResourceGrpMap(List<AclResourceGroup> aclResourceGroupList) throws Throwable {
        String LOG_SUBTITLE = "setResourceGrpMap";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setResourceGrpMap", "Start.");
        try {
            this.resourceGrpMap = new boolean[1024];
            for (AclResourceGroup aclResourceGroup : aclResourceGroupList) {
                BigInteger kind = aclResourceGroup.getKind();
                String strgRsgId = aclResourceGroup.getStrgRsgId();
                if (SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind)) {
                    this.resourceGrpMap[0] = true;
                    continue;
                }
                if (!SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind)) continue;
                int index = Integer.parseInt(strgRsgId);
                this.resourceGrpMap[index] = true;
            }
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setResourceGrpMap", "Throwable occured.");
            throw th;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setResourceGrpMap", "End.");
    }

    private boolean equalsDeviceType(String hcsDeviceType) {
        boolean result = false;
        String deviceType = this.getDeviceType();
        if (null == deviceType) {
            return result;
        }
        if (deviceType.equals(hcsDeviceType)) {
            result = true;
        }
        return result;
    }

    private boolean equalsDeviceNumber(String hcsDeviceNumber) {
        boolean result = false;
        String deviceNumber = SJcProductUty.getShortSerialNumber();
        if (null == deviceNumber || "".equals(deviceNumber)) {
            return result;
        }
        if (deviceNumber.equals(hcsDeviceNumber)) {
            result = true;
        }
        return result;
    }

    private String getDeviceType() {
        String result = null;
        String deviceType = SJsncVersionCheckUty.getVersion();
        if ("80".equals(deviceType)) {
            result = SJbaseHcsDeviceType.R800.getName();
        } else if ("83".equals(deviceType)) {
            int pModel = SJsncProductModelUty.getProductModel();
            switch (pModel) {
                case 20: {
                    result = SJbaseHcsDeviceType.HM800S.getName();
                    break;
                }
                case 40: {
                    result = SJbaseHcsDeviceType.HM800M.getName();
                    break;
                }
                case 60: {
                    result = SJbaseHcsDeviceType.HM800H.getName();
                }
            }
        }
        return result;
    }

    private String[] convAclPermissionToSnRoleId(List<AclPermission> aclPermissionList) throws Throwable {
        String LOG_SUBTITLE = "convAclPermissionToRoleId";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "Start.");
        String[] roleIDs = null;
        try {
            ArrayList<String> roleIdList = new ArrayList<String>();
            Properties props = null;
            try {
                props = SJcFileUty.loadProperties(SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_EXTAUTH, "HCSPermission.properties");
            }
            catch (SJcException ex) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "Failed to read properties.", ex);
                throw ex;
            }
            for (AclPermission aclPermission : aclPermissionList) {
                if (null == aclPermission.getName() || "".equals(aclPermission.getName())) {
                    this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "aclPermission is null or permission name is empty.");
                    throw new Exception();
                }
                String roleName = props.getProperty(aclPermission.getName());
                if (null == roleName || "".equals(roleName)) {
                    this.STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "roleName in null or empty. permission name:" + aclPermission.getName());
                    continue;
                }
                roleIdList.add(roleName);
            }
            if (roleIdList.isEmpty()) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "roleIdList is empty.");
                throw new Exception();
            }
            roleIDs = new String[roleIdList.size() + 1];
            roleIDs = roleIdList.toArray(roleIDs);
            roleIDs[roleIdList.size()] = SJbaseRole.STORAGE_ADMINISTRATOR_VIEW_ONLY.getName();
        }
        catch (SJcException sjex) {
            throw sjex;
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "Throwable occured.", th);
            throw th;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convAclPermissionToRoleId", "End.");
        return roleIDs;
    }

    private void setBuiltInUserInfo() {
        String LOG_SUBTITLE = "setBuiltInUserInfo";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setBuiltInUserInfo", "Start.");
        this.groupIDs = new String[1];
        this.groupIDs[0] = SJbaseUserGroup.ADMINISTRATOR_USER_GROUP.getName();
        this.roleIDs = null;
        this.resourceGrpMap = null;
        this.allRsg = false;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setBuiltInUserInfo", "End.");
    }

    private boolean confirmContent(HiCommandServerMessage responseMessage, String user) throws IOException {
        String LOG_SUBTITLE = "confirmContent";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "confirmContent", "Start. user:" + user);
        boolean result = false;
        result = this.requiredCheck(responseMessage);
        if (!result) {
            return result;
        }
        result = this.rangeCheckAclUser(responseMessage.getResponse().getResultList().getAclUser());
        if (!result) {
            return result;
        }
        Response response = responseMessage.getResponse();
        EchoCommand echoCommand = response.getEchoCommand();
        if (!"GetAclUser".equals(echoCommand.getName())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "confirmContent", "echoCommand.getName():" + echoCommand.getName());
            result = false;
            return result;
        }
        if (!"COMPLETED".equals(echoCommand.getStatus())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "confirmContent", "echoCommand.getStatus():" + echoCommand.getStatus());
            result = false;
            return result;
        }
        AclUser aclUser = response.getResultList().getAclUser();
        if (!user.equalsIgnoreCase(aclUser.getLoginID())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "confirmContent", "user:" + user + " loginID:" + aclUser.getLoginID());
            result = false;
            return result;
        }
        if (SJbaseBuiltIn.BUILT_IN_USER.getValue().equals(aclUser.getBuiltIn())) {
            result = true;
            return result;
        }
        this.aclResourceGroupList = this.rangeCheckAclResourceGroup(aclUser.getAclResourceGroup());
        if (this.aclResourceGroupList.isEmpty()) {
            result = false;
            return result;
        }
        result = true;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "confirmContent", "End. user:" + user);
        return result;
    }

    private boolean requiredCheck(HiCommandServerMessage responseMessage) {
        String LOG_SUBTITLE = "requiredCheck";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "Start.");
        boolean result = false;
        Response response = responseMessage.getResponse();
        if (null == response) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "Response is null.");
            return result;
        }
        EchoCommand echoCommand = response.getEchoCommand();
        if (null == echoCommand) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "EchoCommand is null.");
            return result;
        }
        if (SJbaseHCSAuthUtility.isNullOrEmpty(echoCommand.getName())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "EchoCommand name is null or empty.");
            return result;
        }
        if (SJbaseHCSAuthUtility.isNullOrEmpty(echoCommand.getStatus())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "EchoCommand status is null or empty.");
            return result;
        }
        ResultList resultList = response.getResultList();
        if (null == resultList) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "ResultList is null.");
            return result;
        }
        AclUser aclUser = response.getResultList().getAclUser();
        if (null == aclUser) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "AclUser is null.");
            return result;
        }
        if (SJbaseHCSAuthUtility.isNullOrEmpty(aclUser.getLoginID())) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "AclUser loginID is null or empty.");
            return result;
        }
        if (null == aclUser.getBuiltIn()) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "builtIn is null.");
            return result;
        }
        List<AclResourceGroup> aclResourceGroupList = aclUser.getAclResourceGroup();
        if (null == aclResourceGroupList || aclResourceGroupList.isEmpty()) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "aclResourceGroupList is null or empty.");
            return result;
        }
        for (AclResourceGroup aclResourceGroup : aclResourceGroupList) {
            List<AclPermission> aclPermissionList = aclResourceGroup.getAclPermission();
            if (null == aclPermissionList || aclPermissionList.isEmpty()) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "aclPermissionList is null or empty.");
                return result;
            }
            if (null == aclResourceGroup.getKind()) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "kind is null.");
                return result;
            }
            if (!this.requiredCheckDeviceNumber(aclResourceGroup)) {
                return result;
            }
            if (!this.requiredCheckDeviceType(aclResourceGroup)) {
                return result;
            }
            if (this.requiredCheckStrgRsgId(aclResourceGroup)) continue;
            return result;
        }
        result = true;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "requiredCheck", "End. result:" + result);
        return result;
    }

    private boolean requiredCheckDeviceNumber(AclResourceGroup aclResourceGroup) {
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        result = this.requiredCheckDeviceTypeDeviceNumber(kind, aclResourceGroup.getDeviceNumber());
        return result;
    }

    private boolean requiredCheckDeviceType(AclResourceGroup aclResourceGroup) {
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        result = this.requiredCheckDeviceTypeDeviceNumber(kind, aclResourceGroup.getDeviceType());
        return result;
    }

    private boolean requiredCheckDeviceTypeDeviceNumber(BigInteger kind, String target) {
        String LOG_SUBTITLE = "requiredCheckDeviceTypeDeviceNumber";
        boolean result = true;
        if (SJbaseHcsKind.ALL_RESOURCES.getNum().equals(kind)) {
            if (target == null) {
                result = false;
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheckDeviceTypeDeviceNumber", "target is null. kind:" + kind + " result:" + result);
                return result;
            }
        } else if (SJbaseHcsKind.DEFAULT_RESOURCE_GROUP.getNum().equals(kind) || SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind) || SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind)) {
            if (SJbaseHCSAuthUtility.isNullOrEmpty(target)) {
                result = false;
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheckDeviceTypeDeviceNumber", "target is null or empty. target:" + target + " kind:" + kind + " result:" + result);
                return result;
            }
        } else {
            result = true;
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "requiredCheckDeviceTypeDeviceNumber", "target:" + target + " kind:" + kind + " result:" + result);
            return result;
        }
        return result;
    }

    private boolean requiredCheckStrgRsgId(AclResourceGroup aclResourceGroup) {
        String LOG_SUBTITLE = "requiredCheckStrgRsgId";
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        if (!this.isCheckTargetForStrgRsgId(aclResourceGroup)) {
            result = true;
            return result;
        }
        if (aclResourceGroup.getStrgRsgId() == null || aclResourceGroup.getStrgRsgId().equals("")) {
            result = false;
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "requiredCheckStrgRsgId", "strgRsgId is null or empty. strgRsgId:" + aclResourceGroup.getStrgRsgId() + " kind:" + kind + " result:" + result);
            return result;
        }
        return result;
    }

    private boolean rangeCheckAclUser(AclUser aclUser) {
        String LOG_SUBTITLE = "rangeCheckAclUser";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclUser", "Start.");
        boolean result = false;
        BigInteger builtIn = aclUser.getBuiltIn();
        HashSet<BigInteger> intSet = new HashSet<BigInteger>();
        for (SJbaseBuiltIn bi : SJbaseBuiltIn.values()) {
            intSet.add(bi.getValue());
        }
        if (!intSet.contains(builtIn)) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclUser", "builtIn:" + builtIn + " result:" + result);
            return result;
        }
        result = true;
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclUser", "End. result:" + result);
        return result;
    }

    private List<AclResourceGroup> rangeCheckAclResourceGroup(List<AclResourceGroup> aclResourceGroupList) {
        String LOG_SUBTITLE = "rangeCheckAclResourceGroup";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclResourceGroup", "Start.");
        ArrayList<AclResourceGroup> returnList = new ArrayList<AclResourceGroup>();
        for (AclResourceGroup aclResourceGroup : aclResourceGroupList) {
            BigInteger kind = aclResourceGroup.getKind();
            if (SJbaseHcsKind.ALL_RESOURCES.getMin().compareTo(kind) == 1 || SJbaseHcsKind.ALL_RESOURCES.getMax().compareTo(kind) == -1) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclResourceGroup", "kind:" + kind);
                continue;
            }
            if (!this.rangeCheckDeviceType(aclResourceGroup) || !this.rangeCheckDeviceNumber(aclResourceGroup) || !this.rangeCheckStrgRsgId(aclResourceGroup)) continue;
            returnList.add(aclResourceGroup);
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "rangeCheckAclResourceGroup", "End. List size(sorc):" + aclResourceGroupList.size() + " List size(dest):" + returnList.size());
        return returnList;
    }

    private boolean rangeCheckDeviceType(AclResourceGroup aclResourceGroup) {
        String deviceType;
        String LOG_SUBTITLE = "rangeCheckDeviceType";
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        if ((SJbaseHcsKind.DEFAULT_RESOURCE_GROUP.getNum().equals(kind) || SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind) || SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind)) && 20 < (deviceType = aclResourceGroup.getDeviceType()).length()) {
            result = false;
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckDeviceType", "deviceType length error. kind:" + kind + " length:" + deviceType.length() + " result:" + result);
        }
        return result;
    }

    private boolean rangeCheckDeviceNumber(AclResourceGroup aclResourceGroup) {
        String deviceNumber;
        String LOG_SUBTITLE = "rangeCheckDeviceNumber";
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        if ((SJbaseHcsKind.DEFAULT_RESOURCE_GROUP.getNum().equals(kind) || SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind) || SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind)) && 20 < (deviceNumber = aclResourceGroup.getDeviceNumber()).length()) {
            result = false;
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckDeviceNumber", "deviceNumber length error. kind:" + kind + " length:" + deviceNumber.length() + " result:" + result);
        }
        return result;
    }

    private boolean rangeCheckStrgRsgId(AclResourceGroup aclResourceGroup) {
        String LOG_SUBTITLE = "rangeCheckStrgRsgId";
        boolean result = true;
        BigInteger kind = aclResourceGroup.getKind();
        if (!this.isCheckTargetForStrgRsgId(aclResourceGroup)) {
            result = true;
            return result;
        }
        String strgRsgId = aclResourceGroup.getStrgRsgId();
        if (4 < strgRsgId.length()) {
            result = false;
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckStrgRsgId", "strgRsgId length error. kind:" + kind + " length:" + strgRsgId.length() + " result:" + result);
            return result;
        }
        if (SJbaseHcsKind.RESOURCE_POOL.getNum().equals(kind)) {
            if (0 != Integer.parseInt(strgRsgId)) {
                result = false;
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckStrgRsgId", "strgRsgId range error. kind:" + kind + " strgRsgId:" + Integer.parseInt(strgRsgId) + " result:" + result);
                return result;
            }
        } else if (SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(kind) && (0 > Integer.parseInt(strgRsgId) || 1023 < Integer.parseInt(strgRsgId))) {
            result = false;
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "rangeCheckStrgRsgId", "strgRsgId range error. kind:" + kind + " strgRsgId:" + Integer.parseInt(strgRsgId) + " result:" + result);
            return result;
        }
        return result;
    }

    private boolean isCheckTargetForStrgRsgId(AclResourceGroup aclResourceGroup) {
        boolean result = false;
        result = !SJbaseHcsKind.RESOURCE_POOL.getNum().equals(aclResourceGroup.getKind()) && !SJbaseHcsKind.USER_DEFINE_RESOURCE_GROUP.getNum().equals(aclResourceGroup.getKind()) ? false : this.equalsDeviceType(aclResourceGroup.getDeviceType()) && this.equalsDeviceNumber(aclResourceGroup.getDeviceNumber());
        return result;
    }

    private String getHcsAuthUrl() {
        String LOG_SUBTITLE = "getHcsAuthUrl";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsAuthUrl", "Start.");
        String result = null;
        String url = SJbaseHCSAuthUtility.getHcsUrl(this.hcsInfoMap);
        if (null != url) {
            result = url;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsAuthUrl", "End. - result:" + result);
        return result;
    }

    private Map<String, Object> getHcsInfo() {
        String LOG_SUBTITLE = "getHcsInfo";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsInfo", "Start.");
        Map result = null;
        byte[] encryptedData = null;
        try {
            encryptedData = SJcFileUty.loadBinary(SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH, "HCSInfo", 0, -1);
            if (null == encryptedData) {
                return result;
            }
            Object map = SJcSecureUty.decryptDeserialize(encryptedData);
            result = (Map)map;
        }
        catch (SJcFileUtyException fuex) {
            if (fuex.getCause().getClass().equals(FileNotFoundException.class)) {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHcsInfo", "HCSInfo is notfound.");
                return result;
            }
            throw fuex;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsInfo", "End.");
        return result;
    }

    private String getAclResourceGroupListString(List<AclResourceGroup> aclResourceGroupList) {
        StringBuffer buff = new StringBuffer();
        for (AclResourceGroup rsgrp : aclResourceGroupList) {
            this.setBuffer(buff, rsgrp.getName());
            this.setBuffer(buff, rsgrp.getKind().toString());
            this.setBuffer(buff, rsgrp.getDeviceType());
            this.setBuffer(buff, rsgrp.getDeviceNumber());
            this.setBuffer(buff, rsgrp.getStrgRsgId());
            for (AclPermission perm : rsgrp.getAclPermission()) {
                this.setBuffer(buff, perm.getName());
            }
        }
        return buff.toString();
    }

    private void setBuffer(StringBuffer buff, String str) {
        String DELIMITER = ",";
        buff.append(str);
        buff.append(",");
    }

    @Override
    public boolean[] getRoleMap() {
        return null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }
}

