/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.Map;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrExtAuthServerUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String GUIDE_DISPLAY_ID_EXTAUTH = "AUTH";
    public static final String GUIDE_EXT_AUTHENTICATION = "EXT_AUTHENTICATION";
    public static final String GUIDE_CERTIFY_FILE_NAME = "CERTIFICATION_FILE_NAME";
    public static final String GUIDE_FIXED_TEXT_BROWSE_BTN = "FIXED_TEXT_BROWSE_BTN";
    public static final String GUIDE_DNS_LOOKUP = "DNS_LOOKUP";
    public static final String GUIDE_EXT_AUTHORIZATION = "EXT_AUTHORIZATION";
    public static final String GUIDE_AUTHENTICATION_PROTOCOL = "AUTHENTICATION_PROTOCOL";
    public static final String GUIDE_PRIMARY_HOSTNAME = "PRIMARY_HOSTNAME";
    public static final String GUIDE_PRIMARY_PORTNUMBER = "PRIMARY_PORT_NUM";
    public static final String GUIDE_SECOND_SERVER_AUTH = "SECOND_SERVER_AUTH";
    public static final String GUIDE_SECONDARY_HOSTNAME = "SECONDARY_HOSTNAME";
    public static final String GUIDE_SECONDARY_PORTNUMBER = "SECONDARY_PORT_NUM";
    public static final String GUIDE_HOSTNAME = "HOST_NAME";
    public static final String GUIDE_PORTNUMBER = "PORT_NUMBER";
    public static final String GUIDE_DOMAIN_NAME = "DOMAIN_NAME";
    public static final String GUIDE_USER_ATTRIBUTE = "USER_ATTRIBUTE";
    public static final String GUIDE_BASE_DN = "BASE_DN";
    public static final String GUIDE_SEARCH_DN = "SEARCH_DN";
    public static final String GUIDE_PASSWORD = "PASSWORD";
    public static final String GUIDE_TIMEOUT = "TIMEOUT";
    public static final String GUIDE_RETRY_TIMES = "RETRY_TIMES";
    public static final String GUIDE_RETRY_INTERVAL = "RETRY_INTERVAL";
    public static final String GUIDE_TIMEOUT_UNIT = "TIMEOUT_UNIT";
    public static final String GUIDE_RETRY_INTERVAL_UNIT = "RETRY_INTERVAL_UNIT";
    public static final String GUIDE_CLOCKSKEW_UNIT = "CLOCKSKEW_UNIT";
    public static final String GUIDE_SECRET_KEY = "SECRET_KEY";
    public static final String GUIDE_NAS_ADDRESS = "NAS_ADDRESS";
    public static final String GUIDE_REALM_NAME = "REALM_NAME";
    public static final String GUIDE_CLOCKSKEW = "CLOCKSKEW";
    public static final String GUIDE_SERVER_TYPE_DISABLE = "DISABLE";
    public static final String GUIDE_SERVER_TYPE_LDAP = "LDAP";
    public static final String GUIDE_SERVER_TYPE_RADIUS = "RADIUS";
    public static final String GUIDE_SERVER_TYPE_KERBEROS = "KERBEROS";
    public static final String GUIDE_PROTOCOL_LDAP = "LDAP";
    public static final String GUIDE_PROTOCOL_LDAPS = "LDAPS";
    public static final String GUIDE_PROTOCOL_STARTTLS = "STARTTLS";
    public static final String GUIDE_PROTOCOL_PAP = "PAP";
    public static final String GUIDE_PROTOCOL_CHAP = "CHAP";
    public static final String GUIDE_UNIT_SECONDS = "SEC";
    public static final String ADT_FC_ACCOUNT = "ADT_FC_ACOUNT";
    public static final String GUIDE_ADT_SETUP_SERVER = "ADT_SETUP_SERVER";
    public static final String GUIDE_ADT_NORMAL = "ADT_NORMAL_END";
    public static final String GUIDE_ADT_ERROR = "ADT_ERROR";
    public static final String GUIDE_ADT_NUM_OF_SERVERS = "ADT_NUM_OF_SERVERS";
    public static String[][] AdtGuideKeyTable = new String[][]{{"COMMON", "ENABLE"}, {"COMMON", "DISABLE"}, {"COMMON", "LDAPS"}, {"COMMON", "STARTTLS"}, {"AUTH", "PAP"}, {"AUTH", "CHAP"}};
    public static final String NOTAVAILABLE_DISPLAY = "-";
    public static final String BLANK_DISPLAY = "";
    public static final String PASSWORD_DISPLAY = "*";
    public static final String COLON_DISPLAY = ":";
    public static final String TRUE_DATA = SJctrExtAuthServerInfo.TRUE_DEF;
    public static final String FALSE_DATA = SJctrExtAuthServerInfo.FALSE_DEF;
    public static String TRAIL_SERVER_TYPE_LDAP = "ldap";
    public static String TRAIL_SERVER_TYPE_RADIUS = "radius";
    public static String TRAIL_SERVER_TYPE_KERBEROS = "kerberos";
    public static String TRAIL_SERVER_TYPE_LDAPGRP = "ldapgroup";
    public static final String GUIDE_TEST_NORMAL = "TEST_NORMAL";
    public static final String GUIDE_TEST_ERR_UNKNOWN = "TEST_ERR_UNKNOWN";
    public static final String GUIDE_TEST_LDAP_ERR_CRED = "TEST_ERR_AUTHENTICATE";
    public static final String GUIDE_TEST_LDAP_ERR_BIND = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_LDAP_ERR_DNS = "TEST_ERR_DNS";
    public static final String GUIDE_TEST_LDAP_ERR_CERT = "TEST_ERR_CERTIFICATE";
    public static final String GUIDE_TEST_LDAP_ERR_SEARCHDN = "TEST_ERR_SERCHUSER_AUTH";
    public static final String GUIDE_TEST_LDAP_ERR_BASEDN = "TEST_ERR_BASEUSER_AUTH";
    public static final String GUIDE_TEST_RADIUS_ERR_CRED = "TEST_ERR_AUTHENTICATE";
    public static final String GUIDE_TEST_RADIUS_ERR_BIND = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_KERBEROS_ERR_CRED = "TEST_ERR_AUTHENTICATE";
    public static final String GUIDE_TEST_KERBEROS_ERR_BIND = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_KERBEROS_ERR_DNS = "TEST_ERR_DNS";
    public static final String GUIDE_TEST_KERBEROS_ERR_REALM = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_KERBEROS_ERR_SKEW = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_LDAPG_ERR_BIND = "TEST_ERR_CONNECT";
    public static final String GUIDE_TEST_LDAPG_ERR_DNS = "TEST_ERR_DNS";
    public static final String GUIDE_TEST_LDAPG_ERR_CERT = "TEST_ERR_CERTIFICATE";
    public static final String GUIDE_TEST_LDAPG_ERR_SEARCHDN = "TEST_ERR_SERCHUSER_AUTH";
    public static final String GUIDE_TEST_LDAPG_ERR_BASEDN = "TEST_ERR_BASEUSER_AUTH";
    public static final String GUIDE_TEST_D_LDAP_ERR_CRED = "TEST_LDAP_ERR_CRED";
    public static final String GUIDE_TEST_D_LDAP_ERR_BIND = "TEST_LDAP_ERR_BIND";
    public static final String GUIDE_TEST_D_LDAP_ERR_DNS = "TEST_LDAP_ERR_DNS";
    public static final String GUIDE_TEST_D_LDAP_ERR_CERT = "TEST_LDAP_ERR_CERT";
    public static final String GUIDE_TEST_D_LDAP_ERR_SEARCHDN = "TEST_LDAP_ERR_SERCHDN";
    public static final String GUIDE_TEST_D_LDAP_ERR_BASEDN = "TEST_LDAP_ERR_BASEDN";
    public static final String GUIDE_TEST_D_RADIUS_ERR_CRED = "TEST_RADIUS_ERR_CRED";
    public static final String GUIDE_TEST_D_RADIUS_ERR_BIND = "TEST_RADIUS_ERR_BIND";
    public static final String GUIDE_TEST_D_KERBEROS_ERR_CRED = "TEST_LDAP_ERR_CRED";
    public static final String GUIDE_TEST_D_KERBEROS_ERR_BIND = "TEST_KERBEROS_ERR_BIND";
    public static final String GUIDE_TEST_D_KERBEROS_ERR_DNS = "TEST_KERBEROS_ERR_DNS";
    public static final String GUIDE_TEST_D_KERBEROS_ERR_REALM = "TEST_KERBEROS_ERR_REALM";
    public static final String GUIDE_TEST_D_KERBEROS_ERR_SKEW = "TEST_KERBEROS_ERR_SKEW";
    public static final String GUIDE_TEST_D_LDAPG_ERR_BIND = "TEST_LDAPG_ERR_BIND";
    public static final String GUIDE_TEST_D_LDAPG_ERR_DNS = "TEST_LDAP_ERR_DNS";
    public static final String GUIDE_TEST_D_LDAPG_ERR_CERT = "TEST_LDAP_ERR_CERT";
    public static final String GUIDE_TEST_D_LDAPG_ERR_SEARCHDN = "TEST_LDAP_ERR_SERCHDN";
    public static final String GUIDE_TEST_D_LDAPG_ERR_BASEDN = "TEST_LDAPG_ERR_BASEDN";
    private static final String TEST_GUIDE_DELIMITER = "/";
    public static Object[][] LDAPTestResult = new Object[][]{{0, "TEST_NORMAL", ""}, {1, "TEST_ERR_AUTHENTICATE", "TEST_LDAP_ERR_CRED"}, {2, "TEST_ERR_CONNECT", "TEST_LDAP_ERR_BIND"}, {3, "TEST_ERR_DNS", "TEST_LDAP_ERR_DNS"}, {4, "TEST_ERR_CERTIFICATE", "TEST_LDAP_ERR_CERT"}, {5, "TEST_ERR_SERCHUSER_AUTH", "TEST_LDAP_ERR_SERCHDN"}, {6, "TEST_ERR_BASEUSER_AUTH", "TEST_LDAP_ERR_BASEDN"}};
    public static Object[][] RADIUSTestResult = new Object[][]{{0, "TEST_NORMAL", ""}, {1, "TEST_ERR_AUTHENTICATE", "TEST_RADIUS_ERR_CRED"}, {2, "TEST_ERR_CONNECT", "TEST_RADIUS_ERR_BIND"}};
    public static Object[][] KerberosTestResult = new Object[][]{{0, "TEST_NORMAL", ""}, {1, "TEST_ERR_AUTHENTICATE", "TEST_LDAP_ERR_CRED"}, {2, "TEST_ERR_CONNECT", "TEST_KERBEROS_ERR_BIND"}, {3, "TEST_ERR_DNS", "TEST_KERBEROS_ERR_DNS"}, {4, "TEST_ERR_CONNECT", "TEST_KERBEROS_ERR_REALM"}, {5, "TEST_ERR_CONNECT", "TEST_KERBEROS_ERR_SKEW"}};
    public static Object[][] LDAPGroupTestResult = new Object[][]{{0, "TEST_NORMAL", ""}, {2, "TEST_ERR_CONNECT", "TEST_LDAPG_ERR_BIND"}, {3, "TEST_ERR_DNS", "TEST_LDAP_ERR_DNS"}, {4, "TEST_ERR_CERTIFICATE", "TEST_LDAP_ERR_CERT"}, {5, "TEST_ERR_SERCHUSER_AUTH", "TEST_LDAP_ERR_SERCHDN"}, {6, "TEST_ERR_BASEUSER_AUTH", "TEST_LDAPG_ERR_BASEDN"}};
    public static int OUTLINE_GUIDEKEY_INDEX = 0;
    public static int DETAIL_GUIDEKEY_INDEX = 1;

    public SJctrExtAuthServerUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public static boolean isSupportServer(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_LDAP) || type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_RADIUS) || type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_KERBEROS)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isNothingServer(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_NOTHING)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isServerTypeLdap(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_LDAP)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isServerTypeRadius(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_RADIUS)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isServerTypeKerberos(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(SJctrExtAuthServerInfo.SERVER_TYPE_KERBEROS)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isPrimaryServer(String key) {
        boolean ret = false;
        if (key.equalsIgnoreCase(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isSecondaryServer(String key) {
        boolean ret = false;
        if (key.equalsIgnoreCase(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY)) {
            ret = true;
        }
        return ret;
    }

    public String getServerTypeDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = this.guidanceHandle.getGuidance("COMMON", "LDAP");
            } else if (info.isServerTypeRadius()) {
                ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_SERVER_TYPE_RADIUS);
            } else if (info.isServerTypeKerberos()) {
                ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_SERVER_TYPE_KERBEROS);
            } else if (info.isServerTypeNothing()) {
                ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_SERVER_TYPE_DISABLE);
            }
        }
        return ret;
    }

    public String toInvalidStr(String str) {
        String ret = "?";
        if (str.equalsIgnoreCase(TRUE_DATA)) {
            ret = this.guidanceHandle.getGuidance("COMMON", "ENABLE");
        } else if (str.equalsIgnoreCase(FALSE_DATA)) {
            ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_SERVER_TYPE_DISABLE);
        }
        return ret;
    }

    public static boolean isInvalidStr(String str) {
        return Boolean.valueOf(str);
    }

    public String getDNSLookupDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = this.toInvalidStr(data.getDnsLookup());
            } else if (info.isServerTypeRadius()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = this.toInvalidStr(data.getDns_Lookup_Kdc());
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtDNSLookupDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toInvalidStr(data.getDnsLookup()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String toLdapProtocolStr(String str) {
        String ret = "?";
        if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAP)) {
            ret = this.guidanceHandle.getGuidance("COMMON", "LDAP");
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAPS)) {
            ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_PROTOCOL_LDAPS);
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS)) {
            ret = this.guidanceHandle.getGuidance("COMMON", GUIDE_PROTOCOL_STARTTLS);
        }
        return ret;
    }

    public String toLdapProtocolDefine(String str) {
        String ret = BLANK_DISPLAY;
        if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAP)) {
            ret = SJctrExtAuthServerInfo.PROTOCOL_LDAP;
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAPS)) {
            ret = SJctrExtAuthServerInfo.PROTOCOL_LDAPS;
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS)) {
            ret = SJctrExtAuthServerInfo.PROTOCOL_STARTTLS;
        }
        return ret;
    }

    public static boolean isLdapProtocol(String str) {
        return str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAP);
    }

    public static boolean isLdapsProtocol(String str) {
        return str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_LDAPS);
    }

    public static boolean isStarttlsProtocol(String str) {
        return str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS);
    }

    public String getLdapProtocolDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = this.toLdapProtocolStr(data.getProtocol());
            } else if (info.isServerTypeRadius()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtLdapProtocolDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toLdapProtocolStr(data.getProtocol()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toLdapProtocolStr(data.getProtocol()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtAuthorizationDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            ret = NOTAVAILABLE_DISPLAY;
            if (info.isServerTypeLdap()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toInvalidStr(TRUE_DATA) : this.toInvalidStr(FALSE_DATA);
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toInvalidStr(TRUE_DATA) : this.toInvalidStr(FALSE_DATA);
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? this.toInvalidStr(TRUE_DATA) : this.toInvalidStr(FALSE_DATA);
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String toRadiusProtocolStr(String str) {
        String ret = "?";
        if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_PAP)) {
            ret = this.guidanceHandle.getGuidance(GUIDE_DISPLAY_ID_EXTAUTH, GUIDE_PROTOCOL_PAP);
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_CHAP)) {
            ret = this.guidanceHandle.getGuidance(GUIDE_DISPLAY_ID_EXTAUTH, GUIDE_PROTOCOL_CHAP);
        }
        return ret;
    }

    public String toRadiusProtocolDefine(String str) {
        String ret = BLANK_DISPLAY;
        if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_PAP)) {
            ret = SJctrExtAuthServerInfo.PROTOCOL_PAP;
        } else if (str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_CHAP)) {
            ret = SJctrExtAuthServerInfo.PROTOCOL_CHAP;
        }
        return ret;
    }

    public static boolean isPapProtocol(String str) {
        return str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_PAP);
    }

    public static boolean isChapProtocol(String str) {
        return str.equalsIgnoreCase(SJctrExtAuthServerInfo.PROTOCOL_CHAP);
    }

    public String getRadiusProtocolDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = this.toRadiusProtocolStr(data.getProtocol());
            } else if (info.isServerTypeKerberos()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public static String splitKdcToHostName(String kdc) {
        String ret = BLANK_DISPLAY;
        String[] array = kdc.split(COLON_DISPLAY);
        if (array.length > 0) {
            ret = array[0];
        }
        return ret;
    }

    public static String splitKdcToPortNumer(String kdc) {
        String ret = BLANK_DISPLAY;
        String[] array = kdc.split(COLON_DISPLAY);
        if (array.length > 1) {
            ret = array[1];
        }
        return ret;
    }

    public static String makeKdcString(String host, String port) {
        String ret = BLANK_DISPLAY;
        StringBuffer buffer = new StringBuffer();
        buffer.append(host);
        buffer.append(COLON_DISPLAY);
        buffer.append(port);
        ret = buffer.toString();
        return ret;
    }

    public String getPrimaryHostNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? data.getHost() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getHost();
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDns_Lookup_Kdc().equalsIgnoreCase(FALSE_DATA) ? SJctrExtAuthServerUtility.splitKdcToHostName(data.getKdc()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtPrimaryHostNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? data.getHost() : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? data.getHost() : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getPrimaryPortNumberDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getPort());
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDns_Lookup_Kdc().equalsIgnoreCase(FALSE_DATA) ? SJctrExtAuthServerUtility.splitKdcToPortNumer(data.getKdc()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtPrimaryPortNumberDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getDomainNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getDomainName();
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtDomainNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? data.getDomainName() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getUserAttributeNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getUserAttr();
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getBaseDNDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getSearchDN();
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtBaseDNDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? data.getSearchDN() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? data.getSearchDN() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getUsersSearchDNDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getSearchUserDN();
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtUsersSearchDNDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? data.getSearchUserDN() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? data.getSearchUserDN() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String toAppend(String str, int num) {
        String ret = BLANK_DISPLAY;
        StringBuffer buffer = new StringBuffer();
        for (int loop = 0; loop < num; ++loop) {
            buffer.append(str);
        }
        ret = buffer.toString();
        return ret;
    }

    public String getPasswordDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                String pwd = data.getSearchUserPassword();
                ret = this.toAppend(PASSWORD_DISPLAY, pwd.length());
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtPasswordDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                if (data != null) {
                    String pwd = data.getSearchUserPassword();
                    ret = this.toAppend(PASSWORD_DISPLAY, pwd.length());
                } else {
                    ret = NOTAVAILABLE_DISPLAY;
                }
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                if (data != null) {
                    String pwd = data.getSearchUserPassword();
                    ret = this.toAppend(PASSWORD_DISPLAY, pwd.length());
                } else {
                    ret = NOTAVAILABLE_DISPLAY;
                }
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getSecondaryHostNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? data.getHost() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? data.getHost() : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDns_Lookup_Kdc().equalsIgnoreCase(FALSE_DATA) ? SJctrExtAuthServerUtility.splitKdcToHostName(data.getKdc()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtSecondaryHostNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? data.getHost() : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? data.getHost() : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getSecondaryPortNumberDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDns_Lookup_Kdc().equalsIgnoreCase(FALSE_DATA) ? SJctrExtAuthServerUtility.splitKdcToPortNumer(data.getKdc()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtSecondaryPortNumberDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                ret = data != null ? (data.getDnsLookup().equalsIgnoreCase(FALSE_DATA) ? String.valueOf(data.getPort()) : NOTAVAILABLE_DISPLAY) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String toAppendSecUnit(int sec) {
        String ret = BLANK_DISPLAY;
        String str_sec = String.valueOf(sec);
        String unit = this.guidanceHandle.getGuidance("COMMON", GUIDE_UNIT_SECONDS);
        StringBuffer buffer = new StringBuffer();
        buffer.append(str_sec);
        buffer.append(" ");
        buffer.append(unit);
        ret = buffer.toString();
        return ret;
    }

    public String toAppendSecUnit(String sec) {
        String ret = BLANK_DISPLAY;
        String unit = this.guidanceHandle.getGuidance("COMMON", GUIDE_UNIT_SECONDS);
        StringBuffer buffer = new StringBuffer();
        buffer.append(sec);
        buffer.append(" ");
        buffer.append(unit);
        ret = buffer.toString();
        return ret;
    }

    public static boolean isAppendStr(String str) {
        boolean ret = true;
        if (str.equals("?")) {
            ret = false;
        } else if (str.equals(NOTAVAILABLE_DISPLAY)) {
            ret = false;
        }
        return ret;
    }

    public String getTimeoutDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getTimeout());
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getTimeout());
            } else if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getTimeout());
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtTimeoutDispay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getTimeout()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getTimeout()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getRetryIntervalDispay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getRetryInterval());
            } else if (info.isServerTypeRadius()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtRetryIntervalDispay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getRetryInterval()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getRetryInterval()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getNumOfRetriesDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                SJbaseLdapConfiguration data = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getRetryTimes());
            } else if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getRetryTimes());
            } else if (info.isServerTypeKerberos()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getExtNumOfRetriesDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeLdap()) {
                ret = NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeRadius()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getRetryTimes()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeKerberos()) {
                SJbaseLdapGroupConfiguration data = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data != null ? String.valueOf(data.getRetryTimes()) : NOTAVAILABLE_DISPLAY;
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getRadiusAttribute(Map<String, String> attr_map) {
        String ret = "?";
        if (attr_map != null) {
            for (int index = 0; index < SJctrExtAuthServerInfo.RADIUS_ATTR_INFO.length; ++index) {
                String attr = attr_map.get(SJctrExtAuthServerInfo.RADIUS_ATTR_INFO[index]);
                if (attr == null || attr.length() <= 0) continue;
                ret = attr;
                return ret;
            }
        }
        return ret;
    }

    public static boolean isIdentifier(Map<String, String> attr_map) {
        String attr;
        boolean ret = false;
        if (attr_map != null && (attr = attr_map.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IDENTIFIER)) != null && attr.length() > 0) {
            ret = true;
        }
        return ret;
    }

    public static boolean isIPv4(Map<String, String> attr_map) {
        String attr;
        boolean ret = false;
        if (attr_map != null && (attr = attr_map.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv4)) != null && attr.length() > 0) {
            ret = true;
        }
        return ret;
    }

    public static boolean isIPv6(Map<String, String> attr_map) {
        String attr;
        boolean ret = false;
        if (attr_map != null && (attr = attr_map.get(SJctrExtAuthServerInfo.RADIUS_ATTR_IPv6)) != null && attr.length() > 0) {
            ret = true;
        }
        return ret;
    }

    public String getNASAddressDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                Map<String, String> attr_map = data.getAttributes();
                ret = this.getRadiusAttribute(attr_map);
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getSecretDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeRadius()) {
                SJbaseRadiusConfiguration data = (SJbaseRadiusConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                byte[] pwd = data.getSecret();
                ret = this.toAppend(PASSWORD_DISPLAY, pwd.length);
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getRealmNameDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = data.getDefaul_Realm();
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public String getClockSkewDisplay(SJctrExtAuthServerInfo info) {
        String ret = "?";
        if (info != null) {
            if (info.isServerTypeKerberos()) {
                SJbaseKerberosConfiguration data = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                ret = String.valueOf(data.getClockskew());
            } else if (info.isServerTypeNothing()) {
                ret = NOTAVAILABLE_DISPLAY;
            }
        }
        return ret;
    }

    public static boolean isTrailServerTypeLdap(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(TRAIL_SERVER_TYPE_LDAP)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isTrailServerTypeRadius(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(TRAIL_SERVER_TYPE_RADIUS)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isTrailServerTypeKerberos(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(TRAIL_SERVER_TYPE_KERBEROS)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isTrailServerTypeLdapGroup(String type) {
        boolean ret = false;
        if (type.equalsIgnoreCase(TRAIL_SERVER_TYPE_LDAPGRP)) {
            ret = true;
        }
        return ret;
    }

    public String[] getTestResultGuidId(Object[][] result, int errorcode) {
        String[] guidekey = new String[]{"AUTH/TEST_ERR_UNKNOWN", BLANK_DISPLAY};
        for (int index = 0; index < result.length; ++index) {
            Integer code = (Integer)result[index][0];
            if (errorcode != code) continue;
            guidekey[0] = "AUTH/" + (String)result[index][1];
            guidekey[1] = BLANK_DISPLAY;
            String key = (String)result[index][2];
            if (key.length() <= 0) break;
            guidekey[1] = "AUTH/" + (String)result[index][2];
            break;
        }
        return guidekey;
    }
}

