/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import sanproject.serverux.dataimpl.RJiLoginWWN;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrIconDefine;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.portcondition.SJctrDKCKgetPortLEDStatusInfo;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrHostModeOptionTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.data.SJmoMacroMgr;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortFcoeInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrPortUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static WeakHashMap<String, WeakReference<String>> SIMPLE_NUMBER = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> LDEV_ID = new WeakHashMap(65280);
    private static WeakHashMap<String, WeakReference<String>> ARRAY_GROUP = new WeakHashMap(65280);
    private static WeakHashMap<String, WeakReference<String>> CAPACITY = new WeakHashMap(256);
    public static final byte PORT_OUTLINE_KIND_LCP = 1;
    public static final byte PORT_OUTLINE_KIND_FIBRE = 2;
    public static final byte PORT_OUTLINE_KIND_FICON = 3;
    public static final byte PORT_OUTLINE_KIND_ISCSI = 5;
    public static final byte PORT_OUTLINE_KIND_FCOE = 6;
    public static final byte PORT_OUTLINE_KIND_HNAS_USER = 7;
    public static final byte PORT_OUTLINE_KIND_HNAS_SYSTEM = 8;
    public static final byte PORT_KIND_LCP = 1;
    public static final byte PORT_KIND_RCP = 2;
    public static final byte PORT_KIND_TARGET = 3;
    public static final byte PORT_KIND_RCU_TARGET = 4;
    public static final byte PORT_KIND_INITIATOR = 5;
    public static final byte PORT_KIND_EXTERNAL = 6;
    public static final byte PORT_KIND_HTP = 7;
    public static final byte PORT_KIND_FNP = 8;
    public static final byte PORT_KIND_UNIVERSAL = 9;
    public static final byte FIBRE_TOPOLOGY_FCAL_ON = 1;
    public static final byte FIBRE_TOPOLOGY_FCAL_OFF = 2;
    public static final byte FIBRE_TOPOLOGY_P2P_ON = 3;
    public static final byte FIBRE_TOPOLOGY_P2P_OFF = 4;
    public static final byte FIBRE_TOPOLOGY_NOT_FIBRE = 5;
    public static final byte USER_CHANNEL_SPEED_1GBPS = 1;
    public static final byte USER_CHANNEL_SPEED_2GBPS = 2;
    public static final byte USER_CHANNEL_SPEED_AUTO = 3;
    public static final byte USER_CHANNEL_SPEED_NOTFIBRE = 4;
    public static final byte USER_CHANNEL_SPEED_4GBPS = 5;
    public static final byte USER_CHANNEL_SPEED_RESERVE6 = 6;
    public static final byte USER_CHANNEL_SPEED_8GBPS = 7;
    public static final byte USER_CHANNEL_SPEED_10GBPS = 10;
    public static final byte USER_CHANNEL_SPEED_16GBPS = 16;
    public static final byte USER_CHANNEL_SPEED_32GBPS = 32;
    public static final byte DKC_CHANNEL_SPEED_AUTO = 0;
    public static final byte DKC_CHANNEL_SPEED_1GBPS = 1;
    public static final byte DKC_CHANNEL_SPEED_2GBPS = 2;
    public static final byte DKC_CHANNEL_SPEED_NOT_FIBRE = 3;
    public static final byte DKC_CHANNEL_SPEED_4GBPS = 4;
    public static final byte DKC_CHANNEL_SPEED_RESERVE5 = 5;
    public static final byte DKC_CHANNEL_SPEED_RESERVE6 = 6;
    public static final byte DKC_CHANNEL_SPEED_8GBPS = 7;
    public static final byte DKC_CHANNEL_SPEED_10GBPS = 10;
    public static final byte DKC_CHANNEL_SPEED_16GBPS = 16;
    public static final byte DKC_CHANNEL_SPEED_32GBPS = 32;
    public static final String CHANNEL_SPEED_1GBPS = "1 Gbps";
    public static final String CHANNEL_SPEED_2GBPS = "2 Gbps";
    public static final String CHANNEL_SPEED_4GBPS = "4 Gbps";
    public static final String CHANNEL_SPEED_8GBPS = "8 Gbps";
    public static final String CHANNEL_SPEED_10GBPS = "10 Gbps";
    public static final String CHANNEL_SPEED_16GBPS = "16 Gbps";
    public static final String CHANNEL_SPEED_32GBPS = "32 Gbps";
    public static final String CHANNEL_SPEED_AUTO = "Auto";
    public static final String CHANNEL_SPEED_NOTFIBRE = "Not Fibre";
    public static final byte HOSTMODE_UVM = 76;
    public static final int HOST_MODE_OPT_DISABLE = 0;
    public static final int HOST_MODE_OPT_ENABLE = 1;
    public static final int HOST_MODE_OPT_INDEFINITE = 2;
    public static final int HOST_MODE_OPT_UNKNOWN = -1;
    public static int PORT_MAX = 256;
    public static int PORT_WWN_MAX = 255;
    public static int PORT_LUN_MAX = 2048;
    public static int PORT_HOSTGROUP_MAX = 255;
    public static int PORT_ISCSITARGET_MAX = 255;
    public static int PORT_ISCSINAME_MAX = 255;
    public static int PORT_CHAPUSER_MAX = 255;
    public static int HOST_GROUP_MAX = 48960;
    public static final int HOSTMODE_MAX = 80;
    public static final int HOSTMODEOPT_MAX = 128;
    public static final int HOSTNAME_LEN_MAX = 64;
    public static final int UUID_LEN_MAX = 64;
    public static final int UUID_INITNUMLEN_MAX = 9;
    public static final String SPACE = " ";
    public static final String QUESTION = "?";
    public static final String QUESTION_PARENTHESES = "(?)";
    public static final String QUESTION_KEYPARENTHESES = "[?]";
    public static final String BRACKET_L = "(";
    public static final String BRACKET_R = ")";
    public static final String HOSTMODE_KEYPARENTHESES_L = "[";
    public static final byte HOST_MODE_STANDARD = 0;
    public static final byte HOST_MODE_OPENVMS = 5;
    public static final int HOST_MODE_OPT_REPORTDEVICE = 33;
    public static final short HOST_GROUP_STANDARD = 0;
    public static final String HOSTMODE_DLIMITER = ",";
    public static int PORTUTILITY_ERR1 = 106075;
    public static int FAILED_RSG_ID = -1;
    public static String STR_HYPHEN = "-";
    public static final int VP_INDEX_BORDER = 0;
    public static final int FCF_INDEX_BORDER = 0;
    public static final int VLAN_ID_MIN = 0;
    public static final int VLAN_ID_MAX = 4094;
    public static final int Link_DOWN = 0;
    public static final int LINK_UP_LOGGED_OFF = 1;
    public static final int LINK_UP_LOGGED_ON = 2;
    public static final int LINK_UP_START = 65535;
    public static final String STR_DEFAULT = "";
    public static final String HOSTGROUPNAME_DEFAULT = "-G00";
    public static final int HOST_MODE_OPT_BB_CREDIT1 = 49;
    public static final int HOST_MODE_OPT_BB_CREDIT2 = 50;
    public static final int HOST_MODE_OPT_ROUND_TRIP_SETUP = 51;
    public static final int HOST_MODE_OPT_ROUND_TRIP_EXTENDED_SET_UP = 65;
    public static final int HOST_MODE_OPT_NDM_PORT_CONSOLIDATION = 88;
    public static final ArrayList<Integer> ROUND_TRIP_HOST_MODE_OPT = new ArrayList();
    public static final long HT_RSV_ST_NORMAL = 0L;
    public static final long HT_RSV_ST_BLOCKED = 64L;
    public static final long HT_RSV_ST_BITNUM = 16L;
    public static final String HT_RSV_ST_SEPARATOR = " / ";
    public static final int T10PI_NOT_SUPPORT = 0;
    public static final int T10PI_ENABLE = 1;
    public static final int T10PI_DISABLE = 2;
    public static final String KEY_PORT_MAX_DKC = "PORT_MAX_DKC";
    public static final String KEY_WWN_MAX_PORT_SET = "WWN_MAX_PORT_SET";
    public static final String KEY_LUN_MAX_PORT = "LUN_MAX_PORT";
    public static final String KEY_FCSPGRP_MAX_PORT_SET = "FCSPGRP_MAX_PORT_SET";
    public static final String KEY_NUM_MAX_HTG = "NUM_MAX_HTG";
    public static final String KEY_SN_LUN_ID_DEC = "SN_LUN_ID_DEC";
    public static final int PORT_LED_STATUS_NOT_AVAILABLE = 1;
    public static final int PORT_LED_STATUS_AVAILABLE_CONNECTED = 2;
    public static final int PORT_LED_STATUS_AVAILABLE_NOT_CONNECTED = 3;
    public static final int INT_DEFAULT_ICONID = 0;
    public static final byte MFIBRE_16M8 = 106;
    public static final byte FIBER_16FC8 = 107;
    public static final byte FIBER_8FC8 = 108;
    public static final byte FCOE_16FE10 = 111;
    public static final byte FIBER_8FC16 = 118;
    public static final byte CHB_4FC16 = 119;
    public static final byte OPT_ISCSI = 120;
    public static final byte COP_ISCSI = 121;
    public static final byte CHB_4FC32R = 125;
    public static final Class<?> RESOURCE_PORT_CLASS;
    public static final Class<?> PORT_LED_STATUS_CLASS;
    public static final Class<?> KEY_CLASS_CHA_DETAIL;
    public static final Class<?> KEY_CLASS_PORT_ATTRIBUTE;
    public static final int FUNC_PORTCONDITION = 211;
    public static final int ERROR_CODE_UNKNOWNDETA = 207001;
    private static Map<Byte, String> GUIDANCE_ADAPTER_TYPE;
    private static WeakHashMap<String, WeakReference<String>> PACKAGE_TYPE;
    private static WeakHashMap<String, WeakReference<String>> PORT_LED_STATUS;
    private static final int PORT_MAX_DKC_HM = 64;
    private static final int CL_MAX_DKC = 2;
    public static final String KEY_CHA_MAX_DKC = "CHA_MAX_DKC";
    private static int CHA_MAX_DKC;
    public static final String KEY_PORT_MAX_CHA = "PORT_MAX_CHA";
    private static int PORT_MAX_CHA;
    public static final String KEY_PORT_MAX_CL = "PORT_MAX_CL";
    private static int PORT_MAX_CL;
    public static final String KEY_CHA_MAX_CL = "CHA_MAX_CL";
    private static int CHA_MAX_CL;
    private static short[] PortPCBMaskToCHANumber;
    public static final byte ALUA_ASYMMETRIC_ACCESS_STATE_OPTIMIZED = 0;
    public static final byte ALUA_ASYMMETRIC_ACCESS_STATE_NON_OPTIMIZED = 1;
    public static final byte SFP_SPEED_DO_NOT_CARE = -1;
    public static final byte SFP_SPEED_NOT_FC = 5;
    public static final byte SFP_SPEED_8G = 8;
    public static final byte SFP_SPEED_10G = 10;
    public static final byte SFP_SPEED_16G = 16;
    public static final byte SFP_SPEED_32G = 32;
    public static final String DISP_SFP_SPEED_8G = "8 Gbps";
    public static final String DISP_SFP_SPEED_10G = "10 Gbps";
    public static final String DISP_SFP_SPEED_16G = "16 Gbps";
    public static final String DISP_SFP_SPEED_32G = "32 Gbps";
    private static short[] CHBNumberByPort_HM_S;
    private static short[] CHBNumberByPort_HM_M;
    private static short[] CHBNumberByPort_HM_H;
    private static final short[] CHBNumberByPort_CHBB;
    public static final String KEY_TABLE = "COM_TABLE";
    private static SJctrLdevIndexComparator ldevIndexCmp;
    private static final long HTRSV_DEFINE_MASK = 127L;
    private static final int HTRSV_BLC_GUID_INDEX = 7;
    private static final int HTRSV_RSV_GUID_INDEX = 8;
    private String[] hstRsvStGuidanceID = new String[]{"HTRSV_STATUS_NORMAL", "HTRSV_STATUS_OPEN_RESERVED", "HTRSV_STATUS_PERSISTENT_RESERVED", "HTRSV_STATUS_PERSISTENT_RESERVED", "HTRSV_STATUS_MAINFRAME_RESERVED", "HTRSV_STATUS_H3500_RESERVED", "HTRSV_STATUS_ACA_ACTIVE", "HTRSV_STATUS_BLOCKED", "HTRSV_STATUS_RESERVED"};
    public static final int ISCSINAME_LEN = 219;
    public static final int ISCSINICKNAME_MAX_LEN = 32;
    public static final String IQN_STR_PATTERN = "[0-9a-zA-Z\\-\\.\\:]+";
    public static final int MUTUAL = 1;
    public static final int UNIDIRECTIONAL = 0;
    public static final int AUTH_OFF = 2;
    public static final int AUTH_ON = 1;
    public static final int AUTH_USE_HOST = 3;
    public static String KEY_REQUEST;
    public static String KEY_PORT;
    public static String KEY_PORT_ID;
    public static String KEY_TARGET;
    public static String KEY_TARGET_ID;
    public static String KEY_ISCSI;
    public static String KEY_ISCSI_NAME;
    public static String KEY_ISCSI_NICKNAME;
    public static String KEY_ISCSI_CHE_NAME;
    public static String KEY_PORT_IPV4;
    public static String KEY_PORT_IPV4_IPADDR;
    public static String KEY_PORT_IPV4_SUBNET;
    public static String KEY_PORT_IPV4_GATEWAY;
    public static String KEY_PORT_IPV6;
    public static String KEY_PORT_IPV6_AVAILABLE;
    public static String KEY_PORT_IPV6_LINK;
    public static String KEY_PORT_IPV6_LINK_AUTO;
    public static String KEY_PORT_IPV6_LINK_MANUAL;
    public static String KEY_PORT_IPV6_GLOBAL;
    public static String KEY_PORT_IPV6_GLOBAL_AUTO;
    public static String KEY_PORT_IPV6_GLOBAL_MANUAL;
    public static String KEY_PORT_IPV6_GATEWAY;
    public static String KEY_PORT_IPV6_GATEWAY_ASSIGNED;
    public static String KEY_PORT_TCPPORTNUM;
    public static String KEY_PORT_SEL_ACK;
    public static String KEY_PORT_DEL_ACK;
    public static String KEY_PORT_WINSIZE;
    public static String KEY_PORT_MTUSIZE;
    public static String KEY_PORT_MTUSIZE_MTU;
    public static String KEY_PORT_VLAN;
    public static String KEY_PORT_VLAN_TAGGING;
    public static String KEY_PORT_VLAN_ID;
    public static String KEY_PORT_KAT;
    public static String KEY_PORT_ISNS;
    public static String KEY_PORT_ISNS_ENABLE;
    public static String KEY_PORT_ISNS_IPTYPE;
    public static String KEY_PORT_ISNS_IPV4;
    public static String KEY_PORT_ISNS_IPV6;
    public static String KEY_PORT_ISNS_TCPPORTNUM;
    public static final String KEY_COL_T10PI = "COM_COL_T10PI";
    public static final String KEY_COL_T10PI_MODE = "COM_COL_T10PI_MODE";
    public static int KEY_ISNS_TYPE_V4;
    public static int KEY_ISNS_TYPE_V6;
    public static final Pattern mRegex;
    private static final short[][] PORTGroupArray_2Port_H;
    private static final short[][] PORTGroupArray_2Port_M;
    private static final short[][] PORTGroupArray_2Port_S;
    private static final short[][] PORTGroupArray_4Port_H;
    private static final short[][] PORTGroupArray_4Port_M;
    private static final short[][] PORTGroupArray_4Port_S;
    private static final short[][][] PORTGroupArray_S;
    private static final short[][][] PORTGroupArray_M;
    private static final short[][][] PORTGroupArray_H;

    public SJctrPortUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    private static void changeMacro() {
        SJmoModelMgr modelMgr = (SJmoModelMgr)SJcSingletonManagerUty.getInstance(SJmoModelMgr.class);
        if (modelMgr == null) {
            SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Model manager failed.");
            return;
        }
        SJmoMacroMgr macroMgr = modelMgr.getMacroMgr();
        if (macroMgr == null) {
            SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro manager failed.");
            return;
        }
        Object obj = null;
        try {
            obj = macroMgr.getMacroObj(KEY_PORT_MAX_DKC);
            if (obj != null) {
                PORT_MAX = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"PORT_MAX_DKC\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_WWN_MAX_PORT_SET);
            if (obj != null) {
                PORT_WWN_MAX = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"WWN_MAX_PORT_SET\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_LUN_MAX_PORT);
            if (obj != null) {
                PORT_LUN_MAX = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"LUN_MAX_PORT\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_FCSPGRP_MAX_PORT_SET);
            if (obj != null) {
                PORT_HOSTGROUP_MAX = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"FCSPGRP_MAX_PORT_SET\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_NUM_MAX_HTG);
            if (obj != null) {
                HOST_GROUP_MAX = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"NUM_MAX_HTG\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_CHA_MAX_DKC);
            if (obj != null) {
                CHA_MAX_DKC = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"CHA_MAX_DKC\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_PORT_MAX_CHA);
            if (obj != null) {
                PORT_MAX_CHA = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"PORT_MAX_CHA\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_PORT_MAX_CL);
            if (obj != null) {
                PORT_MAX_CL = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"PORT_MAX_CL\" failed.");
            }
            obj = macroMgr.getMacroObj(KEY_CHA_MAX_CL);
            if (obj != null) {
                CHA_MAX_CL = ((Long)obj).intValue();
            } else {
                SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro \"CHA_MAX_CL\" failed.");
            }
        }
        catch (ClassCastException e) {
            SJctrLogUty.warn(SJctrPortUtility.class.getName(), "changeMacro", "Getting Macro failed from Class Cast Exception.");
        }
    }

    public String toPortNameDisplay(SJmoPortDetail port) {
        String str = QUESTION;
        if (port != null) {
            str = port.getStrPortDisplayName();
        }
        return this.getCache(str, DEFAULT_CACHE);
    }

    public String toPortSecuritySwitchDisplay(SJmoPortDetail port) {
        String ret = QUESTION;
        if (port != null) {
            if (SJctrPortUtility.isHnasPort(port)) {
                return STR_HYPHEN;
            }
            ret = port.isBPortSecuritySwitch() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String toPortSecuritySwitchDisplay(SJmoPortDetail port, SJmoHostGroupInfo hostGroupInfo) {
        String ret = QUESTION;
        if (port != null) {
            if (SJctrPortUtility.isHnasPort(port)) {
                return STR_HYPHEN;
            }
            ret = port.isBPortSecuritySwitch() ? this.guidanceHandle.getGuidance("ENABLED") : (hostGroupInfo.getSHostGroup() == 0 ? this.guidanceHandle.getGuidance("DISABLED_ACCESSIBLE") : this.guidanceHandle.getGuidance("DISABLED"));
        }
        return ret;
    }

    public String toHostNameDisplay(SJmoWwn wwn) {
        String str = QUESTION;
        if (wwn != null) {
            str = wwn.getStrWWNNickName();
        }
        return this.getCache(str, DEFAULT_CACHE);
    }

    private String toWWNDisplay(byte[] wwn) {
        StringBuilder buf = new StringBuilder();
        for (byte st : wwn) {
            buf.append(String.format("%02X", st));
        }
        return buf.toString();
    }

    public String toWWNDisplay(SJmoWwn wwn) {
        String str = QUESTION;
        if (wwn != null) {
            str = this.toWWNDisplay(wwn.getByWWN());
        }
        return this.getCache(str, DEFAULT_CACHE);
    }

    public String toWWNDisplay(SJmoPortDetail port) {
        String str = QUESTION;
        if (port != null) {
            str = SJctrPortUtility.isIscsiPort(port) || SJctrPortUtility.isHnasPort(port) ? STR_HYPHEN : this.toWWNDisplay(port.getByPortWWN());
        }
        return this.getCache(str, DEFAULT_CACHE);
    }

    public String toChannelSpeedDisplay(byte userChannelSpeed, byte dkcChannelSpeed, boolean viewInfoFlg) {
        StringBuilder buf = new StringBuilder();
        block0 : switch (userChannelSpeed) {
            case 1: {
                buf.append(CHANNEL_SPEED_1GBPS);
                break;
            }
            case 2: {
                buf.append(CHANNEL_SPEED_2GBPS);
                break;
            }
            case 3: {
                buf.append(CHANNEL_SPEED_AUTO);
                switch (dkcChannelSpeed) {
                    case 0: {
                        if (!viewInfoFlg) break block0;
                        buf.append(BRACKET_L + STR_HYPHEN + BRACKET_R);
                        break;
                    }
                    case 1: {
                        buf.append("(1 Gbps)");
                        break;
                    }
                    case 2: {
                        buf.append("(2 Gbps)");
                        break;
                    }
                    case 3: {
                        buf.append(QUESTION_PARENTHESES);
                        break;
                    }
                    case 4: {
                        buf.append("(4 Gbps)");
                        break;
                    }
                    case 5: {
                        buf.append("(Reserve)");
                        break;
                    }
                    case 6: {
                        buf.append("(Reserve)");
                        break;
                    }
                    case 7: {
                        buf.append("(8 Gbps)");
                        break;
                    }
                    case 10: {
                        buf.append("(10 Gbps)");
                        break;
                    }
                    case 16: {
                        buf.append("(16 Gbps)");
                        break;
                    }
                    case 32: {
                        buf.append("(32 Gbps)");
                        break;
                    }
                    default: {
                        buf.append(QUESTION_PARENTHESES);
                        break;
                    }
                }
                break;
            }
            case 5: {
                buf.append(CHANNEL_SPEED_4GBPS);
                break;
            }
            case 7: {
                buf.append("8 Gbps");
                break;
            }
            case 10: {
                buf.append("10 Gbps");
                break;
            }
            case 16: {
                buf.append("16 Gbps");
                break;
            }
            case 32: {
                buf.append("32 Gbps");
                break;
            }
            default: {
                buf.append("?(?)");
            }
        }
        return buf.toString();
    }

    public String toChannelSpeedDisplay(SJmoPortDetail port) {
        return this.toChannelSpeedDisplay(port, true);
    }

    public String toChannelSpeedDisplay(SJmoPortDetail port, boolean viewInfoFlg) {
        String str = "?(?)";
        if (port != null) {
            str = SJctrPortUtility.isHnasPort(port) ? STR_HYPHEN + BRACKET_L + STR_HYPHEN + BRACKET_R : this.toChannelSpeedDisplay(port.getByUserChannelSpeed(), port.getByDKCChannelSpeed(), viewInfoFlg);
        }
        return this.getCache(str, DEFAULT_CACHE);
    }

    public boolean isOpenAttribute(byte portKind) {
        boolean fibre = false;
        switch (portKind) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                fibre = true;
                break;
            }
        }
        return fibre;
    }

    public static boolean isFibrePort(SJmoPortDetail portDetail) {
        byte kind = portDetail.getByPortKindNo();
        boolean ret = kind == 2;
        return ret;
    }

    public static boolean isHnasPort(SJmoPortDetail portDetail) {
        boolean ret = SJctrPortUtility.isHnasUserPort(portDetail) || SJctrPortUtility.isHnasSystemPort(portDetail);
        return ret;
    }

    public static boolean isHnasPort(byte portKind) {
        boolean ret = SJctrPortUtility.isHnasUserPort(portKind) || SJctrPortUtility.isHnasSystemPort(portKind);
        return ret;
    }

    public static boolean isHnasUserPort(SJmoPortDetail portDetail) {
        byte kind = portDetail.getByPortKindNo();
        boolean ret = SJctrPortUtility.isHnasUserPort(kind);
        return ret;
    }

    public static boolean isHnasUserPort(byte portKind) {
        return portKind == 7;
    }

    public static boolean isHnasSystemPort(SJmoPortDetail portDetail) {
        byte kind = portDetail.getByPortKindNo();
        boolean ret = SJctrPortUtility.isHnasSystemPort(kind);
        return ret;
    }

    public static boolean isHnasSystemPort(byte portKind) {
        return portKind == 8;
    }

    public String toPortAttributeDisplay(byte portKind) {
        String ret = QUESTION;
        switch (portKind) {
            case 1: {
                ret = this.guidanceHandle.getGuidance("LCP");
                break;
            }
            case 2: {
                ret = this.guidanceHandle.getGuidance("RCP");
                break;
            }
            case 3: {
                ret = this.guidanceHandle.getGuidance("TARGET");
                break;
            }
            case 4: {
                ret = this.guidanceHandle.getGuidance("RCU_TARGET");
                break;
            }
            case 5: {
                ret = this.guidanceHandle.getGuidance("INITIATOR");
                break;
            }
            case 6: {
                ret = this.guidanceHandle.getGuidance("EXTERNAL");
                break;
            }
            case 7: {
                ret = this.guidanceHandle.getGuidance("HTP");
                break;
            }
            case 8: {
                ret = this.guidanceHandle.getGuidance("FNP");
                break;
            }
            case 9: {
                ret = this.guidanceHandle.getGuidance("UNIVERSAL");
                break;
            }
        }
        return ret;
    }

    public String toPortAttributeDisplay(SJmoPortAttributeInfo portAttribute) {
        String ret = QUESTION;
        if (portAttribute != null) {
            ret = this.toPortAttributeDisplay(portAttribute.getByPortKind());
        }
        return ret;
    }

    public String toHostGroupNameDisplay(SJmoHostGroupInfo hostgroupInfo) {
        String nickname;
        String str = "? (?)";
        if (hostgroupInfo != null && (nickname = hostgroupInfo.getStrHostgroupNickName()).length() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(nickname);
            buf.append(" (" + String.format("%02X", hostgroupInfo.getSHostGroup()) + BRACKET_R);
            str = buf.toString();
        }
        return str;
    }

    public String toPortNameShort(SJmoPortDetail port) {
        String longStr = port.getStrPortDisplayName();
        char[] buf = new char[]{longStr.charAt(2), longStr.charAt(4)};
        return new String(buf);
    }

    public String toDefaultHGName(SJmoPortDetail port) {
        return this.toPortNameShort(port) + HOSTGROUPNAME_DEFAULT;
    }

    public String toLunNumDisplay(SJmoPortLunInfo portLunInfo) {
        int num = 0;
        if (portLunInfo != null) {
            num = portLunInfo.getAlPortLun().size();
        }
        return SJctrComUtility.toDecString(num);
    }

    public String toFibreAddressDisplay(SJmoPortDetail port) {
        String str = "?[?]";
        if (port != null) {
            str = this.dataChange.ChangeFibreAdr(port.getSPortFibreAddress());
        }
        return str;
    }

    public boolean isBFCSwitch(byte topology) {
        boolean result = false;
        switch (topology) {
            case 1: 
            case 3: {
                result = true;
                break;
            }
            case 2: 
            case 4: {
                result = false;
                break;
            }
        }
        return result;
    }

    public String toFCSwitchDisplay(byte topology) {
        String result = QUESTION;
        ArrayList changeList = new ArrayList();
        changeList = this.dataChange.ChangeFabricConnection(topology);
        result = ((String)changeList.get(0)).equals("ON") ? this.guidanceHandle.getGuidance("ON") : (((String)changeList.get(0)).equals("OFF") ? this.guidanceHandle.getGuidance("OFF") : (((String)changeList.get(0)).equals(STR_HYPHEN) ? STR_HYPHEN : QUESTION));
        return result;
    }

    public String toFCSwitchDisplay(SJmoPortDetail port) {
        String result = QUESTION;
        if (port != null) {
            result = this.toFCSwitchDisplay(port.getByPortFibreTopology());
        }
        return result;
    }

    public boolean isBFCALConnection(byte topology) {
        boolean result = false;
        switch (topology) {
            case 1: 
            case 2: {
                result = true;
                break;
            }
            case 3: 
            case 4: {
                result = false;
                break;
            }
        }
        return result;
    }

    public String toConnectionDisplay(byte topology) {
        String Connection = QUESTION;
        ArrayList changeList = new ArrayList();
        changeList = this.dataChange.ChangeFabricConnection(topology);
        if (((String)changeList.get(1)).length() != 0) {
            Connection = (String)changeList.get(1);
        }
        return Connection;
    }

    public String toConnectionDisplay(SJmoPortDetail port) {
        String Connection = QUESTION;
        if (port != null) {
            Connection = this.toConnectionDisplay(port.getByPortFibreTopology());
        }
        return Connection;
    }

    public String toHostModeDisplay(byte byHostMode) {
        String ret = "?[?]";
        String str = this.dataChange.ChangeHostMode(byHostMode);
        if (str.length() != 0) {
            ret = str;
        }
        int index = ret.indexOf(HOSTMODE_KEYPARENTHESES_L);
        ret = ret.substring(0, index) + SPACE + ret.substring(index);
        return ret;
    }

    public String toHostModeDisplay(SJmoHostGroupInfo hostgroup) {
        String str = "?[?]";
        if (hostgroup != null) {
            str = this.toHostModeDisplay(hostgroup.getByHostMode());
        }
        return str;
    }

    public String toHostModeOptionDisplay(SJctrHostModeOptionTableKey hostgroup, boolean bSettled) {
        String result = QUESTION;
        if (hostgroup != null) {
            int optIndex = hostgroup.getSOptionNo();
            String optName = this.dataChange.getHostModeName(optIndex);
            if (optName.equals("N/A")) {
                result = "-";
            } else {
                switch (hostgroup.getIOptionStatus()) {
                    case 0: {
                        if (bSettled) {
                            result = this.guidanceHandle.getGuidance("DISABLED");
                            break;
                        }
                        result = this.guidanceHandle.getGuidance("DISABLE");
                        break;
                    }
                    case 1: {
                        if (bSettled) {
                            result = this.guidanceHandle.getGuidance("ENABLED");
                            break;
                        }
                        result = this.guidanceHandle.getGuidance("ENABLE");
                        break;
                    }
                    case 2: {
                        result = STR_DEFAULT;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public String appendToHostModeOptionNoDisplay(SJmoHostGroupInfo hgInfo) {
        String str = QUESTION;
        StringBuffer optionNumber = new StringBuffer();
        if (hgInfo != null) {
            BitSet optbt = hgInfo.getBtOption();
            for (int optIndex = 0; optIndex <= optbt.size(); ++optIndex) {
                if (!optbt.get(optIndex)) continue;
                if (optionNumber.length() != 0) {
                    optionNumber.append(HOSTMODE_DLIMITER);
                }
                optionNumber.append(optIndex);
            }
            str = optionNumber.toString();
        }
        return str;
    }

    public String toExplanationDisplay(int optionNo) {
        String opt = this.dataChange.getHostModeName(optionNo);
        if (opt.equals("N/A")) {
            opt = this.guidanceHandle.getGuidance("RESERVE");
        }
        return opt;
    }

    public String toExplanationDisplay(SJctrHostModeOptionTableKey hostgroup) {
        String str = QUESTION;
        if (hostgroup != null) {
            str = this.toExplanationDisplay(hostgroup.getSOptionNo());
        }
        return str;
    }

    public String toHostNumDisplay(SJmoHostGroupInfo hostGroupInfo) {
        String result = "0";
        if (hostGroupInfo != null) {
            int hostNum = hostGroupInfo.getAlHostGroupWwn().size();
            result = SJctrComUtility.toDecString(hostNum);
        }
        return result;
    }

    public static Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> getPortLunMapFromLdevDetail(List<SJmoPortLunInfo> modelPtLun) {
        TreeMap<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> ldevLunMap = new TreeMap<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>();
        for (SJmoPortLunInfo ptLun : modelPtLun) {
            for (SJmoPortLunDetail ptDetail : ptLun.getAlPortLun()) {
                ArrayList<Object> ptLunArray;
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(ptDetail.getSLDKC(), ptDetail.getSCU(), ptDetail.getSLDEV());
                if (ldevLunMap.containsKey(ldevIndex)) {
                    ptLunArray = ldevLunMap.get(ldevIndex);
                } else {
                    ptLunArray = new ArrayList();
                    ldevLunMap.put(ldevIndex, ptLunArray);
                }
                SJctrPortLunTableKey ptLunTblKey = new SJctrPortLunTableKey(ptLun, ptDetail);
                ptLunArray.add(ptLunTblKey);
            }
        }
        return ldevLunMap;
    }

    public static List<SJctrPortLunTableKey> getPortLunListFromLdevDetail(List<SJmoLdevIndex> ldevList, List<SJmoPortLunInfo> modelPtLun, List<Boolean> errList) {
        Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> ldevLunMap = SJctrPortUtility.getPortLunMapFromLdevDetail(modelPtLun);
        List<SJctrPortLunTableKey> retList = SJctrPortUtility.getPortLunListFromLdevDetail(ldevList, ldevLunMap, errList);
        return retList;
    }

    public static List<SJctrPortLunTableKey> getPortLunListFromLdevDetail(List<SJmoLdevIndex> ldevList, Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> ldevLunMap, List<Boolean> errList) {
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>(10 + ldevList.size() * 2);
        if (errList == null) {
            errList = new ArrayList<Boolean>(ldevList.size());
        }
        for (SJmoLdevIndex ldevIndex : ldevList) {
            if (ldevLunMap.containsKey(ldevIndex)) {
                retList.addAll((Collection<SJctrPortLunTableKey>)ldevLunMap.get(ldevIndex));
                errList.add(Boolean.TRUE);
                continue;
            }
            errList.add(Boolean.FALSE);
        }
        return retList;
    }

    public SJmoPortDetail getPortDetail(List<SJmoPortDetail> portDtlList, int portId) {
        SJmoPortDetail ret = null;
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)portId);
        int index = Collections.binarySearch(portDtlList, portIndex);
        if (index >= 0) {
            ret = portDtlList.get(index);
        }
        return ret;
    }

    public static List<SJmoHostGroupInfo> getAllHostGrpInPort(List<SJmoPortHostGroupInfo> ptHgInfo, SJmoPortIndex chkPort) {
        ArrayList retList = new ArrayList();
        if (ptHgInfo == null || chkPort == null) {
            return retList;
        }
        ArrayList<SJmoPortHostGroupInfo> ptHgInfoList = new ArrayList<SJmoPortHostGroupInfo>(ptHgInfo.size());
        ptHgInfoList.addAll(ptHgInfo);
        Collections.sort(ptHgInfoList);
        int portIndex = Collections.binarySearch(ptHgInfo, chkPort, null);
        if (portIndex >= 0) {
            SJmoPortHostGroupInfo modelPortHgInfo = ptHgInfo.get(portIndex);
            retList = modelPortHgInfo.getAlPortHostGroup();
        }
        return retList;
    }

    public static List<SJmoWwn> getAllWwnInPort(List<SJmoPortHostGroupInfo> ptHgInfo, SJmoPortIndex chkPort) {
        ArrayList<SJmoWwn> retList = new ArrayList<SJmoWwn>();
        List<SJmoHostGroupInfo> modelHgInfoList = SJctrPortUtility.getAllHostGrpInPort(ptHgInfo, chkPort);
        for (SJmoHostGroupInfo hgInfo : modelHgInfoList) {
            ArrayList wwnList = hgInfo.getAlHostGroupWwn();
            retList.addAll(wwnList);
        }
        Collections.sort(retList, null);
        return retList;
    }

    public void checkPortSecurityMsg(List portDetailList, List<SJctrPortHostGroupTableKey> targetHg, SJctrDataController dc) {
        short hostGroup = 0;
        SJmoPortDetail portDetail = null;
        boolean msgFlg = false;
        boolean ret = true;
        for (SJctrPortHostGroupTableKey tableKey : targetHg) {
            int i;
            if (tableKey.isFibre()) {
                SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
                i = Collections.binarySearch(portDetailList, phgInfo);
                if (i < 0) continue;
                portDetail = (SJmoPortDetail)portDetailList.get(i);
                hostGroup = tableKey.getHostGroupInfo().getSHostGroup();
            } else {
                SJmoPortIscsiTargetInfo ptItInfo = tableKey.getPortIscsiTargetInfo();
                i = Collections.binarySearch(portDetailList, ptItInfo);
                if (i < 0) continue;
                portDetail = (SJmoPortDetail)portDetailList.get(i);
                hostGroup = tableKey.getIscsiTargetInfo().getSIscsiTarget();
            }
            if (!(msgFlg = this.isPortSecurityMsg(portDetail, hostGroup))) continue;
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(PORTUTILITY_ERR1);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
            break;
        }
    }

    public void checkPortSecurityMsg(List portDetailList, SJctrDataController dc) {
        for (Object selectedPortObj : portDetailList) {
            SJmoPortDetail selectedPort = (SJmoPortDetail)selectedPortObj;
            boolean portSS = selectedPort.isBPortSecuritySwitch();
            if (portSS) continue;
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(PORTUTILITY_ERR1);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
            break;
        }
    }

    public boolean isPortSecurityMsg(SJmoPortDetail portDetail, short hostGroup) {
        boolean result = false;
        boolean portSS = portDetail.isBPortSecuritySwitch();
        if (!portSS && hostGroup != 0) {
            result = true;
        }
        return result;
    }

    public static boolean isRsgHostGroupIndex(SJmoHostGroupIndex hgIndex, SJctrResourceGroupUtility rsgUtil) {
        int rsgId = rsgUtil.getRsgId(hgIndex);
        boolean result = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
        return result;
    }

    public static boolean chkResourceGroup(int rsgId, SJctrResourceGroupUtility rsgUtil) {
        boolean result = false;
        if (rsgId > FAILED_RSG_ID) {
            result = rsgUtil.chkResourceGroup(rsgId);
        }
        return result;
    }

    public static boolean isSupportPortType(SJmoPortDetail portDetail) {
        boolean result = false;
        result |= SJctrPortUtility.isFibrePort(portDetail);
        result |= SJctrPortUtility.isFcoePort(portDetail);
        return result |= SJctrPortUtility.isHnasPort(portDetail);
    }

    public static boolean isFcoePort(SJmoPortDetail portDetail) {
        byte kind = portDetail.getByPortKindNo();
        boolean result = kind == 6;
        return result;
    }

    public String toMacAddressDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            result = fcoeInfo.getStrMacAddress();
        }
        return result;
    }

    public String toVlanIdDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            int vlanId = fcoeInfo.getIVlanId();
            if (0 <= vlanId && vlanId <= 4094) {
                result = Integer.toString(vlanId);
            } else {
                result = QUESTION;
                SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toVlanIdDisplay", "Vlan Id : " + vlanId);
            }
        }
        return result;
    }

    public String toVpIndexDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            int vpIndex = fcoeInfo.getIVpIndex();
            if (vpIndex == 0) {
                result = Integer.toString(vpIndex);
            } else if (vpIndex == 65535) {
                result = STR_DEFAULT;
            } else {
                result = QUESTION;
                SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toVpIndexDisplay", "VP Index : " + vpIndex);
            }
        }
        return result;
    }

    public String toFcfIndexDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            int fcfIndex = fcoeInfo.getIFcfIndex();
            if (fcfIndex == 0) {
                result = Integer.toString(fcfIndex);
            } else if (fcfIndex == 65535) {
                result = STR_DEFAULT;
            } else {
                result = QUESTION;
                SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toFcfIndexDisplay", "FCF Index : " + fcfIndex);
            }
        }
        return result;
    }

    public String toVpStatusDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            int vpStatus = fcoeInfo.getIVpStatus();
            switch (vpStatus) {
                case 0: {
                    result = this.guidanceHandle.getGuidance("LINK_DOWN");
                    break;
                }
                case 1: {
                    result = this.guidanceHandle.getGuidance("LINK_UP_LOGGED_OFF");
                    break;
                }
                case 2: {
                    result = this.guidanceHandle.getGuidance("LINK_UP_LOGGED_ON");
                    break;
                }
                case 65535: {
                    result = STR_DEFAULT;
                    break;
                }
                default: {
                    result = QUESTION;
                    SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toVpStatusDisplay", "VP Status : " + vpStatus);
                }
            }
        }
        return result;
    }

    public String toFpmaDisplay(SJmoPortFcoeInfo fcoeInfo) {
        String result = STR_HYPHEN;
        if (fcoeInfo != null) {
            result = fcoeInfo.getStrFpma();
        }
        return result;
    }

    public boolean isHostRsv(long hstRsv) {
        boolean result = false;
        if (hstRsv != 0L) {
            result = true;
        }
        return result;
    }

    public List<String> getHostRsvStatusGuidanceId(long hstRsv) {
        ArrayList<String> ret = new ArrayList<String>();
        long temp = hstRsv & 0x7FL;
        long mask = 1L;
        int i = 1;
        while (temp != 0L) {
            String gid;
            if ((temp & mask) == mask && !ret.contains(gid = this.hstRsvStGuidanceID[i]) && i != 7) {
                ret.add(gid);
            }
            temp >>= 1;
            ++i;
        }
        if ((hstRsv & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ret.add(this.hstRsvStGuidanceID[8]);
        }
        return ret;
    }

    public String getHostRsvDispString(List<String> gidList) {
        String retHostRsvDisp = STR_DEFAULT;
        String gid = null;
        if (gidList == null) {
            retHostRsvDisp = QUESTION;
        } else {
            for (int i = 0; i < gidList.size(); ++i) {
                gid = gidList.get(i);
                retHostRsvDisp = retHostRsvDisp + this.guidanceHandle.getGuidance("LUNM", gid);
                if (i >= gidList.size() - 1) continue;
                retHostRsvDisp = retHostRsvDisp + HT_RSV_ST_SEPARATOR;
            }
        }
        return retHostRsvDisp;
    }

    public String toWWNStatusDisplay(RJiLoginWWN loginWwn) {
        String result = QUESTION;
        if (loginWwn != null) {
            result = this.toWWNStatusDisplay(loginWwn.isLoggedIn());
        }
        return result;
    }

    public String toWWNStatusDisplay(boolean login) {
        String result = STR_DEFAULT;
        result = login ? this.guidanceHandle.getGuidance("LUNM", "WWNST_LOGGED_IN") : this.guidanceHandle.getGuidance("LUNM", "WWNST_LOGGED_OUT");
        return result;
    }

    public static boolean isLunIdDecimal(SJbaseUserSessionInterface us) {
        boolean ret = true;
        if (us == null) {
            return ret;
        }
        Serializable prop = us.getUserProperty(KEY_SN_LUN_ID_DEC);
        if (prop instanceof Boolean) {
            ret = (Boolean)prop;
        }
        return ret;
    }

    public static short getPortToCluster(short port) {
        if (port < 0 || port >= PORT_MAX) {
            throw new IndexOutOfBoundsException();
        }
        short rtn = (short)((port / PORT_MAX_CL & 1) + 1);
        return rtn;
    }

    public static short getPortToCHANumber(short port) {
        int iModel = SJsncProductModelUty.getProductModel();
        if (iModel == 20) {
            return CHBNumberByPort_HM_S[port];
        }
        if (iModel == 40) {
            return CHBNumberByPort_HM_M[port];
        }
        if (iModel == 60) {
            return CHBNumberByPort_HM_H[port];
        }
        if (port < 0 || port >= PORT_MAX) {
            throw new IndexOutOfBoundsException();
        }
        int nPortPCB = port / PORT_MAX_CHA & CHA_MAX_CL - 1;
        short rtn = PortPCBMaskToCHANumber[nPortPCB];
        return rtn;
    }

    public static int getPortConditionlIcon(SJctrDKCKgetPortLEDStatusInfo portLEDInfo) {
        int iconID = 0;
        int iLEDStatus = portLEDInfo.getPortLEDStatus();
        switch (iLEDStatus) {
            case 2: {
                iconID = SJctrIconDefine.ICON_ST_AVAILABLE_CONNECTED;
                break;
            }
            case 3: {
                iconID = SJctrIconDefine.ICON_ST_AVAILABLE_NOT_CONNECTED;
                break;
            }
            case 1: {
                iconID = SJctrIconDefine.ICON_ST_NOT_AVAILABLE;
                break;
            }
            default: {
                SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "getPortConditionlIcon", "LEDStatus : " + iLEDStatus);
            }
        }
        return iconID;
    }

    public static int getPortConditionlIcon(SJctrDKCKgetPortLEDStatusInfo portLEDInfo, boolean resourceFlg) {
        int iconID = 0;
        iconID = resourceFlg ? SJctrPortUtility.getPortConditionlIcon(portLEDInfo) : SJctrIconDefine.ICON_ST_NOT_AVAILABLE;
        return iconID;
    }

    public String toDispAdapterType(SJmoChaDetail chaDetail) {
        String sCHAPackageType = QUESTION;
        byte bCHAPackageType = chaDetail.getByCHAPackageType();
        String strGuidKey = GUIDANCE_ADAPTER_TYPE.get(bCHAPackageType);
        if (strGuidKey != null) {
            sCHAPackageType = this.guidanceHandle.getGuidance(strGuidKey);
        } else {
            SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toDispAdapterDype", "CHAPackageType : " + bCHAPackageType);
        }
        return this.getCache(sCHAPackageType, PACKAGE_TYPE);
    }

    public String toDispPortLEDStatus(SJctrDKCKgetPortLEDStatusInfo portLEDStatusInfo, boolean resourceFlg) {
        String sPortLEDStatus = QUESTION;
        if (resourceFlg) {
            int iPortLEDStatus = portLEDStatusInfo.getPortLEDStatus();
            switch (iPortLEDStatus) {
                case 2: {
                    sPortLEDStatus = this.guidanceHandle.getGuidance("AVAILABLE_CONNECTED");
                    break;
                }
                case 3: {
                    sPortLEDStatus = this.guidanceHandle.getGuidance("AVAILABLE_NOT_CONNECTED");
                    break;
                }
                case 1: {
                    sPortLEDStatus = this.guidanceHandle.getGuidance("NOT_AVAILABLE");
                    break;
                }
                default: {
                    SJctrLogUty.warn(SJctrPortUtility.class.getSimpleName(), "toDispPortLEDStatus", "LEDStatus : " + iPortLEDStatus);
                    break;
                }
            }
        } else {
            sPortLEDStatus = this.guidanceHandle.getGuidance("NOT_AVAILABLE");
        }
        return this.getCache(sPortLEDStatus, PORT_LED_STATUS);
    }

    public static boolean hasCHBB(List<SJmoChaDetail> chaDetailList) {
        boolean ret = false;
        ArrayList<Short> chbbList = new ArrayList<Short>(CHBNumberByPort_CHBB.length);
        for (short chaNo : CHBNumberByPort_CHBB) {
            chbbList.add(chaNo);
        }
        for (SJmoChaDetail chaDetail : chaDetailList) {
            short chaNo = chaDetail.getSCHANumber();
            if (!chbbList.contains(chaNo)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void checkIscsiPortSecurityMsg(List portDetailList, List<SJctrPortHostGroupTableKey> targetIt, SJctrDataController dc) {
        short iscsiTarget = 0;
        SJmoPortDetail portDetail = null;
        boolean msgFlg = false;
        boolean ret = true;
        for (SJctrPortHostGroupTableKey tableKey : targetIt) {
            SJmoPortIscsiTargetInfo phgInfo = tableKey.getPortIscsiTargetInfo();
            int i = Collections.binarySearch(portDetailList, phgInfo);
            if (i < 0 || !(msgFlg = this.isPortSecurityMsg(portDetail = (SJmoPortDetail)portDetailList.get(i), iscsiTarget = tableKey.getIscsiTargetInfo().getSIscsiTarget()))) continue;
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(PORTUTILITY_ERR1);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
            break;
        }
    }

    public static String toDispIPv4(int[] intV4Address) {
        int ipv4Size = 4;
        if (ipv4Size != intV4Address.length) {
            return SPACE;
        }
        StringBuffer strV4Address = new StringBuffer();
        for (int length = 0; length < ipv4Size; ++length) {
            strV4Address.append(Integer.toString(intV4Address[length]));
            if (length + 1 >= ipv4Size) continue;
            strV4Address.append(".");
        }
        return strV4Address.toString();
    }

    public static String toDispIPv6(int[] intV8Address) {
        int ipv6Size = 8;
        if (ipv6Size != intV8Address.length) {
            return SPACE;
        }
        StringBuffer strV8Address = new StringBuffer();
        for (int length = 0; length < ipv6Size; ++length) {
            strV8Address.append(Integer.toHexString(intV8Address[length]));
            if (length + 1 >= ipv6Size) continue;
            strV8Address.append(":");
        }
        return strV8Address.toString();
    }

    public String toHostModeDisplay(SJmoIscsiTargetInfo iscsiTarget) {
        String str = "?[?]";
        if (iscsiTarget != null) {
            str = this.toHostModeDisplay((byte)iscsiTarget.getIHostMode());
        }
        return str;
    }

    public String toHostNumDisplay(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String result = "0";
        if (iscsiTargetInfo != null) {
            int hostNum = iscsiTargetInfo.getAlIscsiName().size();
            result = SJctrComUtility.toDecString(hostNum);
        }
        return result;
    }

    public static List<SJmoIscsiTargetInfo> getAllIscsiTarInPort(List<SJmoPortIscsiTargetInfo> ptItInfo, SJmoPortIndex chkPort) {
        ArrayList<SJmoIscsiTargetInfo> retList = new ArrayList<SJmoIscsiTargetInfo>();
        if (ptItInfo == null || chkPort == null) {
            return retList;
        }
        ArrayList<SJmoPortIscsiTargetInfo> ptItInfoList = new ArrayList<SJmoPortIscsiTargetInfo>(ptItInfo.size());
        ptItInfoList.addAll(ptItInfo);
        Collections.sort(ptItInfoList);
        int portIndex = Collections.binarySearch(ptItInfo, chkPort);
        if (portIndex >= 0) {
            SJmoPortIscsiTargetInfo modelPortItInfo = ptItInfo.get(portIndex);
            retList = modelPortItInfo.getAlPortIscsiTarget();
        }
        return retList;
    }

    public static List<SJmoIscsiName> getAllIscsiNameInPort(List<SJmoPortIscsiTargetInfo> ptItInfo, SJmoPortIndex chkPort) {
        ArrayList<SJmoIscsiName> retList = new ArrayList<SJmoIscsiName>();
        List<SJmoIscsiTargetInfo> modelItInfoList = SJctrPortUtility.getAllIscsiTarInPort(ptItInfo, chkPort);
        for (SJmoIscsiTargetInfo itInfo : modelItInfoList) {
            ArrayList<SJmoIscsiName> iscsiNameList = itInfo.getAlIscsiName();
            retList.addAll(iscsiNameList);
        }
        Collections.sort(retList);
        return retList;
    }

    public String toDispStringChapMode(SJmoIscsiTargetInfo itInfo) {
        String ret = QUESTION;
        if (itInfo != null) {
            switch (itInfo.getiAuthentMode()) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                }
            }
        }
        return ret;
    }

    public String toDispStringChapAuth(SJmoIscsiTargetInfo itInfo) {
        String ret = QUESTION;
        if (itInfo != null) {
            switch (itInfo.getiUserAuthentSwitch()) {
                case 2: {
                    ret = this.guidanceHandle.getGuidance("CHAP_NONE");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("CHAP");
                    break;
                }
                case 3: {
                    ret = this.guidanceHandle.getGuidance("COMP_WITH_HOST_SETTING");
                }
            }
        }
        return ret;
    }

    public static boolean isIscsiPort(SJmoPortDetail portDetail) {
        byte kind = portDetail.getByPortKindNo();
        boolean ret = false;
        if (kind == 5) {
            ret = true;
        }
        return ret;
    }

    public String toIscsiTargetNameDisplay(SJmoIscsiTargetInfo itInfo) {
        String nickname;
        String str = "? (?)";
        if (itInfo != null && (nickname = itInfo.getStrIscsiTargetName()).length() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(nickname);
            buf.append(" (" + String.format("%02X", itInfo.getSIscsiTarget()) + BRACKET_R);
            str = buf.toString();
        }
        return str;
    }

    public String toIscsiTargetAliasDisplay(SJmoIscsiTargetInfo itInfo) {
        String alias;
        String str = "? (?)";
        if (itInfo != null && (alias = itInfo.getStrIscsiTargetAlias()).length() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(alias);
            buf.append(" (" + String.format("%02X", itInfo.getSIscsiTarget()) + BRACKET_R);
            str = buf.toString();
        }
        return str;
    }

    public static int[] splitIPv4String(String ipv4Addr) {
        int[] ipv4Default;
        int[] iIpv4Addr = ipv4Default = new int[]{-1, -1, -1, -1};
        String[] strSplitAddr = ipv4Addr.split("\\.");
        if (strSplitAddr.length != 4) {
            return ipv4Default;
        }
        for (int size = 0; size < strSplitAddr.length; ++size) {
            int addrPart = Integer.valueOf(strSplitAddr[size]);
            if (addrPart < 0 || addrPart > 255) {
                return ipv4Default;
            }
            iIpv4Addr[size] = addrPart;
        }
        return iIpv4Addr;
    }

    public String toT10PIModeDisplay(SJmoPortDetail portDetail) {
        String t10PiModeDisp = QUESTION;
        if (portDetail == null) {
            return t10PiModeDisp;
        }
        int t10ModeNum = portDetail.getIT10Pi();
        switch (t10ModeNum) {
            case 0: {
                t10PiModeDisp = "-";
                return t10PiModeDisp;
            }
            case 1: {
                t10PiModeDisp = this.guidanceHandle.getGuidance("ENABLED");
                return t10PiModeDisp;
            }
            case 2: {
                t10PiModeDisp = this.guidanceHandle.getGuidance("DISABLED");
            }
        }
        return t10PiModeDisp;
    }

    public static SJmoLdevIndex getLdevIndexFromLUPathInfo(SJmoPortLunDetail luPathDtl) {
        SJmoLdevIndex ldev = new SJmoLdevIndex();
        ldev.setLdevIndex(luPathDtl.getSLDKC(), luPathDtl.getSCU(), luPathDtl.getSLDEV());
        return ldev;
    }

    public static SJmoLdevIndex getLdevIndexFromPortLunTableKey(SJctrPortLunTableKey portLunTblKey) {
        SJmoPortLunDetail luPathDtl = portLunTblKey.getPortLunDetail();
        return SJctrPortUtility.getLdevIndexFromLUPathInfo(luPathDtl);
    }

    public static List<SJmoLdevIndex> getLdevIndexFromPortLunTableKey(List<SJctrPortLunTableKey> portLunTblKeyList) {
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>(portLunTblKeyList.size());
        for (SJctrPortLunTableKey portLunTblKey : portLunTblKeyList) {
            SJmoLdevIndex ldev = SJctrPortUtility.getLdevIndexFromPortLunTableKey(portLunTblKey);
            int index = Collections.binarySearch(retList, ldev, ldevIndexCmp);
            if (index >= 0) continue;
            retList.add(~index, ldev);
        }
        return retList;
    }

    public static SJmoLdevDetail getLdevDetailFromPortLunDetail(SJmoPortLunDetail luPathDtl, List<SJmoLdevDetail> ldevDtlList) {
        SJmoLdevDetail ldevDtl = null;
        int index = Collections.binarySearch(ldevDtlList, luPathDtl, ldevIndexCmp);
        if (index >= 0) {
            ldevDtl = ldevDtlList.get(index);
        }
        return ldevDtl;
    }

    public static List<SJmoLdevDetail> getLdevDetailFromPortLunDetail(List<SJmoPortLunDetail> portLunDtlList, List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(portLunDtlList.size());
        for (SJmoPortLunDetail luPathDtl : portLunDtlList) {
            SJmoLdevDetail ldevDtl = SJctrPortUtility.getLdevDetailFromPortLunDetail(luPathDtl, ldevDtlList);
            if (ldevDtl == null) continue;
            retList.add(ldevDtl);
        }
        Collections.sort(retList);
        return retList;
    }

    public static List<SJmoLdevDetail> getLdevDetailFromPortLunTableKey(List<SJctrPortLunTableKey> portLunTblKeyList, List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(portLunTblKeyList.size());
        for (SJctrPortLunTableKey portLunTblKey : portLunTblKeyList) {
            SJmoPortLunDetail luPathDtl = portLunTblKey.getPortLunDetail();
            SJmoLdevDetail ldevDtl = SJctrPortUtility.getLdevDetailFromPortLunDetail(luPathDtl, ldevDtlList);
            if (ldevDtl == null) continue;
            retList.add(ldevDtl);
        }
        Collections.sort(retList);
        return retList;
    }

    public static boolean isParentLUN(SJctrWizardWindowDC wiz) {
        boolean rtn = false;
        if (wiz != null) {
            SJctrTableDataModel table = (SJctrTableDataModel)wiz.getParentDC().getDataObjectModel(KEY_TABLE);
            if (table == null) {
                return false;
            }
            List<Object> allRowData = table.getAllRowData();
            if (!allRowData.isEmpty()) {
                Object rowData = allRowData.get(0);
                rtn = rowData instanceof SJmoPortLunDetail | rowData instanceof SJctrPortLunTableKey;
            }
        }
        return rtn;
    }

    public static short[][] getPortGrpArry(PortGroupType type) {
        if (type != PortGroupType.PORTGROUP_2PORT && type != PortGroupType.PORTGROUP_4PORT) {
            return null;
        }
        int iModel = SJsncProductModelUty.getProductModel();
        if (iModel == 20) {
            return PORTGroupArray_S[type.ordinal()];
        }
        if (iModel == 40) {
            return PORTGroupArray_M[type.ordinal()];
        }
        if (iModel == 60) {
            return PORTGroupArray_H[type.ordinal()];
        }
        return PORTGroupArray_H[type.ordinal()];
    }

    public String toAluaStateDisplay(SJmoPortLunDetail portLunDetail) {
        String str = STR_HYPHEN;
        if (portLunDetail != null) {
            byte asymmetricAcessState = portLunDetail.getByAsymmetricAccessState();
            if (asymmetricAcessState == 0) {
                str = this.guidanceHandle.getGuidance("ACTIVE_OPT");
            } else if (asymmetricAcessState == 1) {
                str = this.guidanceHandle.getGuidance("ACTIVE_NONOPT");
            }
        }
        return str;
    }

    public String toAluaUsedDisplay(SJmoLdevDetail ldevDetail) {
        String str = STR_HYPHEN;
        if (ldevDetail != null) {
            str = ldevDetail.getBAluaMode() ? this.guidanceHandle.getGuidance("YES") : this.guidanceHandle.getGuidance("NO");
        }
        return str;
    }

    public String toSFPDataTransferRateDisplay(SJmoPortDetail portDetail) {
        String str = QUESTION;
        if (portDetail != null) {
            switch (portDetail.getSFPDataTransferRate()) {
                case 8: {
                    str = "8 Gbps";
                    break;
                }
                case 10: {
                    str = "10 Gbps";
                    break;
                }
                case 16: {
                    str = "16 Gbps";
                    break;
                }
                case 32: {
                    str = "32 Gbps";
                    break;
                }
                case 5: {
                    str = STR_HYPHEN;
                    break;
                }
                default: {
                    str = QUESTION;
                }
            }
        }
        return str;
    }

    static {
        ROUND_TRIP_HOST_MODE_OPT.add(49);
        ROUND_TRIP_HOST_MODE_OPT.add(50);
        RESOURCE_PORT_CLASS = resourcePortDetail.class;
        PORT_LED_STATUS_CLASS = SJctrDKCKgetPortLEDStatusInfo.class;
        KEY_CLASS_CHA_DETAIL = SJmoGetChaDetail.class;
        KEY_CLASS_PORT_ATTRIBUTE = SJmoGetPortAttributeInfo.class;
        GUIDANCE_ADAPTER_TYPE = new HashMap<Byte, String>();
        if (SJctrDataController.isHM()) {
            GUIDANCE_ADAPTER_TYPE.put((byte)108, "8FC4_CHB");
            GUIDANCE_ADAPTER_TYPE.put((byte)119, "16FC2_CHB");
            GUIDANCE_ADAPTER_TYPE.put((byte)120, "10ISCSI2O_CHB");
            GUIDANCE_ADAPTER_TYPE.put((byte)121, "10ISCSI2C_CHB");
            GUIDANCE_ADAPTER_TYPE.put((byte)125, "32FC4R_CHB");
        } else {
            GUIDANCE_ADAPTER_TYPE.put((byte)106, "16M8_MFIBRE");
            GUIDANCE_ADAPTER_TYPE.put((byte)107, "16FC8_FIBRE");
            GUIDANCE_ADAPTER_TYPE.put((byte)108, "8FC8_FIBRE");
            GUIDANCE_ADAPTER_TYPE.put((byte)118, "8FC16_FIBRE");
        }
        PACKAGE_TYPE = new WeakHashMap();
        PORT_LED_STATUS = new WeakHashMap();
        CHA_MAX_DKC = 32;
        PORT_MAX_CHA = 8;
        PORT_MAX_CL = PORT_MAX / 2;
        CHA_MAX_CL = CHA_MAX_DKC / 2;
        PortPCBMaskToCHANumber = new short[]{1, 3, 2, 4, 9, 11, 10, 12, 5, 7, 6, 8, 13, 15, 14, 16};
        CHBNumberByPort_HM_S = new short[]{1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2};
        CHBNumberByPort_HM_M = new short[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8};
        CHBNumberByPort_HM_H = new short[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16};
        CHBNumberByPort_CHBB = new short[]{9, 10, 11, 12};
        ldevIndexCmp = new SJctrLdevIndexComparator();
        SJctrPortUtility.changeMacro();
        KEY_REQUEST = "RequestData";
        KEY_PORT = "iScsiPorts";
        KEY_PORT_ID = "Id";
        KEY_TARGET = "IscsiTargets";
        KEY_TARGET_ID = "Id";
        KEY_ISCSI = "IscsiNames";
        KEY_ISCSI_NAME = "Name";
        KEY_ISCSI_NICKNAME = "NickName";
        KEY_ISCSI_CHE_NAME = "ChangeName";
        KEY_PORT_IPV4 = "Ipv4";
        KEY_PORT_IPV4_IPADDR = "IpAddress";
        KEY_PORT_IPV4_SUBNET = "SubNetMask";
        KEY_PORT_IPV4_GATEWAY = "DefaultGateway";
        KEY_PORT_IPV6 = "Ipv6";
        KEY_PORT_IPV6_AVAILABLE = "Available";
        KEY_PORT_IPV6_LINK = "LinkLocalAddress";
        KEY_PORT_IPV6_LINK_AUTO = "AutoMode";
        KEY_PORT_IPV6_LINK_MANUAL = "ManualAddress";
        KEY_PORT_IPV6_GLOBAL = "GlobalAddress";
        KEY_PORT_IPV6_GLOBAL_AUTO = "AutoMode";
        KEY_PORT_IPV6_GLOBAL_MANUAL = "ManualAddress";
        KEY_PORT_IPV6_GATEWAY = "DefaultGateway";
        KEY_PORT_IPV6_GATEWAY_ASSIGNED = "AssignedAddress";
        KEY_PORT_TCPPORTNUM = "TcpPortNumber";
        KEY_PORT_SEL_ACK = "AvailableSelectiveAck";
        KEY_PORT_DEL_ACK = "AvailableDelayedAck";
        KEY_PORT_WINSIZE = "TcpWindowSize";
        KEY_PORT_MTUSIZE = "EthernetMtuSize";
        KEY_PORT_MTUSIZE_MTU = "Mtu";
        KEY_PORT_VLAN = "Vlan";
        KEY_PORT_VLAN_TAGGING = "AvailableTagging";
        KEY_PORT_VLAN_ID = "Id";
        KEY_PORT_KAT = "KeepAliveTimer";
        KEY_PORT_ISNS = "iSnsServer";
        KEY_PORT_ISNS_ENABLE = "Enabled";
        KEY_PORT_ISNS_IPTYPE = "IpType";
        KEY_PORT_ISNS_IPV4 = "Ipv4Address";
        KEY_PORT_ISNS_IPV6 = "Ipv6Address";
        KEY_PORT_ISNS_TCPPORTNUM = "TcpPortNumber";
        KEY_ISNS_TYPE_V4 = 0;
        KEY_ISNS_TYPE_V6 = 1;
        mRegex = Pattern.compile("^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$");
        PORTGroupArray_2Port_H = new short[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 13}, {14, 15}, {16, 17}, {18, 19}, {20, 21}, {22, 23}, {24, 25}, {26, 27}, {28, 29}, {30, 31}, {32, 33}, {34, 35}, {36, 37}, {38, 39}, {40, 41}, {42, 43}, {44, 45}, {46, 47}, {48, 49}, {50, 51}, {52, 53}, {54, 55}, {56, 57}, {58, 59}, {60, 61}, {62, 63}, {64, 65}, {66, 67}, {68, 69}, {70, 71}, {72, 73}, {74, 75}, {76, 77}, {78, 79}, {80, 81}, {82, 83}, {84, 85}, {86, 87}, {88, 89}, {90, 91}, {92, 93}, {94, 95}, {96, 97}, {98, 99}, {100, 101}, {102, 103}, {104, 105}, {106, 107}, {108, 109}, {110, 111}, {112, 113}, {114, 115}, {116, 117}, {118, 119}, {120, 121}, {122, 123}, {124, 125}, {126, 127}};
        PORTGroupArray_2Port_M = new short[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 13}, {14, 15}, {16, 17}, {18, 19}, {20, 21}, {22, 23}, {24, 25}, {26, 27}, {28, 29}, {30, 31}, {32, 33}, {34, 35}, {36, 37}, {38, 39}, {40, 41}, {42, 43}, {44, 45}, {46, 47}, {48, 49}, {50, 51}, {52, 53}, {54, 55}, {56, 57}, {58, 59}, {60, 61}, {62, 63}};
        PORTGroupArray_2Port_S = new short[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 13}, {14, 15}};
        PORTGroupArray_4Port_H = new short[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}, {24, 25, 26, 27}, {28, 29, 30, 31}, {32, 33, 34, 35}, {36, 37, 38, 39}, {40, 41, 42, 43}, {44, 45, 46, 47}, {48, 49, 50, 51}, {52, 53, 54, 55}, {56, 57, 58, 59}, {60, 61, 62, 63}, {64, 65, 66, 67}, {68, 69, 70, 71}, {72, 73, 74, 75}, {76, 77, 78, 79}, {80, 81, 82, 83}, {84, 85, 86, 87}, {88, 89, 90, 91}, {92, 93, 94, 95}, {96, 97, 98, 99}, {100, 101, 102, 103}, {104, 105, 106, 107}, {108, 109, 110, 111}, {112, 113, 114, 115}, {116, 117, 118, 119}, {120, 121, 122, 123}, {124, 125, 126, 127}};
        PORTGroupArray_4Port_M = new short[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}, {24, 25, 26, 27}, {28, 29, 30, 31}, {32, 33, 34, 35}, {36, 37, 38, 39}, {40, 41, 42, 43}, {44, 45, 46, 47}, {48, 49, 50, 51}, {52, 53, 54, 55}, {56, 57, 58, 59}, {60, 61, 62, 63}};
        PORTGroupArray_4Port_S = new short[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}};
        PORTGroupArray_S = new short[][][]{PORTGroupArray_2Port_S, PORTGroupArray_4Port_S};
        PORTGroupArray_M = new short[][][]{PORTGroupArray_2Port_M, PORTGroupArray_4Port_M};
        PORTGroupArray_H = new short[][][]{PORTGroupArray_2Port_H, PORTGroupArray_4Port_H};
    }

    public static enum PortGroupType {
        PORTGROUP_2PORT,
        PORTGROUP_4PORT;

    }

    public static final class resourcePortDetail {
    }
}

