/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.wizard.account.com.SJctrRoleInfoDetail;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrRoleInfoDetailUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static final Map<String, String> roleMap = new HashMap<String, String>();
    private static WeakHashMap<String, WeakReference<String>> ROLE_NAME;

    public SJctrRoleInfoDetailUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String toRoleNameDisplay(SJctrRoleInfoDetail roleInfo) {
        String ret = "?";
        if (roleInfo != null) {
            if (roleInfo.getType() == SJcAccountConst.INT_ROLETYPE_BUILDIN) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", roleMap.get(roleInfo.getRoleName()));
            } else {
                String roleName = roleInfo.getRoleName();
                if (roleName != null) {
                    ret = roleName;
                }
            }
        }
        return this.getCache(ret, ROLE_NAME);
    }

    public String toRoleNameDisplayAdt(SJctrRoleInfoDetail roleInfo) {
        String ret = "?";
        if (roleInfo != null) {
            if (roleInfo.getType() == SJcAccountConst.INT_ROLETYPE_BUILDIN) {
                ret = this.guidanceHandle.getGuidance("ACCOUNT", "ADT_" + roleMap.get(roleInfo.getRoleName()));
            } else {
                String roleName = roleInfo.getRoleName();
                if (roleName != null) {
                    ret = roleName;
                }
            }
        }
        return this.getCache(ret, ROLE_NAME);
    }

    static {
        roleMap.put("Security Administrator (View Only)", "BUILT_IN_ROLE1");
        roleMap.put("Audit Log Administrator (View Only)", "BUILT_IN_ROLE2");
        roleMap.put("Security Administrator (View & Modify)", "BUILT_IN_ROLE3");
        roleMap.put("Audit Log Administrator (View & Modify)", "BUILT_IN_ROLE4");
        roleMap.put("Storage Administrator (View Only)", "BUILT_IN_ROLE5");
        roleMap.put("Storage Administrator (Initial Configuration)", "BUILT_IN_ROLE6");
        roleMap.put("Storage Administrator (System Resource Management)", "BUILT_IN_ROLE7");
        roleMap.put("Storage Administrator (Provisioning)", "BUILT_IN_ROLE8");
        roleMap.put("Storage Administrator (Performance Management)", "BUILT_IN_ROLE9");
        roleMap.put("Storage Administrator (Local Copy)", "BUILT_IN_ROLE10");
        roleMap.put("Storage Administrator (Remote Copy)", "BUILT_IN_ROLE11");
        roleMap.put("Support Personnel", "BUILT_IN_ROLE12");
        roleMap.put("User Maintenance", "BUILT_IN_ROLE13");
        ROLE_NAME = new WeakHashMap();
    }
}

