/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;

public class SJctrDepletionThresholdFromPoolVolDetailColumn
extends SJctrColumn {
    private Map<Class<?>, List<?>> m_ModelData;

    public SJctrDepletionThresholdFromPoolVolDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("THRESHOLD_DEPLETION"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPoolDetail> retList = new ArrayList<SJmoPoolDetail>();
        this.m_ModelData = modelData;
        if (null != index && index instanceof SJmoPoolVolDetail) {
            SJmoPoolVolDetail idxPoolVolDetail = (SJmoPoolVolDetail)index;
            List<?> poolDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
            if (null != poolDetailList && 0 != poolDetailList.size()) {
                int iPoolDetailIdx = Collections.binarySearch(poolDetailList, idxPoolVolDetail);
                if (0 <= iPoolDetailIdx) {
                    SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(iPoolDetailIdx);
                    retList.add(poolDetail);
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPoolDetail is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPoolDetail List is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)obj;
            SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
            strRtn = poolUtl.toPoolDepletionThresholdDisplay(poolDtl);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDtl;
        long lPoolThreshold = 0L;
        SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
        String strDepThreshold = poolUtl.toPoolDepletionThresholdDisplay(poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat));
        lPoolThreshold = strDepThreshold.equals("-") ? (long)SJctrPoolUtility.HAIFUN_NUM : (strDepThreshold.equals("?") ? -2L : Long.parseLong(strDepThreshold));
        return lPoolThreshold;
    }
}

