/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrLunIdColumnFromPortLunTableKey
extends SJctrColumn {
    private boolean bLunIdDec;

    public SJctrLunIdColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LUN_ID"));
        this.bLunIdDec = this.isLunIdNotationDec();
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String ret = this.bLunIdDec ? "^\\d{1,19}$" : "^([0-9A-Fa-f]{1,4})$";
        return ret;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortLunDetail> list = new ArrayList<SJmoPortLunDetail>();
        SJctrPortLunTableKey ptLunInfo = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail ptLunDeteil = ptLunInfo.getPortLunDetail();
        list.add(ptLunDeteil);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortLunDetail portlunDetail = (SJmoPortLunDetail)dataList.get(0);
        String ret = this.bLunIdDec ? SJctrComUtility.toDecString(portlunDetail.getSLUN()) : SJctrComUtility.toHexString(portlunDetail.getSLUN(), 4, true);
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int lun = -1;
        SJctrPortLunTableKey ptLunTableKey = (SJctrPortLunTableKey)this.getPrimaryKeyObject(dat);
        SJmoPortLunDetail ptLunDeteil = ptLunTableKey.getPortLunDetail();
        if (ptLunDeteil != null) {
            lun = ptLunDeteil.getSLUN();
        }
        return lun;
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getTable().getDataController().getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }

    public void setBLunIdDec(boolean bLunIdDec) {
        this.bLunIdDec = bLunIdDec;
    }
}

