/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;

public class SJctrNumOfStorageSystemsColumnFromExctg
extends SJctrColumn {
    public SJctrNumOfStorageSystemsColumnFromExctg(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("NUM_OF_STORAGE_SYSTEMS"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        SJmoUniversalReplicatorEXCTG tableData = (SJmoUniversalReplicatorEXCTG)dataList.get(0);
        if (tableData != null) {
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getTable().getComUtility().getRemoteReplicationUtility();
            ret = remoteReplicaUty.getExctgStorageSystemNumString(tableData);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long number = -1L;
        SJmoUniversalReplicatorEXCTG tblData = (SJmoUniversalReplicatorEXCTG)this.getPrimaryKeyObject(dat);
        if (tblData != null && tblData.getJnlGrpList() != null) {
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> jnlList = tblData.getJnlGrpList();
            HashSet<String> set = new HashSet<String>();
            for (SJmoUniversalReplicatorEXCTGJnlGrp jnl : jnlList) {
                String id = SJctrComUtility.toHexString(jnl.getModelId(), 2, true);
                String idSn = id + jnl.getSN();
                set.add(idSn);
            }
            number = set.size();
        }
        return number;
    }
}

