/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.thinimage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.replication.com.SJctrHgNameColumnFromLdevIndex;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrHgNameIscsiTargetAliasColumnFromLdevIndex
extends SJctrHgNameColumnFromLdevIndex {
    public SJctrHgNameIscsiTargetAliasColumnFromLdevIndex(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortIndex> retList = new ArrayList<SJmoPortIndex>();
        if (this.ldevLUPathInfoMap == null) {
            this.ldevLUPathInfoMap = (Map)modelData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        }
        List<?> ptITList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
        SJmoLdevIndex volIndex = this.getTargetLdevIndex(index);
        SJmoPortLunDetail portLunDtl = SJctrRemoteReplicationUtility.getDisplayLunDetailInfo(volIndex, this.ldevLUPathInfoMap);
        if (portLunDtl != null) {
            List<?> portHGList = modelData.get(SJmoGetPortHostGroupInfo.class);
            int portIndex = Collections.binarySearch(portHGList, portLunDtl);
            if (portIndex >= 0) {
                SJmoPortHostGroupInfo portHGInfo = (SJmoPortHostGroupInfo)portHGList.get(portIndex);
                ArrayList hgInfoList = portHGInfo.getAlPortHostGroup();
                for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                    if (hgInfo.getSHostGroup() != portLunDtl.getSHostGroup()) continue;
                    retList.add(hgInfo);
                    break;
                }
            } else {
                if (ptITList != null && ptITList.size() > 0) {
                    portIndex = Collections.binarySearch(ptITList, portLunDtl);
                }
                if (portIndex >= 0) {
                    ArrayList<SJmoIscsiTargetInfo> itList = ((SJmoPortIscsiTargetInfo)ptITList.get(portIndex)).getAlPortIscsiTarget();
                    SJmoIscsiTargetIndex itKey = new SJmoIscsiTargetIndex();
                    itKey.setSPort(portLunDtl.getSPort());
                    itKey.setSIscsiTarget(portLunDtl.getSHostGroup());
                    Collections.sort(itList);
                    int hgIdx = Collections.binarySearch(itList, itKey);
                    if (hgIdx >= 0) {
                        SJmoIscsiTargetInfo data = itList.get(hgIdx);
                        retList.add(data);
                    }
                }
            }
        } else {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            retList.add(portIndex);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
        String strRet = "?";
        if (dataList.size() > 0 && dataList.get(0) != null) {
            if (dataList.get(0) instanceof SJmoHostGroupInfo) {
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)dataList.get(0);
                strRet = util.toHostGroupNameDisplay(hgInfo);
            } else if (dataList.get(0) instanceof SJmoIscsiTargetInfo) {
                SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)dataList.get(0);
                strRet = util.toIscsiTargetAliasDisplay(itInfo);
            } else if (dataList.get(0) instanceof SJmoPortIndex) {
                strRet = "";
            }
        }
        return strRet;
    }
}

