/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDLogicalPath_Fiber;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;

public class SJctrHighestPriorityLUNColumnFromExdlVolumeInfo
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;
    private boolean bDecDisplay = false;

    public SJctrHighestPriorityLUNColumnFromExdlVolumeInfo(String key) {
        super(key);
        this.setPartsId("LUN_HIGHEST_PRIORITY");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrPortUtility.isLunIdDecimal(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strLun = "?";
        SJmoExdVolumeInfo exdVol = (SJmoExdVolumeInfo)dataList.get(0);
        EXDLogicalPath_Fiber logicalPath = (EXDLogicalPath_Fiber)exdVol.getRmiExdVolumeInfo().getLogicalPathList()[0];
        if (logicalPath != null) {
            int lun = logicalPath.getLun();
            strLun = this.bDecDisplay ? SJctrComUtility.toDecString(lun) : SJctrComUtility.toHexString(lun, 4, true);
            if (this.numberMap == null) {
                this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
            }
            this.numberMap.put(strLun, lun);
        }
        return strLun;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String getInputFormat() {
        String ret = "^([0-9A-Fa-f]{1,4})$";
        if (this.bDecDisplay) {
            ret = "^\\d{1,19}$";
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (!strNum.equals("?")) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

