/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.concrete;

import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;

public class SJctrIPAddressInputDataModel
extends SJctrSimpleDataModel {
    public static final int TYPE_IPV4 = 0;
    public static final int TYPE_IPV6 = 1;
    public static final String KEY_IPV4 = "COM_IPV4";
    public static final String kEY_IPV6 = "COM_IPV6";
    public static final String GUID_IPV4 = "IPV4";
    public static final String GUID_IPV6 = "IPV6";
    private SJctrTextBoxDataModel textBox;
    private SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel();

    public SJctrIPAddressInputDataModel(String keyRadio, String keyText) {
        this.addDataModel(keyRadio, this.radio);
        this.textBox = new SJctrTextBoxDataModel();
        this.addDataModel(keyText, this.textBox);
    }

    public void initItems() {
        this.radio.add(KEY_IPV4, this.getComUtility().getGuidance(GUID_IPV4));
        this.radio.add(kEY_IPV6, this.getComUtility().getGuidance(GUID_IPV6));
    }

    public SJctrTextBoxDataModel getTextBoxModel() {
        return this.textBox;
    }

    public SJctrRadioButtonGroupDataModel getRadioModel() {
        return this.radio;
    }

    public void setText(String text) {
        this.textBox.setValue(text);
    }

    public String getText() {
        return this.textBox.getValue();
    }

    public void setVersion(int version) {
        switch (version) {
            case 0: {
                this.radio.setSelect(KEY_IPV4);
                break;
            }
            default: {
                this.radio.setSelect(kEY_IPV6);
            }
        }
    }

    public int getVersion() {
        if (this.radio.isSelect(KEY_IPV4)) {
            return 0;
        }
        return 1;
    }

    public void checkAddress() throws SJcException {
        if (this.radio.isSelect(kEY_IPV6)) {
            SJctrIpAddrUtility.IPv6 ipV6 = new SJctrIpAddrUtility.IPv6();
            ipV6.chkRegex(this.textBox.getValue());
        } else {
            SJctrIpAddrUtility.IPv4 ipV4 = new SJctrIpAddrUtility.IPv4();
            ipV4.chkRegex(this.textBox.getValue());
        }
    }

    public String getRegularAddress() throws SJcException {
        if (this.radio.isSelect(KEY_IPV4)) {
            SJctrIpAddrUtility.IPv4 ipV4 = new SJctrIpAddrUtility.IPv4();
            return ipV4.toRegularWithUsableCheck(this.textBox.getValue());
        }
        SJctrIpAddrUtility.IPv6 ipV6 = new SJctrIpAddrUtility.IPv6();
        return ipV6.toRegularWithUsableCheck(this.textBox.getValue());
    }

    public void setEnableAll(boolean flag) {
        this.radio.setEnable(flag);
        this.textBox.setEnable(flag);
    }
}

