/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrNestedListDataModel;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;

public class SJctrComboBoxDataModel
extends SJctrNestedListDataModel {
    private static final String DIRECT_INPUT_NAME = "";
    private static final String KEY_SELECTED_INDEX = "COM_SELECTED_INDEX";

    public SJctrComboBoxDataModel() {
        this(10);
    }

    public SJctrComboBoxDataModel(int size) {
        super(size);
        SJctrNestedListDataObject nestList = (SJctrNestedListDataObject)this.getManageData();
        nestList.visible(SJctrNestedListDataObject.VISIBLE_ACTIVE);
        this.initListener();
    }

    @Override
    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = super.createItem(name, label);
        Item.setSelect(item, false);
        return item;
    }

    @Override
    protected void makeDataObject() {
    }

    @Override
    protected void makeModelDirect() {
    }

    public void setSelectedIndex(int index) {
        ArrayList<HashMap<String, Object>> listData = ((SJctrNestedListDataObject)this.getManageData()).listData();
        if (index < 0) {
            this.clearSelection();
        } else if (listData.size() > index) {
            HashMap<String, Object> item = listData.get(index);
            String name = Item.getName(item);
            this.setSelection(name);
        }
    }

    public int getSelectedIndex() {
        int index = -1;
        String selectionName = this.getSelection();
        if (selectionName == null) {
            return -1;
        }
        ArrayList<HashMap<String, Object>> listData = ((SJctrNestedListDataObject)this.getManageData()).listData();
        for (int i = 0; i < listData.size(); ++i) {
            HashMap<String, Object> item = listData.get(i);
            String name = Item.getName(item);
            if (!selectionName.equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrNestedListDataObject nestedList;
                if (setObject instanceof SJctrNestedListDataObject && (nestedList = (SJctrNestedListDataObject)setObject).containsKey("COM_SET_ROW")) {
                    SJctrComboBoxDataModel.this.setAction(nestedList);
                }
            }
        });
    }

    private void setAction(SJctrNestedListDataObject nestedList) {
        ArrayList<HashMap<String, Object>> setList = nestedList.setRow();
        for (HashMap<String, Object> item : setList) {
            String name = Item.getName(item);
            if (!Item.containsSelect(item)) continue;
            if (Item.isSelect(item)) {
                if (DIRECT_INPUT_NAME.equals(name)) {
                    String label = Item.getLabel(item);
                    if (label != null) {
                        label = label.trim();
                    }
                    this.clearSelection(name);
                    HashMap<String, Object> directItem = this.createItem(name, label);
                    this.getItemMap().put(name, directItem);
                }
                this.setSelection(name);
                continue;
            }
            this.clearSelection(name);
        }
    }

    @Override
    public void clearSelection(String name) {
        super.clearSelection(name);
        if (DIRECT_INPUT_NAME.equals(name)) {
            this.getItemMap().remove(name);
        }
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        Object obj = controlData.get("COM_SELECTED");
        if (!(obj instanceof String)) {
            this.dataRestoreFailed("COM_SELECTED", obj);
            return;
        }
        String select = (String)obj;
        Map<String, HashMap<String, Object>> itemMap = this.getItemMap();
        if (itemMap.size() == 0) {
            this.dataRestoreFailed("COM_SELECTED", obj);
            return;
        }
        HashMap<String, Object> item = this.getItem(select);
        if (item != null) {
            this.setSelection(select);
            return;
        }
        this.dataRestoreFailed("COM_SELECTED", obj);
    }

    @Override
    public HashMap<String, Object> getOwnControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        String selectedName = this.getSelection();
        if (selectedName != null) {
            controlData.put("COM_SELECTED", selectedName);
        }
        return controlData;
    }

    public static class Item
    extends SJctrNestedListDataModel.Item {
        public Item(Map<String, Object> map) {
            super(map);
        }

        public static boolean containsSelect(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.containsSelect(item);
        }

        public static boolean isSelect(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.isSelect(item);
        }

        public static boolean setSelect(Map<String, Object> item, boolean flg) {
            return SJctrNestedListDataModel.Item.setSelect(item, flg);
        }
    }
}

