/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrAuthorize;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrNestedListDataModel;
import sanproject.sn2.controller.com.model.event.SJctrEventListener;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;

public class SJctrNewTreeDataModel
extends SJctrNestedListDataModel {
    private static final int MSG_NODE_MAX = 106072;
    private static final String SN_TREE_NODE_MAX = "SN_TREE_NODE_MAX";
    private static final int DEFAULT_NODE_MAX = 65536;
    private int nodeMax;
    private Set<String> expandedSet;

    public SJctrNewTreeDataModel() {
        this(10);
    }

    public SJctrNewTreeDataModel(int size) {
        super(size);
        this.initListener();
        this.expandedSet = new HashSet<String>(size);
        this.nodeMax = SJcEnvUty.getProperty2int(SN_TREE_NODE_MAX, 65536);
    }

    @Override
    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = super.createItem(name, label);
        Item.setSelect(item, false);
        Item.setExpand(item, false);
        return item;
    }

    @Override
    public HashMap<String, Object> createItem(SJctrNodeData nodeData, Object ... args) {
        SJctrAuthorize authorize = nodeData.getAuthorize();
        if (!this.chkAdaptiveOpt(nodeData)) {
            this.getLogUty().putlog("createItem", "chkAdaptiveOpt NG:" + nodeData.getLogicalPath() + ",Opt = " + nodeData.getNodeAdaptiveOpt());
            return null;
        }
        if (!authorize.chkResource()) {
            this.getLogUty().putlog("createItem", "chkResource NG:" + nodeData.getLogicalPath());
            return null;
        }
        HashMap<String, Object> item = super.createItem(nodeData, args);
        return item;
    }

    @Override
    protected void makeModelDirect() {
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrNestedListDataObject nestedList;
                if (setObject instanceof SJctrNestedListDataObject && (nestedList = (SJctrNestedListDataObject)setObject).containsKey("COM_SET_ROW")) {
                    SJctrNewTreeDataModel.this.setAction(nestedList);
                }
            }
        });
        this.addItemExpandListener(new SJctrItemExpandListener(){

            @Override
            public void treeCollapsed(SJctrItemExpandEvent<String> event) {
                String collapseName = (String)event.getChangeObject();
                String selectName = SJctrNewTreeDataModel.this.getSelection();
                if (selectName != null && selectName.startsWith(collapseName + "\t")) {
                    SJctrNewTreeDataModel.this.setSelectionToRoot(collapseName);
                }
            }

            @Override
            public void treeExpanded(SJctrItemExpandEvent<String> event) {
            }
        });
    }

    protected void setAction(SJctrNestedListDataObject nestedList) {
        ArrayList<HashMap<String, Object>> setList = nestedList.setRow();
        for (HashMap<String, Object> item : setList) {
            String name = Item.getName(item);
            if (Item.containsSelect(item)) {
                if (Item.isSelect(item)) {
                    this.addSelection(name);
                } else {
                    this.clearSelection(name);
                }
            }
            if (!Item.containsExpand(item)) continue;
            this.setExpandedState(name, Item.isExpand(item));
        }
    }

    public void addItemExpandListener(SJctrItemExpandListener listener) {
        this.addEventListener(listener);
    }

    public List<String> getExpandedList() {
        return new ArrayList<String>(this.expandedSet);
    }

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        this.expandedSet.clear();
    }

    @Override
    public void removeItem(String name) {
        super.removeItem(name);
        this.expandedSet.remove(name);
    }

    public boolean setExpandedState(List<String> nameList, boolean state) {
        boolean result = true;
        for (String name : nameList) {
            if (this.setExpandedState(name, state)) continue;
            result = false;
        }
        return result;
    }

    public boolean setExpandedState(String name, boolean state) {
        HashMap<String, Object> item;
        boolean result;
        int endIndex;
        this.logUty.putlog("setExpandedState", name + ":" + state);
        if (state && name != null && (endIndex = name.lastIndexOf("\t")) > 0) {
            String parentName = name.substring(0, endIndex);
            this.setExpandedState(parentName, state);
        }
        if (result = Item.setExpand(item = this.getItem(name), state)) {
            if (state) {
                this.expandedSet.add(name);
            } else {
                this.expandedSet.remove(name);
            }
            this.fireItemExpanded(name, state);
        } else if (item == null) {
            this.getLogUty().putlog("setExpandedState", "failed:itemName=" + name + " is null");
        } else {
            this.getLogUty().putlog("setExpandedState", "failed:itemName=" + name + "," + Item.isExpand(item));
        }
        return result;
    }

    protected void fireItemExpanded(String name, boolean state) {
        SJctrItemExpandEvent<String> event = null;
        this.setDirty();
        try {
            for (SJctrEventListener listener : this.getEventListeners()) {
                if (!(listener instanceof SJctrItemExpandListener)) continue;
                if (event == null) {
                    event = new SJctrItemExpandEvent<String>(this, name, state);
                }
                if (state) {
                    ((SJctrItemExpandListener)listener).treeExpanded(event);
                    continue;
                }
                ((SJctrItemExpandListener)listener).treeCollapsed(event);
            }
        }
        catch (SJctrTreeExpandException e) {
            this.setExpandedState(name, false);
            SJcMessage msg = e.getMsg();
            this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.TREE_EXPAND_EVNET_MSG, msg);
        }
    }

    @Override
    public boolean addItem(HashMap<String, Object> item) throws SJctrTreeExpandException {
        int nodeNum = this.getItemMap().size();
        if (nodeNum >= this.getNodeMax()) {
            this.getLogUty().putlog("addItem", "The number of nodes exceeded the maximum number. -> " + nodeNum, 40000);
            throw new SJctrTreeExpandException(106072);
        }
        return super.addItem(item);
    }

    public int getNodeMax() {
        return this.nodeMax;
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        Object obj = controlData.get("COM_EXPANDED");
        if (obj instanceof List) {
            ArrayList<String> nameList = new ArrayList<String>((List)obj);
            Collections.sort(nameList);
            this.setExpandedState(nameList, true);
        } else {
            this.dataRestoreFailed("COM_EXPANDED", obj);
        }
        obj = controlData.get("COM_SELECTED");
        if (obj instanceof List) {
            List select = (List)obj;
            if (this.isMultiSelect()) {
                this.addSelectionToRoot(select);
            } else if (select.size() > 0) {
                this.setSelectionToRoot((String)select.get(0));
            }
        } else {
            this.dataRestoreFailed("COM_SELECTED", obj);
        }
    }

    @Override
    public HashMap<String, Object> getOwnControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        controlData.put("COM_SELECTED", this.getSelectionList());
        controlData.put("COM_EXPANDED", this.getExpandedList());
        return controlData;
    }

    public void collapsePath(String name) {
        String path = name;
        int index = name.length();
        while (true) {
            this.setExpandedState(path, false);
            index = path.lastIndexOf("\t", index - 1);
            if (index < 0) break;
            path = name.substring(0, index);
        }
    }

    public static class SJctrTreeExpandException
    extends SJcException {
        private static final long serialVersionUID = -5136508134880445669L;

        public SJctrTreeExpandException() {
        }

        public SJctrTreeExpandException(int errorCode) {
            this(201, 22, errorCode);
        }

        public SJctrTreeExpandException(int func, int module, int errorCode) {
            this(new SJcMessage(Integer.toString(func), Integer.toString(module), Integer.toString(errorCode)));
        }

        public SJctrTreeExpandException(SJcMessage msg) {
            super(msg);
        }
    }

    public static class Item
    extends SJctrNestedListDataModel.Item {
        public Item(Map<String, Object> map) {
            super(map);
        }

        public static boolean containsSelect(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.containsSelect(item);
        }

        public static boolean isSelect(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.isSelect(item);
        }

        public static boolean containsExpand(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.containsExpand(item);
        }

        public static boolean isExpand(Map<String, Object> item) {
            return SJctrNestedListDataModel.Item.isExpand(item);
        }
    }
}

