/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrFilter;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrTabDataController;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.data.SJctrTextBoxDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrMenuDataModel;
import sanproject.sn2.controller.com.model.SJctrNestedListDataModel;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.topwindow.base.SJctrChildViewModel;
import sanproject.sn2.controller.topwindow.base.SJctrCrumbTrailModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.topwindow.comdialog.colsetting.SJctrColumnSettingsDC;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public abstract class SJctrTableDataModel
extends SJctrDataObjectModel<SJctrTblDataObject> {
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String KEY_APPLY = "COM_APPLY";
    public static final String CTRL_MODEL_KEY = "CTRL_MODEL_KEY";
    public static final String KEY_NAME = "name";
    public static final String KEY_FILTER_LOGIC = "COM_FILTER_LOGIC";
    public static final String KEY_FILTER_VALUE = "COM_FILTER_VALUE";
    private static final String TMENU_MAX_ROW_PAGE = "ROWS_PAGES";
    private static final String[] MAX_ROW_PAGE_LIST = new String[]{"300", "1000", "10000"};
    private static final String TMENU_CAPACITY_UNIT = "CAPACITY_UNIT";
    private static final String TMENU_CAPACITY_UNIT_MF = "CAPACITY_UNIT_MF";
    private static final SJctrCapacityUtility.UNIT[] CAPACITY_UNIT_LIST_COM = new SJctrCapacityUtility.UNIT[]{SJctrCapacityUtility.UNIT.TB, SJctrCapacityUtility.UNIT.GB, SJctrCapacityUtility.UNIT.MB, SJctrCapacityUtility.UNIT.BLOCK};
    private static final SJctrCapacityUtility.UNIT[] CAPACITY_UNIT_LIST_MF = new SJctrCapacityUtility.UNIT[]{SJctrCapacityUtility.UNIT.CYL};
    private static final SJctrCapacityUtility.UNIT[] CAPACITY_UNIT_LIST_DP = new SJctrCapacityUtility.UNIT[]{SJctrCapacityUtility.UNIT.PAGE};
    private static final String TMENU_COLUMN_SETTINGS = "COLUMN_SETTINGS";
    private static final int ALL_SELECT = -1;
    private static final int ALL_UNSELECT = -2;
    private static final String FILTER_AND = "ALL";
    private static final String FILTER_OR = "ANY";
    private static final int FILTER_DATA_MAX = 16;
    private static final int MIN_PAGE = 1;
    private static final int MIN_ROW = 1;
    private static final int MAX_PAGE = 999;
    private static final int DEF_PAGE_LIST_INDEX = 1;
    private static final int MAX_PAGE_LIST_INDEX = MAX_ROW_PAGE_LIST.length - 1;
    private static final SJctrColumn NULL_COLUMN_INFO = new SJctrColumn("NullObject"){

        @Override
        public int getFilterType() {
            return 1;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
            return new ArrayList(0);
        }

        @Override
        public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
            return new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
        }

        @Override
        public String toDispString(List<?> models) {
            return this.getMyKey();
        }

        @Override
        protected Comparator<HashMap<String, Object>> createComparator() {
            return new Comparator<HashMap<String, Object>>(){

                @Override
                public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                    return 0;
                }
            };
        }

        @Override
        public String getInputFormat() {
            return "";
        }

        @Override
        public int getSortType() {
            return 0;
        }
    };
    protected ArrayList<HashMap<String, Object>> allRowData;
    protected GET_STATUS status;
    protected ArrayList<HashMap<String, Object>> filteredRowData;
    protected ArrayList<HashMap<String, Object>> targetRowData;
    private Map<String, SJctrColumn> columnData = new LinkedHashMap<String, SJctrColumn>();
    private Class<?> primaryClass;
    private String primaryKey;
    private Map<String, Map<String, Object>> selectRowData;
    private List<SJctrFilter> rowFilterList = new ArrayList<SJctrFilter>(16);
    private static final int DEFAULT_MAX_ROW_PAGE = 1000;
    private static final int MAX_MAX_ROW_PAGE = 0xFFFFFFF;
    private boolean paging = true;
    private boolean capacityFlg;
    private boolean mainframeFlg;
    private boolean openFlg;
    private boolean dpFlg;
    private static final String KEY_HIDE_COLUMN_LIST = "COM_HIDE_COLUMN_LIST";
    private static final String KEY_SHOW_COLUMN_LIST = "COM_SHOW_COLUMN_LIST";
    private static final String KEY_COLUMN_SEQ_LIST = "COM_COLUMN_SEQ_LIST";
    private static final String PARM_TABLE_MODEL = "PARM_TABLE_MODEL";
    private static final String PARM_SEQ_LIST = "PARM_SEQ_LIST";
    private static final int SELECT_TYPE_MULTI = 0;
    private static final int SELECT_TYPE_SINGLE = 1;
    private static final int SELECT_TYPE_NONE = 2;
    private static final String GUID_SN_VER = "SN_VERSION";
    private static final String KEY_SEL_ROW = "COM_SEL_ROW";
    public static final Set<String> USER_DATA_KEY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("COM_SORT_COLUMN", "COM_SORT_ORDER", "COM_FILTER_LIST", "CAPACITY_UNIT", "COM_FILTER_COMP", "COM_HIDE_COLUMN_LIST", "COM_SHOW_COLUMN_LIST", "CAPACITY_UNIT_MF", "CTRL_USER")));
    public static final Set<String> RESET_VIEW_SETTTING_KEY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("COM_SORT_COLUMN", "COM_SORT_ORDER", "COM_FILTER_LIST", "CAPACITY_UNIT", "COM_FILTER_COMP", "COM_HIDE_COLUMN_LIST", "COM_SHOW_COLUMN_LIST", "COM_FILTER_ENABLE", "ROWS_PAGES", "CAPACITY_UNIT_MF", "CTRL_USER")));
    private String defaultUnitSelect = null;
    private boolean notifyUnitSelect = true;
    public static final String COMMENT = "#";
    public static final String COL_DELIMITER = "\t";
    public static final String ROW_DELIMITER = "\n";
    public static final String EXPORT_VERSION = "#! Version ";
    public static final String TAG_SERIAL = "[SerialNumber]";
    public static final String TAG_SUMMARY = "[Summary]";
    public static String SUMMARY_HEADER_SVPVER = "";
    public static final String SUMMARY_HEADER_PATH = "Page Path";
    public static final String SUMMARY_HEADER_TAB = "Page Tab";
    public static final String SUMMARY_HEADER_DATE = "Date";
    public static final String SUMMARY_HEADER_WINDOWNAME = "Window Name";
    public static final String SUMMARY_HEADER_TABNAME = "Tab Name";
    public static final String SUMMARY_HEADER_TABLENAME = "Table Name";
    public static final String CRUMB_DELIMITER = "/";
    private static final SimpleDateFormat EXPORT_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final String TAG_FILTEROPT = "[FilterCondition]";
    public static final String FILTEROPT_HEADER = "#Filter\tCondition";
    public static final String TAG_FILTERITEM = "[FilterItem]";
    public static final String FILTERITEM_HEADER = "#Column\tFilter Option\tFilter Item";
    public static final String FILTER_DELIMITER = "|";
    public static final String FILTER_DISABLED = "-";
    public static final String TAG_DETAIL = "[TableItem]";
    private boolean showColumnSettingMenu = false;
    private boolean flgVScrollReset = false;
    private String unitSelectOpen = null;
    private String unitSelectMainframe = null;

    public SJctrTableDataModel(boolean paging) {
        this.clearRowData();
        this.status = GET_STATUS.values()[0];
        this.initModel();
        this.initTableListener();
        this.initTable();
        this.setPaging(paging);
        this.setShowColumn();
        this.setGettingColumnData();
        this.setUserDataKey(USER_DATA_KEY);
    }

    public SJctrTableDataModel() {
        this(true);
    }

    public void doRefresh() {
        HashMap<String, Object> restoreData = this.getOwnControlData();
        this.setPreOwnControlData(restoreData);
        this.makeDataObject();
        this.setOwnControlData(restoreData);
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
    }

    public void doRefresh(String columnKey) {
        SJctrColumn column = this.getColumnInfo(columnKey);
        for (Map map : this.allRowData) {
            Object keyData = map.get(CTRL_MODEL_KEY);
            List<?> models = column.getNeedModelData(keyData, this.getBasicDataMap());
            Object cell = column.createCellObject(models);
            if (cell == null) continue;
            map.put(columnKey, cell);
            String str = column.getString(map);
            column.makeSelectFilterData(str);
        }
        this.logUty.putlog("doRefresh", "Create row data = " + this.allRowData.size());
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
    }

    public void addColumn(SJctrColumn columnInfo) {
        if (columnInfo != null) {
            String key = columnInfo.getMyKey();
            columnInfo.setTable(this);
            this.columnData.put(key, columnInfo);
            if (this.columnData.size() == 1) {
                this.primaryKey = key;
                this.primaryClass = this.getPrimaryClass();
            }
        }
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrConfirmDataController) {
            SJctrConfirmDataController confirmDc = (SJctrConfirmDataController)dc;
            confirmDc.restoreUnit();
            this.doRefresh();
            this.clearDirty();
        }
        switch (this.status) {
            case FILTER: {
                this.makeFilteredData();
                this.chgMaxRowPageMenu();
            }
            case SORT: {
                this.targetRowData.clear();
                this.targetRowData.addAll(this.filteredRowData);
                this.makeSortedData(this.targetRowData);
            }
            case PAGE: {
                this.makePagedData();
            }
            case NOACTION: {
                this.makeViewDataAlways();
            }
        }
        this.status = GET_STATUS.NOACTION;
        return super.getDataObject(inputObject);
    }

    public int getRowCount() {
        int rowCount = 0;
        if (this.allRowData != null) {
            rowCount = this.allRowData.size();
        }
        return rowCount;
    }

    public List<Object> getAllRowData() {
        return this.toKeyDataList(this.allRowData);
    }

    public List<Object> getSelectedRowDataOrder() {
        int size = this.targetRowData.size();
        ArrayList<Object> retList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> rowData = this.targetRowData.get(i);
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null || !this.selectRowData.containsKey(keyData.toString())) continue;
            retList.add(keyData);
        }
        return retList;
    }

    public List<Object> getSelectedRowData() {
        ArrayList<Object> selectList = new ArrayList<Object>(this.selectRowData.size());
        for (Map<String, Object> rowData : this.selectRowData.values()) {
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null) continue;
            selectList.add(keyData);
        }
        return selectList;
    }

    public List<Object> getTargetRowData() {
        return this.toKeyDataList(this.targetRowData);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        for (SJctrColumn column : this.columnData.values()) {
            column.initGuidance(util);
        }
        SUMMARY_HEADER_SVPVER = util.getGuidance(GUID_SN_VER);
    }

    public List<Object> removeSelectedRowData() {
        int size = this.selectRowData.size();
        ArrayList<Object> removeList = new ArrayList<Object>(size);
        int newAllRowDataSize = this.allRowData.size() - size;
        if (newAllRowDataSize < 0) {
            this.getLogUty().putlog("removeSelectedRowData", "selection size illegal:allRowData=" + this.allRowData.size() + ",selectRowData=" + size);
            newAllRowDataSize = 0;
        }
        ArrayList<HashMap<String, Object>> newAllRowData = new ArrayList<HashMap<String, Object>>(newAllRowDataSize);
        this.makeSortedData(this.allRowData);
        for (HashMap<String, Object> rowData : this.allRowData) {
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null) continue;
            String keyString = keyData.toString();
            if (this.selectRowData.containsKey(keyString)) {
                removeList.add(keyData);
                this.selectRowData.remove(keyString);
                continue;
            }
            newAllRowData.add(rowData);
        }
        this.allRowData = newAllRowData;
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
        return removeList;
    }

    public List<Object> removeRowData(List<?> targetList) {
        ArrayList<Object> removeList = new ArrayList<Object>(targetList.size());
        HashSet<String> removeKey = new HashSet<String>(targetList.size() * 4 / 3 + 1);
        for (Object data : targetList) {
            String delKey = data.toString();
            removeKey.add(delKey);
        }
        int newAllRowDataSize = this.allRowData.size() - removeKey.size();
        if (newAllRowDataSize < 0) {
            this.getLogUty().putlog("removeRowData", "selection size illegal:allRowData=" + this.allRowData.size() + ",Remove Rows=" + removeKey.size());
            newAllRowDataSize = 0;
        }
        ArrayList<HashMap<String, Object>> newAllRowData = new ArrayList<HashMap<String, Object>>(newAllRowDataSize);
        this.makeSortedData(this.allRowData);
        for (HashMap<String, Object> rowData : this.allRowData) {
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null) continue;
            String keyString = keyData.toString();
            if (removeKey.contains(keyString)) {
                removeList.add(keyData);
                this.selectRowData.remove(keyString);
                continue;
            }
            newAllRowData.add(rowData);
        }
        this.allRowData = newAllRowData;
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
        return removeList;
    }

    public void clearRowData() {
        this.allRowData = new ArrayList();
        this.filteredRowData = new ArrayList();
        this.targetRowData = new ArrayList();
        this.selectRowData = new LinkedHashMap<String, Map<String, Object>>();
    }

    public void addRowSelectionList(int[] addIndexes) {
        List<Object> addList = this.pageIndexToRowData(addIndexes);
        this.addRowSelectionList(addList);
    }

    public void addRowSelectionList(List<Object> addList) {
        int length = addList.size();
        HashSet<String> keyStringSet = new HashSet<String>(length * 4 / 3 + 1);
        for (int i = 0; i < length; ++i) {
            Object keyData = addList.get(i);
            if (keyData == null) continue;
            keyStringSet.add(keyData.toString());
        }
        this.setSelectedList(keyStringSet);
        this.setStatus(GET_STATUS.PAGE);
        this.setDirty();
        this.logUty.putlog("addRowSelectionList", length + " rows select. select => " + this.selectRowData.size());
    }

    public void setRowSelectionList(int[] setIndexes) {
        List<Object> setList = this.pageIndexToRowData(setIndexes);
        this.setRowSelectionList(setList);
    }

    public void setRowSelectionList(List<Object> setList) {
        this.clearSelectRow();
        this.addRowSelectionList(setList);
    }

    public void removeRowSelectionList(int[] removeIndexes) {
        List<Object> removeList = this.pageIndexToRowData(removeIndexes);
        this.removeRowSelectionList(removeList);
    }

    public void removeRowSelectionList(List<Object> removeList) {
        int length = removeList.size();
        for (int i = 0; i < length; ++i) {
            Object keyData = removeList.get(i);
            if (keyData == null) continue;
            this.selectRowData.remove(keyData.toString());
        }
        this.setStatus(GET_STATUS.PAGE);
        this.setDirty();
        this.logUty.putlog("removeRowSelectionList", length + " rows remove. select => " + this.selectRowData.size());
    }

    private List<Object> pageIndexToRowData(int[] indexes) {
        int pageStart = this.getPageStartIndex();
        int pageSize = this.getPageEndIndex() - pageStart;
        Arrays.sort(indexes);
        ArrayList<Object> retList = new ArrayList<Object>(indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            if (index < 0) continue;
            if (index >= pageSize) break;
            Map rowData = this.targetRowData.get(pageStart + index);
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null) continue;
            retList.add(keyData);
        }
        return retList;
    }

    public void selectAll() {
        this.clearSelectRow();
        int length = this.filteredRowData.size();
        for (int i = 0; i < length; ++i) {
            Map rowData = this.filteredRowData.get(i);
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null) continue;
            this.selectRowData.put(keyData.toString(), rowData);
        }
        this.setStatus(GET_STATUS.PAGE);
        this.setDirty();
        this.logUty.putlog("selectAll", "All rows select => " + this.selectRowData.size());
    }

    public int getSelectedRowCount() {
        return this.selectRowData.size();
    }

    public int[] getSelectedRows() {
        int[] retIndexes;
        int pageStart = this.getPageStartIndex();
        int pageSize = this.getPageEndIndex() - pageStart;
        int[] indexes = new int[pageSize];
        int addPos = 0;
        for (int i = 0; i < pageSize; ++i) {
            HashMap<String, Object> rowData = this.targetRowData.get(pageStart + i);
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null || !this.selectRowData.containsKey(keyData.toString())) continue;
            indexes[addPos] = i;
            ++addPos;
        }
        if (addPos == pageSize) {
            retIndexes = indexes;
        } else {
            retIndexes = new int[addPos];
            System.arraycopy(indexes, 0, retIndexes, 0, retIndexes.length);
        }
        return retIndexes;
    }

    public void clearSelectRow() {
        this.selectRowData.clear();
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        Object obj = controlData.get(TMENU_MAX_ROW_PAGE);
        if (obj instanceof String) {
            String value = (String)obj;
            this.setMaxRowPageMenu(value);
        } else {
            this.dataRestoreFailed(TMENU_MAX_ROW_PAGE, obj);
        }
        Object sortColumnObj = controlData.get("COM_SORT_COLUMN");
        if (sortColumnObj instanceof String) {
            String sortColumn = (String)sortColumnObj;
            Object sortOrderObj = controlData.get("COM_SORT_ORDER");
            if (sortOrderObj instanceof Boolean) {
                Boolean sortOrder = (Boolean)sortOrderObj;
                this.setSortColumn(sortColumn, sortOrder);
            } else {
                this.dataRestoreFailed("COM_SORT_ORDER", sortOrderObj);
            }
        } else {
            this.dataRestoreFailed("COM_SORT_COLUMN", sortColumnObj);
        }
        obj = controlData.get("COM_FILTER_LIST");
        if (obj instanceof ArrayList) {
            ArrayList filterList = (ArrayList)obj;
            this.setFilterData(filterList);
            this.makeRowFilterList();
        } else {
            this.dataRestoreFailed("COM_FILTER_LIST", obj);
        }
        Object typeObj = controlData.get("COM_FILTER_COMP");
        if (typeObj instanceof Boolean) {
            Boolean typeFlg = (Boolean)typeObj;
            String filterSelect = typeFlg != false ? FILTER_AND : FILTER_OR;
            SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel("COM_FILTER_COMP");
            comboBox.setSelection(filterSelect);
        } else {
            this.dataRestoreFailed("COM_FILTER_COMP", typeObj);
        }
        String unitOpen = null;
        Object obj2 = controlData.get(TMENU_CAPACITY_UNIT);
        if (obj2 != null) {
            if (obj2 instanceof String) {
                String value;
                unitOpen = value = (String)obj2;
                this.setUnitSelectOpen(value);
            } else {
                this.dataRestoreFailed(TMENU_CAPACITY_UNIT, obj2);
            }
        }
        String unitMf = null;
        Object mfObj = controlData.get(TMENU_CAPACITY_UNIT_MF);
        if (mfObj != null) {
            if (mfObj instanceof String) {
                String value;
                unitMf = value = (String)mfObj;
                this.setUnitSelectMainframe(value);
            } else {
                this.dataRestoreFailed(TMENU_CAPACITY_UNIT_MF, mfObj);
            }
        }
        if (this.hasOpenVolume()) {
            if (unitOpen != null) {
                this.setUnitMenu(unitOpen);
            }
        } else if (this.hasMainframeVolume()) {
            if (unitMf != null) {
                this.setUnitMenu(unitMf);
            }
        } else if (unitOpen != null) {
            this.setUnitMenu(unitOpen);
        }
    }

    @Override
    public void setPreOwnControlData(HashMap<String, Object> controlData) {
        Object obj2;
        this.setShowColumn();
        this.setGettingColumnData();
        Object obj1 = controlData.get(KEY_HIDE_COLUMN_LIST);
        if (obj1 != null) {
            if (obj1 instanceof Set) {
                Set value1 = (Set)obj1;
                this.setHideColumnInfo(value1, false);
                this.setGettingColumnData();
            } else {
                this.dataRestoreFailed(KEY_HIDE_COLUMN_LIST, obj1);
            }
        }
        if ((obj2 = controlData.get(KEY_SHOW_COLUMN_LIST)) != null) {
            if (obj2 instanceof Set) {
                Set value2 = (Set)obj2;
                this.setHideColumnInfo(value2, true);
                this.setGettingColumnData();
            } else {
                this.dataRestoreFailed(KEY_SHOW_COLUMN_LIST, obj2);
            }
        }
    }

    public void setHideColumnInfo(Set<String> value, boolean flg) {
        this.logUty.putlog("setHideColumnInfo", "Column: " + value + flg);
        if (value.isEmpty()) {
            return;
        }
        for (String key : value) {
            SJctrColumn column = this.getColumnInfo(key);
            if (!column.getSupportColumn()) continue;
            column.setShowColumn(flg);
        }
    }

    public void setHideColumnList(Set<String> value) {
        SJctrColumn column;
        this.logUty.putlog("setHideColumnList", "HideColumn: " + value);
        for (String key : this.getAllColumnKeySet(false)) {
            column = this.getColumnInfo(key);
            if (!column.getSupportColumn()) continue;
            column.setShowColumn(true);
        }
        for (String key : value) {
            column = this.getColumnInfo(key);
            column.setShowColumn(false);
        }
        this.setGettingColumnData();
        this.makeRowFilterList();
        this.setStatus(GET_STATUS.FILTER);
    }

    public void setShowColumn() {
        for (String key : this.getAllColumnKeySet(false)) {
            SJctrColumn column = this.getColumnInfo(key);
            boolean flg = column.getShowColumnDefault();
            if (!column.getSupportColumn()) {
                flg = false;
            }
            column.setShowColumn(flg);
        }
    }

    public void setGettingColumnData() {
        for (String key : this.getAllColumnKeySet(false)) {
            SJctrColumn column = this.getColumnInfo(key);
            boolean flgShow = column.getShowColumn();
            boolean flgData = column.getGettingHiddenColumnData();
            if (flgShow || flgData) {
                column.setGettingColumnData(true);
                continue;
            }
            column.setGettingColumnData(false);
        }
    }

    private void setSelectedList(Set<?> selRow) {
        for (HashMap<String, Object> rowData : this.allRowData) {
            String keyString;
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null || !selRow.contains(keyString = keyData.toString())) continue;
            this.selectRowData.put(keyString, rowData);
        }
    }

    @Override
    public HashMap<String, Object> getOwnControlData() {
        Set<String> showList;
        Set<String> hideList;
        String unitMf;
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        controlData.put(TMENU_MAX_ROW_PAGE, this.getMaxRowPageMenu());
        controlData.put("COM_SORT_COLUMN", tableData.sortColumn());
        controlData.put("COM_SORT_ORDER", tableData.sortOrder());
        ArrayList srcFilterList = (ArrayList)tableData.getData("COM_FILTER_LIST");
        ArrayList dstFilterList = new ArrayList(srcFilterList);
        controlData.put("COM_FILTER_LIST", dstFilterList);
        controlData.put("COM_FILTER_COMP", this.isFilterMatch());
        String unit = this.getUnitSelectOpen();
        if (unit != null) {
            controlData.put(TMENU_CAPACITY_UNIT, unit);
        }
        if ((unitMf = this.getUnitSelectMainframe()) != null) {
            controlData.put(TMENU_CAPACITY_UNIT_MF, unitMf);
        }
        if ((hideList = this.getHideColumnList()).size() > 0) {
            controlData.put(KEY_HIDE_COLUMN_LIST, hideList);
        }
        if ((showList = this.getShowColumnList()).size() > 0) {
            controlData.put(KEY_SHOW_COLUMN_LIST, showList);
        }
        return controlData;
    }

    protected HashMap<String, Object> getOwnControlDataWithDlgForWiz() {
        Set<String> showList;
        Set<String> hideList;
        String unitMf;
        HashMap<String, Object> ctrlData = new HashMap<String, Object>();
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        ctrlData.put(TMENU_MAX_ROW_PAGE, this.getMaxRowPageMenu());
        ArrayList srcFilterList = (ArrayList)tableData.getData("COM_FILTER_LIST");
        ArrayList dstFilterList = new ArrayList(srcFilterList);
        ctrlData.put("COM_FILTER_LIST", dstFilterList);
        ctrlData.put("COM_FILTER_COMP", this.isFilterMatch());
        String unit = this.getUnitSelectOpen();
        if (unit != null) {
            ctrlData.put(TMENU_CAPACITY_UNIT, unit);
        }
        if ((unitMf = this.getUnitSelectMainframe()) != null) {
            ctrlData.put(TMENU_CAPACITY_UNIT_MF, unitMf);
        }
        if ((hideList = this.getHideColumnList()).size() > 0) {
            ctrlData.put(KEY_HIDE_COLUMN_LIST, hideList);
        }
        if ((showList = this.getShowColumnList()).size() > 0) {
            ctrlData.put(KEY_SHOW_COLUMN_LIST, showList);
        }
        return ctrlData;
    }

    public Set<String> getHideColumnList() {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (String key : this.getAllColumnKeySet(false)) {
            SJctrColumn column = this.getColumnInfo(key);
            if (column.getShowColumn() == column.getShowColumnDefault() || column.getShowColumn()) continue;
            dstSet.add(key);
        }
        return dstSet;
    }

    public Set<String> getShowColumnList() {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (String key : this.getAllColumnKeySet(false)) {
            SJctrColumn column = this.getColumnInfo(key);
            if (column.getShowColumn() == column.getShowColumnDefault() || !column.getShowColumn()) continue;
            dstSet.add(key);
        }
        return dstSet;
    }

    @Override
    public void resetOwnControlData() {
        this.clearSelectRow();
        this.resetCurrentPage();
        SJctrRadioButtonGroupDataModel radioButton = (SJctrRadioButtonGroupDataModel)this.getDataModel("COM_FILTER_ENABLE");
        radioButton.setSelect(KEY_DISABLE);
        this.resetSortColumn();
    }

    private void makeFilterMatchComboBox() {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel("COM_FILTER_COMP");
        if (comboBox != null) {
            SJctrComUtility util = this.getComUtility();
            comboBox.addItem(FILTER_AND, util.getGuidance(FILTER_AND));
            comboBox.addItem(FILTER_OR, util.getGuidance(FILTER_OR));
            comboBox.setSelection(FILTER_AND);
        }
    }

    @Override
    public void makeDataObject() {
        List<?> basicDataList = this.getBasicDataList(this.primaryClass);
        Set<String> keySet = this.getAllColumnKeySet();
        this.clearRowData();
        this.makeTableMenu();
        this.addRowData(basicDataList, 0);
        this.makeFilterMatchComboBox();
    }

    public void addRowData(List<?> dataList) {
        int size = 0;
        if (this.allRowData != null) {
            size = this.allRowData.size();
        }
        this.addRowData(dataList, size);
    }

    public void addRowData(List<?> dataList, int index) {
        ArrayList<HashMap<String, Object>> newRowData = this.toRowDataList(dataList);
        this.logUty.putlog("addRowData", "Create row data = " + dataList.size());
        if (this.allRowData.size() == 0) {
            this.allRowData = newRowData;
        } else {
            this.makeSortedData(this.allRowData);
            this.allRowData.addAll(index, newRowData);
        }
        int dataSize = this.allRowData.size();
        this.filteredRowData.ensureCapacity(dataSize);
        this.targetRowData.ensureCapacity(dataSize);
        LinkedHashMap<String, Map<String, Object>> newSelectData = new LinkedHashMap<String, Map<String, Object>>(dataSize * 4 / 3 + 1);
        newSelectData.putAll(this.selectRowData);
        this.selectRowData = newSelectData;
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
    }

    @Override
    public void setDirty() {
        super.setDirty();
        for (String key : this.keySet()) {
            this.getDataModel(key).setDirty();
        }
    }

    public void setCurrentPage(String currentPage) {
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        SJctrTextBoxDataObject currentPageObj = tableData.currentPage();
        String oldValue = currentPageObj.value();
        this.logUty.putlog("setCurrentPage", oldValue + " => " + currentPage);
        currentPageObj.value(currentPage);
        this.setStatus(GET_STATUS.PAGE);
        this.setDirty();
    }

    private void resetCurrentPage() {
        this.setCurrentPage(Integer.toString(1));
    }

    public void setSortColumn(String column, Boolean order) {
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        tableData.sortColumn(column);
        tableData.sortOrder(order);
        this.setStatus(GET_STATUS.SORT);
        this.setDirty();
    }

    public void resetSortColumn() {
        this.setSortColumn("", SJctrTblDataObject.DEFAULT_SORT_ORDER);
    }

    public String getMaxRowPageMenu() {
        String retValue = null;
        SJctrNewTreeDataModel menu = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        for (String name : menu.getSelectionList()) {
            if (!name.contains(TMENU_MAX_ROW_PAGE)) continue;
            int index = name.lastIndexOf(COL_DELIMITER);
            retValue = name.substring(index + 1);
            break;
        }
        return retValue;
    }

    public void setMaxRowPageMenu(String value) {
        this.logUty.putlog("setMaxRowPageMenu", "Max row page: " + value);
        SJctrNewTreeDataModel menu = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        String newSelect = "ROWS_PAGES\t" + value;
        if (menu.getItem(newSelect) != null) {
            menu.addSelection(newSelect);
            for (String name : menu.getSelectionList()) {
                if (!name.contains(TMENU_MAX_ROW_PAGE) || name.equals(newSelect)) continue;
                menu.clearSelection(name);
            }
            this.setStatus(GET_STATUS.PAGE);
            this.setDirty();
        } else {
            this.logUty.putlog("setMaxRowPageMenu", value + " doesn't exist");
        }
    }

    public String getUnitMenu() {
        String retValue = null;
        SJctrNewTreeDataModel menu = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        for (String name : menu.getSelectionList()) {
            if (!name.contains(TMENU_CAPACITY_UNIT)) continue;
            int index = name.lastIndexOf(COL_DELIMITER);
            retValue = name.substring(index + 1);
            break;
        }
        return retValue;
    }

    public void setUnitMenu(String value) {
        this.logUty.putlog("setUnitMenu", "Unit: " + value);
        SJctrNewTreeDataModel menu = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        String newSelect = "CAPACITY_UNIT\t" + value;
        if (menu.getItem(newSelect) != null) {
            menu.addSelection(newSelect);
            for (String name : menu.getSelectionList()) {
                if (!name.contains(TMENU_CAPACITY_UNIT) || name.equals(newSelect)) continue;
                menu.clearSelection(name);
            }
            for (String key : this.getAllColumnKeySet()) {
                SJctrColumn column = this.getColumnInfo(key);
                if (!(column instanceof SJctrCapacityColumn)) continue;
                SJctrCapacityColumn capacityColumn = (SJctrCapacityColumn)column;
                capacityColumn.setUnitSelect(value);
                this.doRefresh(key);
            }
            this.notifyUnitSelect(value);
            if (this.hasOpenVolume()) {
                this.setUnitSelectOpen(value);
            } else if (this.hasMainframeVolume()) {
                this.setUnitSelectMainframe(value);
            } else {
                this.setUnitSelectOpen(value);
            }
            this.setStatus(GET_STATUS.PAGE);
            this.setDirty();
        } else {
            this.logUty.putlog("setUnitMenu", value + " doesn't exist");
        }
    }

    public final boolean hasCapacity() {
        return this.capacityFlg;
    }

    public final boolean hasMainframeVolume() {
        return this.mainframeFlg;
    }

    public final boolean hasOpenVolume() {
        return this.openFlg;
    }

    public final boolean hasDpVolume() {
        return this.dpFlg;
    }

    public final void setCapacityFlg(boolean flg) {
        this.capacityFlg = flg;
    }

    public final void setMainframeVolumeFlg(boolean flg) {
        this.mainframeFlg = flg;
    }

    public final void setOpenVolumeFlg(boolean flg) {
        this.openFlg = flg;
    }

    public final void setDpVolumeFlg(boolean flg) {
        this.dpFlg = flg;
    }

    public List<SJctrCapacityUtility.UNIT> getUnitList() {
        ArrayList<SJctrCapacityUtility.UNIT> retList = new ArrayList<SJctrCapacityUtility.UNIT>();
        if (this.hasCapacity()) {
            retList.addAll(Arrays.asList(CAPACITY_UNIT_LIST_COM));
            if (this.hasMainframeVolume()) {
                retList.addAll(Arrays.asList(CAPACITY_UNIT_LIST_MF));
            }
            if (this.hasDpVolume()) {
                retList.addAll(Arrays.asList(CAPACITY_UNIT_LIST_DP));
            }
        }
        return retList;
    }

    public void setFilterData(List<SJctrDataObject> setFilterData) {
        StringBuffer log = new StringBuffer();
        for (SJctrDataObject filterData : setFilterData) {
            log.append(filterData.getDataMap().toString());
        }
        this.logUty.putlog("setFilterData", log.toString());
        List getFilterData = (List)((SJctrTblDataObject)this.getManageData()).getData("COM_FILTER_LIST");
        getFilterData.clear();
        getFilterData.addAll(setFilterData);
    }

    @Override
    protected SJctrTblDataObject createManageData() {
        return new SJctrTblDataObject();
    }

    protected abstract List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> var1);

    protected abstract SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> var1);

    protected int getPageEndIndex() {
        int retValue = this.targetRowData.size();
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        SJctrTextBoxDataObject currentPageBox = tableData.currentPage();
        int currentPage = Integer.parseInt(currentPageBox.value());
        int maxRowPage = 0xFFFFFFF;
        String value = this.getMaxRowPageMenu();
        if (value != null) {
            maxRowPage = Integer.valueOf(value);
        }
        if (currentPage >= 1 && maxRowPage >= 1) {
            retValue = Math.min(currentPage * maxRowPage, this.targetRowData.size());
        }
        return retValue;
    }

    protected int getPageStartIndex() {
        int retValue = 0;
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        SJctrTextBoxDataObject currentPageBox = tableData.currentPage();
        int currentPage = Integer.parseInt(currentPageBox.value());
        int maxRowPage = 0xFFFFFFF;
        String value = this.getMaxRowPageMenu();
        if (value != null) {
            maxRowPage = Integer.valueOf(value);
        }
        if (currentPage >= 1 && maxRowPage >= 1) {
            retValue = (currentPage - 1) * maxRowPage;
        }
        return retValue;
    }

    private Class<?> getPrimaryClass() {
        SJctrColumn columnInfo = this.getColumnInfo(this.primaryKey);
        List<Class<? extends SJmoGetKind_IF>> kinds = columnInfo.getNeedModelKind();
        Class<? extends SJmoGetKind_IF> keyClass = null;
        if (kinds != null && kinds.size() > 0) {
            keyClass = kinds.get(0);
        }
        return keyClass;
    }

    protected abstract void initTable();

    @Override
    protected void makeModelDirect() {
        Set<String> keySet = this.getGettingDataColumnKeySet();
        Set<Class<? extends SJmoGetKind_IF>> classList = this.getNeedModelKind(keySet);
        for (Class clazz : classList) {
            this.directList.add(this.createModelDirect(clazz));
        }
        Set<SJctrGetDirectWrapper> needModelDirectList = this.getNeedModelDirect(keySet);
        if (needModelDirectList != null) {
            this.directList.addAll(needModelDirectList);
        }
    }

    public final void setPrimaryClass(Class<?> cls) {
        this.primaryClass = cls;
    }

    public String getPrimaryColumn() {
        return this.primaryKey;
    }

    public final void setPrimaryColumn(String key) {
        this.primaryKey = key;
    }

    protected void setStatus(GET_STATUS newStatus) {
        if (this.status.compareTo(newStatus) > 0) {
            this.status = newStatus;
        }
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = this.createModelRange(kindClass);
            List<SJmoSearchTerm_IF> filterList = this.createModelFilter(kindClass);
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    private HashMap<String, Object> createRowData(Object keyData, Set<String> keySet) {
        HashMap<String, Object> dat = new HashMap<String, Object>();
        for (String key : keySet) {
            List<?> models;
            SJctrColumn column = this.getColumnInfo(key);
            Object cell = column.createCellObject(models = column.getNeedModelData(keyData, this.getBasicDataMap()));
            if (cell == null) continue;
            dat.put(key, cell);
            String str = column.getString(dat);
            column.makeSelectFilterData(str);
        }
        dat.put(CTRL_MODEL_KEY, keyData);
        return dat;
    }

    private HashMap<String, Object> copyRowData(HashMap<String, Object> srcData, String[] keys) {
        HashMap<String, Object> dstData = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = srcData.get(key);
            dstData.put(key, value);
        }
        return dstData;
    }

    private List<HashMap<String, Object>> doAndFiltering(List<HashMap<String, Object>> targetRowList, List<HashMap<String, Object>> filteredRowList) {
        int filterListSize = this.rowFilterList.size();
        for (HashMap<String, Object> rowData : targetRowList) {
            SJctrFilter filter;
            boolean result = true;
            for (int i = 0; i < filterListSize && (result &= (filter = this.rowFilterList.get(i)).include(rowData)); ++i) {
            }
            if (!result) continue;
            filteredRowList.add(rowData);
        }
        return filteredRowList;
    }

    protected void doFilterAction() {
        this.makeRowFilterList();
        this.clearSelectRow();
        this.resetCurrentPage();
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
    }

    private List<HashMap<String, Object>> doOrFiltering(List<HashMap<String, Object>> targetRowList, List<HashMap<String, Object>> filteredRowList) {
        int filterListSize = this.rowFilterList.size();
        for (HashMap<String, Object> rowData : targetRowList) {
            SJctrFilter filter;
            boolean result = true;
            for (int i = 0; i < filterListSize && !(result = (filter = this.rowFilterList.get(i)).include(rowData)); ++i) {
            }
            if (!result) continue;
            filteredRowList.add(rowData);
        }
        return filteredRowList;
    }

    public SJctrColumn getColumnInfo(String key) {
        String searchKey = key;
        String childKey = null;
        int delimiterIndex = key.indexOf(COL_DELIMITER);
        if (delimiterIndex > 0) {
            searchKey = key.substring(0, delimiterIndex);
            childKey = key.substring(delimiterIndex + 1);
        }
        SJctrColumn info = this.columnData.get(searchKey);
        if (childKey != null && info != null) {
            info = info.getColumnInfo(childKey);
        }
        if (info == null) {
            info = NULL_COLUMN_INFO;
        }
        return info;
    }

    public Set<String> getHideColumnKeySet() {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (String key : this.getAllColumnKeySet(false)) {
            if (this.isShowColumn(key)) continue;
            dstSet.add(key);
        }
        return dstSet;
    }

    public Set<String> getDefaultHideColumnKeySet() {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (String key : this.getAllColumnKeySet(false)) {
            if (this.isShowColumnDefault(key)) continue;
            dstSet.add(key);
        }
        return dstSet;
    }

    public Set<String> getGettingDataColumnKeySet() {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (String key : this.getAllColumnKeySet(false)) {
            if (!this.isGettingDataColumn(this.getColumnInfo(key), key)) continue;
            dstSet.add(key);
        }
        return dstSet;
    }

    public boolean isGettingDataColumn(SJctrColumn column, String key) {
        return column.getGettingColumnData();
    }

    public Set<String> getAllColumnKeySet() {
        return this.getAllColumnKeySet(true);
    }

    public Set<String> getAllColumnKeySet(boolean filter) {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        for (Map.Entry<String, SJctrColumn> entry : this.columnData.entrySet()) {
            Set<String> list = entry.getValue().getAllKeySet();
            for (String key : list) {
                if (filter) {
                    if (!this.isShowColumn(key)) continue;
                    dstSet.add(key);
                    continue;
                }
                dstSet.add(key);
            }
        }
        return dstSet;
    }

    public boolean isShowColumn(String key) {
        return this.getColumnInfo(key).getShowColumn();
    }

    public boolean isShowColumnDefault(String key) {
        return this.getColumnInfo(key).getShowColumnDefault();
    }

    public Set<String> getTopColumnKeySet() {
        return this.getTopColumnKeySet(true);
    }

    public Set<String> getTopColumnKeySet(boolean filter) {
        LinkedHashSet<String> dstSet = new LinkedHashSet<String>();
        Set<String> srcSet = this.columnData.keySet();
        for (String key : srcSet) {
            if (filter) {
                // empty if block
            }
            dstSet.add(key);
        }
        return dstSet;
    }

    private Set<Class<? extends SJmoGetKind_IF>> getNeedModelKind(Set<String> keyList) {
        HashSet<Class<? extends SJmoGetKind_IF>> retObject = new HashSet<Class<? extends SJmoGetKind_IF>>();
        for (String key : keyList) {
            retObject.addAll(this.getNeedModelKind(key));
        }
        return retObject;
    }

    private Collection<Class<? extends SJmoGetKind_IF>> getNeedModelKind(String key) {
        return this.getColumnInfo(key).getNeedModelKind();
    }

    private Set<SJctrGetDirectWrapper> getNeedModelDirect(Set<String> keyList) {
        HashSet<SJctrGetDirectWrapper> retObject = new HashSet<SJctrGetDirectWrapper>();
        for (String key : keyList) {
            Collection<SJctrGetDirectWrapper> directList = this.getNeedModelDirect(key);
            if (directList == null) continue;
            retObject.addAll(directList);
        }
        return retObject;
    }

    private Collection<SJctrGetDirectWrapper> getNeedModelDirect(String key) {
        return this.getColumnInfo(key).getNeedModelDirect();
    }

    private void initModel() {
        final SJctrTblDataObject table = (SJctrTblDataObject)this.getManageData();
        SJctrSimpleDataModel type = new SJctrSimpleDataModel();
        type.setReceiveOnly();
        type.setRestoreFlg(false);
        this.addDataModel("COM_SELECT_TYPE", type);
        type.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof Integer) {
                    table.selectType((Integer)setObject);
                }
            }
        });
        SJctrDataObjectModel model = new SJctrSimpleDataModel();
        model.setReceiveOnly();
        model.setRestoreFlg(false);
        this.addDataModel("COM_SEL_ROW_PAGE", model);
        model.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof List) {
                    List selectList = (List)setObject;
                    Collections.sort(selectList);
                    int selectRow = 0;
                    if (selectList.size() > 0) {
                        selectRow = (Integer)selectList.get(0);
                    }
                    if (selectRow == -1) {
                        SJctrTableDataModel.this.selectAll();
                    } else if (selectRow == -2) {
                        SJctrTableDataModel.this.selectRowData.clear();
                        SJctrTableDataModel.this.setDirty();
                        SJctrTableDataModel.this.logUty.putlog("doAction", "All rows unselect");
                    } else {
                        int selectType = table.selectType();
                        if ((selectType == 1 || selectType == 2) && selectList.size() > 0) {
                            SJctrTableDataModel.this.selectRowData.clear();
                        }
                        this.setSelectTargetData(selectList);
                        SJctrTableDataModel.this.logUty.putlog("doAction", selectList.size() + " rows select => " + SJctrTableDataModel.this.selectRowData.size());
                    }
                    SJctrTableDataModel.this.setStatus(GET_STATUS.PAGE);
                }
            }

            private void setSelectTargetData(List<Integer> selectList) {
                int pageStart = SJctrTableDataModel.this.getPageStartIndex();
                int pageEnd = SJctrTableDataModel.this.getPageEndIndex();
                int indexEnd = pageEnd - pageStart;
                int listLength = selectList.size();
                int listIndex = 0;
                int selectRow = -1;
                for (int pageIndex = 0; pageIndex < indexEnd; ++pageIndex) {
                    Map rowData = SJctrTableDataModel.this.targetRowData.get(pageStart + pageIndex);
                    Object keyData = rowData.get(SJctrTableDataModel.CTRL_MODEL_KEY);
                    if (keyData == null) continue;
                    String keyString = keyData.toString();
                    if (pageIndex > selectRow && listIndex < listLength) {
                        selectRow = selectList.get(listIndex);
                        ++listIndex;
                    }
                    if (pageIndex == selectRow) {
                        SJctrTableDataModel.this.selectRowData.put(keyString, rowData);
                        continue;
                    }
                    SJctrTableDataModel.this.selectRowData.remove(keyString);
                }
            }
        });
        SJctrTextBoxDataObject currentPage = new SJctrTextBoxDataObject();
        currentPage.value(Integer.toString(1));
        currentPage.max(Integer.toString(1));
        currentPage.min(Integer.toString(1));
        currentPage.visible(SJctrTextBoxDataObject.VISIBLE_ACTIVE);
        ((SJctrTblDataObject)this.getManageData()).currentPage(currentPage);
        table.sortColumn("");
        table.sortOrder(SJctrTblDataObject.DEFAULT_SORT_ORDER);
        ArrayList filterList = new ArrayList(16);
        table.setData("COM_FILTER_LIST", filterList);
        SJctrRadioButtonGroupDataModel radioButton = new SJctrRadioButtonGroupDataModel();
        radioButton.add(KEY_ENABLE);
        radioButton.add(KEY_DISABLE);
        radioButton.setSelect(KEY_DISABLE);
        this.addDataModel("COM_FILTER_ENABLE", radioButton);
        radioButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrTableDataModel.this.doFilterAction();
                }
            }
        });
        SJctrComboBoxDataModel comboBox = new SJctrComboBoxDataModel(2);
        this.addDataModel("COM_FILTER_COMP", comboBox);
        model = new SJctrNewTreeDataModel();
        ((SJctrNestedListDataModel)model).setMultiSelect(true);
        model.setRestoreFlg(false);
        this.addDataModel("COM_TABLE_MENU", model);
        ((SJctrNestedListDataModel)model).addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    String name = (String)event.getChangeObject();
                    if (name.contains(SJctrTableDataModel.TMENU_MAX_ROW_PAGE)) {
                        int index = name.lastIndexOf(SJctrTableDataModel.COL_DELIMITER);
                        String str = name.substring(index + 1);
                        SJctrTableDataModel.this.setMaxRowPageMenu(str);
                        SJctrTableDataModel.this.resetCurrentPage();
                    } else if (name.contains(SJctrTableDataModel.TMENU_CAPACITY_UNIT)) {
                        int index = name.lastIndexOf(SJctrTableDataModel.COL_DELIMITER);
                        String str = name.substring(index + 1);
                        SJctrTableDataModel.this.setUnitMenu(str);
                    }
                }
            }
        });
    }

    private void initTableListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObj) {
                SJctrTblDataObject setTable;
                if (setObj instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObj).containsKey("COM_CURRENT_PAGE")) {
                    SJctrTblDataObject tableData = (SJctrTblDataObject)SJctrTableDataModel.this.getManageData();
                    SJctrTextBoxDataObject newPage = setTable.currentPage();
                    String newValue = newPage.value();
                    SJctrTableDataModel.this.setCurrentPage(newValue);
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObj) {
                SJctrTblDataObject setTable;
                if (setObj instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObj).containsKey("COM_SORT_COLUMN") && setTable.containsKey("COM_SORT_ORDER")) {
                    String sortColumn = setTable.sortColumn();
                    Boolean sortOrder = setTable.sortOrder();
                    SJctrTableDataModel.this.logUty.putlog("doAction", "Sort: " + sortColumn + ", " + sortOrder);
                    SJctrTableDataModel.this.setSortColumn(sortColumn, sortOrder);
                    SJctrTableDataModel.this.resetCurrentPage();
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrTblDataObject setTable;
                if (setObject instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObject).containsKey("COM_SEL_COLUMN") && setTable.containsKey("COM_LINK") && setTable.containsKey("COM_SEL_ROW_PAGE") && setTable.link().booleanValue()) {
                    String columnKey = setTable.selColumn();
                    ArrayList<Integer> indexList = setTable.selRowPage();
                    this.doLinkAction(columnKey, indexList);
                }
            }

            private void doLinkAction(String columnKey, List<Integer> indexList) {
                SJctrColumn column = SJctrTableDataModel.this.getColumnInfo(columnKey);
                HashMap<String, Object> rowData = this.getLinkActionRowData(indexList);
                if (rowData == null) {
                    SJctrTableDataModel.this.getLogUty().putlog("doLinkAction", "Not found row data.");
                    return;
                }
                Object keyData = rowData.get(SJctrTableDataModel.CTRL_MODEL_KEY);
                SJctrTableDataModel.this.getLogUty().putlog("doLinkAction", "Select: " + columnKey + ", " + keyData);
                if (keyData == null) {
                    return;
                }
                List<Object> result = column.doLinkAction(rowData);
                if (result != null) {
                    SJctrNotifyState message = (SJctrNotifyState)result.get(0);
                    List<Object> param = result.subList(1, result.size());
                    SJctrTableDataModel.this.fireMessageEvent(message, param);
                }
            }

            private HashMap<String, Object> getLinkActionRowData(List<Integer> indexList) {
                HashMap<String, Object> retRowData = null;
                int start = SJctrTableDataModel.this.getPageStartIndex();
                int end = SJctrTableDataModel.this.getPageEndIndex();
                for (Integer integer : indexList) {
                    int pageIndex = integer;
                    if (pageIndex >= 0) {
                        int index = start + pageIndex;
                        if (index < end) {
                            retRowData = SJctrTableDataModel.this.targetRowData.get(index);
                            break;
                        }
                        String detail = "Index(" + start + SJctrTableDataModel.FILTER_DISABLED + (end - 1) + "): " + index;
                        SJctrTableDataModel.this.getLogUty().putlog("getLinkActionRowData", detail, 30000);
                        continue;
                    }
                    String detail = "Index: " + pageIndex;
                    SJctrTableDataModel.this.getLogUty().putlog("getLinkActionRowData", detail, 30000);
                }
                return retRowData;
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObj) {
                SJctrTblDataObject setData;
                if (setObj instanceof SJctrTblDataObject && (setData = (SJctrTblDataObject)setObj).containsKey("COM_FILTER_LIST")) {
                    List setFilterData = (List)setData.getData("COM_FILTER_LIST");
                    SJctrTableDataModel.this.setFilterData(setFilterData);
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrSelectableDataObject apply;
                SJctrTblDataObject setTable;
                if (setObject instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObject).containsKey(SJctrTableDataModel.KEY_APPLY) && SJctrButtonDataModel.isSelect(apply = (SJctrSelectableDataObject)setTable.getData(SJctrTableDataModel.KEY_APPLY))) {
                    this.selectFilterRadioButton(SJctrTableDataModel.KEY_ENABLE);
                    SJctrTableDataModel.this.doFilterAction();
                }
            }

            private void selectFilterRadioButton(String radioButtonKey) {
                SJctrRadioButtonGroupDataModel radioButton = (SJctrRadioButtonGroupDataModel)SJctrTableDataModel.this.getDataModel("COM_FILTER_ENABLE");
                radioButton.setEnableListener(false);
                radioButton.setSelect(radioButtonKey);
                radioButton.setEnableListener(true);
            }
        });
        final SJctrTableDataModel table = this;
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                Object getObj;
                SJctrTblDataObject setTable;
                if (setObject instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObject).containsKey(SJctrTableDataModel.KEY_COLUMN_SEQ_LIST) && (getObj = setTable.getData(SJctrTableDataModel.KEY_COLUMN_SEQ_LIST)) instanceof List) {
                    List getList = (List)getObj;
                    HashMap<String, List> param = new HashMap<String, List>();
                    ArrayList<SJctrTableDataModel> tableList = new ArrayList<SJctrTableDataModel>();
                    tableList.add(table);
                    param.put(SJctrTableDataModel.PARM_TABLE_MODEL, tableList);
                    param.put(SJctrTableDataModel.PARM_SEQ_LIST, getList);
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(SJctrColumnSettingsDC.class);
                    list.add(param);
                    SJctrTableDataModel.this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_DIALOG_EX, list);
                }
            }
        });
    }

    private boolean isFilterEnable() {
        SJctrRadioButtonGroupDataModel radioButton = (SJctrRadioButtonGroupDataModel)this.getDataModel("COM_FILTER_ENABLE");
        boolean result = false;
        String key = radioButton.getSelect();
        if (key != null) {
            result = key.equals(KEY_ENABLE);
        }
        return result;
    }

    private boolean isFilterMatch() {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel("COM_FILTER_COMP");
        boolean result = false;
        String key = comboBox.getSelection();
        if (key != null) {
            result = key.equals(FILTER_AND);
        }
        return result;
    }

    private void makeTableMenu() {
        SJctrNewTreeDataModel model = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        model.setEnableListener(false);
        model.removeAllItems();
        if (this.isPaging()) {
            this.makeMaxRowPageMenu(model);
            model.addSelection("ROWS_PAGES\t" + MAX_ROW_PAGE_LIST[1]);
        }
        this.makeCapacityUnitInfo();
        if (this.hasCapacity()) {
            String selectedName;
            this.makeCapacityMenu(model);
            String defaultName = this.hasMainframeVolume() && !this.hasOpenVolume() ? "CAPACITY_UNIT\t" + (Object)((Object)CAPACITY_UNIT_LIST_MF[0]) : "CAPACITY_UNIT\t" + (Object)((Object)CAPACITY_UNIT_LIST_COM[1]);
            String name = defaultName;
            String defUnit = this.getDefaultUnitSelect();
            if (defUnit != null) {
                name = "CAPACITY_UNIT\t" + defUnit;
            }
            if (model.addSelection(name)) {
                selectedName = name;
            } else {
                model.addSelection(defaultName);
                selectedName = defaultName;
            }
            int index = selectedName.lastIndexOf(COL_DELIMITER);
            String unit = selectedName.substring(index + 1);
            for (String key : this.getAllColumnKeySet()) {
                SJctrColumn column = this.getColumnInfo(key);
                column.setUnitSelect(unit);
            }
            this.notifyUnitSelect(this.getUnitMenu());
        }
        model.setEnableListener(true);
    }

    private void makeMaxRowPageMenu(SJctrNewTreeDataModel model) {
        SJctrComUtility util = this.getComUtility();
        model.addItem(TMENU_MAX_ROW_PAGE, util.getGuidance(TMENU_MAX_ROW_PAGE));
        for (String str : MAX_ROW_PAGE_LIST) {
            model.addItem("ROWS_PAGES\t" + str, str);
        }
    }

    protected void makeCapacityUnitInfo() {
        Map<Class<?>, List<?>> basicData = this.getBasicDataMap();
        for (String key : this.getAllColumnKeySet()) {
            SJctrColumn column = this.getColumnInfo(key);
            if (!(column instanceof SJctrCapacityColumn)) continue;
            SJctrCapacityColumn capacityColumn = (SJctrCapacityColumn)column;
            this.capacityFlg = true;
            this.mainframeFlg |= capacityColumn.hasMainframeVolume(basicData);
            this.openFlg |= capacityColumn.hasOpenVolume(basicData);
            this.dpFlg |= capacityColumn.hasDpVolume(basicData);
        }
    }

    private void makeCapacityMenu(SJctrNewTreeDataModel model) {
        SJctrComUtility comUtil = this.getComUtility();
        SJctrCapacityUtility capaUtil = comUtil.getCapacityUtility();
        model.addItem(TMENU_CAPACITY_UNIT, comUtil.getGuidance(TMENU_CAPACITY_UNIT));
        for (SJctrCapacityUtility.UNIT unit : this.getUnitList()) {
            model.addItem("CAPACITY_UNIT\t" + unit.toString(), capaUtil.getUnitString(unit));
        }
    }

    private void makeFilteredData() {
        this.filteredRowData.clear();
        if (this.isFilterEnable()) {
            this.filteredRowData = this.isFilterMatch() ? (ArrayList)this.doAndFiltering(this.allRowData, this.filteredRowData) : (ArrayList)this.doOrFiltering(this.allRowData, this.filteredRowData);
        } else {
            this.filteredRowData.addAll(this.allRowData);
        }
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        tableData.maxRow(this.filteredRowData.size());
    }

    public List<Object> getFilterData(List<?> inputBasicDataList) {
        ArrayList<Object> outputBasicDataList;
        if (inputBasicDataList == null) {
            outputBasicDataList = new ArrayList();
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getFilterData", "Input Null pointer!!");
        } else if (this.isFilterEnable()) {
            ArrayList<HashMap<String, Object>> inputRowList = this.toRowDataList(inputBasicDataList);
            List<HashMap<String, Object>> outputRowList = new ArrayList<HashMap<String, Object>>(inputBasicDataList.size());
            outputRowList = this.isFilterMatch() ? this.doAndFiltering(inputRowList, outputRowList) : this.doOrFiltering(inputRowList, outputRowList);
            outputBasicDataList = this.toKeyDataList(outputRowList);
        } else {
            outputBasicDataList = inputBasicDataList;
        }
        return outputBasicDataList;
    }

    private void makePagedData() {
        int maxPage;
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        int maxRowPage = 0xFFFFFFF;
        String value = this.getMaxRowPageMenu();
        if (value != null) {
            maxRowPage = Integer.valueOf(value);
        }
        if ((maxPage = (this.targetRowData.size() + maxRowPage - 1) / maxRowPage) < 1) {
            maxPage = 1;
        }
        tableData.maxPage(maxPage);
        tableData.currentPage().max(Integer.toString(maxPage));
        SJctrTextBoxDataObject currentPageBox = tableData.currentPage();
        int currentPage = Integer.parseInt(currentPageBox.value());
        if (currentPage < 1 || maxPage < currentPage) {
            currentPage = maxPage;
            currentPageBox.value(Integer.toString(currentPage));
        }
        int pageStart = this.getPageStartIndex();
        int pageEnd = this.getPageEndIndex();
        int indexEnd = pageEnd - pageStart;
        ArrayList<HashMap<String, Object>> viewDataList = new ArrayList<HashMap<String, Object>>(indexEnd);
        ArrayList<Integer> selectList = new ArrayList<Integer>(indexEnd);
        Set<String> allKeySet = this.getAllColumnKeySet();
        Set<String> allKeySet_all = this.getAllColumnKeySet(false);
        long t = System.nanoTime();
        String[] keys = new String[allKeySet.size()];
        int i = 0;
        Iterator<String> i$ = allKeySet.iterator();
        while (i$.hasNext()) {
            String str;
            keys[i] = str = i$.next();
            ++i;
        }
        for (int pageIndex = 0; pageIndex < indexEnd; ++pageIndex) {
            HashMap<String, Object> rowData = this.targetRowData.get(pageStart + pageIndex);
            HashMap<String, Object> copyData = this.copyRowData(rowData, keys);
            viewDataList.add(copyData);
            Object keyData = rowData.get(CTRL_MODEL_KEY);
            if (keyData == null || !this.selectRowData.containsKey(keyData.toString())) continue;
            selectList.add(pageIndex);
        }
        long time = System.nanoTime() - t;
        this.getLogUty().putlog("makePagedData", "Row data processing: " + time + " ns", 10000);
        Set<String> topKeySet = this.getTopColumnKeySet();
        ArrayList<HashMap<String, Object>> headerList = new ArrayList<HashMap<String, Object>>(topKeySet.size());
        for (String key : topKeySet) {
            SJctrColumn column = this.getColumnInfo(key);
            HashMap<String, Object> headerInfo = column.getHeaderInfo(allKeySet_all);
            if (headerInfo == null) continue;
            headerList.add(headerInfo);
        }
        SJctrNestedListDataObject columnList = new SJctrNestedListDataObject();
        columnList.listData(headerList);
        tableData.setData("COM_COLUMN_LIST", columnList);
        tableData.tableData(viewDataList);
        tableData.selRowPage(selectList);
        tableData.selCount(this.selectRowData.size());
    }

    private void makeRowFilterList() {
        SJctrTblDataObject table = (SJctrTblDataObject)this.getManageData();
        List filterData = (List)table.getData("COM_FILTER_LIST");
        this.rowFilterList.clear();
        Iterator ite = filterData.iterator();
        while (ite.hasNext()) {
            SJctrDataObject data = (SJctrDataObject)ite.next();
            if (data == null || data.getDataMap().size() == 0) continue;
            String key = (String)data.getData(KEY_NAME);
            SJctrColumn column = this.getColumnInfo(key);
            SJctrFilter filter = column.getFilter(data);
            if (filter != null) {
                if (!column.getShowColumn()) continue;
                this.rowFilterList.add(filter);
                continue;
            }
            this.logUty.putlog("makeRowFilterList", "FilterData remove: " + data.toString());
            ite.remove();
        }
    }

    private void makeSortedData(List<HashMap<String, Object>> sortList) {
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        String sortColumn = tableData.sortColumn();
        Boolean sortOrder = tableData.sortOrder();
        SJctrColumn info = this.getColumnInfo(sortColumn);
        if (!info.getShowColumn()) {
            return;
        }
        Comparator<HashMap<String, Object>> comparator = info.getComparator();
        if (sortOrder.booleanValue()) {
            comparator = Collections.reverseOrder(comparator);
        }
        Collections.sort(sortList, comparator);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }

    public String getDefaultUnitSelect() {
        return this.defaultUnitSelect;
    }

    public void setDefaultUnitSelect(String unitSelect) {
        this.defaultUnitSelect = unitSelect;
    }

    public boolean isNotifyUnitSelect() {
        return this.notifyUnitSelect;
    }

    public void setNotifyUnitSelect(boolean notifyUnitSelect) {
        this.notifyUnitSelect = notifyUnitSelect;
    }

    public void notifyUnitSelect(String unitSelect) {
        if (!this.isNotifyUnitSelect()) {
            return;
        }
        SJctrDataController dc = this.getDataController();
        if (dc == null) {
            return;
        }
        dc.setUnitSelect(unitSelect);
    }

    protected ArrayList<Object> toKeyDataList(List<HashMap<String, Object>> rowDataList) {
        ArrayList<Object> retList;
        if (rowDataList == null) {
            retList = new ArrayList<Object>();
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toKeyDataList", "Input Null pointer!!");
        } else {
            retList = new ArrayList(rowDataList.size());
            for (Map map : rowDataList) {
                Object keyData = map.get(CTRL_MODEL_KEY);
                if (keyData == null) continue;
                retList.add(keyData);
            }
        }
        return retList;
    }

    protected ArrayList<HashMap<String, Object>> toRowDataList(List<?> targetRow) {
        ArrayList<HashMap<String, Object>> returnRowList;
        if (targetRow == null) {
            returnRowList = new ArrayList<HashMap<String, Object>>();
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toRowDataList", "Input Null pointer!!");
        } else {
            Set<String> keySet = this.getAllColumnKeySet();
            returnRowList = new ArrayList(targetRow.size());
            for (Object data : targetRow) {
                returnRowList.add(this.createRowData(data, keySet));
            }
        }
        return returnRowList;
    }

    @Override
    protected String makeExportString() {
        StringBuilder result = new StringBuilder();
        result.append(this.makeExportStringHeader());
        result.append(this.makeExportStringSummary());
        result.append(this.makeExportStringFilter());
        result.append(this.makeExportStringDetail());
        return result.toString();
    }

    protected String makeExportStringHeader() {
        StringBuilder result = new StringBuilder();
        List<?> subsystemList = this.getDataController().getModelData(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo subsystem = (SJmoSubsystemInfo)subsystemList.get(0);
        result.append(EXPORT_VERSION);
        result.append(subsystem.getServProgVersion());
        result.append(ROW_DELIMITER);
        result.append(TAG_SERIAL);
        result.append(ROW_DELIMITER);
        result.append(subsystem.getDKCSNString());
        result.append(ROW_DELIMITER);
        result.append(ROW_DELIMITER);
        return result.toString();
    }

    protected String makeExportStringSummary() {
        StringBuilder result = new StringBuilder();
        List<?> subsystemList = this.getDataController().getModelData(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo subsystem = (SJmoSubsystemInfo)subsystemList.get(0);
        result.append(TAG_SUMMARY);
        result.append(ROW_DELIMITER);
        result.append(COMMENT + SUMMARY_HEADER_SVPVER + COL_DELIMITER + SUMMARY_HEADER_PATH + COL_DELIMITER + SUMMARY_HEADER_TAB + COL_DELIMITER + SUMMARY_HEADER_DATE);
        result.append(ROW_DELIMITER);
        result.append(subsystem.getDKCMibVersion());
        result.append(COL_DELIMITER);
        SJctrTopWindowDC topwindow = this.getDataController().getTopWindow();
        SJctrCrumbTrailModel crumb = (SJctrCrumbTrailModel)topwindow.getDataObjectModel("COM_CRUMB");
        ArrayList<String> itemList = new ArrayList<String>(crumb.getItemMap().keySet());
        Collections.sort(itemList);
        for (String name : itemList) {
            HashMap<String, Object> item = crumb.getItem(name);
            String label = SJctrMenuDataModel.Item.getLabel(item);
            result.append(label);
            result.append(CRUMB_DELIMITER);
        }
        if (itemList.size() > 0) {
            result = result.delete(result.length() - CRUMB_DELIMITER.length(), result.length());
        }
        result.append(COL_DELIMITER);
        String label = this.getExportTabLabel();
        result.append(label);
        result.append(COL_DELIMITER);
        String date = EXPORT_DATE_FORMAT.format(new Date());
        result.append(date);
        result.append(ROW_DELIMITER);
        result.append(ROW_DELIMITER);
        return result.toString();
    }

    protected String makeExportStringSummary2Dialog(String windowName, String tabName, String tableName) {
        StringBuilder result = new StringBuilder();
        List<?> subsystemList = this.getDataController().getModelData(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo subsystem = (SJmoSubsystemInfo)subsystemList.get(0);
        result.append(TAG_SUMMARY);
        result.append(ROW_DELIMITER);
        result.append(COMMENT + SUMMARY_HEADER_SVPVER + COL_DELIMITER + SUMMARY_HEADER_WINDOWNAME);
        if (tabName != null && tabName.length() > 0) {
            result.append("/Tab Name");
        }
        result.append("\tTable Name\tDate");
        result.append(ROW_DELIMITER);
        result.append(subsystem.getDKCMibVersion());
        result.append(COL_DELIMITER);
        result.append(windowName);
        if (tabName != null && tabName.length() > 0) {
            result.append(CRUMB_DELIMITER + tabName);
        }
        result.append(COL_DELIMITER);
        result.append(tableName);
        result.append(COL_DELIMITER);
        String date = EXPORT_DATE_FORMAT.format(new Date());
        result.append(date);
        result.append(ROW_DELIMITER);
        result.append(ROW_DELIMITER);
        return result.toString();
    }

    public String getExportTabLabel() {
        String ret = "";
        SJctrTopWindowDC topwindow = this.getDataController().getTopWindow();
        SJctrChildViewModel child = (SJctrChildViewModel)topwindow.getDataObjectModel("COM_CHILD");
        SJctrDataController childDC = topwindow.getOwner().getDataController(child.getMoveDisp());
        if (childDC instanceof SJctrTabDataController) {
            String label;
            SJctrComboBoxDataModel tabCombo = ((SJctrTabDataController)childDC).getTabModel();
            String name = tabCombo.getSelection();
            ret = label = SJctrComboBoxDataModel.Item.getLabel(tabCombo.getItem(name));
        }
        return ret;
    }

    protected String makeExportStringFilter() {
        StringBuilder result = new StringBuilder();
        result.append(TAG_FILTEROPT);
        result.append(ROW_DELIMITER);
        result.append(FILTEROPT_HEADER);
        result.append(ROW_DELIMITER);
        boolean filterEnable = this.isFilterEnable();
        String str = filterEnable ? this.getComUtility().getGuidance("ENABLE") : this.getComUtility().getGuidance("DISABLE");
        result.append(str);
        result.append(COL_DELIMITER);
        if (filterEnable) {
            SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataModel("COM_FILTER_COMP");
            result.append(comboBox.getSelection());
        } else {
            result.append(FILTER_DISABLED);
        }
        result.append(ROW_DELIMITER);
        result.append(ROW_DELIMITER);
        if (filterEnable) {
            result.append(this.makeExportStringFilterDetail());
        }
        return result.toString();
    }

    public String makeExportStringFilterDetail() {
        StringBuilder result = new StringBuilder();
        result.append(TAG_FILTERITEM);
        result.append(ROW_DELIMITER);
        result.append(FILTERITEM_HEADER);
        result.append(ROW_DELIMITER);
        List filterList = (List)((SJctrTblDataObject)this.getManageData()).getData("COM_FILTER_LIST");
        for (SJctrDataObject data : filterList) {
            if (data == null || data.getDataMap().size() == 0) continue;
            String key = (String)data.getData(KEY_NAME);
            SJctrColumn column = this.getColumnInfo(key);
            String parentKey = key;
            StringBuilder parentLabel = new StringBuilder();
            while (parentKey.contains(COL_DELIMITER)) {
                parentKey = parentKey.substring(0, parentKey.lastIndexOf(COL_DELIMITER));
                SJctrColumn parentColumn = this.getColumnInfo(parentKey);
                parentLabel.insert(0, parentColumn.getLabel() + FILTER_DELIMITER);
            }
            result.append((CharSequence)parentLabel);
            result.append(column.getLabel());
            result.append(COL_DELIMITER);
            result.append(column.getFilterLogicString(data));
            result.append(COL_DELIMITER);
            result.append(column.getFilterValueString(data));
            result.append(ROW_DELIMITER);
        }
        result.append(ROW_DELIMITER);
        return result.toString();
    }

    protected String makeExportStringDetail() {
        StringBuilder result = new StringBuilder();
        result.append(TAG_DETAIL);
        result.append(ROW_DELIMITER);
        Set<String> allColKeys = this.getAllColumnKeySet();
        ArrayList<SJctrColumn> outputCols = new ArrayList<SJctrColumn>(allColKeys.size());
        int colNest = 0;
        for (String key : allColKeys) {
            SJctrColumn sJctrColumn;
            String[] keys = key.split(COL_DELIMITER);
            if (colNest < keys.length) {
                colNest = keys.length;
            }
            if (!(sJctrColumn = this.getColumnInfo(key)).getChildColumn().isEmpty()) continue;
            outputCols.add(sJctrColumn);
        }
        StringBuffer[] buffers = new StringBuffer[colNest];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new StringBuffer(COMMENT);
        }
        String[] preKeys = new String[]{};
        for (SJctrColumn sJctrColumn : outputCols) {
            String key = sJctrColumn.getMyFullPathKey();
            String[] keys = key.split(COL_DELIMITER);
            StringBuffer parentKey = new StringBuffer();
            for (int i = 0; i < buffers.length; ++i) {
                if (keys.length - 1 < i) {
                    buffers[i].append(COL_DELIMITER);
                } else if (preKeys.length == keys.length && preKeys[i].equals(keys[i])) {
                    parentKey.append(keys[i]);
                    buffers[i].append(COL_DELIMITER);
                } else {
                    parentKey.append(keys[i]);
                    SJctrColumn outputCol = this.getColumnInfo(parentKey.toString());
                    buffers[i].append(outputCol.getLabel());
                    buffers[i].append(COL_DELIMITER);
                }
                parentKey.append(COL_DELIMITER);
            }
            preKeys = keys;
        }
        for (StringBuffer buf : buffers) {
            result.append(buf.toString());
            if (result.length() > 0) {
                result = result.delete(result.length() - COL_DELIMITER.length(), result.length());
            }
            result.append(ROW_DELIMITER);
        }
        for (HashMap hashMap : this.targetRowData) {
            for (SJctrColumn column : outputCols) {
                String dispString = column.getString(hashMap);
                result.append(dispString);
                result.append(COL_DELIMITER);
            }
            if (result.length() > 0) {
                result = result.delete(result.length() - COL_DELIMITER.length(), result.length());
            }
            result.append(ROW_DELIMITER);
        }
        return result.toString();
    }

    private void chgMaxRowPageMenu() {
        SJctrNewTreeDataModel model = (SJctrNewTreeDataModel)this.getDataModel("COM_TABLE_MENU");
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        String nowSelect = this.getMaxRowPageMenu();
        String nextSelect = null;
        if (!this.isPaging()) {
            return;
        }
        for (String str : MAX_ROW_PAGE_LIST) {
            model.removeItem("ROWS_PAGES\t" + str);
        }
        SJctrComUtility util = this.getComUtility();
        boolean selectFlg = false;
        int defaultRowPage = Integer.valueOf(MAX_ROW_PAGE_LIST[1]);
        for (String str : MAX_ROW_PAGE_LIST) {
            int maxRowPage = Integer.valueOf(str);
            int maxPage = (tableData.maxRow() + maxRowPage - 1) / maxRowPage;
            if (maxPage < 1) {
                maxPage = 1;
            }
            if (maxPage <= 999) {
                model.addItem("ROWS_PAGES\t" + str, str);
                if (nowSelect != null) {
                    selectFlg |= nowSelect.equals(str);
                }
                if (nextSelect != null || maxRowPage < defaultRowPage) continue;
                nextSelect = str;
                continue;
            }
            if (!str.equals(MAX_ROW_PAGE_LIST[MAX_PAGE_LIST_INDEX])) continue;
            model.addItem("ROWS_PAGES\t" + str, str);
            nextSelect = str;
        }
        if (selectFlg) {
            model.setEnableListener(false);
            this.setMaxRowPageMenu(nowSelect);
            model.setEnableListener(true);
        } else {
            this.setMaxRowPageMenu(nextSelect);
        }
    }

    public boolean isShowColumnSettingMenu() {
        return this.showColumnSettingMenu;
    }

    public void setShowColumnSettingMenu(boolean showColumnSettingMenu) {
        this.showColumnSettingMenu = showColumnSettingMenu;
    }

    public void addRowDataTop(List<?> dataList) {
        this.clearSelectRow();
        this.addRowData(dataList, 0);
        List<Object> selectedList = this.getFilterData(dataList);
        this.addRowSelectionList(selectedList);
        this.resetCurrentPage();
        this.setSortColumn(null, SJctrTblDataObject.DEFAULT_SORT_ORDER);
        this.setVScrollReset(true);
        this.setStatus(GET_STATUS.FILTER);
        this.setDirty();
    }

    public void setVScrollReset(boolean flg) {
        this.flgVScrollReset = flg;
    }

    private void makeViewDataAlways() {
        this.makeVScrollReset();
    }

    private void makeVScrollReset() {
        SJctrTblDataObject tableData = (SJctrTblDataObject)this.getManageData();
        tableData.vScrollReset(this.flgVScrollReset);
        this.setVScrollReset(false);
    }

    public String getUnitSelectOpen() {
        return this.unitSelectOpen;
    }

    public String getUnitSelectMainframe() {
        return this.unitSelectMainframe;
    }

    public void setUnitSelectOpen(String unit) {
        this.unitSelectOpen = unit;
    }

    public void setUnitSelectMainframe(String unit) {
        this.unitSelectMainframe = unit;
    }

    protected static enum GET_STATUS {
        FILTER,
        SORT,
        PAGE,
        NOACTION;

    }
}

