/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.rsg.rsgs.ldevs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.topwindow.account.rsg.rsgs.SJctrRsgSummaryModel;
import sanproject.sn2.controller.topwindow.account.rsg.rsgs.com.SJctrRsgLdevActionMenuModel;
import sanproject.sn2.controller.topwindow.account.rsg.rsgs.com.SJctrRsgRscDC;
import sanproject.sn2.controller.wizard.account.rsg.assigngadreserves.SJctrAssignGADReservesSubWizard;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTopTableModel;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.SJctrEditVirtualManageSetSubWizard;
import sanproject.sn2.controller.wizard.account.rsg.releasegadreserves.SJctrReleaseGADReservesSubWizard;
import sanproject.sn2.controller.wizard.account.rsg.removeresources.SJctrRemoveResourcesSubWizard;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrRsgLdevsDC
extends SJctrRsgRscDC {
    private static final int DISP_ID = 9987;

    public SJctrRsgLdevsDC() throws SJcException {
        super(9987);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_SUMMARY", new SJctrRsgSummaryModel());
        this.addDataObjectModel("COM_TABLE", new SJctrRsgLdevsTopTableModel());
        this.addDataObjectModel("COM_ACTION_MENU", new SJctrRsgLdevActionMenuModel());
    }

    @Override
    protected void makeRemoveRS(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<Object> checkLdevList;
        boolean reserveResult;
        SJmoRSGInfo rsgInfo = this.getRsgInfo();
        if (0 == rsgInfo.getRsgId()) {
            this.getLogUty().putlog("makeRemoveRS", "Resource remove cannot be carried out from the resource group 0.");
            SJctrError err = new SJctrError(207, 22, 105294);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrRsgLdevsTopTableModel rsgsRscLdevTable = (SJctrRsgLdevsTopTableModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selectedRsgList = rsgsRscLdevTable.getSelectedRowData();
        boolean vdkcResult = SJctrRsgUtility.isDefaultVdkcNumber(rsgInfo);
        if (!vdkcResult && (reserveResult = SJctrRsgUtility.isVirtualLdevIdListReserve(checkLdevList = selectedRsgList))) {
            this.getLogUty().putlog("makeRemoveRS", "Selected vertualldev is reserved.");
            SJctrError err = new SJctrError(207, 22, 205059);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedRsgList);
        SJmoRSGgetRsg rsgData = new SJmoRSGgetRsg();
        rsgData.setRsgInfo(rsgInfo);
        rsgData.setLdevs((ArrayList)selectedRsgList);
        SJctrRsgInfo rsgParamInfo = new SJctrRsgInfo(rsgData);
        ArrayList<SJctrRsgInfo> rsgDataList = new ArrayList<SJctrRsgInfo>();
        rsgDataList.add(rsgParamInfo);
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), rsgDataList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrRemoveResourcesSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    @Override
    protected void makeEditVirtualMng(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJmoRSGInfo rsgInfo = this.getRsgInfo();
        if (SJctrRsgUtility.isSysRsg(rsgInfo)) {
            this.getLogUty().putlog("makeAddRS", "Selected RSG is System RSG.");
            throw SJctrRsgUtility.makeException(205170);
        }
        SJctrRsgLdevsTopTableModel rsgsRscLdevTable = (SJctrRsgLdevsTopTableModel)this.getDataObjectModel("COM_TABLE");
        if (rsgsRscLdevTable == null) {
            this.getLogUty().putlog("makeEditVirtualMng", "Information of SJctrRsgLdevsTopTableModel is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedRsgList = rsgsRscLdevTable.getSelectedRowData();
        List<Object> checkLdevList = selectedRsgList;
        if (checkLdevList == null) {
            this.getLogUty().putlog("makeEditVirtualMng", "Information of SJctrRsgLdevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (checkLdevList.size() == 0) {
            this.getLogUty().putlog("makeEditVirtualMng", "Size of SJctrRsgLdevInfo is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedRsgList);
        SJmoRSGgetRsg rsgData = new SJmoRSGgetRsg();
        rsgData.setRsgInfo(rsgInfo);
        rsgData.setLdevs((ArrayList)selectedRsgList);
        SJctrRsgInfo rsgParamInfo = new SJctrRsgInfo(rsgData);
        ArrayList<SJctrRsgInfo> rsgDataList = new ArrayList<SJctrRsgInfo>();
        rsgDataList.add(rsgParamInfo);
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), rsgDataList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditVirtualManageSetSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    @Override
    protected void makeAssignGADReserves(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJmoRSGInfo rsgInfo = this.getRsgInfo();
        SJctrRsgLdevsTopTableModel rsgsRscLdevTable = (SJctrRsgLdevsTopTableModel)this.getDataObjectModel("COM_TABLE");
        if (rsgsRscLdevTable == null) {
            this.getLogUty().putlog("makeAssignGADReserves", "Information of SJctrRsgLdevsTopTableModel is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedRsgList = rsgsRscLdevTable.getSelectedRowData();
        List<Object> checkLdevList = selectedRsgList;
        if (checkLdevList == null) {
            this.getLogUty().putlog("makeAssignGADReserves", "Information of SJctrRsgLdevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (checkLdevList.size() == 0) {
            this.getLogUty().putlog("makeAssignGADReserves", "Size of SJctrRsgLdevInfo is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean virtualLdevIdResult = SJctrRsgUtility.isVirtualLdevIdListReserve(checkLdevList);
        if (virtualLdevIdResult) {
            this.getLogUty().putlog("makeAssignGADReserves", "Selected virtual ldev id is reserved.");
            SJctrError err = new SJctrError(207, 22, 205098);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean attributeResult = SJctrRsgUtility.isVirtualLdevIdListNotNormal(checkLdevList);
        if (attributeResult) {
            this.getLogUty().putlog("makeAssignGADReserves", "Selected ldev is not normal attribute.");
            SJctrError err = new SJctrError(207, 22, 205101);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedRsgList);
        SJmoRSGgetRsg rsgData = new SJmoRSGgetRsg();
        rsgData.setRsgInfo(rsgInfo);
        rsgData.setLdevs((ArrayList)selectedRsgList);
        SJctrRsgInfo rsgParamInfo = new SJctrRsgInfo(rsgData);
        ArrayList<SJctrRsgInfo> rsgDataList = new ArrayList<SJctrRsgInfo>();
        rsgDataList.add(rsgParamInfo);
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), rsgDataList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAssignGADReservesSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    @Override
    protected void makeReleaseGADReserves(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJmoRSGInfo rsgInfo = this.getRsgInfo();
        SJctrRsgLdevsTopTableModel rsgsRscLdevTable = (SJctrRsgLdevsTopTableModel)this.getDataObjectModel("COM_TABLE");
        if (rsgsRscLdevTable == null) {
            this.getLogUty().putlog("makeReleaseGADReserves", "Information of SJctrRsgLdevsTopTableModel is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedRsgList = rsgsRscLdevTable.getSelectedRowData();
        List<Object> checkLdevList = selectedRsgList;
        if (checkLdevList == null) {
            this.getLogUty().putlog("makeReleaseGADReserves", "Information of SJctrRsgLdevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (checkLdevList.size() == 0) {
            this.getLogUty().putlog("makeReleaseGADReserves", "Size of SJctrRsgLdevInfo is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean attributeResult = SJctrRsgUtility.isVirtualLdevListNotReserve(checkLdevList);
        if (attributeResult) {
            this.getLogUty().putlog("makeReleaseGADReserves", "Selected ldev is not reserve attribute.");
            SJctrError err = new SJctrError(207, 22, 205103);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean migration = SJctrRsgUtility.isIncludeMigrationVolume(checkLdevList);
        if (migration) {
            this.getLogUty().putlog("makeReleaseGADReserves", "Selected virtual ldev include migration ldev.");
            SJctrError err = new SJctrError(207, 22, 205106);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedRsgList);
        SJmoRSGgetRsg rsgData = new SJmoRSGgetRsg();
        rsgData.setRsgInfo(rsgInfo);
        rsgData.setLdevs((ArrayList)selectedRsgList);
        SJctrRsgInfo rsgParamInfo = new SJctrRsgInfo(rsgData);
        ArrayList<SJctrRsgInfo> rsgDataList = new ArrayList<SJctrRsgInfo>();
        rsgDataList.add(rsgParamInfo);
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), rsgDataList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrReleaseGADReservesSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }
}

