/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.usergroups;

import java.util.ArrayList;
import java.util.Arrays;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;

public class SJctrItemExpandListenerUserGrp
implements SJctrItemExpandListener {
    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childLogicalPath);
        ArrayList<String> keyList = new ArrayList<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keyList) {
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        String strLogSubTitle = "treeExpanded";
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        Object[] userGrps = null;
        SJcUserGroupInfoContainer[] groupInfo_Array = null;
        try {
            userGrps = SJcUserGroupInfoUty.getUserGroupList();
            Arrays.sort(userGrps);
            groupInfo_Array = SJcUserGroupInfoUty.getUserGroupInfo((String[])userGrps);
        }
        catch (SJcCommunicationErrorException e) {
            dataModel.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGroupInfo() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(201, 22, 208003);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            dataModel.getLogUty().putlog(strLogSubTitle, "[Logic Error]get GroupInfo is failed(" + e.getClass().getSimpleName() + ")", e, 40000);
            SJctrError err = new SJctrError(2, 22, 107014);
            SJcException exception = err.createException();
            throw exception;
        }
        for (SJcUserGroupInfoContainer groupInfo : groupInfo_Array) {
            Object[] childArgs = new Object[]{groupInfo};
            dataModel.addItem(childeNodeData, childArgs);
        }
    }
}

