/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.usergroups.roles;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.account.usergroups.SJctrUserGrpSelectDC;
import sanproject.sn2.controller.topwindow.account.usergroups.SJctrUserGrpSummaryModel;
import sanproject.sn2.controller.topwindow.account.usergroups.roles.SJctrUserGrpRolesActionMenuModel;
import sanproject.sn2.controller.topwindow.account.usergroups.roles.SJctrUserGrpRolesTableModel;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpsSelectData;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;

public class SJctrUserGrpRolesDC
extends SJctrUserGrpSelectDC {
    public static final int DISP_ID = 9474;
    public static final String COM_TABLE = "COM_TABLE";
    public static final String COM_SUMMARY = "COM_SUMMARY";
    public static final String COM_ACTION_MENU = "COM_ACTION_MENU";

    private void initDataModel() {
        this.addDataObjectModel(COM_SUMMARY, new SJctrUserGrpSummaryModel());
        this.addDataObjectModel(COM_TABLE, new SJctrUserGrpRolesTableModel());
        this.addDataObjectModel(COM_ACTION_MENU, new SJctrUserGrpRolesActionMenuModel());
    }

    public SJctrUserGrpRolesDC() throws SJcException {
        super(9474);
        this.initDataModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(USERGRP_ROLES_NOTIFY_STATE.MAKE_ADDROLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpRolesDC.this.makeAddRoles(event, dstModel);
            }
        });
    }

    private void makeAddRoles(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeAddRoles";
        this.getLogUty().putlog(strLogSubTitle, "start");
        ArrayList<SJctrUserGrpsSelectData> selectList = new ArrayList<SJctrUserGrpsSelectData>(1);
        SJctrUserGrpsSelectData selectData = new SJctrUserGrpsSelectData();
        String[] userGrpName = new String[]{this.getUserGrpName()};
        if (userGrpName != null) {
            try {
                SJcUserGroupInfoContainer[] userGrpInfo = SJctrUserInfoUtility.getUserGroupInfo(userGrpName, this);
                SJctrUserGrpInfoDetail userGrpInfoDetail = new SJctrUserGrpInfoDetail(userGrpInfo[0]);
                ArrayList<SJctrUserGrpInfoDetail> list = new ArrayList<SJctrUserGrpInfoDetail>();
                list.add(userGrpInfoDetail);
                selectData.setUserGrpInfoDetailList(list);
                selectList.add(selectData);
                HashMap param = new HashMap();
                param.put(SJctrAccountDataMacro.WIZARD_ADDROLES_SELECT_DATA.getName(), selectList);
                SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_ADDROLES, param);
                this.addUpdateDisp(wizardRelated);
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGroupInfo() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(201, 22, 208003);
                SJcException exception = err.createException();
                throw exception;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]User Group Name is Empty.", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    public static enum USERGRP_ROLES_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_ADDROLE;

    }
}

