/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.List;
import sanproject.sn2.com.cif.SJcSn2Option;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrEnvParamUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMainteRoleUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrLaunchDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemStatusMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSystemOption;
import sanproject.sn2.model.data.system.SJmoSubsystemStatusMgr;
import sanproject.sn2.model.data.system.SJmoSystemOption;

public class SJctrAlertModel
extends SJctrButtonDataModel
implements SJcSn2Option {
    public static final String KEY_ICON = "COM_ICON";
    private static final String DISP_ID = "M1-0";
    private static final String TAB_INDEX = "2";
    public static final String ALERT = "ALERT";
    public static int SIM_ST_UNKNOWN = 0;
    public static int UNCHECKED_SIM_ST_UNKNOWN = -1;
    public static int UNCHECKED_SIM_ST_NOT_EXIST = 0;
    public static int UNCHECKED_SIM_ST_EXIST = 1;
    private static final int[] icon_st = new int[]{12294, 12289, 12293, 12292, 12291, 12290};
    private static final int[] icon_st_unchecked = new int[]{12294, 16435, 12293, 16433, 16434, 12290};
    private int statusSim_old = SIM_ST_UNKNOWN;
    private int unchecked_old = UNCHECKED_SIM_ST_UNKNOWN;
    private boolean flgHideStatusWindow = false;
    private boolean hideAlert_old = false;
    static final String ACT_DEVICEHEALTH = "ACT_OLDGUI_DEVICEHEALTH";
    private String labelAlert = "Alert";

    public SJctrAlertModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrLaunchDC.launchGGI(event, SJctrAlertModel.DISP_ID, 99, SJctrAlertModel.TAB_INDEX, null);
            }
        });
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.labelAlert = util.getGuidance(ALERT);
        this.setLabel(this.labelAlert);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetSubsystemStatusMgr());
        this.directList.add(new SJctrGetDirectWrapper(direct, false));
        SJmoGetDirect direct_sn2opt = new SJmoGetDirect();
        direct_sn2opt.setGetKind(new SJmoGetSystemOption());
        this.directList.add(new SJctrGetDirectWrapper(direct_sn2opt, false));
    }

    @Override
    protected void makeDataObject() {
        boolean authority = this.chkAuthority();
        this.setVisible(authority);
        if (!authority) {
            return;
        }
        int statusSim = SIM_ST_UNKNOWN;
        int unchecked = UNCHECKED_SIM_ST_UNKNOWN;
        List<SJmoGetSubsystemStatusMgr> datalist = this.getBasicDataList(SJmoGetSubsystemStatusMgr.class);
        if (datalist.size() == 0) {
            this.getLogUty().putlog("getBasicDataList", "SJmoSubsystemStatusMgr is null");
        } else {
            SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)((Object)datalist.get(0));
            statusSim = mgr.getSubsystemStatus();
            unchecked = mgr.getSIMStatus();
        }
        if (this.statusSim_old != statusSim || unchecked != this.unchecked_old) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.statusSim_old);
            msg.append("->");
            msg.append(statusSim);
            msg.append(",");
            msg.append(this.unchecked_old);
            msg.append("->");
            msg.append(unchecked);
            this.getLogUty().putlog("getSubsystemStatus,getSIMStatus", msg.toString());
            this.statusSim_old = statusSim;
            this.unchecked_old = unchecked;
        }
        if (statusSim < 0 || statusSim >= icon_st.length) {
            statusSim = SIM_ST_UNKNOWN;
        }
        SJctrSelectableDataObject viewData = (SJctrSelectableDataObject)this.getManageData();
        if (unchecked == UNCHECKED_SIM_ST_EXIST) {
            viewData.setData(KEY_ICON, icon_st_unchecked[statusSim]);
        } else {
            viewData.setData(KEY_ICON, icon_st[statusSim]);
        }
    }

    private boolean chkAuthority() {
        boolean ret;
        block7: {
            block6: {
                if (this.isNorBasic()) {
                    return false;
                }
                if (this.isHideAlertInfo()) {
                    return false;
                }
                ret = false;
                SJctrDataController dc = this.getDataController();
                SJctrUserController uc = dc.getOwner();
                SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
                SJcRoleResourceContainer rr = ac.getRoleResourceContainer();
                SJctrLicenseContainer lc = ac.getLisenceContainer();
                SJctrSystemParamContainer spc = ac.getSystemParamContainer();
                ret = rr.checkAuthority(32);
                boolean host = spc.isLocalHost();
                if (!host) {
                    ret = ret && lc.checkPP(SJctrLicenseContainer.PPID_SN);
                }
                SJctrMainteRoleUtility roleUtil = new SJctrMainteRoleUtility();
                roleUtil.setContainer(ac);
                int role = roleUtil.isMainteRole();
                if (role == 1) break block6;
                if (role != 2) break block7;
            }
            ret = false;
        }
        return ret;
    }

    private boolean isNorBasic() {
        SJctrDataController dc = this.getDataController();
        SJctrUserController uc = dc.getOwner();
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        return spc.isNorBasic();
    }

    private boolean chkHideStatusWindow() {
        boolean ret = false;
        SJctrEnvParamUtility env = new SJctrEnvParamUtility(this.logUty);
        ret = env.isHideStatusWindow();
        String hideStWindow = env.getParam(SJctrEnvParamUtility.Param.HIDE_ST_WINDOW);
        this.getLogUty().putlog("chkHideStatusWindow", hideStWindow);
        return ret;
    }

    private boolean isHideAlertInfo() {
        boolean hideAlert = false;
        List<SJmoGetSystemOption> datalist = this.getBasicDataList(SJmoGetSystemOption.class);
        if (datalist.size() == 0) {
            this.getLogUty().putlog("getBasicDataList", "SJmoSystemOption is null");
        } else {
            SJmoSystemOption opt = (SJmoSystemOption)((Object)datalist.get(0));
            hideAlert = opt.isSnSysOptBit(0);
        }
        if (this.hideAlert_old != hideAlert) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.hideAlert_old);
            msg.append("->");
            msg.append(hideAlert);
            this.getLogUty().putlog("HideAlertInformation", msg.toString());
            this.hideAlert_old = hideAlert;
        }
        return hideAlert;
    }
}

