/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;

public class SJctrOperationLockStatus
implements Serializable {
    public static final String KEY_OPERATIONLOCKSTATUS = "SANreadOperationLockStatus";
    public static final String KEY_ERRORINFO = "ErrorInfo";
    public static final String KEY_ERROCODE = "ErrorCode";
    public static final String KEY_MESSAGEID = "MessageId";
    private static final String KEY_SVPLOCKSTATUS = "SvplockStatus";
    private static final String KEY_SYSTEMLOCKSTATUS = "SystemlockStatus";
    private static final String KEY_RESOURCELOCKSTATUSES = "ResourcelockStatuses";
    private static final String KEY_LOCKSTATUS = "LockStatus";
    private static final String KEY_USERNAME = "UserName";
    private static final String KEY_HOSTNAME = "HostName";
    private static final String KEY_LOCKSTARTTIME = "LockStartTime";
    public static final int ERROCODE_NORMAL = 0;
    private SanObject svpLockStatus = null;
    private SanObject systemLockStatus = null;
    private SanList resourceLockStatuses = null;
    private BASEgetDkcLockList svpLockInfo = null;
    private BASEgetDkcLockList systemLockInfo = null;
    private BASEgetDkcLockList[] resourceLockInfo = null;

    public SJctrOperationLockStatus(SanResponse response) throws SanDataException {
        boolean system_sts;
        this.svpLockStatus = response.getObj(KEY_SVPLOCKSTATUS);
        this.systemLockStatus = response.getObj(KEY_SYSTEMLOCKSTATUS);
        this.resourceLockStatuses = response.getList(KEY_RESOURCELOCKSTATUSES);
        boolean svp_sts = this.svpLockStatus.getBoolean(KEY_LOCKSTATUS);
        if (svp_sts) {
            BASEgetDkcLockList svp = new BASEgetDkcLockList();
            svp.setIResourceId(0);
            svp.setIAccessType(0);
            svp.setLockTime(null);
            svp.setStrUsername("");
            svp.setStrGsid("");
            this.svpLockInfo = svp;
        }
        if (system_sts = this.systemLockStatus.getBoolean(KEY_LOCKSTATUS)) {
            BASEgetDkcLockList system = new BASEgetDkcLockList();
            system.setIResourceId(0);
            system.setIAccessType(0);
            int[] time = this.systemLockStatus.getIntArray(KEY_LOCKSTARTTIME);
            Calendar cal = this.makeCalendarInfo(time);
            system.setLockTime(cal.getTime());
            system.setStrUsername(this.systemLockStatus.getString(KEY_USERNAME));
            system.setStrGsid("");
            this.systemLockInfo = system;
        }
        ArrayList<BASEgetDkcLockList> resourceList = new ArrayList<BASEgetDkcLockList>();
        for (int i = 0; i < this.resourceLockStatuses.size(); ++i) {
            SanObject resource_info = this.resourceLockStatuses.getObj(i);
            boolean resource_sts = resource_info.getBoolean(KEY_LOCKSTATUS);
            if (!resource_sts) continue;
            BASEgetDkcLockList resource = new BASEgetDkcLockList();
            resource.setIResourceId(i);
            resource.setIAccessType(0);
            int[] time = resource_info.getIntArray(KEY_LOCKSTARTTIME);
            Calendar cal = this.makeCalendarInfo(time);
            resource.setLockTime(cal.getTime());
            resource.setStrUsername(resource_info.getString(KEY_USERNAME));
            resource.setStrGsid("");
            resourceList.add(resource);
        }
        this.resourceLockInfo = new BASEgetDkcLockList[resourceList.size()];
        this.resourceLockInfo = resourceList.toArray(this.resourceLockInfo);
    }

    private Calendar makeCalendarInfo(int[] time) throws SanDataException {
        int yyyy = time[0];
        int MM = time[1] - 1;
        int dd = time[2];
        int HH = time[3];
        int mm = time[4];
        int ss = time[5];
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(yyyy, MM, dd, HH, mm, ss);
        return cal;
    }

    public BASEgetDkcLockList getSVPLockInfo() {
        return this.svpLockInfo;
    }

    public BASEgetDkcLockList getSystemLockInfo() {
        return this.systemLockInfo;
    }

    public BASEgetDkcLockList[] getResourceLockInfo() {
        return this.resourceLockInfo;
    }
}

