/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrActionMenuModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.node.SJctrMenuNodeData;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.controller.topwindow.base.SJctrLaunchMenuModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopMenuData;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;

public class SJctrTopMenuModel
extends SJctrActionMenuModel {
    private SJctrLaunchMenuModel launch = new SJctrLaunchMenuModel();
    private static final String MENU_LAUNCH = "MENU_LAUNCH";
    public static final String COM_LAUNCH = "COM_LAUNCH";
    public static final int MENU_TYPE_DEPEND_DISP = 1;
    public static final int MENU_TYPE_NOT_DEPEND_DISP = 0;

    @Override
    public Map<String, Map<String, Object>> getActionMenu() {
        HashMap<String, Map<String, Object>> actionMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> item = this.createItem("", "", "");
        actionMap.put("", item);
        for (HashMap<String, Object> menuItem : this.getItemMap().values()) {
            int selType;
            String key = SJctrActionMenuModel.Item.getActionKey(menuItem);
            if ("".equals(key) || (selType = SJctrActionMenuModel.Item.getSelType(menuItem).intValue()) != 0) continue;
            actionMap.put(key, menuItem);
        }
        return actionMap;
    }

    public SJctrTopMenuModel() {
        this.addDataModel(COM_LAUNCH, this.launch);
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                String name;
                if (event.isSelect() && (name = (String)event.getChangeObject()).startsWith("SETTINGS\tLAUNCHAPP\t")) {
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add(SJctrTopMenuModel.this.getDataModel(SJctrTopMenuModel.COM_LAUNCH));
                    param.add(SJctrTopMenuModel.this.getItem(name));
                    SJctrTopMenuModel.this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.SELECT_MENU, param);
                }
            }
        });
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        Map<String, Map<String, Object>> actionMap = this.getDataController().getActionMenu();
        SJctrTopWindowDC topDc = (SJctrTopWindowDC)this.getDataController();
        int opneDispId = topDc.getDisplayID();
        for (Map map : this.getItemMap().values()) {
            if (this.launch.setActionMenu(opneDispId, map)) continue;
            String actionKey = SJctrActionMenuModel.Item.getActionKey(map);
            Map<String, Object> item = actionMap.get(actionKey);
            if (item != null) {
                boolean enableFlg = SJctrActionMenuModel.Item.isEnable(item);
                SJctrActionMenuModel.Item.setEnable(map, enableFlg);
                int toolTip = SJctrActionMenuModel.Item.getToolTip(item);
                SJctrActionMenuModel.Item.setToolTip(map, toolTip);
                continue;
            }
            String name = SJctrActionMenuModel.Item.getName(map);
            SJctrNodeData nodeData = this.getNodePathToNodeDataMap().get(name);
            if (nodeData != null) {
                this.chkItem(map, nodeData);
            }
            SJctrActionMenuModel.Item.setEnable(map, false);
            int toolTip = 1 | SJctrActionMenuModel.Item.getToolTip(map);
            SJctrActionMenuModel.Item.setToolTip(map, toolTip);
        }
        return super.getDataObject(inputObject);
    }

    @Override
    protected void initLogicalNode() {
        super.initLogicalNode();
        for (Object[] data : SJctrTopMenuData.menuData) {
            SJctrMenuNodeData nodeData = SJctrMenuNodeData.createMenuNodeData(data);
            this.addNodeData(nodeData);
        }
    }

    @Override
    public void initNode() {
        super.initNode();
        for (SJctrNodeData nodeData : this.getLogicalPathToNodeDataMap().values()) {
            this.addItem(nodeData, new Object[0]);
        }
        Map<String, HashMap<String, Object>> mTopMenu = this.launch.initLaunch();
        for (HashMap<String, Object> menu : mTopMenu.values()) {
            menu.remove("children");
            this.addItem(menu);
        }
    }

    @Override
    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("name", name);
        item.put("label", label);
        item.put("enabled", true);
        item.put("COM_TYPE", 0);
        return item;
    }

    private void addItem(SJctrComUtility util, String base, String[] action) {
        String name = base + "\t" + action[0];
        String label = util.getGuidance(action[1], action[2]);
        String actKey = action[0];
        HashMap<String, Object> item = this.createItem(name, label, actKey);
        this.addItem(item);
    }

    private void addItem(SJctrComUtility util, String name, String partsId) {
        String label = util.getGuidance(partsId);
        HashMap<String, Object> item = this.createItem(name, label, "");
        this.addItem(item);
    }

    List<HashMap<String, Object>> getLaunchMenu(int dispId) {
        List itemList;
        List<HashMap<String, Object>> retList = Collections.emptyList();
        HashMap<String, Object> rootItem = this.getItem("SETTINGS\tLAUNCHAPP");
        if (rootItem != null && (itemList = (List)rootItem.get("children")) != null) {
            retList = new ArrayList<HashMap<String, Object>>();
            String dispStr = this.launch.makeDispName(dispId);
            for (HashMap item : itemList) {
                HashMap<String, Object> cloneItem;
                List<HashMap<String, Object>> list = this.getApplicationItem(dispStr, item);
                if (list.isEmpty()) continue;
                if (retList.isEmpty()) {
                    cloneItem = this.cloneLaunchMenuItem(rootItem);
                    retList.add(cloneItem);
                }
                cloneItem = this.cloneLaunchMenuItem(item);
                retList.add(cloneItem);
                retList.addAll(list);
            }
        }
        return retList;
    }

    private List<HashMap<String, Object>> getApplicationItem(String dispStr, HashMap<String, Object> item) {
        List<HashMap<String, Object>> retList = Collections.emptyList();
        List appItemList = (List)item.get("children");
        if (appItemList != null) {
            retList = new ArrayList<HashMap<String, Object>>(appItemList.size());
            for (HashMap appItem : appItemList) {
                List dispIdList = (List)appItem.get("DISPID");
                if (dispIdList == null || dispIdList.isEmpty()) continue;
                Collections.sort(dispIdList);
                int index = Collections.binarySearch(dispIdList, dispStr);
                if (index < 0) continue;
                HashMap<String, Object> cloneItem = this.cloneLaunchMenuItem(appItem);
                retList.add(cloneItem);
            }
        }
        return retList;
    }

    private HashMap<String, Object> cloneLaunchMenuItem(HashMap<String, Object> launchItem) {
        HashMap cloneItem = (HashMap)launchItem.clone();
        cloneItem.remove("children");
        return cloneItem;
    }

    public static boolean isLaunchMenu(String name) {
        boolean result = false;
        if (name != null) {
            result = name.startsWith("LAUNCHAPP");
        }
        return result;
    }

    public static String toTopMenuName(String actionMenuName) {
        String retName = null;
        if (actionMenuName != null) {
            retName = "SETTINGS\t" + actionMenuName;
        }
        return retName;
    }

    public static String toActionMenuName(String topMenuName) {
        String retName = null;
        if (topMenuName != null) {
            int pos = topMenuName.indexOf("LAUNCHAPP");
            if (pos >= 0) {
                retName = topMenuName.substring(pos);
            } else {
                SJctrLogUty.error("SJctrTopMenuModel", "toActionMenuName", topMenuName);
            }
        }
        return retName;
    }
}

