/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.comdialog.ldevproperties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.comdialog.ldevproperties.SJctrLdevPropertiesDC;
import sanproject.sn2.controller.topwindow.comdialog.ldevproperties.SJctrLdevPropertiesDef;
import sanproject.sn2.controller.topwindow.comdialog.ldevproperties.data.SJctrLdevPropertiesData;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPoolTieringPolicy;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrLdevPropertiesBasicSummaryModel
extends SJctrSimpleDataModel
implements SJctrLdevPropertiesDef,
SJctrGuidIdDefinition {
    private static final String RSG_COL_FORMAT = "%s(%d)";
    private SJctrComUtility comUtil;
    private SJctrLdevUtility ldevUtil;
    private SJctrPoolUtility poolUtil;
    private SJctrComCVSUtility cvsUtil;
    private SJctrCapacityUtility capUtil;
    private SJctrRsgUtility rsgUtil;

    public void initData() {
        SJctrLdevPropertiesDC dc = (SJctrLdevPropertiesDC)this.getDataController();
        SJctrLdevPropertiesData data = dc.getPropertiesData();
        Object sumData = this.getManageData();
        this.comUtil = this.getComUtility();
        this.ldevUtil = this.comUtil.getLdevUtility();
        this.poolUtil = this.comUtil.getPoolUtility();
        this.cvsUtil = this.comUtil.getCVSUtility();
        this.capUtil = this.comUtil.getCapacityUtility();
        this.rsgUtil = this.comUtil.getRsgUtility();
        ((SJctrDataObject)sumData).setData("COM_CAP_IND", this.toCapacityDisplay(data, data.getLLDEVLBASize()));
        ((SJctrDataObject)sumData).setData("COM_PROV", this.ldevUtil.toVolumeTypeDisplay(data));
        ((SJctrDataObject)sumData).setData("COM_STATUS", data.getLdevStatusInfo() == null ? "?" : this.ldevUtil.toStatusDisplay(data.getLdevStatusInfo().getLDEVStatus()));
        if (SJctrDataController.isHM()) {
            ((SJctrDataObject)sumData).setData("COM_PIN_STATUS", this.ldevUtil.toPinStatusDisplay(data.getLdevPinStatus()));
        }
        ((SJctrDataObject)sumData).setData("COM_ATTR", this.ldevUtil.toLdevAttributeDisplay(data));
        this.setCommandDeviceDisplayData((SJctrDataObject)sumData, data);
        ((SJctrDataObject)sumData).setData("COM_NUM_PATH", this.toNumberOfPathDisplay(data));
        ((SJctrDataObject)sumData).setData("COM_UUID", data.getLdevUuidInfo() == null ? "-" : data.getLdevUuidInfo().getStrUuid());
        ((SJctrDataObject)sumData).setData("COM_CLPR", this.ldevUtil.toClprDisplay(data.getClprInfo()));
        ((SJctrDataObject)sumData).setData("COM_ACCESS", this.toLdevGuardDisplay(data));
        ((SJctrDataObject)sumData).setData("COM_SSID", data.getSsidDetail() == null ? "?" : this.cvsUtil.toSsidDisplay(data.getSsidDetail()));
        String strCache = "-";
        if (data.getbExternalVolume() && !data.getbOdmVol()) {
            strCache = this.getEnabledDisabledDisplay(data.getbCasheMode());
        }
        ((SJctrDataObject)sumData).setData("COM_CACHE_MODE", strCache);
        this.setPgDisplayData((SJctrDataObject)sumData, data);
        this.setPoolDisplayData((SJctrDataObject)sumData, data);
        this.setMpBladeDisplayData((SJctrDataObject)sumData, data);
        ((SJctrDataObject)sumData).setData("COM_T10PI", this.ldevUtil.toT10PIDisplay(data));
        this.setExStorageSystemDisplayData((SJctrDataObject)sumData, data);
        this.setDataDirectMappedDisplayData((SJctrDataObject)sumData, data);
        this.setFullAllocationDisplayData((SJctrDataObject)sumData, data);
        this.setTierLevelDisplayData((SJctrDataObject)sumData, data);
        ((SJctrDataObject)sumData).setData("COM_COL_VIRTUAL_SPACE_USED", this.toVirtSpaceUsed(data));
        ((SJctrDataObject)sumData).setData("COM_VSS_ATTR", this.rsgUtil.toDispStringVssAttribute(data.getVHuvmLdev()));
        ((SJctrDataObject)sumData).setData("COM_ALUAMODE", this.cvsUtil.getALUAModeDisplay(data));
        this.setDataSavingDisplayData((SJctrDataObject)sumData, data);
        this.setDataSavingStatusDisplay((SJctrDataObject)sumData, data);
        this.setDeduplicationDataDisplay((SJctrDataObject)sumData, data);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        SJctrLdevPropertiesDC dc = (SJctrLdevPropertiesDC)this.getDataController();
        SJctrLdevPropertiesData data = dc.getPropertiesData();
        Object sumData = this.getManageData();
        List<SJmoGetRSGgetAllRsgs> allRsgsList = super.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
        SJmoRSGgetRsg rsg = null;
        if (allRsgsList.size() > 0) {
            ArrayList<SJmoRSGgetRsg> rsgList = ((SJmoRSGgetAllRsgs)((Object)allRsgsList.get(0))).getRsgs();
            rsg = sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility.getBelongToRsg(data, rsgList);
        }
        if (rsg == null) {
            ((SJctrDataObject)sumData).setData("COM_RSG_NAME", "?");
        } else {
            ((SJctrDataObject)sumData).setData("COM_RSG_NAME", String.format(RSG_COL_FORMAT, rsg.getRsgInfo().getRsgName(), rsg.getRsgInfo().getRsgId()));
        }
    }

    private void setPgDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        sumData.setData("COM_PG_ID", this.ldevUtil.toArrayGroupDisplay(data));
        sumData.setData("COM_PG_INTER_PG", this.toPgScatteredDisplay(data));
        sumData.setData("COM_PG_RAID", this.toPgRaidLevelDisplay(data));
        sumData.setData("COM_PG_DRIVE", this.toPgDriveTypeRPM(data));
        sumData.setData("COM_PG_PRO", this.ldevUtil.getProtectionLevel(data.getPgDetail()));
        sumData.setData("COM_PG_ENC", this.toPgEncryptionDisplay(data.getPgEncryption()));
        sumData.setData("COM_COL_VIRTUALIZATION_MODE", this.toVirtModeDisplay(data));
    }

    private void setPoolDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        if (data.getbPoolVol()) {
            sumData.setData("COM_POOL_ID", this.poolUtil.toPoolNameDisplay(data.getPoolVolumeDetail()));
            sumData.setData("COM_POOL_RAID", "-");
            sumData.setData("COM_POOL_TYPE", "-");
            sumData.setData("COM_POOL_ENCRYPTION", "-");
            sumData.setData("COM_PAGE_STATUS", "-");
            return;
        }
        if (data.getHdpRelation() != null) {
            sumData.setData("COM_POOL_ID", this.poolUtil.toPoolNameDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_RAID", this.poolUtil.toPoolRaidLevelDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_TYPE", this.poolUtil.toPoolDriveTypeDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_ENCRYPTION", this.poolUtil.getPoolEncryptionString(data.getPoolDetail()));
            sumData.setData("COM_PAGE_STATUS", this.poolUtil.toVVOLManagementTaskDisplay(data.getHdpRelation()));
        } else if (data.getQsRelation() != null) {
            sumData.setData("COM_POOL_ID", this.poolUtil.toPoolNameDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_RAID", this.poolUtil.toPoolRaidLevelDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_TYPE", this.poolUtil.toPoolDriveTypeDisplay(data.getPoolDetail()));
            sumData.setData("COM_POOL_ENCRYPTION", this.poolUtil.getPoolEncryptionString(data.getPoolDetail()));
            sumData.setData("COM_PAGE_STATUS", "-");
        } else {
            sumData.setData("COM_POOL_ID", "-");
            sumData.setData("COM_POOL_RAID", "-");
            sumData.setData("COM_POOL_TYPE", "-");
            sumData.setData("COM_POOL_ENCRYPTION", "-");
            sumData.setData("COM_PAGE_STATUS", "-");
        }
    }

    private void setCommandDeviceDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        if (!data.getbLUPathCmdDev() || data.getbRmtComDev()) {
            sumData.setData("COM_CMD_SEC", "-");
            sumData.setData("COM_CMD_USR", "-");
            sumData.setData("COM_CMD_DEVGRP", "-");
        } else {
            sumData.setData("COM_CMD_SEC", this.ldevUtil.toCommandDeviceSecurityDisplay(data));
            sumData.setData("COM_CMD_USR", this.ldevUtil.toCommandDeviceAuthenticationDisplay(data));
            sumData.setData("COM_CMD_DEVGRP", this.ldevUtil.toDeviceGrpDifinitionDisplay(data));
        }
    }

    private String getEnabledDisabledDisplay(boolean enabled) {
        if (enabled) {
            return this.comUtil.getGuidance("ENABLED");
        }
        return this.comUtil.getGuidance("DISABLED");
    }

    private String toCapacityDisplay(SJctrLdevPropertiesData ldev, long capacity) {
        if (ldev.getbOpenVolume()) {
            return this.capUtil.toUnitString(capacity);
        }
        return this.capUtil.toString(capacity, SJctrCapacityUtility.UNIT.CYL, ldev.getIEmulationType()) + this.capUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
    }

    private String toPgEncryptionDisplay(SJmoPgEncryptionInfo info) {
        if (info == null) {
            return "-";
        }
        if (info.getEncrypt() == 0) {
            return this.comUtil.getGuidance("DISABLED");
        }
        return this.comUtil.getGuidance("ENABLED");
    }

    private String toPgScatteredDisplay(SJctrLdevPropertiesData data) {
        StringBuffer sb = new StringBuffer();
        if (data.getScatteredPgList() == null || data.getScatteredPgList().size() == 0) {
            return "-";
        }
        List<SJmoPgIndex> pgList = data.getScatteredPgList();
        SJmoPgIndex pgIndex = pgList.get(0);
        SJmoLdevDetail scatteredPgLdev = new SJmoLdevDetail();
        scatteredPgLdev.setIFB4(pgIndex.getFB4());
        scatteredPgLdev.setIPG(pgIndex.getPG());
        sb.append(this.ldevUtil.toArrayGroupDisplay(scatteredPgLdev));
        for (int i = 1; i < pgList.size(); ++i) {
            pgIndex = pgList.get(i);
            scatteredPgLdev.setIFB4(pgIndex.getFB4());
            scatteredPgLdev.setIPG(pgIndex.getPG());
            sb.append(", ").append(this.ldevUtil.toArrayGroupDisplay(scatteredPgLdev));
        }
        return sb.toString();
    }

    private String toPgRaidLevelDisplay(SJctrLdevPropertiesData data) {
        if (data.getPgDetail() == null) {
            return "?";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.ldevUtil.toRaidLevelDisplay(data.getPgDetail()));
        if (sb.toString().equals("N/A")) {
            return sb.toString();
        }
        if (data.getScatteredPgList() != null && data.getScatteredPgList().size() > 1 && !sb.toString().equals("N/A")) {
            sb.append("*").append(data.getScatteredPgList().size());
        }
        return sb.toString();
    }

    private String toLdevGuardDisplay(SJctrLdevPropertiesData data) {
        if (data.getLdevGuardInfo() == null) {
            return "?";
        }
        return this.ldevUtil.getGuardAttrStr(data.getLdevGuardInfo().getByLdevGuardStatus(), data.getbVma(), data.getbExtent());
    }

    private void setMpBladeDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        String strCurMP = SJctrOwnerShipUtility.toMpBladeIdDisplay(this.comUtil, data.getByCurrentMPBladeID());
        String strAssMP = SJctrOwnerShipUtility.toMpBladeIdDisplay(this.comUtil, data.getByUserMPBladeID());
        sumData.setData("COM_CUR_MPB_ID", strCurMP);
        sumData.setData("COM_CUR_MPB_NAME", data.getCurentMP());
        sumData.setData("COM_ASGN_MPB_ID", strAssMP);
        sumData.setData("COM_ASGN_MPB_NAME", data.getAssignMP());
    }

    private void setExStorageSystemDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        sumData.setData("COM_LDEV_EXSS_PATHGROUP_ID", "-");
        sumData.setData("COM_LDEV_EXSS_VEND_MODEL_SN", "-");
        List<SJmoLdevDetail> ldevDetailList = data.getLdevDetailList();
        SJmoLdevDetail cnctLdev = SJctrLdevUtility.getLdevDetailFromDdmLdev(data, ldevDetailList);
        this.setExStorageSystemDisplayDataFromLdevIndex(sumData, data, cnctLdev);
    }

    private void setExStorageSystemDisplayDataFromLdevIndex(SJctrDataObject sumData, SJctrLdevPropertiesData data, SJmoLdevDetail ldev) {
        SJctrExtUtility util = this.comUtil.getExtUtility();
        if (ldev == null) {
            return;
        }
        SJmoExDVirtualPgInfo exVpgInfo = data.getExdVirtualPgInfo();
        SJmoExdPathGroupInfoMgr exPathGrpInfoMgr = data.getExdPathGroupInfoMgr();
        SJmoExdSubsystemInfoMgr exSubsysInfoMgr = data.getExdSubsystemInfoMgr();
        SJmoExdProfileInfoMgr exProfileInfoMgr = data.getExdProfileInfoMgr();
        SJmoExdPathGroupInfo exPathGrpInfo = SJctrExtUtility.getExdPathGrpInfoFromLdevDetail(ldev, exVpgInfo, exPathGrpInfoMgr);
        if (exPathGrpInfo == null) {
            return;
        }
        sumData.setData("COM_LDEV_EXSS_PATHGROUP_ID", util.toPathGroupIDDisplay(exPathGrpInfo.getRmiExdPathGroupInfo().getPathGroupID()));
        SJmoExdSubsystemInfo exSubsysInfo = SJctrExtUtility.getExdSubsysInfoFromLdevDetail(ldev, exVpgInfo, exPathGrpInfoMgr, exSubsysInfoMgr);
        SJmoExdProfileInfo exProfileInfo = SJctrExtUtility.getExdProfileInfoFromLdevDetail(ldev, exVpgInfo, exPathGrpInfoMgr, exSubsysInfoMgr, exProfileInfoMgr);
        if (exSubsysInfo == null || exProfileInfo == null) {
            return;
        }
        sumData.setData("COM_LDEV_EXSS_VEND_MODEL_SN", util.toSubSystemName(exSubsysInfo, exProfileInfo));
    }

    private void setDataDirectMappedDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        sumData.setData("COM_LDEV_DDM_LDEV_ID", "-");
        sumData.setData("COM_LDEV_DDM_PG_ID", "-");
        if (data.getBDM()) {
            List<SJmoLdevDetail> ldevList;
            int ldevIndex;
            SJmoLdevIndex cnctLdevIndex = data.getCnctLDEVIndex();
            if (cnctLdevIndex == null) {
                sumData.setData("COM_LDEV_DDM_LDEV_ID", "");
                return;
            }
            sumData.setData("COM_LDEV_DDM_LDEV_ID", this.ldevUtil.toLdevDisplay(cnctLdevIndex));
            if (data.getbVvol() && data.getbAouVvol() && (ldevIndex = Collections.binarySearch(ldevList = data.getLdevDetailList(), cnctLdevIndex)) >= 0) {
                SJmoLdevDetail cnctLdev = ldevList.get(ldevIndex);
                sumData.setData("COM_LDEV_DDM_PG_ID", this.ldevUtil.toArrayGroupDisplay(cnctLdev.getIFB4(), cnctLdev.getIPG()));
            }
        }
    }

    private void setFullAllocationDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        sumData.setData("COM_ALL_PAGE_RSV", this.cvsUtil.getFullAllocationDisplay(data, data.getHdpRelation()));
    }

    private void setTierLevelDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        ArrayList policyDataList = (ArrayList)this.getDataController().getProxy().getCache(SJmoGetPoolTieringPolicy.class);
        sumData.setData("COM_TIERLEVEL", this.cvsUtil.getTierLevelDisplay(data, data.getHdpRelation(), policyDataList));
        sumData.setData("COM_TIERNEWPAGE", this.cvsUtil.getNewPageAssignmentDisplay(data, data.getHdpRelation()));
        sumData.setData("COM_TIER", this.cvsUtil.getTierRelocationDisplay(data, data.getHdpRelation()));
        sumData.setData("COM_RELOCATIONPRIORITY", this.cvsUtil.getRelocationPriorityDisplay(data, data.getHdpRelation()));
    }

    public String toPgDriveTypeRPM(SJctrLdevPropertiesData data) {
        if (data.getPgDetail() == null) {
            return "?";
        }
        SJctrPGDetail pgDetail = new SJctrPGDetail();
        pgDetail.setPGDetail(data.getPgDetail());
        return pgDetail.getStrDriveTypeRPM(this.comUtil);
    }

    private String toNumberOfPathDisplay(SJctrLdevPropertiesData ldev) {
        if (ldev.getSLUSEEmlCount() == 0) {
            return "-";
        }
        return String.valueOf(ldev.getILUPathNumber());
    }

    private String toVirtModeDisplay(SJctrLdevPropertiesData data) {
        SJctrArrayGroupUtility agUtil = this.comUtil.getArrayGroupUtility();
        String ret = agUtil.toVirtModeDisplay(data.getPgDetail(), false);
        return ret;
    }

    private String toVirtSpaceUsed(SJctrLdevPropertiesData data) {
        SJctrLdevUtility ldevUtil = this.comUtil.getLdevUtility();
        String ret = ldevUtil.toVirtSpaceUsedDisplay(data);
        return ret;
    }

    private void setDataSavingDisplayData(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        SJctrLDEVDetail ldevDtl = new SJctrLDEVDetail();
        ldevDtl.setDetailData(data);
        if (data.getHdpRelation() != null) {
            ldevDtl.setRelationData(data.getHdpRelation());
        }
        sumData.setData("COM_DATA_SAVING", this.cvsUtil.toDataSavingDisplay(ldevDtl, false));
    }

    private void setDataSavingStatusDisplay(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        String str = "-";
        if (data.getByVolumeType() == 3 && data.getHdpRelation() != null) {
            SJmoThinProvisioningVolumesStatus dpStatusInfo = data.getDPVOLStatusInfo();
            str = this.poolUtil.getSavingStatus(dpStatusInfo, true);
        }
        sumData.setData("COM_COL_DATA_SAVING_STATE", str);
    }

    private void setDeduplicationDataDisplay(SJctrDataObject sumData, SJctrLdevPropertiesData data) {
        SJctrLDEVDetail ldevDtl = new SJctrLDEVDetail();
        ldevDtl.setDetailData(data);
        if (data.getDPVOLStatusInfo() != null) {
            ldevDtl.setDPVolStatus(data.getDPVOLStatusInfo());
        }
        sumData.setData("COM_DEDUPLICATION_DATA", this.cvsUtil.toDeduplicationDataDisplay(ldevDtl));
    }
}

