/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.encryption;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver.SJctrKmipViewBackupKeyServerDC;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncryptionKeysActionMenuModel;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncryptionKeysSummaryActionMenuModel;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncryptionKeysSummaryModel;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncryptionKeysTableModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.encryption.backupkeys.SJctrBackupKeysSubwizard;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysSubWizard;
import sanproject.sn2.controller.wizard.encryption.deletekeys.SJctrDeleteKeysSubWizard;
import sanproject.sn2.controller.wizard.encryption.forcerestorekeys.SJctrForceRestoreKeysSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.SJctrBackupKeysToServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.SJctrEditEnviromentalSetSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.forcerestorekeys.SJctrForceRestoreKeysFromServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.SJctrRestoreKeysFromServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.rekeycek.SJctrRekeyCekSubWizard;
import sanproject.sn2.controller.wizard.encryption.rekeykek.SJctrRekeyKekSubWizard;
import sanproject.sn2.controller.wizard.encryption.restorekeys.SJctrRestoreKeysSubWizard;
import sanproject.sn2.controller.wizard.encryption.retryKek.SJctrRetryKekSubWizard;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrEncryptionKeysDC
extends SJctrDataController {
    private static final int DISP_ID = 8704;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    private static final String KEY_SUMMARY_ACTION_MENU = "COM_SUMMARY_MENU";

    public SJctrEncryptionKeysDC() throws SJcException {
        super(8704);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrDataObjectModel model = new SJctrEncryptionKeysSummaryModel();
        this.addDataObjectModel(KEY_SUMMARY, model);
        model = new SJctrEncryptionKeysSummaryActionMenuModel();
        this.addDataObjectModel(KEY_SUMMARY_ACTION_MENU, model);
        model = new SJctrEncryptionKeysTableModel();
        this.addDataObjectModel(KEY_TABLE, model);
        model = new SJctrEncryptionKeysActionMenuModel();
        this.addDataObjectModel(KEY_ACTION_MENU, model);
    }

    private void initListener() {
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_CREATEKEYS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeCreateKeys();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_DELETEKEYS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeDeleteKeys();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_BACKUPKEYS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeBackupKeys();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_RESTOREKEYS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeRestoreKeys();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_BACKUPKEYS_TOSERVER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeBackupServer();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_RESTOREKEYS_FROMSERVER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeRestoreServer();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_VIEWBACKUPSERVER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeViewBackupServer();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_REKEY_CEK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeRekeyCEK();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_REKEY_KEK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeRekeyKEK();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_RETRY_KEK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeRetryKEK();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_EDITENVSETTING, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeEditEncSetting();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_FORCE_RESTOREKEYS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeForceRestoreKeys();
            }
        });
        this.addMessageEventListener(ENC_NOTIFY_STATE.MAKE_FORCE_RESTOREKEYS_FROMSERVER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEncryptionKeysDC.this.makeForceRestoreServer();
            }
        });
    }

    private List<?> getTableSelectData() {
        SJctrEncryptionKeysTableModel table = (SJctrEncryptionKeysTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectList = table.getSelectedRowData();
        Collections.sort(selectList);
        this.getLogUty().putlog("getTableSelectData", "Select = " + selectList.size());
        return selectList;
    }

    private Map<String, List<?>> createWizardDefaultParam() {
        HashMap param = new HashMap();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(this.getDisplayId());
        param.put("KEY_DISPID", list);
        return param;
    }

    private void makeCreateKeys() {
        SJctrRelatedDispDataObject related = this.createWizard(SJctrCreateKeysSubWizard.class, new HashMap());
        this.addUpdateDisp(related);
    }

    private void makeDeleteKeys() {
        List<?> selectList = this.getTableSelectData();
        if (selectList.isEmpty()) {
            return;
        }
        Map<String, List<?>> param = this.createWizardDefaultParam();
        param.put("KEYID", selectList);
        SJctrRelatedDispDataObject related = this.createWizard(SJctrDeleteKeysSubWizard.class, param);
        this.addUpdateDisp(related);
    }

    private void makeBackupKeys() {
        ArrayList<Integer> dispId = new ArrayList<Integer>();
        List backupKeyInfoList = new ArrayList();
        ArrayList backupKeyList = new ArrayList();
        SJmoEncryptionKeyInfoMgr enckeyMgr = null;
        Map<Object, Object> basicDataMap = new HashMap();
        HashMap dataMap = new HashMap();
        Object encKeyTable = null;
        SJctrRelatedDispDataObject bKSubWizard = null;
        Integer iDisp = new Integer(8704);
        dispId.add(iDisp);
        basicDataMap = this.getDataObjectModel(KEY_TABLE).getBasicDataMap();
        backupKeyInfoList = (List)basicDataMap.get(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        enckeyMgr = (SJmoEncryptionKeyInfoMgr)backupKeyInfoList.get(0);
        dataMap.put("KEY_DISPID", dispId);
        dataMap.put("KEYID", backupKeyList);
        bKSubWizard = this.createWizard(SJctrBackupKeysSubwizard.class, dataMap);
        this.addUpdateDisp(bKSubWizard);
    }

    private void makeRestoreKeys() {
        ArrayList<Integer> dispId = new ArrayList<Integer>();
        HashMap dataMap = new HashMap();
        SJctrRelatedDispDataObject rKSubWizard = null;
        Integer iDisp = new Integer(8704);
        dispId.add(iDisp);
        dataMap.put("KEY_DISPID", dispId);
        rKSubWizard = this.createWizard(SJctrRestoreKeysSubWizard.class, dataMap);
        this.addUpdateDisp(rKSubWizard);
    }

    private void makeBackupServer() {
        this.makeSubWizard(SJctrBackupKeysToServerSubWizard.class, new HashMap());
    }

    private void makeRestoreServer() {
        this.makeSubWizard(SJctrRestoreKeysFromServerSubWizard.class, new HashMap());
    }

    private void makeForceRestoreKeys() {
        ArrayList<Integer> dispId = new ArrayList<Integer>();
        HashMap dataMap = new HashMap();
        SJctrRelatedDispDataObject frKSubWizard = null;
        Integer iDisp = new Integer(8704);
        dispId.add(iDisp);
        dataMap.put("KEY_DISPID", dispId);
        frKSubWizard = this.createWizard(SJctrForceRestoreKeysSubWizard.class, dataMap);
        this.addUpdateDisp(frKSubWizard);
    }

    private void makeForceRestoreServer() {
        this.makeSubWizard(SJctrForceRestoreKeysFromServerSubWizard.class, new HashMap());
    }

    private void makeViewBackupServer() {
        this.makeDialog(SJctrKmipViewBackupKeyServerDC.class, new HashMap());
    }

    private void makeSubWizard(Class<? extends SJctrSubWizard> clazz, Map<String, List<?>> cache) {
        SJctrRelatedDispDataObject subWizard = this.createWizard(clazz, cache);
        this.addUpdateDisp(subWizard);
    }

    private void makeDialog(Class<? extends SJctrDialogDataController> clazz, Map<String, List<?>> cache) {
        SJctrRelatedDispDataObject dialog = this.createDialog(clazz, cache);
        this.addUpdateDisp(dialog);
    }

    private void makeRekeyCEK() {
        this.makeSubWizard(SJctrRekeyCekSubWizard.class, new HashMap());
    }

    private void makeRekeyKEK() {
        this.makeSubWizard(SJctrRekeyKekSubWizard.class, new HashMap());
    }

    private void makeRetryKEK() {
        this.makeSubWizard(SJctrRetryKekSubWizard.class, new HashMap());
    }

    private void makeEditEncSetting() {
        this.makeSubWizard(SJctrEditEnviromentalSetSubWizard.class, new HashMap());
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        super.makeDataObjectModel(keyList);
        List<SJmoEncryptionKeyInfoMgr> keyInfoList = this.getModelData(SJmoGetEncryptionKeyInfoMgr.class);
        SJmoEncryptionKeyInfoMgr keyInfo = (SJmoEncryptionKeyInfoMgr)keyInfoList.get(0);
        SJmoEncryptionKeyGenerationInfo generate = keyInfo.getGenerationInfo();
        if (generate.getIEncKeyGenerationInfo() == 0) {
            this.getManageData().setData("COM_INITFLG", 0);
        } else if (SJctrEncryptionKeysUtility.isKekKey(keyInfoList)) {
            this.getManageData().setData("COM_INITFLG", 2);
        } else {
            this.getManageData().setData("COM_INITFLG", 1);
        }
    }

    public static enum ENC_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_CREATEKEYS,
        MAKE_DELETEKEYS,
        MAKE_BACKUPKEYS,
        MAKE_RESTOREKEYS,
        MAKE_BACKUPKEYS_TOSERVER,
        MAKE_RESTOREKEYS_FROMSERVER,
        MAKE_VIEWBACKUPSERVER,
        MAKE_REKEY_CEK,
        MAKE_REKEY_KEK,
        MAKE_RETRY_KEK,
        MAKE_EDITENVSETTING,
        MAKE_FORCE_RESTOREKEYS,
        MAKE_FORCE_RESTOREKEYS_FROMSERVER;

    }
}

