/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.pool.poolvol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPbTSMMonitorOperationInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoPoolUsedCapacity;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrPLSummaryModel
extends SJctrSimpleDataModel {
    public SJctrPoolSelectDC m_PoolSelDC = null;
    public SJctrPoolUtility m_PoolUtl = null;
    private SJmoTiPvolInfo[] tiPVolArray = null;
    private SJmoPoolUsedCapacity poolUseCapInfo = null;
    public static final String KEY_POOL_STATUS = "COM_POOL_STATUS";
    public static final String KEY_STATUS_ICON = "COM_STATUS_ICON";
    public static final String KEY_POOL_NAME = "COM_POOL_NAME";
    public static final String KEY_POOL_ATTR = "COM_POOL_ATTR";
    public static final String KEY_POOL_RAIDLVE = "COM_POOL_RAIDLVE";
    public static final String KEY_POOL_TYPE = "COM_POOL_TYPE";
    public static final String KEY_POOL_CACHEMODE = "COM_POOL_CACHEMODE";
    public static final String KEY_POOL_TOPVOLNAME = "COM_POOL_TOPVOLNAME";
    public static final String KEY_POOL_CAP = "COM_POOL_CAP";
    public static final String KEY_POOL_SUBSCRIPTION = "COM_POOL_SUBSCRIPTION";
    public static final String KEY_VVOL_CAP = "COM_VVOL_CAP";
    public static final String KEY_POOL_THRESHOLD = "COM_POOL_THRESHOLD";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_POOL_VOL_NUM = "COM_POOL_VOL_NUM";
    public static final String KEY_TIER = "COM_TIER";
    public static final String KEY_EXECUT_INTERVAL = "COM_EXECUT_INTERVAL";
    public static final String KEY_MONITOR_PERIOD = "COM_MONITOR_PERIOD";
    public static final String KEY_MONITOR_STATUS = "COM_MONITOR_STATUS";
    public static final String KEY_AVAILABLE_MONITOR_DATA = "COM_AVAILABLE_MONITOR_DATA";
    public static final String KEY_RELOCATION_STATUS = "COM_RELOCATION_STATUS";
    public static final String KEY_RELOCATION_PROGRESS_RATE = "COM_RELOCATION_PROGRESS_RATE";
    public static final String RELOCATION_PROGRESS_PERCENT = " %";
    public static final String KEY_MONITORING_MODE = "COM_MONITOR_MODE";
    public static final String KEY_PRIMARY_VOL_NUM = "COM_PRIMARY_VOL_NUM";
    public static final String KEY_POOL_MANAGE_TASK = "COM_POOL_MANAGE_TASK";
    public static final String KEY_RELOCATION_RESULT = "COM_RELOCATION_RESULT";
    public static final String KEY_RELOCATION_SPEED = "COM_RELOCATION_SPEED";
    public static final String KEY_BLOCKADE_POOL = "COM_BLOCKADE_POOL";
    public static final String KEY_POOL_FULL = "COM_POOL_FULL";
    public static final String KEY_POOL_ENCRYPTION = "COM_POOL_ENCRYPTION";
    public static final String KEY_BASIC_CAP = "COM_BASIC_CAP";
    public static final String KEY_SAVING = "COM_SAVING";
    public static final String KEY_EXP_RATE = "COM_EXP_RATE";
    public static final String KEY_EXP_RATE_ICON = "COM_EXP_RATE_ICON";
    public static final String KEY_DEDUPLICATIONP = "COM_DEDUPLICATION";
    public static final String KEY_POOL_SAVING_PER = "COM_POOL_SAVING_PER";
    private final String FORMAT_SAVING_EFFECT = "%s %% (%s)";
    public static final String KEY_COM_TI_PAIR_SUSPEND_DEP_EXC = "COM_TI_PAIR_SUSPEND_DEP_EXC";
    public static final String KEY_SNAPSHOT_USED_CAP = "COM_SNAPSHOT_USED_CAP";
    SJctrLicenseContainer licensecontainer = null;
    boolean bLicense_DRU = false;
    private List<SJmoPgDetail> pgDtlList = Collections.emptyList();
    private List<SJmoVdevDetail> vdevDtlList = Collections.emptyList();
    private List<SJmoPgScatteredInfo> scPgInfoList = Collections.emptyList();

    @Override
    public void makeDataObject() {
        List<?> getList;
        List<SJmoPoolUsedCapacity> poolUseCapList;
        List<SJmoGetTiPvolStatus> tiPVolStatusList;
        ArrayList<Object> summaryList = new ArrayList<Object>();
        SJctrDataController dc = this.getDataController();
        if (null != dc && dc instanceof SJctrPoolSelectDC) {
            this.m_PoolSelDC = (SJctrPoolSelectDC)dc;
            this.m_PoolUtl = this.getComUtility().getPoolUtility();
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeDataObject", "getDataController failed");
            this.m_PoolSelDC = null;
        }
        SJmoPoolIndex poolIndex = new SJmoPoolIndex();
        if (this.m_PoolSelDC != null) {
            poolIndex.setPoolId(this.m_PoolSelDC.getSelectPool());
        }
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        SJmoPoolDetail poolDtlSmry = this.getPoolDetailSummary(poolDtlList);
        ArrayList<SJmoPoolVolDetail> poolVolDtlList = new ArrayList<SJmoPoolVolDetail>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        SJmoPoolVolDetail poolVolDtlSmry = this.getPoolVolDetailSummary(poolVolDtlList);
        ArrayList<SJmoHDPRelationByPool> hdpRelbyPoolList = new ArrayList<SJmoHDPRelationByPool>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        SJmoHDPRelationByPool hdpRelbyPoolSmry = this.getHDPRelationbyPoolSummary(hdpRelbyPoolList);
        ArrayList<SJmoLdevDetail> ldevDtlList = new ArrayList<SJmoLdevDetail>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        List<SJmoLdevDetail> ldevDtlListSmry = this.getLdevDetailSummary(ldevDtlList, poolVolDtlSmry);
        ArrayList<SJmoPoolNameInfo> poolNameInfList = new ArrayList<SJmoPoolNameInfo>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        SJmoPoolNameInfo poolNameInfSmry = this.getPoolNameInfSummary(poolNameInfList);
        ArrayList<SJmoLdevNicknameInfo> ldevNameInfList = new ArrayList<SJmoLdevNicknameInfo>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO));
        List<SJmoLdevNicknameInfo> ldevNameInfListSmry = this.getLdevNameInfSummary(ldevNameInfList, poolVolDtlSmry);
        ArrayList allRsgsList = new ArrayList(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        SJmoRSGgetAllRsgs allRsgs = null;
        if (0 < allRsgsList.size()) {
            allRsgs = (SJmoRSGgetAllRsgs)allRsgsList.get(0);
        }
        ArrayList<SJmoPbTSMMonitorOperationInfo> pbtsmMonInfList = new ArrayList<SJmoPbTSMMonitorOperationInfo>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO));
        SJmoPbTSMMonitorOperationInfo pbtsmMonInfListSmry = this.getPbTSMMonInfSummary(pbtsmMonInfList);
        List<?> poolSummaryList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        SJmoPoolSummary poolSummaryInfo = null;
        if (poolSummaryList != null && !poolSummaryList.isEmpty()) {
            poolSummaryInfo = (SJmoPoolSummary)poolSummaryList.get(0);
        }
        if ((tiPVolStatusList = this.getBasicDataList(SJmoGetTiPvolStatus.class)) != null && !tiPVolStatusList.isEmpty()) {
            SJmoTiPvolStatus tiPVolStatus = (SJmoTiPvolStatus)((Object)tiPVolStatusList.get(0));
            this.tiPVolArray = tiPVolStatus.getTiPvolInfo();
        }
        if ((poolUseCapList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY)) != null && !poolUseCapList.isEmpty()) {
            this.poolUseCapInfo = SJctrPoolUtility.getPoolUsedCapacityInfo(poolIndex, poolUseCapList);
        }
        if ((getList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_PG_DETAIL)) != null) {
            this.pgDtlList = getList;
        }
        if ((getList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL)) != null) {
            this.vdevDtlList = getList;
        }
        if ((getList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF)) != null) {
            this.scPgInfoList = getList;
        }
        summaryList.add(poolDtlSmry);
        summaryList.add(poolVolDtlSmry);
        summaryList.add(hdpRelbyPoolSmry);
        summaryList.add(ldevDtlListSmry);
        summaryList.add(poolNameInfSmry);
        summaryList.add(ldevNameInfListSmry);
        summaryList.add(allRsgs);
        summaryList.add(pbtsmMonInfListSmry);
        summaryList.add(poolSummaryInfo);
        this.makeSummary(summaryList);
    }

    @Override
    protected void makeModelDirect() {
        SJctrGetDirectWrapper getDrctWrpPoolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        this.directList.add(getDrctWrpPoolDtl);
        SJctrGetDirectWrapper getDrctWrpPoolVolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        this.directList.add(getDrctWrpPoolVolDtl);
        SJctrGetDirectWrapper getDrctWrpHDPRelbyPool = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        this.directList.add(getDrctWrpHDPRelbyPool);
        SJctrGetDirectWrapper getDrctWrpLdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        this.directList.add(getDrctWrpLdevDtl);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        this.directList.add(getDrctWrpPoolNameInf);
        SJctrGetDirectWrapper getDrctWrpLdevNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        this.directList.add(getDrctWrpLdevNameInf);
        SJctrGetDirectWrapper getDrctWrpAllRsg = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_ALL_RSG);
        this.directList.add(getDrctWrpAllRsg);
        SJctrGetDirectWrapper getDrctWrpPbTSMMonInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO);
        this.directList.add(getDrctWrpPbTSMMonInf);
        SJctrGetDirectWrapper getDrctWrpPoolSummaryInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        this.directList.add(getDrctWrpPoolSummaryInfo);
        SJctrGetDirectWrapper getDrctWrpTiPvolStatus = this.createModelDirect(SJmoGetTiPvolStatus.class);
        this.directList.add(getDrctWrpTiPvolStatus);
        SJctrGetDirectWrapper getDrctWrpPoolUsedCapInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        this.directList.add(getDrctWrpPoolUsedCapInfo);
        SJctrGetDirectWrapper getDrctWrpPGDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        this.directList.add(getDrctWrpPGDtl);
        SJctrGetDirectWrapper getDrctWrpVdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        this.directList.add(getDrctWrpVdevDtl);
        SJctrGetDirectWrapper getDrctWrpScPgInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        this.directList.add(getDrctWrpScPgInfo);
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return getDrctWrap;
    }

    protected void makeSummary(List<?> summaryList) {
        SJmoPoolDetail poolDtlSmry = null;
        SJmoPoolVolDetail poolVolDtlSmry = null;
        SJmoHDPRelationByPool hdpRelbyPoolSmry = null;
        List ldevDtlListSmry = null;
        SJmoPoolNameInfo poolNameInfSmry = null;
        List ldevNameListSmry = null;
        SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo = null;
        SJmoPoolSummary poolSummaryInfo = null;
        if (null != summaryList) {
            for (int iListIdx = 0; iListIdx < summaryList.size(); ++iListIdx) {
                Object obj = summaryList.get(iListIdx);
                if (null != obj) {
                    if (obj instanceof SJmoPoolDetail) {
                        poolDtlSmry = (SJmoPoolDetail)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPoolVolDetail) {
                        poolVolDtlSmry = (SJmoPoolVolDetail)obj;
                        continue;
                    }
                    if (obj instanceof SJmoHDPRelationByPool) {
                        hdpRelbyPoolSmry = (SJmoHDPRelationByPool)obj;
                        continue;
                    }
                    if (obj instanceof List) {
                        List objList = (List)obj;
                        if (0 != objList.size()) {
                            Object objData = objList.get(0);
                            if (objData instanceof SJmoLdevDetail) {
                                ldevDtlListSmry = (List)obj;
                                continue;
                            }
                            if (!(objData instanceof SJmoLdevNicknameInfo)) continue;
                            ldevNameListSmry = (List)obj;
                            continue;
                        }
                        if (iListIdx == 3) {
                            ldevNameListSmry = objList;
                            continue;
                        }
                        if (iListIdx == 5) {
                            ldevDtlListSmry = objList;
                            continue;
                        }
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "SummaryList Index Error:" + iListIdx);
                        continue;
                    }
                    if (obj instanceof SJmoPoolNameInfo) {
                        poolNameInfSmry = (SJmoPoolNameInfo)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPbTSMMonitorOperationInfo) {
                        pbTSMMonitorOpeInfo = (SJmoPbTSMMonitorOperationInfo)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPoolSummary) {
                        poolSummaryInfo = (SJmoPoolSummary)obj;
                        continue;
                    }
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "class error in summaryLis : ListIdx=" + iListIdx);
                    continue;
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "null data in summaryList : ListIdx=" + iListIdx);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "summaryList is null");
        }
        String strStatus = this.getPoolStatus(poolDtlSmry);
        int iStatusIcon = this.getStatusIcon(poolDtlSmry);
        String strPoolName = this.getPoolName(poolNameInfSmry);
        String strPoolAttribute = this.getPoolAttribute(poolDtlSmry);
        String strRaidLevel = this.getRaidLevel(poolDtlSmry);
        String strDriveType = this.getDriveType(poolDtlSmry);
        String strCacheMode = this.getCacheMode(ldevDtlListSmry, poolVolDtlSmry);
        String strTopPoolVolName = this.getTopPoolVolName(poolDtlSmry, poolVolDtlSmry, ldevNameListSmry);
        String strPoolCapa = this.getPoolCapa(poolDtlSmry);
        String strSubscription = this.getSubscription(poolDtlSmry);
        String strVVolCapa = this.getVVolCapa(poolDtlSmry, hdpRelbyPoolSmry);
        String strThreshold = this.getThreshold(poolDtlSmry);
        String strVVolNum = this.getVVolNum(hdpRelbyPoolSmry, poolDtlSmry);
        String strPoolVolNum = this.getPoolVolNum(poolDtlSmry);
        String strTier = this.getTierInfo(poolDtlSmry, poolSummaryInfo);
        String strExeInt = this.getExecutionInt(poolDtlSmry);
        String strMonPeriod = this.gerMonPeriond(poolDtlSmry);
        String strMonitorStatus = this.getMonitorStatus(pbTSMMonitorOpeInfo, poolDtlSmry, poolSummaryInfo);
        String strAvailableMonitorData = this.getAvailableMonitorData(pbTSMMonitorOpeInfo, poolDtlSmry, poolSummaryInfo);
        String strRelocationStatus = this.getRelocationStatus(pbTSMMonitorOpeInfo, poolDtlSmry);
        String strRelocationProgressRate = this.getRelocationProgressRate(pbTSMMonitorOpeInfo, poolDtlSmry);
        String strMonMode = this.getMonMode(poolDtlSmry, poolSummaryInfo);
        String strSVolNum = this.getPrimaryVolumeNum(poolDtlSmry, this.tiPVolArray);
        String strPoolManageTask = this.getPoolManagementTask(poolDtlSmry);
        String strRelocationResult = this.getRelocationResult(pbTSMMonitorOpeInfo, poolDtlSmry);
        String strRelocationSpeed = this.getRelocationSpeed(poolDtlSmry);
        String strBlockadePoolVOLs = this.getPoolSystemOption(poolDtlSmry, 0x40000000L);
        String strPoolFull = this.getPoolSystemOption(poolDtlSmry, 0x80000000L);
        String strBasicUsableCapa = this.getBasicUsableCapa(poolDtlSmry);
        String strDeduplication = this.getDeduplication(poolDtlSmry);
        String strSuspendTiPair = this.getSuspendTiPair(poolDtlSmry);
        String strSnapshotUsedCap = this.getSnapshotUsedCapacity(poolDtlSmry);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_POOL_STATUS, strStatus);
        Integer intStatusIcon = new Integer(iStatusIcon);
        ((SJctrDataObject)summaryData).setData(KEY_STATUS_ICON, intStatusIcon);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_NAME, strPoolName);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_ATTR, strPoolAttribute);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_RAIDLVE, strRaidLevel);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_TYPE, strDriveType);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_CACHEMODE, strCacheMode);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_TOPVOLNAME, strTopPoolVolName);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_CAP, strPoolCapa);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_SUBSCRIPTION, strSubscription);
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_CAP, strVVolCapa);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_THRESHOLD, strThreshold);
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_NUM, strVVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_VOL_NUM, strPoolVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_TIER, strTier);
        ((SJctrDataObject)summaryData).setData(KEY_EXECUT_INTERVAL, strExeInt);
        ((SJctrDataObject)summaryData).setData(KEY_MONITOR_PERIOD, strMonPeriod);
        ((SJctrDataObject)summaryData).setData(KEY_MONITOR_STATUS, strMonitorStatus);
        ((SJctrDataObject)summaryData).setData(KEY_AVAILABLE_MONITOR_DATA, strAvailableMonitorData);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_STATUS, strRelocationStatus);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_PROGRESS_RATE, strRelocationProgressRate);
        ((SJctrDataObject)summaryData).setData(KEY_MONITORING_MODE, strMonMode);
        ((SJctrDataObject)summaryData).setData(KEY_PRIMARY_VOL_NUM, strSVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_MANAGE_TASK, strPoolManageTask);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_RESULT, strRelocationResult);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_SPEED, strRelocationSpeed);
        ((SJctrDataObject)summaryData).setData(KEY_BLOCKADE_POOL, strBlockadePoolVOLs);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_FULL, strPoolFull);
        ((SJctrDataObject)summaryData).setData(KEY_BASIC_CAP, strBasicUsableCapa);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_ENCRYPTION, this.getComUtility().getPoolUtility().getPoolEncryptionString(poolDtlSmry));
        ((SJctrDataObject)summaryData).setData(KEY_SAVING, this.getPoolSavingRate(poolDtlSmry));
        ((SJctrDataObject)summaryData).setData(KEY_EXP_RATE, this.getPoolExpantionRate(poolDtlSmry));
        ArrayList<SJmoPoolVolDetail> poolVolList = new ArrayList<SJmoPoolVolDetail>();
        poolVolList.add(poolVolDtlSmry);
        int poolExpantionRateIconId = this.m_PoolUtl.getPoolCapExpantionRateIconId(poolDtlSmry, poolVolList, ldevDtlListSmry, this.pgDtlList, this.vdevDtlList, this.scPgInfoList);
        ((SJctrDataObject)summaryData).setData(KEY_EXP_RATE_ICON, poolExpantionRateIconId);
        ((SJctrDataObject)summaryData).setData(KEY_DEDUPLICATIONP, strDeduplication);
        ((SJctrDataObject)summaryData).setData(KEY_COM_TI_PAIR_SUSPEND_DEP_EXC, strSuspendTiPair);
        ((SJctrDataObject)summaryData).setData(KEY_SNAPSHOT_USED_CAP, strSnapshotUsedCap);
        String strSavingRate = this.getEffectSavingDisplay(poolDtlSmry);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_SAVING_PER, strSavingRate);
    }

    public SJmoPoolDetail getPoolDetailSummary(List<SJmoPoolDetail> poolDetailList) {
        SJmoPoolDetail retPoolDtl = null;
        if (null != this.m_PoolSelDC) {
            int iSelPool = this.m_PoolSelDC.getSelectPool();
            SJmoPoolIndex selPoolIdx = new SJmoPoolIndex();
            selPoolIdx.setPoolId(iSelPool);
            Collections.sort(poolDetailList);
            int iPoolDtlIdx = Collections.binarySearch(poolDetailList, selPoolIdx);
            if (0 <= iPoolDtlIdx) {
                retPoolDtl = poolDetailList.get(iPoolDtlIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolDetailSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolDetailSummary", "m_poolSelDC is null");
        }
        return retPoolDtl;
    }

    public SJmoPoolVolDetail getPoolVolDetailSummary(List<SJmoPoolVolDetail> poolVolDetailList) {
        SJmoPoolVolDetail retPoolVolDtl = null;
        if (null != this.m_PoolSelDC) {
            int iSelPool = this.m_PoolSelDC.getSelectPool();
            SJmoPoolIndex selPoolIdx = new SJmoPoolIndex();
            selPoolIdx.setPoolId(iSelPool);
            Collections.sort(poolVolDetailList);
            int iPoolVolDtlIdx = Collections.binarySearch(poolVolDetailList, selPoolIdx);
            if (0 <= iPoolVolDtlIdx) {
                retPoolVolDtl = poolVolDetailList.get(iPoolVolDtlIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolDetailSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolDetailSummary", "m_poolSelDC is null");
        }
        return retPoolVolDtl;
    }

    public SJmoHDPRelationByPool getHDPRelationbyPoolSummary(List<SJmoHDPRelationByPool> hdpRelationbyPoolList) {
        SJmoHDPRelationByPool retHDPRelationbyPool = null;
        if (null != this.m_PoolSelDC) {
            int iSelPool = this.m_PoolSelDC.getSelectPool();
            SJmoPoolIndex selPoolIdx = new SJmoPoolIndex();
            selPoolIdx.setPoolId(iSelPool);
            Collections.sort(hdpRelationbyPoolList);
            int iPoolHDPRelationbyPoolIdx = Collections.binarySearch(hdpRelationbyPoolList, selPoolIdx);
            if (0 <= iPoolHDPRelationbyPoolIdx) {
                retHDPRelationbyPool = hdpRelationbyPoolList.get(iPoolHDPRelationbyPoolIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getHDPRelationbyPoolSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolDetailSummary", "m_poolSelDC is null");
        }
        return retHDPRelationbyPool;
    }

    public List<SJmoLdevDetail> getLdevDetailSummary(List<SJmoLdevDetail> ldevDetailList, SJmoPoolVolDetail poolVolDetail) {
        ArrayList<SJmoLdevDetail> retLdevDtlList = new ArrayList<SJmoLdevDetail>();
        if (null != poolVolDetail) {
            ArrayList poolVolInfList = poolVolDetail.getAlPoolInfo();
            if (null != poolVolInfList && 0 != poolVolInfList.size()) {
                Collections.sort(ldevDetailList);
                for (int iVolInfCnt = 0; iVolInfCnt < poolVolInfList.size(); ++iVolInfCnt) {
                    SJmoPoolVolInfo poolVolInf = (SJmoPoolVolInfo)poolVolInfList.get(iVolInfCnt);
                    int iLdevDtlIdx = Collections.binarySearch(ldevDetailList, poolVolInf);
                    if (0 <= iLdevDtlIdx) {
                        SJmoLdevDetail ldevDtl = ldevDetailList.get(iLdevDtlIdx);
                        retLdevDtlList.add(ldevDtl);
                        continue;
                    }
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevDetailSummary", "Select PoolVol is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevDetailSummary", "poolVolInfList is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevDetailSummary", "poolVolDetail is null");
        }
        return retLdevDtlList;
    }

    public SJmoPoolNameInfo getPoolNameInfSummary(List<SJmoPoolNameInfo> poolNameInfList) {
        SJmoPoolNameInfo retPoolNameInf = null;
        if (null != this.m_PoolSelDC) {
            int iSelPool = this.m_PoolSelDC.getSelectPool();
            SJmoPoolIndex selPoolIdx = new SJmoPoolIndex();
            selPoolIdx.setPoolId(iSelPool);
            Collections.sort(poolNameInfList);
            int iPoolNameInfIdx = Collections.binarySearch(poolNameInfList, selPoolIdx);
            if (0 <= iPoolNameInfIdx) {
                retPoolNameInf = poolNameInfList.get(iPoolNameInfIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "m_poolSelDC is null");
        }
        return retPoolNameInf;
    }

    public List<SJmoLdevNicknameInfo> getLdevNameInfSummary(List<SJmoLdevNicknameInfo> ldevNameInfList, SJmoPoolVolDetail poolVolDetail) {
        ArrayList<SJmoLdevNicknameInfo> retLdevNickNameInfList = new ArrayList<SJmoLdevNicknameInfo>();
        if (null != poolVolDetail) {
            ArrayList poolVolInfList = poolVolDetail.getAlPoolInfo();
            if (null != poolVolInfList && 0 != poolVolInfList.size()) {
                Collections.sort(ldevNameInfList);
                for (int iVolInfCnt = 0; iVolInfCnt < poolVolInfList.size(); ++iVolInfCnt) {
                    SJmoPoolVolInfo poolVolInf = (SJmoPoolVolInfo)poolVolInfList.get(iVolInfCnt);
                    int iLdevNameInfIdx = Collections.binarySearch(ldevNameInfList, poolVolInf);
                    if (0 <= iLdevNameInfIdx) {
                        SJmoLdevNicknameInfo ldevNameInf = ldevNameInfList.get(iLdevNameInfIdx);
                        retLdevNickNameInfList.add(ldevNameInf);
                        continue;
                    }
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevNameInfSummary", "Select PoolVol is not found");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevNameInfSummary", "poolVolInfList is null or size 0");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getLdevNameInfSummary", "poolVolDetail is null");
        }
        return retLdevNickNameInfList;
    }

    public SJmoPbTSMMonitorOperationInfo getPbTSMMonInfSummary(List<SJmoPbTSMMonitorOperationInfo> pbtsmMonInfList) {
        SJmoPbTSMMonitorOperationInfo retPbTSMMonInf = null;
        if (null != this.m_PoolSelDC) {
            int iSelPool = this.m_PoolSelDC.getSelectPool();
            SJmoPoolIndex selPoolIdx = new SJmoPoolIndex();
            selPoolIdx.setPoolId(iSelPool);
            Collections.sort(pbtsmMonInfList);
            int iPoolNameInfIdx = Collections.binarySearch(pbtsmMonInfList, selPoolIdx);
            if (0 <= iPoolNameInfIdx) {
                retPbTSMMonInf = pbtsmMonInfList.get(iPoolNameInfIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "m_poolSelDC is null");
        }
        return retPbTSMMonInf;
    }

    private String getPoolStatus(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolStatusDisplay(poolDtl);
        return strRtn;
    }

    private int getStatusIcon(SJmoPoolDetail poolDtl) {
        int iRtn = 0;
        iRtn = this.getComUtility().getPoolUtility().toPoolStatusIconDisplay(poolDtl);
        return iRtn;
    }

    private String getPoolName(SJmoPoolNameInfo poolNameInf) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolNameDisplay(poolNameInf);
        return strRtn;
    }

    private String getPoolAttribute(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = null != this.m_PoolUtl ? this.m_PoolUtl.toPoolAttributeDisplay(poolDtl) : "?";
        return strRtn;
    }

    private String getRaidLevel(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolRaidLevelDisplay(poolDtl);
        return strRtn;
    }

    private String getDriveType(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolDriveTypeDisplay(poolDtl);
        return strRtn;
    }

    private String getCacheMode(List<SJmoLdevDetail> ldevDtlList, SJmoPoolVolDetail poolVolDtl) {
        String strRtn = "?";
        if (null != poolVolDtl) {
            if (poolVolDtl.getAlPoolInfo().size() <= 0) {
                strRtn = "-";
            } else if (null != ldevDtlList && ldevDtlList.size() > 0) {
                strRtn = this.getComUtility().getPoolUtility().toCacheModeDisplay(ldevDtlList);
            }
        }
        return strRtn;
    }

    private String getTopPoolVolName(SJmoPoolDetail poolDtl, SJmoPoolVolDetail poolVolDtl, List<SJmoLdevNicknameInfo> ldevNameInfList) {
        String strRtn = "";
        strRtn = null != this.m_PoolUtl ? this.m_PoolUtl.toTopPoolVolNameDisplay(poolDtl, poolVolDtl, ldevNameInfList, this.getComUtility().getLdevUtility()) : "?:?:?( ?)";
        return strRtn;
    }

    private String getPoolCapa(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolSummaryTotalUsedCapacityDisplay(poolDtl, this.getComUtility(), true);
        return strRtn;
    }

    private String getSubscription(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toSubscriptionDisplay(poolDtl, this.getComUtility());
        return strRtn;
    }

    private String getVVolCapa(SJmoPoolDetail poolDtl, SJmoHDPRelationByPool hdpRelbyPoolSmry) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toVVolCapaDisplay(poolDtl, hdpRelbyPoolSmry, this.getComUtility());
        return strRtn;
    }

    private String getThreshold(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolThresholdDisplay(poolDtl);
        return strRtn;
    }

    private String getVVolNum(SJmoHDPRelationByPool hdpRelbyPool, SJmoPoolDetail poolDetail) {
        String strRtn = this.getComUtility().getPoolUtility().toMaxAllowedDisplay("?");
        if (null != poolDetail) {
            strRtn = poolDetail.getPoolKind() == 8 ? this.getComUtility().getPoolUtility().toMaxAllowedDisplay("-") : this.getComUtility().getPoolUtility().toVVolNumDisplay(hdpRelbyPool, this.getComUtility(), poolDetail);
        }
        return strRtn;
    }

    private String getPoolVolNum(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toPoolVolNumDisplay(poolDtl, this.getComUtility(), true);
        return strRtn;
    }

    private String getTierInfo(SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toTierManagementDisplay(poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getExecutionInt(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toExecutIntervalDisplay(poolDtl, this.getComUtility());
        return strRtn;
    }

    private String gerMonPeriond(SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toMonitorPeriodDisplay(poolDtl);
        return strRtn;
    }

    private String getMonitorStatus(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toMonitorStatusDisplay(pbTSMMonitorOpeInfo, poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getAvailableMonitorData(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toAvailableMonitorDataDisplay(pbTSMMonitorOpeInfo, poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getRelocationStatus(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toRelocationProgressStatusDisplay(pbTSMMonitorOpeInfo, poolDtl);
        return strRtn;
    }

    private String getRelocationProgressRate(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl) {
        String strRtn = "";
        strRtn = this.getComUtility().getPoolUtility().toRelocationProgressRateDisplay(pbTSMMonitorOpeInfo, poolDtl);
        if (!SJctrPoolUtility.HAIFUN_STR.equals(strRtn)) {
            strRtn = strRtn + RELOCATION_PROGRESS_PERCENT;
        }
        return strRtn;
    }

    private String getMonMode(SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        return this.getComUtility().getPoolUtility().toMonModeDisplay(poolDtl, poolSummaryInfo);
    }

    private String getPrimaryVolumeNum(SJmoPoolDetail poolDtl, SJmoTiPvolInfo[] tiPVolArray) {
        return this.getComUtility().getPoolUtility().toTIPVolNumToDisplay(poolDtl, tiPVolArray);
    }

    private String getPoolManagementTask(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toPoolManagementTaskDisplay(poolDtl);
    }

    private String getRelocationResult(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl) {
        String strReturn = "";
        strReturn = this.getComUtility().getPoolUtility().toRelocationResultDisplay(poolDtl, pbTSMMonitorOpeInfo);
        return strReturn;
    }

    private String getRelocationSpeed(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toRelocationSpeedDisplay(poolDtl);
    }

    private String getPoolSystemOption(SJmoPoolDetail poolDtl, long poolOprtionKey) {
        String strRtn = "?";
        this.chkPoolSystemOptLicense();
        boolean bLicense = true;
        bLicense = SJctrPoolUtility.isOpenPool(poolDtl) ? this.bLicense_DRU : false;
        strRtn = bLicense ? this.getComUtility().getPoolUtility().toPoolSystemOptionDisplay(poolDtl, poolOprtionKey) : SJctrPoolUtility.HAIFUN_STR;
        return strRtn;
    }

    private String getBasicUsableCapa(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toBasicUsableCapaDisplay(poolDtl, this.getComUtility());
    }

    private String getPoolSavingRate(SJmoPoolDetail poolDtl) {
        String str = SJctrPoolUtility.HAIFUN_STR;
        long lPoolFMCActualPages = poolDtl.getLPoolFmcActualPages();
        if (0L < lPoolFMCActualPages) {
            int savingRate = SJctrPoolUtility.getPoolSavingRate(poolDtl);
            if (savingRate == -2) {
                str = "?";
            } else {
                StringBuffer buf = new StringBuffer();
                String strSavingRate = SJctrComUtility.toDecString(savingRate);
                buf.append(strSavingRate);
                buf.append(RELOCATION_PROGRESS_PERCENT);
                str = buf.toString();
            }
        }
        return str;
    }

    private String getPoolExpantionRate(SJmoPoolDetail poolDtl) {
        String str = SJctrPoolUtility.HAIFUN_STR;
        long lPoolFMCActualPages = poolDtl.getLPoolFmcActualPages();
        if (0L < lPoolFMCActualPages) {
            long lPoolFMCLogicalPages = poolDtl.getLPoolFmcLogicalPages();
            long expantionRate = lPoolFMCLogicalPages * 100L / lPoolFMCActualPages;
            if (expantionRate == 100L && 0L < lPoolFMCLogicalPages - lPoolFMCActualPages) {
                ++expantionRate;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(expantionRate);
            buf.append(RELOCATION_PROGRESS_PERCENT);
            str = buf.toString();
        }
        return str;
    }

    private String getDeduplication(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toDeduplicationDisplay(poolDtl);
    }

    private String getSuspendTiPair(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toSuspendTiPairDisplay(poolDtl);
    }

    private String getSnapshotUsedCapacity(SJmoPoolDetail poolDtl) {
        return this.getComUtility().getPoolUtility().toSnapshotUsedCapacityDisplay(poolDtl, this.poolUseCapInfo, "KB", this.getComUtility(), true);
    }

    private void chkPoolSystemOptLicense() {
        if (this.licensecontainer == null) {
            this.licensecontainer = this.getDataController().getOwner().getAuthorizeContainer().getLisenceContainer();
            this.bLicense_DRU = this.licensecontainer.checkPP(SJctrLicenseContainer.PPID_DRU);
        }
    }

    private String getEffectSavingDisplay(SJmoPoolDetail pool) {
        String strSavingRate = "?";
        String strSavingCapa = "?";
        if (this.poolUseCapInfo != null) {
            int savingRate = SJctrPoolUtility.getSavingEffectRate(this.poolUseCapInfo, (byte)-1, pool);
            strSavingRate = SJctrComUtility.toDecString(savingRate);
            long savingcapa = SJctrPoolUtility.getSavingEffectCap(this.poolUseCapInfo, (byte)-1, pool);
            strSavingCapa = this.getComUtility().getCapacityUtility().toUnitString(savingcapa);
        }
        return String.format("%s %% (%s)", strSavingRate, strSavingCapa);
    }
}

