/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrQueueBox;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrLastUpdateTimeModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.topwindow.tasks.SJctrDispTaskInfo;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksActionMenuModel;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksAuthorize;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksPollingModel;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksSummaryModel;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksTableModel;
import sanproject.sn2.controller.topwindow.tasks.SJctrUpdateTopWindowDataModel;
import sanproject.sn2.controller.topwindow.tasks.com.SJctrTaskDef;
import sanproject.sn2.controller.topwindow.tasks.detail.SJctrTasksDetailDC;
import sanproject.sn2.controller.topwindow.tasks.status.SJctrTasksStatusDC;
import sanproject.sn2.controller.wizard.tasks.operation.SJctrCanAutoDeleteProtectTaskDC;
import sanproject.sn2.controller.wizard.tasks.operation.SJctrDeleteTaskDC;
import sanproject.sn2.controller.wizard.tasks.operation.SJctrResumeTaskDC;
import sanproject.sn2.controller.wizard.tasks.operation.SJctrSetAutoDeleteProtectTaskDC;
import sanproject.sn2.controller.wizard.tasks.operation.SJctrSuspendTaskDC;

public class SJctrTasksDC
extends SJctrDataController {
    public static final String KEY_POLLING_ENABLE = "COM_POLLING_ENABLE";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    private static final int LIST_ELEMNT_ONE = 1;
    public static final String KEY_NEXT_DISP = "COM_CHILD";
    ArrayList<SJctrDispTaskInfo> mDspTaskList;
    private SJctrButtonDataModel sPollingEnableButton;
    SJctrTasksTableModel tableModel;

    public SJctrTasksDC() throws SJcException {
        this(768);
        this.initDataObjectModel();
        this.initListener();
        this.initButton();
    }

    protected SJctrTasksDC(int dispID) throws SJcException {
        super(dispID);
    }

    private void initDataObjectModel() {
        this.getLogUty().putlog("SJctrTasksDC", "initDataObjectModel Start");
        String sPolling_int = "0";
        this.addDataObjectModel("COM_POLLING_INTERVAL", new SJctrTasksPollingModel());
        this.addDataObjectModel(KEY_SUMMARY, new SJctrTasksSummaryModel());
        this.tableModel = new SJctrTasksTableModel();
        this.addDataObjectModel(KEY_TABLE, this.tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrTasksActionMenuModel());
        this.addDataObjectModel(KEY_NEXT_DISP, new SJctrUpdateTopWindowDataModel());
        this.getLogUty().putlog("SJctrTasksDC", "initDataObjectModel End");
    }

    public void resetTaskList() {
        this.mDspTaskList = null;
    }

    public List<SJctrDispTaskInfo> getTaskList() {
        if (this.mDspTaskList == null) {
            this.getLogUty().putlog("SJctrTasksDC", "getTaskList Start");
            SJctrQueueBox mQueBox = this.getOwner().getQueueBox();
            List<SJctrTask> mtaskList = mQueBox.getTaskList();
            this.mDspTaskList = new ArrayList(mtaskList.size());
            for (SJctrTask task : mtaskList) {
                SJctrDispTaskInfo dispTask = new SJctrDispTaskInfo(task, this.getComUtility());
                this.mDspTaskList.add(dispTask);
            }
            this.getLogUty().putlog("SJctrTasksDC", "getTaskList End");
        }
        return this.mDspTaskList;
    }

    public void initButton() {
        this.sPollingEnableButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_POLLING_ENABLE, this.sPollingEnableButton);
        this.sPollingEnableButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrTasksDC.this.resetTaskList();
                SJctrTasksDC.this.getTaskList();
                SJctrTasksDC.this.tableModel.setStatus(true);
                SJctrTasksDC.this.sPollingEnableButton.clearDirty();
                SJctrTasksDC.this.setLastUpdateTime(null);
            }
        });
    }

    private void initListener() {
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.MAKE_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                if (obj instanceof List) {
                    Class class1;
                    List list = (List)obj;
                    SJctrTask pTask = (SJctrTask)list.get(1);
                    if (!SJctrTasksDC.this.isAvailableTask(pTask)) {
                        SJctrTasksDC.this.getLogUty().putlog("SJctrTasksDC", "Display authority none:" + pTask.getUserId());
                        throw new SJcException("202", "22", "105306");
                    }
                    Class dcClass = class1 = (Class)list.get(0);
                    SJctrUserController uc = SJctrTasksDC.this.getOwner();
                    SJctrRelatedDispDataObject relatedDisp = uc.createRelatedDispData(dcClass);
                    SJctrTasksDetailDC dialog = (SJctrTasksDetailDC)uc.getDataController(relatedDisp);
                    try {
                        dialog.initDataObjectModel(pTask);
                    }
                    catch (SJcException e) {
                        uc.removeRelatedDispData(dialog.getuId());
                        throw e;
                    }
                    SJctrTasksDC.this.addUpdateDisp(relatedDisp);
                }
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.MAKE_STATUS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                if (obj instanceof List) {
                    SJctrRelatedDispDataObject relatedDisp;
                    Class class1;
                    List list = (List)obj;
                    SJctrTask pTask = (SJctrTask)list.get(1);
                    if (!SJctrTasksDC.this.isAvailableTask(pTask)) {
                        SJctrTasksDC.this.getLogUty().putlog("SJctrTasksDC", "Display authority none:" + pTask.getUserId());
                        throw new SJcException("202", "22", "105307");
                    }
                    Class dcClass = class1 = (Class)list.get(0);
                    SJctrUserController uc = SJctrTasksDC.this.getOwner();
                    SJctrTasksStatusDC dialog = (SJctrTasksStatusDC)uc.getDataController(relatedDisp = uc.createRelatedDispData(dcClass));
                    boolean bRtn = dialog.checkTaskStatus(pTask);
                    if (!bRtn) {
                        SJctrTasksDC.this.getLogUty().putlog("SJctrTasksStatus", "Status Error");
                        throw new SJcException("202", "22", "106040");
                    }
                    dialog.setParameter(pTask);
                    try {
                        dialog.initDataObjectModel(pTask);
                    }
                    catch (SJcException e) {
                        uc.removeRelatedDispData(dialog.getuId());
                        SJctrTasksDC.this.getLogUty().putlog("SJctrTasksDC", "Parameter Get Error!");
                        throw e;
                    }
                    SJctrTasksDC.this.addUpdateDisp(relatedDisp);
                }
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.BTN_RESUME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTasksDC.this.makeResumeTask(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.BTN_SUSPEND, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTasksDC.this.makeSuspendTask(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.BTN_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTasksDC.this.makeDeleteTask(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.BTN_SETPROT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTasksDC.this.makeSetProtectTask(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrTaskDef.TASK_CONTROL_MSG.BTN_CANPROT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTasksDC.this.makeCanProtectTask(event, dstModel);
            }
        });
    }

    private List<SJctrDispTaskInfo> getSelectTask(List<Object> selectedRowList) {
        this.getLogUty().putlog("SJctrTasksDC", "getSelectTask Start");
        ArrayList<SJctrDispTaskInfo> selTaskList = new ArrayList<SJctrDispTaskInfo>(selectedRowList.size());
        for (int ii = 0; ii < selectedRowList.size(); ++ii) {
            SJctrDispTaskInfo selTask = (SJctrDispTaskInfo)selectedRowList.get(ii);
            selTaskList.add(selTask);
        }
        this.getLogUty().putlog("SJctrTasksDC", "getSelectTask End");
        return selTaskList;
    }

    private void makeResumeTask(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject relatedDisp;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeResumeTask", "not selected");
            throw new SJcException("202", "22", "105004");
        }
        List<SJctrDispTaskInfo> selTaskList = this.getSelectTask(selectedRowList);
        SJctrUserController uc = this.getOwner();
        SJctrResumeTaskDC dialog = (SJctrResumeTaskDC)uc.getDataController(relatedDisp = uc.createRelatedDispData(SJctrResumeTaskDC.class));
        List<SJctrDispTaskInfo> errTaskList = dialog.checkTaskStatus(selTaskList, 2);
        if (errTaskList.size() != 0) {
            uc.removeRelatedDispData(dialog.getuId());
            this.getLogUty().putlog("makeResumeTask", "Un Match Status");
            SJcException exp = this.setErrorListParameterSet(uc, errTaskList, Integer.valueOf("105005"));
            throw exp;
        }
        dialog.setSelTaskList(selTaskList);
        this.addUpdateDisp(relatedDisp);
    }

    private void makeSuspendTask(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject relatedDisp;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeSuspendTask", "not selected");
            throw new SJcException("202", "22", "105004");
        }
        List<SJctrDispTaskInfo> selTaskList = this.getSelectTask(selectedRowList);
        SJctrUserController uc = this.getOwner();
        SJctrSuspendTaskDC dialog = (SJctrSuspendTaskDC)uc.getDataController(relatedDisp = uc.createRelatedDispData(SJctrSuspendTaskDC.class));
        List<SJctrDispTaskInfo> errTaskList = dialog.checkTaskStatus(selTaskList, 1);
        if (errTaskList.size() != 0) {
            uc.removeRelatedDispData(dialog.getuId());
            this.getLogUty().putlog("makeSuspendTask", "Un Match Status");
            SJcException exp = this.setErrorListParameterSet(uc, errTaskList, Integer.valueOf("105006"));
            throw exp;
        }
        dialog.setSelTaskList(selTaskList);
        this.addUpdateDisp(relatedDisp);
    }

    private void makeDeleteTask(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject relatedDisp;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDeleteTask", "not selected");
            throw new SJcException("202", "22", "105004");
        }
        List<SJctrDispTaskInfo> selTaskList = this.getSelectTask(selectedRowList);
        SJctrUserController uc = this.getOwner();
        SJctrDeleteTaskDC dialog = (SJctrDeleteTaskDC)uc.getDataController(relatedDisp = uc.createRelatedDispData(SJctrDeleteTaskDC.class));
        List<SJctrDispTaskInfo> errTaskList = dialog.checkTaskStatus(selTaskList);
        if (errTaskList.size() != 0) {
            uc.removeRelatedDispData(dialog.getuId());
            this.getLogUty().putlog("makeDeleteTask", "Un Match Status");
            SJcException exp = this.setErrorListParameterSet(uc, errTaskList, Integer.valueOf("105007"));
            throw exp;
        }
        dialog.setSelTaskList(selTaskList);
        this.addUpdateDisp(relatedDisp);
    }

    private void makeSetProtectTask(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeSetProtectTask", "not selected");
            throw new SJcException("202", "22", "105004");
        }
        List<SJctrDispTaskInfo> selTaskList = this.getSelectTask(selectedRowList);
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = uc.createRelatedDispData(SJctrSetAutoDeleteProtectTaskDC.class);
        SJctrSetAutoDeleteProtectTaskDC dialog = (SJctrSetAutoDeleteProtectTaskDC)uc.getDataController(relatedDisp);
        dialog.setSelTaskList(selTaskList);
        this.addUpdateDisp(relatedDisp);
    }

    private void makeCanProtectTask(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeCanProtectTask", "not selected");
            throw new SJcException("202", "22", "105004");
        }
        List<SJctrDispTaskInfo> selTaskList = this.getSelectTask(selectedRowList);
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = uc.createRelatedDispData(SJctrCanAutoDeleteProtectTaskDC.class);
        SJctrCanAutoDeleteProtectTaskDC dialog = (SJctrCanAutoDeleteProtectTaskDC)uc.getDataController(relatedDisp);
        dialog.setSelTaskList(selTaskList);
        this.addUpdateDisp(relatedDisp);
    }

    private SJcException setErrorListParameterSet(SJctrUserController uc, List<SJctrDispTaskInfo> errTaskList, int error_code) {
        SJctrTableDataModel etable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errlist = new ArrayList<SJctrErrorColumnData>();
        SJctrError err_Top = new SJctrError(Integer.valueOf("202"), Integer.valueOf("22"), error_code);
        for (SJctrDispTaskInfo task_err : errTaskList) {
            SJctrError err_detail = new SJctrError(Integer.valueOf("202"), Integer.valueOf("22"), error_code);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(task_err, err_detail);
            errlist.add(errData);
        }
        SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)uc.getDataController(rel);
        errDc.setParameter(etable, errlist);
        SJcException exp = err_Top.createException();
        exp.setErrDisp(rel);
        return exp;
    }

    private boolean isAvailableTask(SJctrTask pTask) {
        String taskUserId;
        SJctrTasksAuthorize tasksAuthorize = new SJctrTasksAuthorize();
        SJctrAuthorizeContainer container_new = this.getOwner().getAuthorizeContainer();
        tasksAuthorize.setContainer(container_new);
        if (tasksAuthorize.chkRole()) {
            return true;
        }
        String userId = this.getOwner().getUserSession().getUserID();
        return userId.equals(taskUserId = pTask.getUserId());
    }

    @Override
    public void setLastUpdateTime(Map<SJctrGetDirectWrapper, List<?>> map) {
        SJctrTopWindowDC topWindow = this.getTopWindow();
        SJctrLastUpdateTimeModel lastUpdateTimeModel = (SJctrLastUpdateTimeModel)topWindow.getDataObjectModel("COM_LASTUPDATE");
        lastUpdateTimeModel.setLastUpdateTime();
    }
}

