/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrAuthorize;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrActionMenuModel;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrFooterDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_NEXT_TASK = "COM_NEXT_TASK";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    private static final String GUID_CONTINUE_TO = "CONTINUE_TO";
    public static final Set<Button> BGO_WIZARD = Collections.unmodifiableSet(EnumSet.of(Button.BACK, Button.NEXT, Button.FINISH, Button.CANCEL));
    public static final Set<Button> BGO_CONFIRM = Collections.unmodifiableSet(EnumSet.of(Button.BACK, Button.NEXT, Button.APPLY, Button.CANCEL));
    public static final Set<Button> BGO_OKCANCEL = Collections.unmodifiableSet(EnumSet.of(Button.OK, Button.DLG_CANCEL));
    public static final Set<Button> BGO_CLOSE = Collections.unmodifiableSet(EnumSet.of(Button.CLOSE));
    public static final Set<Button> BGO_OK = Collections.unmodifiableSet(EnumSet.of(Button.OK));
    public static final Set<Button> BGO_YESNO = Collections.unmodifiableSet(EnumSet.of(Button.YES, Button.NO));
    public static final Set<Button> BGO_YESNOCANCEL = Collections.unmodifiableSet(EnumSet.of(Button.YES, Button.NO, Button.CANCEL));
    private final Set<Button> buttonGroupOption;
    private boolean enableNextButton;
    private final Set<Button> permanentRollBackCheck;
    private final Set<Button> temporaryRollBackCheck;

    public SJctrFooterDataModel() {
        this(BGO_WIZARD);
    }

    public SJctrFooterDataModel(Set<Button> buttonGroupOption) {
        this.buttonGroupOption = buttonGroupOption;
        this.enableNextButton = true;
        this.permanentRollBackCheck = EnumSet.of(Button.OK);
        this.temporaryRollBackCheck = EnumSet.noneOf(Button.class);
        this.initListener();
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrFooterDataModel.this.doCloseAction(setObject);
            }
        });
    }

    private void doCloseAction(Object setObject) {
        SJctrSelectableDataObject buttonData;
        String closeKey;
        SJctrDataObject setGroupData;
        SJctrDataObject setFooterData;
        Object groupData;
        SJctrButtonDataModel closeButton = this.getFooterButtonObject(Button.CLOSE);
        if (closeButton == null && setObject instanceof SJctrDataObject && (groupData = (setFooterData = (SJctrDataObject)setObject).getData(KEY_BUTTON_GROUP)) instanceof SJctrDataObject && (setGroupData = (SJctrDataObject)groupData).containsKey(closeKey = Button.CLOSE.getKey()) && SJctrButtonDataModel.isSelect(buttonData = (SJctrSelectableDataObject)setGroupData.getData(closeKey))) {
            this.logUty.putlog("Select Footer Button", "Default CLOSE");
            this.fireMessageEvent(Button.CLOSE.getMessage());
        }
    }

    public SJctrActionDefine getNextTask() {
        String select;
        SJctrActionDefine retAction = null;
        NextTaskOption nextTask = (NextTaskOption)this.getDataModel(KEY_NEXT_TASK);
        if (nextTask != null && (select = nextTask.getSelection()) != null) {
            retAction = SJctrActionDefine.valueOf(select);
        }
        return retAction;
    }

    public void initNextTask(SJctrActionDefine[] actions) {
        if (actions.length > 0) {
            String select;
            NextTaskOption nextTaskOption = new NextTaskOption(actions.length);
            SJctrComUtility util = this.getComUtility();
            boolean selectFlg = true;
            for (SJctrActionDefine action : actions) {
                String name = action.getActionKey();
                String pattern = util.getGuidance(GUID_CONTINUE_TO);
                String label = MessageFormat.format(pattern, action.getGuidance(util));
                String actionKey = action.getActionKey();
                HashMap<String, Object> item = nextTaskOption.createItem(name, label, actionKey);
                int toolTip = 0;
                SJctrUserController uc = this.getDataController().getOwner();
                if (uc != null) {
                    SJctrActionDefine actDefine = SJctrActionDefine.valueOf(actionKey);
                    SJctrAuthorize authorize = actDefine.getAuthorize(uc);
                    if (!authorize.chkResource()) {
                        this.getLogUty().putlog("initNextTask", "chkResource NG: " + actionKey);
                        continue;
                    }
                    if (!authorize.chkRole()) {
                        toolTip |= 2;
                    }
                    if (!authorize.chkPP()) {
                        toolTip |= 4;
                    }
                } else {
                    toolTip = 2;
                    this.getLogUty().putlog("initNextTask", "uc is null.", 40000);
                }
                SJctrActionMenuModel.Item.setToolTip(item, toolTip);
                boolean enableFlg = false;
                enableFlg = toolTip == 0;
                SJctrComboBoxDataModel.Item.setEnable(item, enableFlg);
                nextTaskOption.addItem(item);
                if (!selectFlg || !enableFlg) continue;
                nextTaskOption.setEnableListener(false);
                nextTaskOption.setSelection(name);
                selectFlg = false;
                nextTaskOption.setEnableListener(true);
            }
            if (!nextTaskOption.getItemMap().isEmpty()) {
                this.addDataModel(KEY_NEXT_TASK, nextTaskOption);
            }
            if ((select = nextTaskOption.getSelection()) == null) {
                this.enableNextButton = false;
            }
        }
    }

    public void setEnableButton(Button button, boolean flg) {
        String key;
        SJctrButtonDataModel buttonModel;
        SJctrDataObjectModel<SJctrDataObject> buttonGroup = this.getDataModel(KEY_BUTTON_GROUP);
        if (buttonGroup != null && (buttonModel = (SJctrButtonDataModel)buttonGroup.getDataModel(key = button.getKey())) != null) {
            if (button == Button.NEXT) {
                flg &= this.enableNextButton;
            }
            buttonModel.setEnable(flg);
            this.setDirtyAll();
        }
    }

    public void setRollBackCheck(Button button, boolean flg) {
        this.setRollBackCheck(button, flg, this.permanentRollBackCheck);
    }

    @Override
    protected void makeDataObject() {
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        this.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
        for (Button button : Button.values()) {
            this.makeButton(button, buttonGroup);
        }
    }

    void setTemporaryRollBackCheck(Button button, boolean flg) {
        this.setRollBackCheck(button, flg, this.temporaryRollBackCheck);
    }

    private void makeButton(final Button button, SJctrSimpleDataModel buttonGroup) {
        if (this.buttonGroupOption.contains((Object)button)) {
            SJctrButtonDataModel buttonModel = new SJctrButtonDataModel(){

                @Override
                public Object getDataObject(SJctrDataObject inputObject) {
                    boolean flg = false;
                    flg |= SJctrFooterDataModel.this.permanentRollBackCheck.contains((Object)button);
                    this.setRollBackCheck(flg |= SJctrFooterDataModel.this.temporaryRollBackCheck.contains((Object)button));
                    return super.getDataObject(inputObject);
                }
            };
            buttonModel.addItemSelectListener(new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrFooterDataModel.this.logUty.putlog("Select Footer Button", button.toString());
                    SJctrFooterDataModel.this.fireMessageEvent(button.getMessage());
                }
            });
            buttonGroup.addDataModel(button.getKey(), buttonModel);
        }
    }

    private void setRollBackCheck(Button button, boolean flg, Set<Button> rollBackSet) {
        if (this.buttonGroupOption.contains((Object)button)) {
            if (flg) {
                rollBackSet.add(button);
            } else {
                rollBackSet.remove((Object)button);
            }
            this.setDirtyAll();
        }
    }

    public SJctrButtonDataModel getFooterButtonObject(Button button) {
        SJctrButtonDataModel buttonModel = null;
        SJctrDataObjectModel<SJctrDataObject> buttonGroup = this.getDataModel(KEY_BUTTON_GROUP);
        if (buttonGroup != null) {
            String key = button.getKey();
            buttonModel = (SJctrButtonDataModel)buttonGroup.getDataModel(key);
        }
        return buttonModel;
    }

    private static class NextTaskOption
    extends SJctrComboBoxDataModel {
        public NextTaskOption(int size) {
            super(size);
        }

        public HashMap<String, Object> createItem(String name, String label, String actionKey) {
            HashMap<String, Object> item = super.createItem(name, label);
            item.put("enabled", true);
            item.put("COM_TYPE", 0);
            item.put("COM_ACTKEY", actionKey);
            return item;
        }
    }

    public static enum Button {
        BACK("COM_BACK", SJctrWizardDataController.WIZ_MSG.BACK),
        NEXT("COM_NEXT", SJctrWizardDataController.WIZ_MSG.NEXT),
        FINISH("COM_FINISH", SJctrWizardDataController.WIZ_MSG.FINISH),
        APPLY("COM_APPLY", SJctrWizardDataController.WIZ_MSG.APPLY),
        CANCEL("COM_CANCEL", SJctrWizardDataController.WIZ_MSG.CANCEL),
        OK("COM_OK", SJctrWizardDataController.WIZ_MSG.OK),
        DLG_CANCEL("COM_CANCEL", SJctrWizardDataController.WIZ_MSG.DLG_CANCEL),
        CLOSE("COM_CLOSE", SJctrWizardDataController.WIZ_MSG.CLOSE),
        YES("COM_YES", SJctrWizardDataController.WIZ_MSG.YES),
        NO("COM_NO", SJctrWizardDataController.WIZ_MSG.NO);

        private final String key;
        private final SJctrNotifyState message;

        private Button(String key, SJctrNotifyState message) {
            this.key = key;
            this.message = message;
        }

        public String getKey() {
            return this.key;
        }

        public SJctrNotifyState getMessage() {
            return this.message;
        }
    }
}

