/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.addresourcegroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundGroupException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsAvailableTableModel;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsData;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsExData;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsSelectedTableModel;
import sanproject.sn2.controller.wizard.account.addroles.SJctrAddRolesData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrTaskInfoDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpsSelectData;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgUserInfo;
import sanproject.sn2.controller.wizard.account.rsg.rsgproperties.SJctrRsgPropertiesDialogDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.rsg.SJmoRSGIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrAddResourceGrpsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101141;
    private static final String COM_GUIDANCEKEY = "ACCOUNT/DISP_DI_114S-1";
    private static final String COM_TABLE_AVA = "COM_TABLE_AVAILABLE";
    private static final String COM_TABLE_SEL = "COM_TABLE_SELECTED";
    private static final String COM_ADD = "COM_ADD";
    private static final String COM_REMOVE = "COM_REMOVE";
    public static final String TITLE = "RES_GRP_ASSIGN";
    private boolean taskcombination = false;
    private List<Integer> initialSelRSGList = null;
    private boolean allRsg = false;
    private boolean existUser = true;

    public SJctrAddResourceGrpsDC() throws SJcException {
        super(0x1101141);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        String guidance = COM_GUIDANCEKEY;
        this.initGuidance(util, guidance);
    }

    public void initGuidance(SJctrComUtility util, String guidance) {
        super.initGuidance(util);
        SJctrDataObject manageData = this.getManageData();
        Object obj = new SJctrTaskInfoDataModel().getManageData();
        ((SJctrDataObject)obj).setData("COM_GUIDANCE", guidance);
        manageData.setData("COM_TASK_INFO", obj);
    }

    protected void initDataModel() {
        this.addDataObjectModel(COM_TABLE_AVA, new SJctrAddResourceGrpsAvailableTableModel());
        this.addDataObjectModel(COM_TABLE_SEL, new SJctrAddResourceGrpsSelectedTableModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddResourceGrpsDC.this.addAction();
                        if (SJctrAddResourceGrpsDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(0x1101141);
                            SJctrAddResourceGrpsDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        add.setRollBackCheck(true);
        this.addDataObjectModel(COM_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddResourceGrpsDC.this.removeAction();
                        if (SJctrAddResourceGrpsDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(0x1101141);
                            SJctrAddResourceGrpsDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        remove.setRollBackCheck(true);
        this.addDataObjectModel(COM_REMOVE, remove);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> selectedList = selectedTable.getAllRowData();
        boolean flg = true;
        if (selectedList.size() > SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_RESOURCE")) {
            flg = false;
        }
        if (this.taskcombination && selectedList.size() == 0) {
            flg = false;
        }
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.taskcombination) {
            if (flg || this.allRsg) {
                if (this.existUser) {
                    footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
                }
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
            } else {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            }
        } else {
            if (selectedList.size() == this.initialSelRSGList.size()) {
                boolean flgtmp = true;
                for (SJctrRsgUserInfo sJctrRsgUserInfo : selectedList) {
                    boolean flgtmptmp = true;
                    for (int initialSelRSG : this.initialSelRSGList) {
                        if (sJctrRsgUserInfo.getRsgInfo().getRsgInfo().getRsgId() != initialSelRSG) continue;
                        flgtmptmp = false;
                    }
                    if (!flgtmptmp) continue;
                    flgtmp = false;
                }
                if (flgtmp) {
                    flg = false;
                }
            }
            if (flg) {
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
            } else {
                footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            }
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        }
    }

    private void addAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> list = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(list);
        selectedTable.setRowSelectionList(list);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> list = selectedTable.removeSelectedRowData();
        availableTable.addRowDataTop(list);
        List<Object> selectedList = availableTable.getFilterData(list);
        availableTable.setRowSelectionList(selectedList);
        availableTable.setCurrentPage(Integer.toString(1));
        this.updateFooter();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache("KEY_CREATEUG_TASKCOMBINATION");
        if (dat != null) {
            this.taskcombination = true;
        }
        if (this.taskcombination) {
            dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDROLES_DATA);
            if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_ADDROLES_DATA)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (Add Role Data) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrAddRolesData addRolesData = (SJctrAddRolesData)dat.get(0);
            if (addRolesData == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (Role Info Detail List) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            this.allRsg = addRolesData.getAllResourceGrp();
            String[] allUserIDs = null;
            try {
                allUserIDs = SJctrUserInfoUtility.getAllUser(this);
            }
            catch (SJcNotFoundUserException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                SJctrError err = new SJctrError(2, 22, 106050);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[CommunicationError]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                SJctrError error = new SJctrError(201, 22, 208003);
                SJcException exception = error.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            ArrayList<String> userIDList = new ArrayList<String>();
            for (String allUserID : allUserIDs) {
                if (SJctrUserInfoUtility.isTypeBuildin(allUserID, this)) continue;
                userIDList.add(allUserID);
            }
            if (userIDList.isEmpty()) {
                this.existUser = false;
            }
        } else {
            dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_SELECT_DATA);
            if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_SELECT_DATA)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (AddResourceGrpsSelectData) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrUserGrpsSelectData userGrpsSelectData = (SJctrUserGrpsSelectData)dat.get(0);
            List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = userGrpsSelectData.getUserGrpInfoDetailList();
            if (userGrpInfoDetailList == null || userGrpInfoDetailList.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (UserGrp Info Detail List) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL);
        List<Object> selectedList = selectedTable.getAllRowData();
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA);
        List<Object> availableList = availableTable.getAllRowData();
        if (this.taskcombination && selectedList.isEmpty() && !this.allRsg) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]Selected Resource Groups is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105225);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrRsgUserInfo> selectResourceGrpList = new ArrayList<SJctrRsgUserInfo>();
        for (Object selectRow : selectedList) {
            if (selectRow == null || !(selectRow instanceof SJctrRsgUserInfo)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]illegal Row Data.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrRsgUserInfo rsgUserInfo = (SJctrRsgUserInfo)selectRow;
            if (rsgUserInfo == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]RSG Info is Empty.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            selectResourceGrpList.add(rsgUserInfo);
        }
        ArrayList<SJctrRsgUserInfo> assignedRsgUserInfoList = null;
        ArrayList<SJctrRsgUserInfo> unassignedRsgUserInfoList = null;
        if (!this.taskcombination) {
            assignedRsgUserInfoList = new ArrayList<SJctrRsgUserInfo>();
            for (SJctrRsgUserInfo rsgUserInfo : selectResourceGrpList) {
                int chk = rsgUserInfo.getRsgInfo().getRsgInfo().getRsgId();
                if (this.initialSelRSGList.contains(chk)) continue;
                assignedRsgUserInfoList.add(rsgUserInfo);
            }
            unassignedRsgUserInfoList = new ArrayList<SJctrRsgUserInfo>();
            for (Object availRow : availableList) {
                if (availRow == null || !(availRow instanceof SJctrRsgUserInfo)) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]illegal Row Data.", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                SJctrRsgUserInfo rsgUserInfo = (SJctrRsgUserInfo)availRow;
                if (rsgUserInfo == null) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]RSG Info is Empty.", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                int chk = rsgUserInfo.getRsgInfo().getRsgInfo().getRsgId();
                if (!this.initialSelRSGList.contains(chk)) continue;
                unassignedRsgUserInfoList.add(rsgUserInfo);
            }
        }
        SJctrAddResourceGrpsData addResourceGrpsData = new SJctrAddResourceGrpsData();
        SJctrAddResourceGrpsExData addResourceGrpsExData = new SJctrAddResourceGrpsExData();
        if (this.taskcombination) {
            addResourceGrpsData.setRsgUserInfoList(selectResourceGrpList);
        } else {
            addResourceGrpsExData.setRsgUserInfoList(selectResourceGrpList);
            addResourceGrpsExData.setAssignedRsgUserInfoList(assignedRsgUserInfoList);
            addResourceGrpsExData.setUnassignedRsgUserInfoList(unassignedRsgUserInfoList);
        }
        if (this.taskcombination) {
            if (this.checkBeforeContactData(addResourceGrpsData)) {
                ArrayList<SJctrAddResourceGrpsData> list = new ArrayList<SJctrAddResourceGrpsData>();
                list.add(addResourceGrpsData);
                this.putCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA, list);
                ArrayList<Integer> list_disp = new ArrayList<Integer>();
                list_disp.add(0x1101141);
                this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
            }
        } else if (this.checkBeforeContactData(addResourceGrpsExData)) {
            ArrayList<SJctrAddResourceGrpsExData> list = new ArrayList<SJctrAddResourceGrpsExData>();
            list.add(addResourceGrpsExData);
            this.putCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA, list);
            ArrayList<Integer> list_disp = new ArrayList<Integer>();
            list_disp.add(0x1101141);
            this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkContactData(List<?> dat, Class<?> cls) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + cls.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!obj.getClass().equals(cls)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrAddResourceGrpsData addResourceGrpsData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrAddResourceGrpsData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrAddResourceGrpsData old_data = (SJctrAddResourceGrpsData)confirm_dat_obj;
            if (addResourceGrpsData.compareTo(old_data) == 0) {
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        String strLogSubTitle = "checkContactData";
        ArrayList rsglistfortable = new ArrayList();
        ArrayList<SJctrRsgUserInfo> availableList = new ArrayList<SJctrRsgUserInfo>();
        ArrayList<SJctrRsgUserInfo> selectedList = new ArrayList<SJctrRsgUserInfo>();
        ArrayList allRsgs = null;
        try {
            allRsgs = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getRsgListInfo() is failed (" + e.getClass().getSimpleName() + ")", null, 30000);
        }
        Map<String, SJctrUserGrpInfoDetail> userGrpInfoDetailMap = SJctrRsgUtility.getUserGroupsInfo(this.logUty);
        int allRsgCount = 0;
        HashMap<Integer, Integer> numOfUgCounts = new HashMap<Integer, Integer>();
        if (userGrpInfoDetailMap != null) {
            Collection<SJctrUserGrpInfoDetail> userGroupColect = userGrpInfoDetailMap.values();
            for (SJctrUserGrpInfoDetail userGroupInfo : userGroupColect) {
                int[] rsgIds;
                if (userGroupInfo.getAllRsrcGroup()) {
                    ++allRsgCount;
                    continue;
                }
                for (int rsgId : rsgIds = userGroupInfo.getRsrcGroupID()) {
                    Integer numOfUser = (Integer)numOfUgCounts.get(rsgId);
                    if (null == numOfUser) {
                        numOfUser = 1;
                    } else {
                        Integer n = numOfUser;
                        Integer n2 = numOfUser = Integer.valueOf(numOfUser + 1);
                    }
                    numOfUgCounts.put(rsgId, numOfUser);
                }
            }
        }
        if (this.taskcombination) {
            ArrayList rsgInfoList = allRsgs;
            for (SJmoRSGgetRsg rsgInfo : rsgInfoList) {
                SJctrRsgUserInfo tableData = new SJctrRsgUserInfo(rsgInfo);
                int numOfUser = allRsgCount;
                Integer numOfUserGroups = (Integer)numOfUgCounts.get(rsgInfo.getRsgInfo().getRsgId());
                if (null != numOfUserGroups) {
                    numOfUser += numOfUserGroups.intValue();
                }
                tableData.setNumOfUserGroups(numOfUser);
                availableList.add(tableData);
            }
            if (availableList.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Available Resource Groups is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 106050);
                SJcException exception = err.createException();
                throw exception;
            }
        } else {
            boolean[] rsgBitmap;
            List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_SELECT_DATA);
            SJctrUserGrpsSelectData userGrpsSelectData = (SJctrUserGrpsSelectData)dat.get(0);
            List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = userGrpsSelectData.getUserGrpInfoDetailList();
            int iListSize = userGrpInfoDetailList.size();
            String[] userGrpNames = new String[iListSize];
            for (int i = 0; i < iListSize; ++i) {
                userGrpNames[i] = userGrpInfoDetailList.get(i).getGroupName();
            }
            SJcUserGroupInfoContainer[] userGroupInfoList = null;
            try {
                userGroupInfoList = SJctrUserInfoUtility.getUserGroupInfo(userGrpNames, this);
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGroupInfo() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            }
            catch (SJcNotFoundGroupException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserGroupInfo() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
            }
            if (userGroupInfoList != null && (rsgBitmap = userGroupInfoList[0].getRsrcGroupMap()) != null && rsgBitmap.length > 0) {
                ArrayList rsgInfoList = allRsgs;
                boolean[] existRsgBitmap = new boolean[rsgBitmap.length];
                for (int i = 0; i < rsgBitmap.length; ++i) {
                    existRsgBitmap[i] = false;
                }
                for (SJmoRSGgetRsg rsgInfo : rsgInfoList) {
                    existRsgBitmap[rsgInfo.getRsgInfo().getRsgId()] = true;
                }
                int cnt = 0;
                boolean allRsg = userGroupInfoList[0].getAllRsrcGroup();
                for (int i = 0; i < rsgBitmap.length; ++i) {
                    Integer numOfUserGroups;
                    SJctrRsgUserInfo tableData;
                    SJmoModelData_Base rsgInfo;
                    if (existRsgBitmap[i] && (rsgBitmap[i] || allRsg)) {
                        rsgInfo = (SJmoRSGgetRsg)rsgInfoList.get(cnt);
                        tableData = new SJctrRsgUserInfo((SJmoRSGgetRsg)rsgInfo);
                        int numOfUser = allRsgCount;
                        numOfUserGroups = (Integer)numOfUgCounts.get(((SJmoRSGgetRsg)rsgInfo).getRsgInfo().getRsgId());
                        if (null != numOfUserGroups) {
                            numOfUser += numOfUserGroups.intValue();
                        }
                        tableData.setNumOfUserGroups(numOfUser);
                        selectedList.add(tableData);
                        ++cnt;
                        continue;
                    }
                    if (rsgBitmap[i]) {
                        rsgInfo = new SJmoRSGInfo();
                        ((SJmoRSGIndex)rsgInfo).setRsgId(i);
                        SJmoRSGgetRsg getRsg = new SJmoRSGgetRsg();
                        getRsg.setRsgInfo((SJmoRSGInfo)rsgInfo);
                        SJctrRsgUserInfo tableData2 = new SJctrRsgUserInfo(getRsg);
                        int numOfUser = 0;
                        Integer numOfUserGroups2 = (Integer)numOfUgCounts.get(getRsg.getRsgInfo().getRsgId());
                        if (null != numOfUserGroups2) {
                            numOfUser += numOfUserGroups2.intValue();
                        }
                        tableData2.setNumOfUserGroups(numOfUser);
                        selectedList.add(tableData2);
                        continue;
                    }
                    if (!existRsgBitmap[i]) continue;
                    rsgInfo = (SJmoRSGgetRsg)rsgInfoList.get(cnt);
                    tableData = new SJctrRsgUserInfo((SJmoRSGgetRsg)rsgInfo);
                    int numOfUser = allRsgCount;
                    numOfUserGroups = (Integer)numOfUgCounts.get(((SJmoRSGgetRsg)rsgInfo).getRsgInfo().getRsgId());
                    if (null != numOfUserGroups) {
                        numOfUser += numOfUserGroups.intValue();
                    }
                    tableData.setNumOfUserGroups(numOfUser);
                    availableList.add(tableData);
                    ++cnt;
                }
            }
        }
        this.initialSelRSGList = new ArrayList<Integer>();
        if (selectedList != null) {
            for (SJctrRsgUserInfo rsgUserInfo : selectedList) {
                this.initialSelRSGList.add(rsgUserInfo.getRsgInfo().getRsgInfo().getRsgId());
            }
        }
        rsglistfortable.add(availableList);
        rsglistfortable.add(selectedList);
        this.putCache(SJctrAccountDataMacro.CLASS_RESOURCEGRP_INFO, rsglistfortable);
        return true;
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_MSG.DETAIL_AVAILABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddResourceGrpsDC.this.getDataObjectModel(SJctrAddResourceGrpsDC.COM_TABLE_AVA);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddResourceGrpsDC.this.makeRsgProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_MSG.DETAIL_SELECTED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddResourceGrpsDC.this.getDataObjectModel(SJctrAddResourceGrpsDC.COM_TABLE_SEL);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddResourceGrpsDC.this.makeRsgProperty(selectedRows);
            }
        });
    }

    private void makeRsgProperty(List<Object> selectRows) {
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), selectRows);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgPropertiesDialogDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    public static enum SELECT_MSG implements SJctrNotifyState
    {
        DETAIL_AVAILABLE,
        DETAIL_SELECTED;

    }
}

