/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.addusers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.addusers.SJctrAddUsersAvailableUsersTableModel;
import sanproject.sn2.controller.wizard.account.addusers.SJctrAddUsersData;
import sanproject.sn2.controller.wizard.account.addusers.SJctrAddUsersSelectData;
import sanproject.sn2.controller.wizard.account.addusers.SJctrAddUsersSelectedUsersTableModel;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;

public class SJctrAddUsersDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17828177;
    private static final String COM_TABLE_AVA_USER_95S = "COM_TABLE_AVA_USER_95S";
    private static final String COM_TABLE_SEL_USER_95S = "COM_TABLE_SEL_USER_95S";
    private static final String COM_ADD = "COM_ADD";
    private static final String COM_REMOVE = "COM_REMOVE";
    public static final String TITLE = "ADD_USERS";
    private boolean taskcombination = false;

    public SJctrAddUsersDC() throws SJcException {
        super(17828177);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_TABLE_AVA_USER_95S, new SJctrAddUsersAvailableUsersTableModel());
        this.addDataObjectModel(COM_TABLE_SEL_USER_95S, new SJctrAddUsersSelectedUsersTableModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddUsersDC.this.addAction();
                        if (SJctrAddUsersDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(17828177);
                            SJctrAddUsersDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        add.setRollBackCheck(true);
        this.addDataObjectModel(COM_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddUsersDC.this.removeAction();
                        if (SJctrAddUsersDC.this.taskcombination) {
                            ArrayList<Integer> list_disp = new ArrayList<Integer>();
                            list_disp.add(17828177);
                            SJctrAddUsersDC.this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
                        }
                    }
                });
            }
        };
        remove.setRollBackCheck(true);
        this.addDataObjectModel(COM_REMOVE, remove);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void addAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA_USER_95S);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL_USER_95S);
        List<Object> list = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(list);
        selectedTable.setRowSelectionList(list);
        this.updateFooter();
    }

    private void removeAction() {
        SJctrTableDataModel availableTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_AVA_USER_95S);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL_USER_95S);
        List<Object> list = selectedTable.removeSelectedRowData();
        availableTable.addRowDataTop(list);
        List<Object> selectedList = availableTable.getFilterData(list);
        availableTable.setRowSelectionList(selectedList);
        availableTable.setCurrentPage(Integer.toString(1));
        this.updateFooter();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache("KEY_CREATEUG_TASKCOMBINATION");
        if (dat != null) {
            this.taskcombination = true;
        }
        ArrayList<String> availableUserIDList = new ArrayList<String>();
        if (!this.taskcombination) {
            SJctrError err;
            SJcException exception;
            List<?> dat2 = this.getCache(SJctrAccountDataMacro.WIZARD_ADDUSERS_SELECT_DATA);
            if (!this.checkContactData(dat2)) {
                SJctrError err2 = new SJctrError(2, 22, 107010);
                SJcException exception2 = err2.createException();
                throw exception2;
            }
            SJctrAddUsersSelectData addUsersSelectData = (SJctrAddUsersSelectData)dat2.get(0);
            List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = addUsersSelectData.getUserGrpInfoDetailList();
            if (userGrpInfoDetailList == null || userGrpInfoDetailList.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (UserGrp Info Detail List) is Empty", null, 40000);
                SJctrError err3 = new SJctrError(2, 22, 107010);
                SJcException exception3 = err3.createException();
                throw exception3;
            }
            int iListSize = userGrpInfoDetailList.size();
            String[] userGrpNames = new String[iListSize];
            for (int i = 0; i < iListSize; ++i) {
                userGrpNames[i] = userGrpInfoDetailList.get(i).getGroupName();
            }
            for (String userGrpName : userGrpNames) {
                boolean bRet = true;
                try {
                    bRet = SJctrUserInfoUtility.isExistGroup(userGrpName, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]isExistGroup() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err4 = new SJctrError(201, 22, 208003);
                    SJcException exception4 = err4.createException();
                    throw exception4;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]isExistGroup() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err5 = new SJctrError(2, 22, 107010);
                    SJcException exception5 = err5.createException();
                    throw exception5;
                }
                if (bRet) continue;
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Exist Group.(" + userGrpName + ")", null, 40000);
                SJctrError err6 = new SJctrError(2, 22, 107011);
                SJcException exception6 = err6.createException();
                throw exception6;
            }
            ArrayList<Object> userIDsList = new ArrayList();
            try {
                userIDsList = SJctrUserInfoUtility.getUserInUserGroup(userGrpNames, this);
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserInUserGroup() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err7 = new SJctrError(201, 22, 208003);
                exception = err7.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInUserGroup() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err8 = new SJctrError(2, 22, 107010);
                exception = err8.createException();
                throw exception;
            }
            String[] allUserIDs = null;
            try {
                allUserIDs = SJctrUserInfoUtility.getAllUser(this);
            }
            catch (SJcNotFoundUserException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                err = new SJctrError(2, 22, 106050);
                SJcException exception7 = err.createException();
                throw exception7;
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[CommunicationError]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                SJctrError error = new SJctrError(201, 22, 208003);
                SJcException exception8 = error.createException();
                throw exception8;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")");
                err = new SJctrError(2, 22, 107010);
                SJcException exception9 = err.createException();
                throw exception9;
            }
            for (String userID : allUserIDs) {
                boolean bRet = true;
                for (Object[] objectArray : userIDsList) {
                    if (objectArray == null || objectArray.length <= 0) continue;
                    Arrays.sort(objectArray);
                    if (Arrays.binarySearch(objectArray, userID) < 0) continue;
                    bRet = false;
                    break;
                }
                if (!bRet) continue;
                Collections.sort(availableUserIDList);
                if (Collections.binarySearch(availableUserIDList, userID) >= 0) continue;
                availableUserIDList.add(userID);
            }
            Map<String, SJctrUserInfoDetail> userInfoDetailMap = null;
            ArrayList<SJctrUserInfoDetail> list = new ArrayList<SJctrUserInfoDetail>();
            if (!availableUserIDList.isEmpty()) {
                String[] userIDs = availableUserIDList.toArray(new String[0]);
                try {
                    userInfoDetailMap = SJctrAccountInfoUty.getUserInfoDetailList(userIDs, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err9 = new SJctrError(201, 22, 208003);
                    SJcException exception10 = err9.createException();
                    throw exception10;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err10 = new SJctrError(2, 22, 107010);
                    SJcException exception2 = err10.createException();
                    throw exception2;
                }
                for (String string : userIDs) {
                    SJctrUserInfoDetail userInfoDetail = userInfoDetailMap.get(string);
                    if (userInfoDetail == null || userInfoDetail.getType() != SJcAccountConst.INT_USERTYPE_USER) continue;
                    list.add(userInfoDetail);
                }
            }
            if (list.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Available Users is Empty", null, 40000);
                SJctrError err11 = new SJctrError(2, 22, 106050);
                SJcException exception11 = err11.createException();
                throw exception11;
            }
            this.putCache(SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL, list);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        SJctrTableDataModel selectedTable;
        List<Object> selectedList;
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean result = true;
        SJctrError errInfo = null;
        List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = null;
        if (!this.taskcombination) {
            List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDUSERS_SELECT_DATA);
            if (!this.checkContactData(dat)) {
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrAddUsersSelectData addUsersSelectData = (SJctrAddUsersSelectData)dat.get(0);
            userGrpInfoDetailList = addUsersSelectData.getUserGrpInfoDetailList();
            if (userGrpInfoDetailList == null || userGrpInfoDetailList.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (UserGrp Info Detail) is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
        }
        if ((selectedList = (selectedTable = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL_USER_95S)).getAllRowData()).isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]Selected Users is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105222);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrUserInfoDetail> selectUserList = new ArrayList<SJctrUserInfoDetail>();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectedList.size());
        for (Object selectRow : selectedList) {
            if (selectRow == null || !(selectRow instanceof SJctrUserInfoDetail)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]illegal Row Data.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrUserInfoDetail userInfoDetail = (SJctrUserInfoDetail)selectRow;
            String[] userGrpName = userInfoDetail.getGrpName();
            if (userGrpName == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Group Name is Empty.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            int iGroupMax = SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_USER_NUM_IN_GROUP");
            int userGrpInfoDetailListSize = 0;
            userGrpInfoDetailListSize = !this.taskcombination ? userGrpInfoDetailList.size() : 1;
            if (userGrpInfoDetailListSize + userGrpName.length > iGroupMax) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Over UserGroup Num in User(" + userInfoDetail.getUserName() + ")", null, 40000);
                result = false;
                SJctrError error = new SJctrError(2, 22, 106051);
                if (errInfo == null) {
                    errInfo = error;
                }
                if (errInfo.getError() == 106051) {
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(userInfoDetail, error);
                    errList.add(errData);
                    continue;
                }
            }
            selectUserList.add(userInfoDetail);
        }
        if (!result) {
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE_SEL_USER_95S);
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        SJctrAddUsersData addUsersData = new SJctrAddUsersData();
        addUsersData.setUserInfoDetailList(selectUserList);
        if (!this.taskcombination) {
            addUsersData.setUserGrpInfoDetailList(userGrpInfoDetailList);
        }
        if (this.checkBeforeContactData(addUsersData)) {
            ArrayList<SJctrAddUsersData> list = new ArrayList<SJctrAddUsersData>();
            list.add(addUsersData);
            this.putCache(SJctrAccountDataMacro.WIZARD_ADDUSERS_DATA, list);
            ArrayList<Integer> list_disp = new ArrayList<Integer>();
            list_disp.add(17828177);
            this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkContactData(List<?> dat) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_ADDUSERS_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!(obj instanceof SJctrAddUsersSelectData)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrAddUsersData addUsersData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDUSERS_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_ADDUSERS_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrAddUsersData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrAddUsersData old_addUsersData = (SJctrAddUsersData)confirm_dat_obj;
            if (addUsersData.compareTo(old_addUsersData) != 0) {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has been changed.");
            } else {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has not been changed.");
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        if (bRet) {
            ArrayList<SJctrAddUsersData> list = new ArrayList<SJctrAddUsersData>();
            list.add(addUsersData);
            this.putCache(SJctrAccountDataMacro.WIZARD_ADDUSERS_DATA, list);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        if (this.taskcombination) {
            ArrayList<String> availableUserIDList = new ArrayList<String>();
            String strLogSubTitle = "checkConstructData";
            this.getLogUty().putlog(strLogSubTitle, "start");
            String[] allUserIDs = null;
            try {
                allUserIDs = SJcUserInfoUty.getAllUser();
            }
            catch (SJcNotFoundUserException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 106050);
                SJcException exception = err.createException();
                throw exception;
            }
            catch (SJcException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getAllUser() is failed.(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            for (String userID : allUserIDs) {
                Collections.sort(availableUserIDList);
                if (Collections.binarySearch(availableUserIDList, userID) >= 0) continue;
                availableUserIDList.add(userID);
            }
            Map<String, SJctrUserInfoDetail> userInfoDetailMap = null;
            ArrayList<SJctrUserInfoDetail> list = new ArrayList<SJctrUserInfoDetail>();
            if (!availableUserIDList.isEmpty()) {
                String[] userIDs = availableUserIDList.toArray(new String[0]);
                try {
                    userInfoDetailMap = SJctrAccountInfoUty.getUserInfoDetailList(userIDs, this);
                }
                catch (SJcCommunicationErrorException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(201, 22, 208003);
                    SJcException exception = err.createException();
                    throw exception;
                }
                catch (SJcException e) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                for (String strUserID : userIDs) {
                    SJctrUserInfoDetail userInfoDetail = userInfoDetailMap.get(strUserID);
                    if (userInfoDetail == null || userInfoDetail.getType() != SJcAccountConst.INT_USERTYPE_USER) continue;
                    list.add(userInfoDetail);
                }
            }
            if (list.isEmpty()) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Available Users is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 106050);
                SJcException exception = err.createException();
                throw exception;
            }
            this.putCache(SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL, list);
        }
        return true;
    }
}

