/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.createusergroup;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseCheckExternalGroupModule;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.createusergroup.SJctrCreateUserGrpCheckResultDataModel;
import sanproject.sn2.controller.wizard.account.createusergroup.SJctrCreateUserGrpData;

public class SJctrCreateUserGrpDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1009101;
    protected static final String COM_USERGRP_NAME = "COM_USER_GRP";
    protected static final String COM_CHECK_BUTTON = "COM_CHECK_BUTTON";
    private static final String COM_CHECK_RESULT = "COM_CHECK_RESULT";
    public static final String TITLE = "CREATE_UG";
    public static final String UGN_AVAILABLE = "UGN_AVAILABLE";
    public static final String UGN_NA = "UGN_NA";

    public SJctrCreateUserGrpDC() throws SJcException {
        super(0x1009101);
        this.initDataModel();
    }

    public SJctrCreateUserGrpDC(int dispID) throws SJcException {
        super(dispID);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        SJctrTextBoxDataModel groupNameTextBox = new SJctrTextBoxDataModel();
        groupNameTextBox.setValue("");
        groupNameTextBox.setVisible(true);
        this.addDataObjectModel(COM_USERGRP_NAME, groupNameTextBox);
        SJctrButtonDataModel checkbutton = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrCreateUserGrpDC.this.checkAction();
                    }
                });
            }
        };
        if (this.chkExternalAuthorization()) {
            checkbutton.setEnable(true);
        } else {
            checkbutton.setEnable(false);
        }
        this.addDataObjectModel(COM_CHECK_BUTTON, checkbutton);
        this.addDataObjectModel(COM_CHECK_RESULT, new SJctrCreateUserGrpCheckResultDataModel());
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
        footer.setRollBackCheck(SJctrFooterDataModel.Button.NEXT, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean chkExternalAuthorization() {
        boolean result = false;
        try {
            SJcFileUty.decryptFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config.properties", "base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
            Properties checkGroupProperties = SJcFileUty.loadProperties("base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
            String groupMapping = checkGroupProperties.getProperty("auth.group.mapping");
            result = Boolean.parseBoolean(groupMapping);
        }
        catch (Exception ex) {
            result = false;
        }
        finally {
            try {
                SJcFileUty.deleteFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private void checkAction() {
        String strLogSubTitle = "checkAction";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTextBoxDataModel userGrpNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(COM_USERGRP_NAME);
        String userGrpNametmp = userGrpNameTextBox.getValue();
        String userGrpName = userGrpNametmp.replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        SJctrCreateUserGrpCheckResultDataModel checkResult = (SJctrCreateUserGrpCheckResultDataModel)this.getDataObjectModel(COM_CHECK_RESULT);
        try {
            SJbaseCheckExternalGroupModule chkExtGrp = new SJbaseCheckExternalGroupModule();
            if (chkExtGrp.checkGroup(userGrpName).getGroupInfo().booleanValue()) {
                checkResult.setLabel(this.getComUtility().getGuidance(UGN_AVAILABLE));
                checkResult.setEnable(true);
            } else {
                checkResult.setLabel(this.getComUtility().getGuidance(UGN_NA));
                checkResult.setEnable(false);
            }
        }
        catch (SJbaseExAuthenticationException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]getGroupInfo is failed(authentication error)", null, 40000);
            SJctrError err = new SJctrError(2, 22, 106077);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJbaseExCommunicationException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]getGroupInfo is failed(communication error)", null, 40000);
            SJctrError err = new SJctrError(2, 22, 106077);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]getGroupInfo is failed(logical error)", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (Exception e) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]getGroupInfo is failed(logical error)", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_CREATEUSERGRP_SELECT_DATA);
        if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_CREATEUSERGRP_SELECT_DATA)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTextBoxDataModel userGrpNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(COM_USERGRP_NAME);
        String userGrpNametmp = userGrpNameTextBox.getValue();
        String userGrpName = userGrpNametmp.replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        SJctrUserGrpInfoDetail userGrpInfoDetail = new SJctrUserGrpInfoDetail();
        userGrpInfoDetail.setGroupName(userGrpName);
        SJctrCreateUserGrpData createUserGrpNameData = new SJctrCreateUserGrpData();
        createUserGrpNameData.setUserGrpInfoDetail(userGrpInfoDetail);
        if (this.checkBeforeContactData(createUserGrpNameData)) {
            ArrayList<SJctrCreateUserGrpData> list = new ArrayList<SJctrCreateUserGrpData>();
            list.add(createUserGrpNameData);
            this.putCache(SJctrAccountDataMacro.WIZARD_CREATEUSERGRP_NAME_DATA, list);
            ArrayList<Integer> list_disp = new ArrayList<Integer>();
            list_disp.add(0x1009101);
            this.putCache("KEY_CREATEUG_TASKCOMBINATION", list_disp);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkContactData(List<?> dat, Class<?> cls) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + cls.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!obj.getClass().equals(cls)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrCreateUserGrpData createUserGrpData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_CREATEUSERGRP_NAME_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CREATEUSERGRP_NAME_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrCreateUserGrpData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrCreateUserGrpData old_createUserGrpData = (SJctrCreateUserGrpData)confirm_dat_obj;
            if (createUserGrpData.compareTo(old_createUserGrpData) != 0) {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has been changed.");
            } else {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has not been changed.");
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }
}

