/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.com.file;

import java.util.ArrayList;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrFileUploadInterface;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrCertifyFileNameDataModel;

public class SJctrCertificationFileUpload
implements SJctrFileUploadInterface {
    private String originFileName = "";
    private static final String PATH_EXTAUTH = "base\\setting\\extAuth\\";
    private static final String FILENAME_EXTAUTH = "ExternalAuth.keystore";
    private static final int FILE_SIZE_MAX = 0x400000;
    private static final int FILE_UPLOAD_ERROR = 101533;
    private SJctrCertifyFileNameDataModel certifyFileNameDataModel = null;

    public void setFileNameDataModel(SJctrCertifyFileNameDataModel certifyFileNameDataModel) {
        this.certifyFileNameDataModel = certifyFileNameDataModel;
    }

    @Override
    public void fileUpload(ArrayList<String> fileList) {
        String randomFileName = "";
        long fileSize = 0L;
        SJcLogUty.getLogger().info("SJctrFileUploadInterface", "SJctrCertificationFileUpload", "fileUpload()", "Upload start.");
        SJbaseExternalFile extfile = new SJbaseExternalFile();
        randomFileName = fileList.get(0);
        if (!SJcFileUty.exists(PATH_EXTAUTH)) {
            SJcFileUty.makeDirectory(PATH_EXTAUTH);
        }
        this.originFileName = SJcFileUty.getUploadFile(randomFileName, PATH_EXTAUTH, randomFileName);
        String dataPath = System.getProperty("SN_DataPath") + SJcConst.sjc_PathSeparator + "data" + SJcConst.sjc_PathSeparator;
        String tmpFileName = dataPath + PATH_EXTAUTH + randomFileName;
        boolean result = extfile.setKeyStoreFile(tmpFileName);
        try {
            SJcFileUty.deleteFile(PATH_EXTAUTH, randomFileName);
        }
        catch (SJcException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "Upload File Delete Falied", "base\\setting\\extAuth\\FileName = " + this.originFileName);
        }
        SJcLogUty.getLogger().info("SJctrCertificationFileUpload", "SJbaseExternalFile", "setKeyStoreFile()", "cerfile=" + tmpFileName + " result=" + Boolean.toString(result));
        if (!result) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setKeyStoreFile()", "FileName = " + tmpFileName);
            SJctrError err = new SJctrError(2, 22, 101533);
            SJcException exp = err.createException();
            throw exp;
        }
        this.certifyFileNameDataModel.setDisplayFileName(this.originFileName);
        this.certifyFileNameDataModel.setFixed(true, false);
        SJctrWizardDataController wizDc = (SJctrWizardDataController)this.certifyFileNameDataModel.getDataController();
        ArrayList<SJctrExtAuthServerInfo> list = new ArrayList<SJctrExtAuthServerInfo>(1);
        list.add(new SJctrExtAuthServerInfo());
        wizDc.putCache(SJctrExtAuthServerInfo.class, list);
        fileSize = SJcFileUty.getFileSize(PATH_EXTAUTH, this.originFileName);
        if (fileSize > 0x400000L) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "fileUpload", "FileName = " + this.originFileName + ", " + "FileSize =" + fileSize + "byte");
        }
        SJcLogUty.getLogger().info("SJctrFileUploadInterface", "SJctrCertificationFileUpload", "fileUpload()", "Upload end.");
    }

    public String getOriginFileName() {
        return this.originFileName;
    }
}

