/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupkerberos;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExTrialException;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalTrial;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrMsgCodeDef;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;
import sanproject.sn2.controller.wizard.account.extauth.com.file.SJctrCertificationFileUpload;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrCertifyFileNameDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrExistDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrPasswordDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrProtocolComboBoxDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResult2DataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResultDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTextDataModel;
import sanproject.sn2.controller.wizard.account.extauth.setupkerberos.SJctrKerberosServerConfirmData;

public class SJctrKerberosServerDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16826432;
    public static final String TITLE = "SETUP_SERVER";
    public static final String KEY_BROWSE_BTN = "COM_BROWSE_BTN";
    public static final String KEY_TEST_BTN = "COM_TEST_BTN";
    SJctrExtAuthServerInfo extAuthServerInfo = null;
    SJctrExistDataModel dnsLookupDataModel = null;
    SJctrTextDataModel realmNameDataModel = null;
    SJctrTextDataModel priHostNameDataModel = null;
    SJctrTextDataModel priPortNumberDataModel = null;
    SJctrTextDataModel clockSkewDataModel = null;
    SJctrTextDataModel timeoutDataModel = null;
    SJctrExistDataModel secServerDataModel = null;
    SJctrTextDataModel secHostNameDataModel = null;
    SJctrTextDataModel secPortNumberDataModel = null;
    SJctrExistDataModel authorizeDataModel = null;
    SJctrCertifyFileNameDataModel certifyFileNameDataModel = null;
    SJctrCertificationFileUpload fileUpload = null;
    SJctrProtocolComboBoxDataModel extProtocolDataModel = null;
    SJctrTextDataModel extPriPortNumberDataModel = null;
    SJctrTextDataModel extBaseDnDataModel = null;
    SJctrTextDataModel extSearchDnDataModel = null;
    SJctrPasswordDataModel extPasswordDataModel = null;
    SJctrPasswordDataModel extRePasswordDataModel = null;
    SJctrTextDataModel extTimeoutDataModel = null;
    SJctrTextDataModel extIntervalDataModel = null;
    SJctrTextDataModel extRetriesDataModel = null;
    SJctrExistDataModel extSecServerDataModel = null;
    SJctrTextDataModel extSecPortNumberDataModel = null;
    SJctrTextDataModel testUserNameDataModel = null;
    SJctrPasswordDataModel testPasswordDataModel = null;
    SJctrTestResultDataModel testResultDataModel = null;
    SJctrTestResult2DataModel testResult2DataModel = null;
    public static int RESULT_NORMAL = 0;
    public static int KERBEROS_NON_REALMNAME = SJctrMsgCodeDef.NON_REALMNAME;
    public static int KERBEROS_OVER_LENGTH_REALMNAME = SJctrMsgCodeDef.OVER_LENGTH_REALMNAME;
    public static int KERBEROS_INVALID_REALMNAME = SJctrMsgCodeDef.INVALID_REALMNAME;
    public static int KERBEROS_NON_HOSTNAME = SJctrMsgCodeDef.NON_HOSTNAME;
    public static int KERBEROS_OVER_LENGTH_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_HOSTNAME;
    public static int KERBEROS_INVALID_HOSTNAME = SJctrMsgCodeDef.INVALID_HOSTNAME;
    public static int KERBEROS_NON_PORT = SJctrMsgCodeDef.NON_PORT;
    public static int KERBEROS_INVALID_PORT = SJctrMsgCodeDef.INVALID_PORT;
    public static int KERBEROS_NOT_RANGE_PORT = SJctrMsgCodeDef.NOT_RANGE_PORT;
    public static int KERBEROS_NON_CLOCKSKEW = SJctrMsgCodeDef.NON_CLOCKSKEW;
    public static int KERBEROS_INVALID_CLOCKSKEW = SJctrMsgCodeDef.INVALID_CLOCKSKEW;
    public static int KERBEROS_NOT_RANGE_CLOCKSKEW = SJctrMsgCodeDef.NOT_RANGE_CLOCKSKEW;
    public static int KERBEROS_NON_TIMEOUTE = SJctrMsgCodeDef.NON_TIMEOUTE;
    public static int KERBEROS_INVALID_TIMEOUT = SJctrMsgCodeDef.INVALID_TIMEOUT;
    public static int KERBEROS_NOT_RANGE_TIMEOUT = SJctrMsgCodeDef.NOT_RANGE_TIMEOUT;
    public static int KERBEROS_NOT_SET_SECONDARY = SJctrMsgCodeDef.NOT_SET_SECONDARY;
    public static int KERBEROS_NON_SEC_HOSTNAME = SJctrMsgCodeDef.NON_SEC_HOSTNAME;
    public static int KERBEROS_OVER_LENGTH_SEC_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_SEC_HOSTNAME;
    public static int KERBEROS_INVALID_SEC_HOSTNAME = SJctrMsgCodeDef.INVALID_SEC_HOSTNAME;
    public static int KERBEROS_NON_SEC_PORT = SJctrMsgCodeDef.NON_SEC_PORT;
    public static int KERBEROS_INVALID_SEC_PORT = SJctrMsgCodeDef.INVALID_SEC_PORT;
    public static int KERBEROS_NOT_RANGE_SEC_PORT = SJctrMsgCodeDef.NOT_RANGE_SEC_PORT;
    public static int KERBEROS_NON_CFFILE = SJctrMsgCodeDef.NON_EXT_CFFILE;
    public static int KERBEROS_INVALID_CFFILE = SJctrMsgCodeDef.INVALID_EXT_CFFILE;
    public static int KERBEROS_NOT_SELECT_LDAPS = SJctrMsgCodeDef.NOT_EXT_SELECT_LDAPS;
    public static int KERBEROS_NON_EXT_PORT = SJctrMsgCodeDef.NON_EXT_PORT;
    public static int KERBEROS_INVALID_EXT_PORT = SJctrMsgCodeDef.INVALID_EXT_PORT;
    public static int KERBEROS_NOT_RANGE_EXT_PORT = SJctrMsgCodeDef.NOT_RANGE_EXT_PORT;
    public static int KERBEROS_NON_EXT_BASEDN = SJctrMsgCodeDef.NON_EXT_BASEDN;
    public static int KERBEROS_OVER_LENGTH_EXT_BASEDN = SJctrMsgCodeDef.OVER_LENGTH_EXT_BASEDN;
    public static int KERBEROS_INVALID_EXT_BASEDN = SJctrMsgCodeDef.INVALID_EXT_BASEDN;
    public static int KERBEROS_NON_EXT_SEARCHDN = SJctrMsgCodeDef.NON_EXT_SEARCHDN;
    public static int KERBEROS_OVER_LENGTH_EXT_SEARCHDN = SJctrMsgCodeDef.OVER_LENGTH_EXT_SEARCHDN;
    public static int KERBEROS_INVALID_EXT_SEARCHDN = SJctrMsgCodeDef.INVALID_EXT_SEARCHDN;
    public static int KERBEROS_NON_EXT_PASSWORD = SJctrMsgCodeDef.NON_EXT_PASSWORD;
    public static int KERBEROS_OVER_LENGTH_EXT_PASSWORD = SJctrMsgCodeDef.OVER_LENGTH_EXT_PASSWORD;
    public static int KERBEROS_INVALID_EXT_PASSWORD = SJctrMsgCodeDef.INVALID_EXT_PASSWORD;
    public static int KERBEROS_NON_EXT_REPASSWORD = SJctrMsgCodeDef.NON_EXT_REPASSWORD;
    public static int KERBEROS_OVER_LENGTH_EXT_REPASSWORD = SJctrMsgCodeDef.OVER_LENGTH_EXT_REPASSWORD;
    public static int KERBEROS_INVALID_EXT_REPASSWORD = SJctrMsgCodeDef.INVALID_EXT_REPASSWORD;
    public static int KERBEROS_NOT_EQUAL_PASSWORD = SJctrMsgCodeDef.NOT_EQUAL_EXT_PASSWORD;
    public static int KERBEROS_NON_EXT_TIMEOUTE = SJctrMsgCodeDef.NON_EXT_TIMEOUTE;
    public static int KERBEROS_INVALID_EXT_TIMEOUT = SJctrMsgCodeDef.INVALID_EXT_TIMEOUT;
    public static int KERBEROS_NOT_RANGE_EXT_TIMEOUT = SJctrMsgCodeDef.NOT_RANGE_EXT_TIMEOUT;
    public static int KERBEROS_NON_EXT_INTERVAL = SJctrMsgCodeDef.NON_EXT_INTERVAL;
    public static int KERBEROS_INVALID_EXT_INTERVAL = SJctrMsgCodeDef.INVALID_EXT_INTERVAL;
    public static int KERBEROS_NOT_RANGE_EXT_INTERVAL = SJctrMsgCodeDef.NOT_RANGE_EXT_INTERVAL;
    public static int KERBEROS_NON_EXT_RETRIES = SJctrMsgCodeDef.NON_EXT_RETRIES;
    public static int KERBEROS_INVALID_EXT_RETRIES = SJctrMsgCodeDef.INVALID_EXT_RETRIES;
    public static int KERBEROS_NOT_RANGE_EXT_RETRIES = SJctrMsgCodeDef.NOT_RANGE_EXT_RETRIES;
    public static int KERBEROS_NON_EXT_SEC_PORT = SJctrMsgCodeDef.NON_EXT_SEC_PORT;
    public static int KERBEROS_INVALID_EXT_SEC_PORT = SJctrMsgCodeDef.INVALID_EXT_SEC_PORT;
    public static int KERBEROS_NOT_RANGE_EXT_SEC_PORT = SJctrMsgCodeDef.NOT_RANGE_EXT_SEC_PORT;
    public static int KERBEROS_NON_USERNAME = SJctrMsgCodeDef.NON_USERNAME;
    public static int KERBEROS_OVERLENGTH_USERNAME = SJctrMsgCodeDef.OVERLENGTH_USERNAME;
    public static int KERBEROS_INVALID_USERNAME = SJctrMsgCodeDef.INVALID_USERNAME;
    public static int KERBEROS_NON_TPASSWORD = SJctrMsgCodeDef.NON_TPASSWORD;
    public static int KERBEROS_OVERLENGTH_TPASSWORD = SJctrMsgCodeDef.OVERLENGTH_TPASSWORD;
    public static int KERBEROS_INVALID_TPASSWORD = SJctrMsgCodeDef.INVALID_TPASSWORD;
    boolean debug_testresult = false;

    public SJctrKerberosServerDC() throws SJcException {
        super(16826432);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_REALM_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_DNSINF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_PRI_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PRI_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_CLOCK_SKEW", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TOV", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEC_SRV_AUTH", new SJctrExistDataModel());
        this.addDataObjectModel("COM_SEC_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEC_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_AUTH_INF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_CERTIFICATES", new SJctrCertifyFileNameDataModel());
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BROWSE_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrKerberosServerDC.this.browseAction();
            }
        });
        this.addDataObjectModel("COM_EXT_AUTH_PROT_INF", new SJctrProtocolComboBoxDataModel());
        this.addDataObjectModel("COM_EXT_PRI_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_BASE_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEARCH_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_RE_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_EXT_TOV", new SJctrTextDataModel());
        this.addDataObjectModel("COM_RET_INTERVAL", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_RET_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_EXT_SEC_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_PASS", new SJctrPasswordDataModel());
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_TEST_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrKerberosServerDC.this.testAction();
            }
        });
        this.addDataObjectModel("COM_TEST_RESULT", new SJctrTestResultDataModel());
        this.addDataObjectModel("COM_TEST_RESULT2", new SJctrTestResult2DataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void browseAction() {
        this.fileUpload = new SJctrCertificationFileUpload();
        this.fileUpload.setFileNameDataModel(this.certifyFileNameDataModel);
        SJctrRelatedDispDataObject relatedDisp = null;
        relatedDisp = this.createFileUpload(this.fileUpload);
        this.addUpdateDisp(relatedDisp);
    }

    private void testAction() {
        int errcode = this.checkSetting();
        if (errcode == RESULT_NORMAL) {
            errcode = this.checkTestSetting();
        }
        if (errcode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseKerberosConfiguration setConfig_pri = null;
        SJbaseKerberosConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseKerberosConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseKerberosConfiguration>();
        setConfig_pri = (SJbaseKerberosConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseKerberosConfiguration();
        }
        this.updateKerberosSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyKerberosConfig(setConfig_pri);
            this.updateKerberosSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        String displayFileName = "-";
        if (this.authorizeDataModel.isSelectEnable()) {
            displayFileName = this.certifyFileNameDataModel.getDisplayFileName();
        }
        info.setCertifyFullPathName(displayFileName);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_KERBEROS);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        String name = this.testUserNameDataModel.getValue();
        String pass = this.testPasswordDataModel.getValue();
        String priErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_KERBEROS;
        int priErrorCode = RESULT_NORMAL;
        SJcLogUty.getLogger().info("SJctrKerberosServerDC", "SJctrKerberosServerDC", "ConnectTest(Primary)", "Test start.");
        try {
            SJbaseKerberosConfiguration conf = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (this.authorizeDataModel.isSelectEnable()) {
                SJbaseExternalTrial.externalKerberosConnect(name, pass, conf, gconf);
            } else {
                SJbaseExternalTrial.externalKerberosConnect(name, pass, conf);
            }
        }
        catch (SJbaseExTrialException e) {
            priErrorType = e.getServerType();
            priErrorCode = e.getErrCode();
        }
        SJcLogUty.getLogger().info("SJctrKerberosServerDC", "SJctrKerberosServerDC", "ConnectTest(Primary)", "Test end. result=" + priErrorType + ":" + priErrorCode);
        boolean execSecondary = false;
        String secErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_KERBEROS;
        int secErrorCode = RESULT_NORMAL;
        if (priErrorCode == RESULT_NORMAL && this.secServerDataModel.isSelectEnable()) {
            SJcLogUty.getLogger().info("SJctrKerberosServerDC", "SJctrKerberosServerDC", "ConnectTest(Secondary)", "Test start.");
            try {
                SJbaseKerberosConfiguration conf = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                if (this.authorizeDataModel.isSelectEnable()) {
                    SJbaseExternalTrial.externalKerberosConnect(name, pass, conf, gconf);
                } else {
                    SJbaseExternalTrial.externalKerberosConnect(name, pass, conf);
                }
            }
            catch (SJbaseExTrialException e) {
                secErrorType = e.getServerType();
                secErrorCode = e.getErrCode();
            }
            execSecondary = true;
            SJcLogUty.getLogger().info("SJctrKerberosServerDC", "SJctrKerberosServerDC", "ConnectTest(Secondary)", "Test end. result=" + secErrorType + ":" + secErrorCode);
        }
        if (this.debug_testresult) {
            Properties debug_properties = new Properties();
            String confFileName = "C:\\DKC200\\others\\exauth.properties";
            try {
                debug_properties.load(new FileInputStream(confFileName));
            }
            catch (Exception e) {
                // empty catch block
            }
            priErrorType = debug_properties.getProperty("TestPrimaryErrorType");
            priErrorCode = Integer.parseInt(debug_properties.getProperty("TestPrimaryErrorType"));
            execSecondary = Boolean.valueOf(debug_properties.getProperty("TestExecuteSecondary"));
            secErrorType = debug_properties.getProperty("TestSecondaryErrorType");
            secErrorCode = Integer.parseInt(debug_properties.getProperty("TestSecondaryErrorCode"));
        }
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        boolean result = false;
        if (priErrorCode == RESULT_NORMAL) {
            result = true;
        }
        this.testResultDataModel.setTestResut(result);
        String[] guidekey = new String[]{"", ""};
        guidekey = SJctrExtAuthServerUtility.isTrailServerTypeKerberos(priErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.KerberosTestResult, priErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, priErrorCode);
        this.testResultDataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDirty();
        if (execSecondary && this.secServerDataModel.isSelectEnable()) {
            result = false;
            if (secErrorCode == RESULT_NORMAL) {
                result = true;
            }
            this.testResult2DataModel.setTestResut(result);
            guidekey = new String[]{"", ""};
            guidekey = SJctrExtAuthServerUtility.isTrailServerTypeKerberos(secErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.KerberosTestResult, secErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, secErrorCode);
            this.testResult2DataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDirty();
        }
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        SJbaseExternalFile config = new SJbaseExternalFile();
        HashMap<String, SJbaseConfiguration> config_map = null;
        HashMap<String, SJbaseGroupConfiguration> config_group_map = null;
        SJbaseKerberosConfiguration config_data = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        String type = config.getType();
        if (SJctrExtAuthServerUtility.isServerTypeKerberos(type)) {
            config_map = config.getConfiguration(type);
            config_group_map = config.getGroupConfiguration(type);
            if (config_map != null && (config_data = (SJbaseKerberosConfiguration)config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY)) != null) {
                info.setServerType(type);
                SJbaseConfiguration pri_conf = null;
                SJbaseConfiguration sec_conf = null;
                if (config_map != null) {
                    pri_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setConfiguration(pri_conf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setConfiguration(sec_conf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                SJbaseGroupConfiguration pri_gconf = null;
                SJbaseGroupConfiguration sec_gconf = null;
                if (config_group_map != null) {
                    pri_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setGroupConfiguration(pri_gconf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setGroupConfiguration(sec_gconf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
            }
        }
        this.extAuthServerInfo = info;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.dnsLookupDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_DNSINF");
        this.realmNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_REALM_NAME");
        this.priHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_HOST_NAME");
        this.priPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_PORT_NUM");
        this.priPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.priPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.clockSkewDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_CLOCK_SKEW");
        this.clockSkewDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.CLOCKSKEW_MIN));
        this.clockSkewDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.CLOCKSKEW_MAX));
        this.timeoutDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TOV");
        this.timeoutDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MIN));
        this.timeoutDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MAX));
        this.secServerDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_SEC_SRV_AUTH");
        this.secHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_HOST_NAME");
        this.secPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_PORT_NUM");
        this.secPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.secPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.authorizeDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_EXT_AUTH_INF");
        this.certifyFileNameDataModel = (SJctrCertifyFileNameDataModel)this.getDataObjectModel("COM_CERTIFICATES");
        this.extProtocolDataModel = (SJctrProtocolComboBoxDataModel)this.getDataObjectModel("COM_EXT_AUTH_PROT_INF");
        this.extPriPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_PRI_PORT_NUM");
        this.extPriPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.extPriPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.extTimeoutDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_TOV");
        this.extTimeoutDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MIN));
        this.extTimeoutDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MAX));
        this.extIntervalDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_RET_INTERVAL");
        this.extIntervalDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN));
        this.extIntervalDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX));
        this.extRetriesDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_RET_NUM");
        this.extRetriesDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MIN));
        this.extRetriesDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MAX));
        this.extBaseDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_BASE_DN");
        this.extSearchDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEARCH_DN");
        this.extPasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_PASSWORD");
        this.extRePasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_RE_PASSWORD");
        this.extSecPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_EXT_SEC_PORT_NUM");
        this.extSecPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.extSecPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.testUserNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TEST_NAME");
        this.testPasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_TEST_PASS");
        this.testResultDataModel = (SJctrTestResultDataModel)this.getDataObjectModel("COM_TEST_RESULT");
        this.testResultDataModel.setEnable(true);
        this.testResultDataModel.setTestResut(true);
        this.testResult2DataModel = (SJctrTestResult2DataModel)this.getDataObjectModel("COM_TEST_RESULT2");
        this.testResult2DataModel.setEnable(true);
        this.testResult2DataModel.setTestResut(true);
        this.initialSettings();
        this.initialSettings_Authorize();
        this.initialSettings_Test();
        return ret;
    }

    private void initialSettings() {
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        SJbaseKerberosConfiguration config_pri = (SJbaseKerberosConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseKerberosConfiguration config_sec = (SJbaseKerberosConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        boolean initialSetting = false;
        if (config_pri == null) {
            config_pri = this.extAuthServerInfo.getDefaultKerberosConfig();
            initialSetting = true;
        }
        if (SJctrExtAuthServerUtility.isInvalidStr(config_pri.getDns_Lookup_Kdc())) {
            this.dnsLookupDataModel.selectEnable();
        } else {
            this.dnsLookupDataModel.selectDisable();
        }
        String value = config_pri.getDefaul_Realm();
        this.realmNameDataModel.setValue(value);
        value = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value = SJctrExtAuthServerUtility.splitKdcToHostName(config_pri.getKdc());
        }
        this.priHostNameDataModel.setValue(value);
        value = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value = SJctrExtAuthServerUtility.splitKdcToPortNumer(config_pri.getKdc());
        }
        this.priPortNumberDataModel.setValue(value);
        value = String.valueOf(config_pri.getClockskew());
        this.clockSkewDataModel.setValue(value);
        value = String.valueOf(config_pri.getTimeout());
        this.timeoutDataModel.setValue(value);
        if (config_sec != null) {
            this.secServerDataModel.selectEnable();
        } else {
            if (initialSetting) {
                this.secServerDataModel.selectEnable();
            } else {
                this.secServerDataModel.selectDisable();
            }
            config_sec = this.extAuthServerInfo.getDefaultKerberosConfig();
        }
        if (SJctrExtAuthServerUtility.isInvalidStr(config_pri.getDns_Lookup_Kdc())) {
            // empty if block
        }
        value = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value = SJctrExtAuthServerUtility.splitKdcToHostName(config_sec.getKdc());
        }
        this.secHostNameDataModel.setValue(value);
        value = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value = SJctrExtAuthServerUtility.splitKdcToPortNumer(config_sec.getKdc());
        }
        this.secPortNumberDataModel.setValue(value);
    }

    private void initialSettings_Authorize() {
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        SJbaseLdapGroupConfiguration config_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseLdapGroupConfiguration config_sec = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        if (config_pri != null) {
            this.authorizeDataModel.selectEnable();
        } else {
            this.authorizeDataModel.selectDisable();
            config_pri = this.extAuthServerInfo.getDefaultGroupLdapConfig();
        }
        this.certifyFileNameDataModel.setFixed(true, true);
        String value = comUtility.getGuidance("COMMON", "FIXED_TEXT_BROWSE_BTN");
        this.certifyFileNameDataModel.setDisplayFileName(value);
        String protocol = this.extProtocolDataModel.getSelectionName(config_pri.getProtocol());
        this.extProtocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS, comUtility.getGuidance("COMMON", "STARTTLS"));
        this.extProtocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_LDAPS, comUtility.getGuidance("COMMON", "LDAPS"));
        if (protocol.equals("")) {
            this.extProtocolDataModel.setSelection(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS);
        } else {
            this.extProtocolDataModel.setSelection(protocol);
        }
        String value2 = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value2 = String.valueOf(config_pri.getPort());
        }
        if (protocol.equals("")) {
            value2 = String.valueOf(SJctrExtAuthServerInfo.LDAP_PORT_NUMBER_DEF);
        }
        this.extPriPortNumberDataModel.setValue(value2);
        value2 = config_pri.getSearchDN();
        if (value2 == null) {
            value2 = "";
        }
        this.extBaseDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserDN();
        this.extSearchDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        this.extPasswordDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        this.extRePasswordDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getTimeout());
        this.extTimeoutDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryInterval());
        this.extIntervalDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryTimes());
        this.extRetriesDataModel.setValue(value2);
        if (config_sec == null) {
            config_sec = this.extAuthServerInfo.getDefaultGroupLdapConfig();
        }
        if (this.dnsLookupDataModel.isSelectEnable()) {
            // empty if block
        }
        value2 = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value2 = String.valueOf(config_sec.getPort());
        }
        this.extSecPortNumberDataModel.setValue(value2);
        if (this.authorizeDataModel.isSelectDisable()) {
            // empty if block
        }
    }

    private void initialSettings_Test() {
        this.testUserNameDataModel.setValue("");
        this.testPasswordDataModel.setValue("");
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        int errcode = this.checkSetting();
        if (errcode != RESULT_NORMAL) {
            ret = false;
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseKerberosConfiguration setConfig_pri = null;
        SJbaseKerberosConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseKerberosConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseKerberosConfiguration>();
        setConfig_pri = (SJbaseKerberosConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseKerberosConfiguration();
        }
        this.updateKerberosSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyKerberosConfig(setConfig_pri);
            this.updateKerberosSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        String displayFileName = "-";
        if (this.authorizeDataModel.isSelectEnable()) {
            displayFileName = this.certifyFileNameDataModel.getDisplayFileName();
        }
        if (this.fileUpload == null || this.fileUpload.getOriginFileName() == "") {
            displayFileName = "";
        }
        info.setCertifyFullPathName(displayFileName);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_KERBEROS);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        ArrayList<SJctrKerberosServerConfirmData> confirmDataList = new ArrayList<SJctrKerberosServerConfirmData>(1);
        SJctrKerberosServerConfirmData confirmData = new SJctrKerberosServerConfirmData(info);
        confirmDataList.add(confirmData);
        this.putCache(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    private int checkSetting() {
        String searchDn;
        String baseDn;
        String clockskew;
        int portvalue;
        String port;
        String host;
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
        String realm = this.realmNameDataModel.getValue();
        if (realm == null || realm.length() <= 0) {
            errcode = KERBEROS_NON_REALMNAME;
            return errcode;
        }
        if (!validUtil.isValid(realm, SJctrValidatorUtility.Length_1to255)) {
            errcode = KERBEROS_OVER_LENGTH_REALMNAME;
            return errcode;
        }
        if (!validUtil.isValid(realm, SJctrValidatorUtility.RealmName)) {
            errcode = KERBEROS_INVALID_REALMNAME;
            return errcode;
        }
        if (this.dnsLookupDataModel.isSelectDisable()) {
            host = this.priHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = KERBEROS_NON_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = KERBEROS_OVER_LENGTH_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = KERBEROS_INVALID_HOSTNAME;
                return errcode;
            }
            port = this.priPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = KERBEROS_NON_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = KERBEROS_INVALID_PORT;
                return errcode;
            }
            portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = KERBEROS_NOT_RANGE_PORT;
                return errcode;
            }
        }
        if ((clockskew = this.clockSkewDataModel.getValue()) == null || clockskew.length() <= 0) {
            errcode = KERBEROS_NON_CLOCKSKEW;
            return errcode;
        }
        if (!validUtil.isValid(clockskew, SJctrValidatorUtility.CloclSkew)) {
            errcode = KERBEROS_INVALID_CLOCKSKEW;
            return errcode;
        }
        int clockskewvalue = Integer.valueOf(clockskew);
        if (clockskewvalue < SJctrExtAuthServerInfo.CLOCKSKEW_MIN || SJctrExtAuthServerInfo.CLOCKSKEW_MAX < clockskewvalue) {
            errcode = KERBEROS_NOT_RANGE_CLOCKSKEW;
            return errcode;
        }
        String timeout = this.timeoutDataModel.getValue();
        if (timeout == null || timeout.length() <= 0) {
            errcode = KERBEROS_NON_TIMEOUTE;
            return errcode;
        }
        if (!validUtil.isValid(timeout, SJctrValidatorUtility.Timeout)) {
            errcode = KERBEROS_INVALID_TIMEOUT;
            return errcode;
        }
        int timeoutvalue = Integer.valueOf(timeout);
        if (timeoutvalue < SJctrExtAuthServerInfo.TIMEOUT_MIN || SJctrExtAuthServerInfo.TIMEOUT_MAX < timeoutvalue) {
            errcode = KERBEROS_NOT_RANGE_TIMEOUT;
            return errcode;
        }
        if (this.secServerDataModel.isSelectEnable()) {
            if (this.dnsLookupDataModel.isSelectEnable()) {
                errcode = KERBEROS_NOT_SET_SECONDARY;
                return errcode;
            }
            host = this.secHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = KERBEROS_NON_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = KERBEROS_OVER_LENGTH_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = KERBEROS_INVALID_SEC_HOSTNAME;
                return errcode;
            }
            port = this.secPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = KERBEROS_NON_SEC_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = KERBEROS_INVALID_SEC_PORT;
                return errcode;
            }
            portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = KERBEROS_NOT_RANGE_SEC_PORT;
                return errcode;
            }
        }
        if (this.authorizeDataModel.isSelectDisable()) {
            return errcode;
        }
        if (this.fileUpload != null && this.fileUpload.getOriginFileName() != "") {
            String full = this.certifyFileNameDataModel.getDisplayFileName();
            if (full == null || full.length() <= 0) {
                errcode = KERBEROS_NON_CFFILE;
                return errcode;
            }
            if (!validUtil.isValid(full, SJctrValidatorUtility.nFullPathName)) {
                errcode = KERBEROS_INVALID_CFFILE;
                return errcode;
            }
        }
        if (this.dnsLookupDataModel.isSelectEnable()) {
            String name = this.extProtocolDataModel.getSelection();
            if (SJctrExtAuthServerUtility.isLdapsProtocol(name)) {
                errcode = KERBEROS_NOT_SELECT_LDAPS;
                return errcode;
            }
        } else {
            port = this.extPriPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = KERBEROS_NON_EXT_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = KERBEROS_INVALID_EXT_PORT;
                return errcode;
            }
            portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = KERBEROS_NOT_RANGE_EXT_PORT;
                return errcode;
            }
            if (this.secServerDataModel.isSelectEnable()) {
                port = this.extSecPortNumberDataModel.getValue();
                if (port == null || port.length() <= 0) {
                    errcode = KERBEROS_NON_EXT_SEC_PORT;
                    return errcode;
                }
                if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                    errcode = KERBEROS_INVALID_EXT_SEC_PORT;
                    return errcode;
                }
                portvalue = Integer.valueOf(port);
                if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                    errcode = KERBEROS_NOT_RANGE_EXT_SEC_PORT;
                    return errcode;
                }
            }
        }
        if ((baseDn = this.extBaseDnDataModel.getValue()) != null && baseDn.length() > 0) {
            if (!validUtil.isValid(baseDn, SJctrValidatorUtility.Length_1to255)) {
                errcode = KERBEROS_OVER_LENGTH_EXT_BASEDN;
                return errcode;
            }
            if (!validUtil.isValid(baseDn, SJctrValidatorUtility.BaseDN)) {
                errcode = KERBEROS_INVALID_EXT_BASEDN;
                return errcode;
            }
        }
        if ((searchDn = this.extSearchDnDataModel.getValue()) == null || searchDn.length() <= 0) {
            errcode = KERBEROS_NON_EXT_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.Length_1to255)) {
            errcode = KERBEROS_OVER_LENGTH_EXT_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.SearchDN)) {
            errcode = KERBEROS_INVALID_EXT_SEARCHDN;
            return errcode;
        }
        String password = this.extPasswordDataModel.getValue();
        if (password == null || password.length() <= 0) {
            errcode = KERBEROS_NON_EXT_PASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Length_1to256)) {
            errcode = KERBEROS_OVER_LENGTH_EXT_PASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Password)) {
            errcode = KERBEROS_INVALID_EXT_PASSWORD;
            return errcode;
        }
        String rePassword = this.extRePasswordDataModel.getValue();
        if (rePassword == null || rePassword.length() <= 0) {
            errcode = KERBEROS_NON_EXT_REPASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Length_1to256)) {
            errcode = KERBEROS_OVER_LENGTH_EXT_REPASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Password)) {
            errcode = KERBEROS_INVALID_EXT_REPASSWORD;
            return errcode;
        }
        if (!password.equals(rePassword)) {
            errcode = KERBEROS_NOT_EQUAL_PASSWORD;
            return errcode;
        }
        String timeout2 = this.extTimeoutDataModel.getValue();
        if (timeout2 == null || timeout2.length() <= 0) {
            errcode = KERBEROS_NON_EXT_TIMEOUTE;
            return errcode;
        }
        if (!validUtil.isValid(timeout2, SJctrValidatorUtility.Timeout)) {
            errcode = KERBEROS_INVALID_EXT_TIMEOUT;
            return errcode;
        }
        int timeoutvalue2 = Integer.valueOf(timeout2);
        if (timeoutvalue2 < SJctrExtAuthServerInfo.TIMEOUT_MIN || SJctrExtAuthServerInfo.TIMEOUT_MAX < timeoutvalue2) {
            errcode = KERBEROS_NOT_RANGE_EXT_TIMEOUT;
            return errcode;
        }
        String interval = this.extIntervalDataModel.getValue();
        if (interval == null || interval.length() <= 0) {
            errcode = KERBEROS_NON_EXT_INTERVAL;
            return errcode;
        }
        if (!validUtil.isValid(interval, SJctrValidatorUtility.Timeout)) {
            errcode = KERBEROS_INVALID_EXT_INTERVAL;
            return errcode;
        }
        int intervalvalue = Integer.valueOf(interval);
        if (intervalvalue < SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN || SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX < intervalvalue) {
            errcode = KERBEROS_NOT_RANGE_EXT_INTERVAL;
            return errcode;
        }
        String retries = this.extRetriesDataModel.getValue();
        if (retries == null || retries.length() <= 0) {
            errcode = KERBEROS_NON_EXT_RETRIES;
            return errcode;
        }
        if (!validUtil.isValid(retries, SJctrValidatorUtility.Retries)) {
            errcode = KERBEROS_INVALID_EXT_RETRIES;
            return errcode;
        }
        int retriesvalue = Integer.valueOf(retries);
        if (retriesvalue < SJctrExtAuthServerInfo.RETRY_TIMES_MIN || SJctrExtAuthServerInfo.RETRY_TIMES_MAX < retriesvalue) {
            errcode = KERBEROS_NOT_RANGE_EXT_RETRIES;
            return errcode;
        }
        return errcode;
    }

    private int checkTestSetting() {
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility varidUtil = new SJctrValidatorUtility();
        String name = this.testUserNameDataModel.getValue();
        String password = this.testPasswordDataModel.getValue();
        if (name == null || name.length() <= 0) {
            errcode = KERBEROS_NON_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.Length_1to128)) {
            errcode = KERBEROS_OVERLENGTH_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.TestUserName)) {
            errcode = KERBEROS_INVALID_USERNAME;
            return errcode;
        }
        if (password == null || password.length() <= 0) {
            errcode = KERBEROS_NON_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.Length_1to128)) {
            errcode = KERBEROS_OVERLENGTH_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.TestPassword)) {
            errcode = KERBEROS_INVALID_TPASSWORD;
            return errcode;
        }
        return errcode;
    }

    private void updateKerberosSetting(String key, SJbaseKerberosConfiguration conf) {
        String dns_lookup_kdc = SJctrExtAuthServerUtility.FALSE_DATA;
        if (this.dnsLookupDataModel.isSelectEnable()) {
            dns_lookup_kdc = SJctrExtAuthServerUtility.TRUE_DATA;
        }
        conf.setDns_Lookup_Kdc(dns_lookup_kdc);
        String defaul_realm = this.realmNameDataModel.getValue();
        conf.setDefaul_Realm(defaul_realm);
        String realm_name = SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY;
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            realm_name = SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY;
        }
        conf.setRealm_Name(realm_name);
        String realm = defaul_realm;
        conf.setRealm(realm);
        String kdc = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            String host = this.priHostNameDataModel.getValue();
            String port = this.priPortNumberDataModel.getValue();
            if (port.length() > 0 && host.length() > 0) {
                kdc = SJctrExtAuthServerUtility.makeKdcString(host, port);
            }
        }
        conf.setKdc(kdc);
        int clockskew = Integer.parseInt(this.clockSkewDataModel.getValue());
        conf.setClockskew(clockskew);
        int timeout = Integer.parseInt(this.timeoutDataModel.getValue());
        conf.setTimeout(timeout);
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            String seckdc = "";
            if (this.secServerDataModel.isSelectEnable()) {
                String sechost = this.secHostNameDataModel.getValue();
                String secport = this.secPortNumberDataModel.getValue();
                if (secport.length() > 0 && sechost.length() > 0) {
                    seckdc = SJctrExtAuthServerUtility.makeKdcString(sechost, secport);
                }
            }
            conf.setKdc(seckdc);
        }
    }

    private void updateLdapGroupSetting(String key, SJbaseLdapGroupConfiguration conf) {
        String strport;
        String dnsLookup = SJctrExtAuthServerUtility.FALSE_DATA;
        if (this.dnsLookupDataModel.isSelectEnable()) {
            dnsLookup = SJctrExtAuthServerUtility.TRUE_DATA;
        }
        conf.setDnsLookup(dnsLookup);
        String protocol = this.extProtocolDataModel.getSelection();
        conf.setProtocol(protocol);
        String host = "";
        int port = SJctrExtAuthServerInfo.INVALID_VALUE;
        if (this.dnsLookupDataModel.isSelectDisable() && (strport = this.extPriPortNumberDataModel.getValue()).length() > 0) {
            port = Integer.parseInt(strport);
        }
        conf.setHost(host);
        conf.setPort(port);
        String baseDN = this.extBaseDnDataModel.getValue();
        conf.setSearchDN(baseDN);
        String searchUserDN = this.extSearchDnDataModel.getValue();
        conf.setSearchUserDN(searchUserDN);
        String searchUserPassword = this.extPasswordDataModel.getValue();
        conf.setSearchUserPassword(searchUserPassword);
        int timeout = Integer.parseInt(this.extTimeoutDataModel.getValue());
        conf.setTimeout(timeout);
        int retryInterval = Integer.parseInt(this.extIntervalDataModel.getValue());
        conf.setRetryInterval(retryInterval);
        int retryTimes = Integer.parseInt(this.extRetriesDataModel.getValue());
        conf.setRetryTimes(retryTimes);
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            String strsecport;
            String sechost = "";
            int secport = SJctrExtAuthServerInfo.INVALID_VALUE;
            if (this.secServerDataModel.isSelectEnable() && (strsecport = this.extSecPortNumberDataModel.getValue()).length() > 0) {
                secport = Integer.parseInt(strsecport);
            }
            conf.setHost(sechost);
            conf.setPort(secport);
        }
    }
}

