/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupkerberos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlFreeFormElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;

public class SJctrSetupServerKerberosAuditLog
implements Serializable {
    static final String FUNCTION_NAME = "ADT_FC_ACOUNT";
    static final int NUMBER_OF_SERVERS = 1;
    public static String[][] KeyTable_BasicInfo = new String[][]{{"COMMON", "ADT_SETUP_SERVER"}, {"COMMON", "KERBEROS"}, {"COMMON", "ADT_NUM_OF_SERVERS"}};
    public static String[][] KeyTable_DtlInfo_Auth = new String[][]{{"COMMON", "DNS_LOOKUP"}, {"COMMON", "REALM_NAME"}, {"COMMON", "PRIMARY_HOSTNAME"}, {"COMMON", "PRIMARY_PORT_NUM"}, {"COMMON", "CLOCKSKEW"}, {"COMMON", "TIMEOUT"}, {"AUTH", "SECOND_SERVER_AUTH"}, {"COMMON", "SECONDARY_HOSTNAME"}, {"COMMON", "SECONDARY_PORT_NUM"}};
    public static String[][] KeyTable_DtlInfo_AuthGroup = new String[][]{{"COMMON", "EXT_AUTHORIZATION"}, {"COMMON", "CERTIFICATION_FILE_NAME"}, {"COMMON", "AUTHENTICATION_PROTOCOL"}, {"COMMON", "PRIMARY_PORT_NUM"}, {"COMMON", "BASE_DN"}, {"COMMON", "SEARCH_DN"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}, {"AUTH", "SECOND_SERVER_AUTH"}, {"COMMON", "SECONDARY_PORT_NUM"}};
    private static final int INDEX_DISPID = 0;
    private static final int INDEX_PARTSID = 1;
    private Map<String, String> TitleEnGuideMap = null;
    private Map<String, String> DataEnGuideMap = null;
    HashMap<String, String> addition = null;
    private String headAuth = "";
    private List<String> detailAuth = new ArrayList<String>();
    private String headAuthGroup = "";
    private List<String> detailAuthGroup = new ArrayList<String>();
    private String footer = "";

    SJctrSetupServerKerberosAuditLog() {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleEnGuideMap = new HashMap<String, String>();
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_BasicInfo));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Auth));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_AuthGroup));
        this.DataEnGuideMap = new HashMap<String, String>();
        this.DataEnGuideMap.putAll(guidance.getGuidance(SJctrExtAuthServerUtility.AdtGuideKeyTable));
        this.addition = new HashMap();
    }

    public void setAdditionData(SJbaseUserSession userSession) {
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    SJcAuditLogCtrlFreeFormElemCon createElemCon() {
        SJcAuditLogCtrlFreeFormElemCon elemCon = new SJcAuditLogCtrlFreeFormElemCon();
        elemCon.setFunctionName(FUNCTION_NAME);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_SETUP_SERVER");
        String opeName = this.TitleEnGuideMap.get(key);
        elemCon.setOperationName(opeName);
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "KERBEROS");
        String opeParam = this.TitleEnGuideMap.get(key);
        elemCon.setOperationParameter(opeParam);
        elemCon.setAdditionalInfo(this.addition);
        elemCon.setHeadHier1st(this.headAuth);
        elemCon.setDetailHier1st(this.detailAuth);
        elemCon.setHeadHier2nd(this.headAuthGroup);
        elemCon.setDetailHier2nd(this.detailAuthGroup);
        elemCon.setFooter(this.footer);
        return elemCon;
    }

    public void setPrintData(SJctrExtAuthServerInfo info) {
        String data;
        String authorize;
        String key;
        String key2;
        SJbaseKerberosConfiguration config = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseKerberosConfiguration config_sec = (SJbaseKerberosConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        SJbaseLdapGroupConfiguration gconfig = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseLdapGroupConfiguration gconfig_sec = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_Auth.length; ++index) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_Auth[index][0], KeyTable_DtlInfo_Auth[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key2));
            if (index == KeyTable_DtlInfo_Auth.length - 1) break;
            buffer.append(",");
        }
        this.headAuth = "{" + buffer.toString() + "}" + "=" + "\n";
        buffer = new StringBuffer();
        buffer.append("{");
        String dns = "";
        if (SJctrExtAuthServerUtility.isInvalidStr(config.getDns_Lookup_Kdc())) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            dns = this.DataEnGuideMap.get(key2);
        } else {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            dns = this.DataEnGuideMap.get(key2);
        }
        buffer.append(dns + ",");
        buffer.append(config.getDefaul_Realm() + ",");
        String host = "";
        String port = "";
        if (!SJctrExtAuthServerUtility.isInvalidStr(config.getDns_Lookup_Kdc())) {
            host = SJctrExtAuthServerUtility.splitKdcToHostName(config.getKdc());
            port = SJctrExtAuthServerUtility.splitKdcToPortNumer(config.getKdc());
        }
        buffer.append(host + ",");
        buffer.append(port + ",");
        String skew = String.valueOf(config.getClockskew());
        buffer.append(skew + ",");
        String timeout = String.valueOf(config.getTimeout());
        buffer.append(timeout + ",");
        String secondary = "";
        String sechost = "";
        String secport = "";
        if (config_sec != null) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            secondary = this.DataEnGuideMap.get(key);
            sechost = SJctrExtAuthServerUtility.splitKdcToHostName(config_sec.getKdc());
            secport = SJctrExtAuthServerUtility.splitKdcToPortNumer(config_sec.getKdc());
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            secondary = this.DataEnGuideMap.get(key);
        }
        buffer.append(secondary + ",");
        buffer.append(sechost + ",");
        buffer.append(secport);
        buffer.append("}\n");
        String data2 = buffer.toString();
        this.detailAuth.add(data2);
        buffer = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_AuthGroup.length; ++index) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_AuthGroup[index][0], KeyTable_DtlInfo_AuthGroup[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key2));
            if (index == KeyTable_DtlInfo_AuthGroup.length - 1) break;
            buffer.append(",");
        }
        this.headAuthGroup = "{" + buffer.toString() + "}" + "=" + "\n";
        if (gconfig == null) {
            buffer = new StringBuffer();
            buffer.append("{");
            String key3 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            authorize = this.DataEnGuideMap.get(key3);
            buffer.append(authorize + ",");
            buffer.append(",,,,,,,,,");
            buffer.append("}");
            data = buffer.toString();
            this.detailAuthGroup.add(data);
        } else {
            buffer = new StringBuffer();
            buffer.append("{");
            String key4 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            authorize = this.DataEnGuideMap.get(key4);
            buffer.append(authorize + ",");
            buffer.append(info.getCertifyFileName() + ",");
            String protocol = "";
            if (SJctrExtAuthServerUtility.isLdapsProtocol(gconfig.getProtocol())) {
                key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LDAPS");
                protocol = this.DataEnGuideMap.get(key2);
            } else if (SJctrExtAuthServerUtility.isStarttlsProtocol(gconfig.getProtocol())) {
                key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "STARTTLS");
                protocol = this.DataEnGuideMap.get(key2);
            }
            buffer.append(protocol + ",");
            String port2 = "";
            if (!SJctrExtAuthServerUtility.isInvalidStr(gconfig.getDnsLookup())) {
                port2 = String.valueOf(gconfig.getPort());
            }
            buffer.append(port2 + ",");
            buffer.append("\n");
            data = buffer.toString();
            this.detailAuthGroup.add(data);
            SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
            StringBuffer buffer2 = new StringBuffer();
            String baseDN = validUtil.replaceStr(gconfig.getSearchDN(), SJctrValidatorUtility.Comma, " ");
            buffer2.append(baseDN + ",");
            String searchDN = validUtil.replaceStr(gconfig.getSearchUserDN(), SJctrValidatorUtility.Comma, " ");
            buffer2.append(searchDN + ",");
            String timeout2 = String.valueOf(gconfig.getTimeout());
            buffer2.append(timeout2 + ",");
            String interval = String.valueOf(gconfig.getRetryInterval());
            buffer2.append(interval + ",");
            String retries = String.valueOf(gconfig.getRetryTimes());
            buffer2.append(retries + ",");
            String secondary2 = "";
            String port3 = "";
            if (gconfig_sec != null) {
                key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
                secondary2 = this.DataEnGuideMap.get(key);
                port3 = String.valueOf(gconfig_sec.getPort());
            } else {
                key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
                secondary2 = this.DataEnGuideMap.get(key);
            }
            buffer2.append(secondary2 + ",");
            buffer2.append(port3);
            buffer2.append("}");
            data2 = buffer2.toString();
            this.detailAuthGroup.add(data2);
        }
        String key5 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_NUM_OF_SERVERS");
        this.footer = this.TitleEnGuideMap.get(key5) + "=" + 1;
    }
}

