/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.addresources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.account.rsg.addresources.SJctrAddResourcesConfirmData;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.creatersgs.SJctrCreateRsgsDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrAddResourcesDC
extends SJctrCreateRsgsDC {
    protected static final int DISP_ID = 0x1001131;
    protected static final String DISP_TITLE = "ADD_RESOURCES";

    public SJctrAddResourcesDC() throws SJcException {
        super(0x1001131);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    protected void initDataModel() {
        this.initSelectionDataModel();
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(SJctrCreateRsgsDC.CREATE_RSGS_MSG.SELECT_SEL_PGS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.selectPgsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrCreateRsgsDC.CREATE_RSGS_MSG.SELECT_SEL_LDEVS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.selectLdevsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrCreateRsgsDC.CREATE_RSGS_MSG.SELECT_SEL_PTS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.selectPortsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrCreateRsgsDC.CREATE_RSGS_MSG.SELECT_SEL_HGS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.selectHgsAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrCreateRsgsDC.CREATE_RSGS_MSG.SELECT_SEL_ISCSIS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.selectIscsisAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddResourcesDC.this.exitSelectResources(event, dstModel);
                SJctrAddResourcesDC.this.setFinishChangeCheck(true);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache(SJmoRSGInfo.class);
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGInfo viewData = (SJmoRSGInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkStartData", "Information of selected RSG is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            List<?> viewDataList = this.getProxy().getCache(SJmoRSGInfo.class);
            SJmoRSGInfo viewData = (SJmoRSGInfo)viewDataList.get(0);
            SJmoRSGgetRsg editRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(viewData.getRsgId(), rsgInfoList);
            if (null == editRsgInfo) {
                this.getLogUty().putlog("checkConstructData", "The resource group to edit does not exist.");
                SJctrError err = new SJctrError(207, 22, 105303);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isSysRsg(editRsgInfo.getRsgInfo()) && !SJcEnvUty.isMPC()) {
                this.getLogUty().putlog("checkConstructData", "Selected RSG is System RSG.");
                throw SJctrRsgUtility.makeException(205172);
            }
            SJmoRSGgetRsg rsg0Info = SJctrRsgUtility.getRsgInfoByRsgId(0, rsgInfoList);
            if (null == rsg0Info) {
                this.getLogUty().putlog("checkConstructData", "Information of RSG0 is null.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (!SJctrRsgUtility.isExistResource(rsg0Info)) {
                this.getLogUty().putlog("checkConstructData", "The resource which can be added does not exist.");
                SJctrError err = new SJctrError(207, 22, 105288);
                SJcException exp = err.createException();
                throw exp;
            }
            this.setAvailableTableData(rsg0Info, rsgInfoList);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrAddResourcesConfirmData confirmData = new SJctrAddResourcesConfirmData();
            List<?> viewDataList = this.getProxy().getCache(SJmoRSGInfo.class);
            SJmoRSGInfo viewData = (SJmoRSGInfo)viewDataList.get(0);
            SJmoRSGgetRsg setRsg = new SJmoRSGgetRsg();
            setRsg.setRsgInfo(viewData);
            SJctrRsgPgsTableModel rsgPgsTable = (SJctrRsgPgsTableModel)this.getDataObjectModel("COM_TABLE_SEL_PGS");
            List<Object> selectedPgsList = rsgPgsTable.getAllRowData();
            Collections.sort((ArrayList)selectedPgsList);
            setRsg.setVdevs((ArrayList)selectedPgsList);
            SJctrRsgLdevsTableModel rsgLdevsTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel("COM_TABLE_SEL_LDEVS");
            List<Object> selectedLdevsList = rsgLdevsTable.getAllRowData();
            Collections.sort((ArrayList)selectedLdevsList);
            setRsg.setLdevs((ArrayList)selectedLdevsList);
            SJctrRsgPortsTableModel rsgPortsTable = (SJctrRsgPortsTableModel)this.getDataObjectModel("COM_TABLE_SEL_PTS");
            List<Object> selectedPortsList = rsgPortsTable.getAllRowData();
            Collections.sort((ArrayList)selectedPortsList);
            setRsg.setPorts((ArrayList)selectedPortsList);
            SJctrRsgHostGroupsTableModel rsgHgsTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel("COM_TABLE_SEL_HGS");
            List<Object> selectedHgsList = rsgHgsTable.getAllRowData();
            SJctrRsgIscsiTargetsTableModel rsgIscsisTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel("COM_TABLE_SEL_ISCSIS");
            List<Object> selectedIscsisList = rsgIscsisTable.getAllRowData();
            ArrayList<SJmoHostGroupIndex> selectedHgIscsiList = new ArrayList<SJmoHostGroupIndex>(selectedHgsList.size() + selectedIscsisList.size());
            selectedHgIscsiList.addAll((ArrayList)selectedHgsList);
            selectedHgIscsiList.addAll((ArrayList)selectedIscsisList);
            Collections.sort(selectedHgIscsiList);
            setRsg.setHostGrps(selectedHgIscsiList);
            SJctrRsgInfo confirmInfo = new SJctrRsgInfo(setRsg);
            ArrayList<SJctrRsgInfo> confirmList = new ArrayList<SJctrRsgInfo>();
            confirmList.add(confirmInfo);
            confirmData.setAddResourcesInfo(confirmList);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddResourcesConfirmData> confirmDataList = new ArrayList<SJctrAddResourcesConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddResourcesConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107003);
        }
        return true;
    }

    @Override
    protected void setAvailableTableData(SJmoRSGgetRsg rsg0Info, List<SJmoRSGgetRsg> rsgInfoList) {
        ArrayList<SJmoPgIndex> pgIndexList = rsg0Info.getVdevs();
        ArrayList pgDetailList = (ArrayList)SJctrRsgUtility.getSJmoPgDetail(this);
        ArrayList vdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoVdevDetail(this);
        ArrayList pdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoPdevDetail(this);
        ArrayList pgStList = (ArrayList)SJctrRsgUtility.getSJmoPgScatteredInfo(this);
        ArrayList pgEncList = (ArrayList)SJctrRsgUtility.getSJmoPgEncryptionInfo(this);
        ArrayList ldevDetailList = (ArrayList)SJctrRsgUtility.getSJmoLdevDetail(this);
        ArrayList ldevStatusList = (ArrayList)SJctrRsgUtility.getSJmoLdevStatusInfo(this);
        ArrayList luseList = (ArrayList)SJctrRsgUtility.getSJmoLdevLuseInfo(this);
        List<SJctrRsgPgInfo> pgTableList = SJctrRsgUtility.createRsgPgInfoList(pgIndexList, pgDetailList, vdevDetailList, pdevDetailList, pgStList, pgEncList, ldevDetailList, ldevStatusList, luseList);
        SJctrRsgPgsTableModel rsgPgsTable = (SJctrRsgPgsTableModel)this.getDataObjectModel("COM_TABLE_AVAIL_PGS");
        rsgPgsTable.setBasicDataList(pgTableList);
        ArrayList<SJmoLdevIndex> ldevIndexList = rsg0Info.getLdevs();
        List<SJmoHUVMVirtualLdev> vLdevList = SJctrRsgUtility.getSJmoHUVMVirtualLdev(this);
        List<SJctrRsgLdevInfo> ldevTableList = SJctrRsgUtility.createRsgLdevInfoList(ldevIndexList, ldevDetailList, vLdevList);
        List<Object> compAvailableList = new ArrayList();
        List<?> targetRsgList = this.getProxy().getCache(SJmoRSGInfo.class);
        SJmoRSGInfo targetRsg = (SJmoRSGInfo)targetRsgList.get(0);
        boolean vdkcResult = SJctrRsgUtility.isDefaultVdkcNumber(targetRsg);
        if (!vdkcResult) {
            for (SJctrRsgLdevInfo checkLdev : ldevTableList) {
                int luPathNum;
                SJmoHUVMVirtualLdev checkData = checkLdev.getVLDEV();
                if (!SJctrRsgUtility.isVirtualLdevHuvmOn(checkData) || SJctrRsgUtility.isVirtualLdevIdReserve(checkData) || (luPathNum = checkLdev.getILUPathNumber()) > 0) continue;
                compAvailableList.add(checkLdev);
            }
        } else {
            compAvailableList = ldevTableList;
        }
        SJctrRsgLdevsTableModel rsgLdevsTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel("COM_TABLE_AVAIL_LDEVS");
        rsgLdevsTable.setBasicDataList(compAvailableList);
        ArrayList<SJmoPortIndex> portIndexList = rsg0Info.getPorts();
        ArrayList portDetailList = (ArrayList)SJctrRsgUtility.getSJmoPortDetail(this);
        List<SJctrRsgPortInfo> portTableList = SJctrRsgUtility.createRsgPortInfoList(portIndexList, portDetailList);
        SJctrRsgPortsTableModel rsgPortTable = (SJctrRsgPortsTableModel)this.getDataObjectModel("COM_TABLE_AVAIL_PTS");
        rsgPortTable.setBasicDataList(portTableList);
        ArrayList<SJmoHostGroupIndex> hgIndexList = rsg0Info.getHostGrps();
        ArrayList<SJctrRsgHostGroupInfo> compHgAvailableList = new ArrayList<SJctrRsgHostGroupInfo>();
        ArrayList<SJctrRsgIscsiTargetInfo> compIscsiAvailableList = new ArrayList<SJctrRsgIscsiTargetInfo>();
        ArrayList hgInfoList = (ArrayList)SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
        List<SJmoPortIscsiTargetInfo> iscsiInfoList = SJctrRsgUtility.getSJmoPortIscsiTargetInfo(this);
        List<SJctrRsgHostGroupIscsiTargetInfo> hgIscsiList = SJctrRsgUtility.createRsgHgIscsiInfoList(hgIndexList, portDetailList, hgInfoList, iscsiInfoList);
        if (!vdkcResult) {
            List<SJmoPortLunInfo> portLuPathList = SJctrRsgUtility.getSJmoPortLunDetail(this);
            for (SJctrRsgHostGroupIscsiTargetInfo checkHgIscsi : hgIscsiList) {
                SJmoPortDetail portDetail;
                if (checkHgIscsi.isExist()) {
                    short hgIscsiId;
                    ArrayList portLunDetailList;
                    boolean luPathResultHg;
                    SJmoPortIndex portIndex = new SJmoPortIndex();
                    portIndex.setSPort(checkHgIscsi.getSPort());
                    SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)SJctrIscsiUtility.getPortInfoByPortIndex(portLuPathList, portIndex);
                    if (portLunInfo != null && (luPathResultHg = SJctrRsgUtility.checkPortLunDetailUsedSpecifiedHg(portLunDetailList = portLunInfo.getAlPortLun(), hgIscsiId = checkHgIscsi.getSHostGroup()))) continue;
                }
                if (SJctrRsgUtility.isFibrePort(portDetail = checkHgIscsi.getPortDetail())) {
                    compHgAvailableList.add((SJctrRsgHostGroupInfo)checkHgIscsi);
                    continue;
                }
                if (!SJctrIscsiUtility.isIscsiPort(portDetail)) continue;
                compIscsiAvailableList.add((SJctrRsgIscsiTargetInfo)checkHgIscsi);
            }
        } else {
            for (SJctrRsgHostGroupIscsiTargetInfo checkHgIscsi : hgIscsiList) {
                SJmoPortDetail portDetail = checkHgIscsi.getPortDetail();
                if (SJctrRsgUtility.isFibrePort(portDetail)) {
                    compHgAvailableList.add((SJctrRsgHostGroupInfo)checkHgIscsi);
                    continue;
                }
                if (!SJctrIscsiUtility.isIscsiPort(portDetail)) continue;
                compIscsiAvailableList.add((SJctrRsgIscsiTargetInfo)checkHgIscsi);
            }
        }
        SJctrRsgHostGroupsTableModel rsgHgTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel("COM_TABLE_AVAIL_HGS");
        rsgHgTable.setBasicDataList(compHgAvailableList);
        SJctrRsgIscsiTargetsTableModel rsgIscsiTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel("COM_TABLE_AVAIL_ISCSIS");
        rsgIscsiTable.setBasicDataList(compIscsiAvailableList);
        if (pgTableList.size() == 0 && portTableList.size() == 0 && compAvailableList.size() == 0 && compHgAvailableList.size() == 0 && compIscsiAvailableList.size() == 0) {
            this.getLogUty().putlog("checkConstructData", "The resource does not exist which can be added.");
            SJctrError err = new SJctrError(207, 22, 105288);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortLunInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

