/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.SJctrPGDriveData;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.column.SJctrPGTableStringColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.volume.SJmoDriveBoxInfo;

public class SJctrPGPropertyDriveTableModel
extends SJctrTableDataModel {
    private List<SJctrPGDriveData> list = new ArrayList<SJctrPGDriveData>();

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void setControllerData() {
        super.setControllerData();
        this.setBasicData(SJctrPGDriveData.class, this.list);
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_LOCATION", "LOCATION", "HDD_LOCATION_TOOLTIP"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_DRIVEBOX", "DRIVE_BOX"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_DRIVEBOXTYPE", "DRIVE_BOX_TYPE"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_DRIVETYPE", "DRIVE_CODE"));
        this.setPrimaryColumn("COM_COL_LOCATION");
        this.setPrimaryClass(SJctrPGDriveData.class);
    }

    public void setupPdevData(List<SJmoDriveBoxInfo> driveBoxInfo, SJctrParityGroupUtility.ScatteredPgInfo selected) {
        this.list.clear();
        for (SJctrParityGroupUtility.PgPdevInfo pg : selected.getPgPdevs()) {
            for (SJmoPdevDetail pdev : pg.getPdevs()) {
                SJctrPGDriveData data = new SJctrPGDriveData();
                Integer cdev = pdev.getCDEV();
                Integer dbType = null;
                for (SJmoDriveBoxInfo dbInfo : driveBoxInfo) {
                    if (dbInfo.getDriveBoxId() != cdev.intValue()) continue;
                    dbType = dbInfo.getDriveBoxType();
                }
                if (dbType != null) {
                    if (dbType == 8) {
                        data.setDriveBox(String.format("DB-%02d&%02d", cdev, cdev + 1));
                    } else if (dbType == 9) {
                        data.setDriveBox(String.format("DB-%02d&%02d", cdev - 1, cdev));
                    } else {
                        data.setDriveBox(String.format("DB-%02d", cdev));
                    }
                } else {
                    data.setDriveBox(String.format("DB-%02d", cdev));
                }
                data.setDriveType(pdev.getHDDKind().trim());
                data.setLocation(pdev.getHDDLocation());
                data.setDriveBoxType(this.resolveDriveBoxType(pdev, driveBoxInfo));
                this.list.add(data);
            }
        }
        this.doRefresh();
    }

    public void setupFreePdevData(Collection<SJctrParityGroupUtility.DriveBoxPdev> freeDriveBoxPdevs) {
        this.list.clear();
        for (SJctrParityGroupUtility.DriveBoxPdev boxPdev : freeDriveBoxPdevs) {
            String type = SJctrParityGroupUtility.RMI_VALUE_DRIVE_BOX_TYPE.get(boxPdev.getDriveBox().getDriveBoxType());
            for (SJmoPdevDetail pdev : boxPdev.getPdevs()) {
                SJctrPGDriveData data = new SJctrPGDriveData();
                Integer cdev = pdev.getCDEV();
                Integer dbType = boxPdev.getDriveBox().getDriveBoxType();
                if (dbType == 8) {
                    data.setDriveBox(String.format("DB-%02d&%02d", cdev, cdev + 1));
                } else if (dbType == 9) {
                    data.setDriveBox(String.format("DB-%02d&%02d", cdev - 1, cdev));
                } else {
                    data.setDriveBox(String.format("DB-%02d", cdev));
                }
                data.setDriveType(pdev.getHDDKind().trim());
                data.setLocation(pdev.getHDDLocation());
                data.setDriveBoxType(type == null ? "-" : type);
                this.list.add(data);
            }
        }
        this.doRefresh();
    }

    private String resolveDriveBoxType(SJmoPdevDetail pdev, List<SJmoDriveBoxInfo> driveBox) {
        for (SJmoDriveBoxInfo box : driveBox) {
            for (int[] pdevId : box.getDriveIds()) {
                if (pdev.getCDEV() != pdevId[0] || pdev.getRDEV() != pdevId[1]) continue;
                String type = SJctrParityGroupUtility.RMI_VALUE_DRIVE_BOX_TYPE.get(box.getDriveBoxType());
                return type == null ? "-" : type;
            }
        }
        return "-";
    }
}

