/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.cntl;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrPGErrorInfo;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;

public class SJctrEditCBMAC
extends SJctrApplyController {
    private static final long serialVersionUID = 1L;
    private List<SJctrPGDetail> pgDetailList;
    private List<SJctrError> resultData = new ArrayList<SJctrError>();
    private boolean isApplyVM = true;
    private boolean isApplyCBM = true;
    private int iApplyType = 0;
    public static final int APPLY_TYPE_VM = 1;
    public static final int APPLY_TYPE_CBM = 2;

    @Override
    public int getLeadTime() {
        return 6;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> list = new ArrayList<SanRequest>();
        try {
            switch (this.iApplyType) {
                case 1: {
                    if (!this.isApplyVM) break;
                    list.add(this.createVirtModeRequest());
                    break;
                }
                case 2: {
                    if (!this.isApplyCBM) break;
                    list.add(this.createRequest());
                    break;
                }
            }
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSetList", "Failed to build set list", e);
        }
        return list;
    }

    private SanRequest createRequest() throws SanDataException {
        if (this.pgDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createRequest", "pgDeitalList is empty");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        SanRequest request = this.newRequest("MNTupdateCopybackMode");
        SanList pgList = request.newList("ParityGroups");
        for (SJctrPGDetail pgIdx : this.pgDetailList) {
            SanObject pg = pgList.addObj();
            pg.putIntArray("Id", new int[]{pgIdx.getFB4(), pgIdx.getPG()});
            pg.putBoolean("Copyback", pgIdx.getCopybackMode() == SJctrParityGroupUtility.RMI_VALUE_COPYBACK_ENABLED);
        }
        return request;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        if (resultObject == null) {
            return;
        }
        if (!(resultObject instanceof SanResponse)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "Unexpected error");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        SanResponse result = (SanResponse)resultObject;
        try {
            this.handleResult(result);
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", e);
        }
    }

    private void handleResult(SanResponse response) throws SanDataException {
        SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(response);
        if (errorInfo.getErrorCode() != 0) {
            SJctrError error = errorInfo.createError();
            this.setError(error);
            if (errorInfo.hasLowerNodeError()) {
                SanList pgList = response.getList("ParityGroups");
                List<SJctrPGDetail> sourcePgs = this.pgDetailList;
                this.resultData = SJctrPGErrorInfo.createStatusList(error.getFunc(), error.getModule(), sourcePgs, pgList);
            }
        }
    }

    public void setWizardSetData(List<SJctrPGDetail> pgDetailList) {
        this.pgDetailList = pgDetailList;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private SanRequest createVirtModeRequest() throws SanDataException {
        if (this.pgDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createVirtModeRequest", "pgDeitalList is empty");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        SanRequest request = this.newRequest("MNTupdateParityGroupSettings");
        SanList pgList = request.newList("ParityGroups");
        for (SJctrPGDetail pgIdx : this.pgDetailList) {
            SanObject pg = pgList.addObj();
            pg.putIntArray("Id", new int[]{pgIdx.getFB4(), pgIdx.getPG()});
            pg.putBoolean("VirtualizationMode", pgIdx.getBVirtMode());
        }
        return request;
    }

    public void setApplyList(boolean bVirtualizationMode, boolean bCopybackMode, int applyType) {
        this.isApplyVM = bVirtualizationMode;
        this.isApplyCBM = bCopybackMode;
        this.iApplyType = applyType;
    }

    public ArrayList getApplyList(List<SJctrPGDetail> pgDtlList, boolean bVirtualizationMode, boolean bCopybackMode) {
        SJctrEditCBMAC ac;
        ArrayList<SJctrEditCBMAC> rtn = new ArrayList<SJctrEditCBMAC>();
        if (bVirtualizationMode) {
            ac = new SJctrEditCBMAC();
            ac.setWizardSetData(pgDtlList);
            ac.setApplyList(bVirtualizationMode, bCopybackMode, 1);
            rtn.add(ac);
        }
        if (bCopybackMode) {
            ac = new SJctrEditCBMAC();
            ac.setWizardSetData(pgDtlList);
            ac.setApplyList(bVirtualizationMode, bCopybackMode, 2);
            rtn.add(ac);
        }
        return rtn;
    }

    @Override
    public boolean hasApplyResult() {
        boolean applyResultFlg = this.getResultData() != null && !this.getResultData().isEmpty();
        return applyResultFlg;
    }
}

