/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrMenuDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmDC;

public class SJctrWizardCrumbTrailModel
extends SJctrMenuDataModel {
    private static final Class<SJctrConfirmDC> CONFIRM_CLASS = SJctrConfirmDC.class;
    private final Map<Class<? extends SJctrSubWizard>, SJctrSubWizard> subWizardMap = new LinkedHashMap<Class<? extends SJctrSubWizard>, SJctrSubWizard>();
    private int wizardIndex = -1;
    private final List<SJctrWizardDataController> wizardList = new ArrayList<SJctrWizardDataController>();

    public SJctrWizardCrumbTrailModel() {
        this.initListener();
    }

    public boolean addSubWizard(Class<? extends SJctrSubWizard> cls) {
        if (this.contains(cls)) {
            return false;
        }
        SJctrUserController userController = this.getDataController().getOwner();
        SJctrWizardWindowDC topWiz = (SJctrWizardWindowDC)this.getDataController();
        if (this.getConfirmDataController() == null) {
            SJctrRelatedDispDataObject relatedDisp = userController.createRelatedDispData(CONFIRM_CLASS);
            SJctrWizardDataController confirmDc = (SJctrWizardDataController)userController.getDataController(relatedDisp);
            confirmDc.setTopWizard(topWiz);
            this.wizardList.add(confirmDc);
        }
        try {
            SJctrSubWizard subWizard = cls.newInstance();
            subWizard.makeWizardDataController(userController);
            this.subWizardMap.put(cls, subWizard);
            List<SJctrWizardDataController> addList = subWizard.getDataControllerList();
            for (SJctrWizardDataController wiz : addList) {
                wiz.setTopWizard(topWiz);
            }
            this.wizardList.addAll(this.wizardList.size() - 1, addList);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    public SJctrSubWizard getSubWizard(Class<? extends SJctrSubWizard> cls) {
        return this.subWizardMap.get(cls);
    }

    public boolean contains(Class<? extends SJctrSubWizard> sub) {
        return this.subWizardMap.containsKey(sub);
    }

    public void doBack() {
        if (this.isBack()) {
            --this.wizardIndex;
        }
    }

    public void doFinish() {
        if (this.isFinish()) {
            this.wizardIndex = this.wizardList.size() - 1;
        }
    }

    public void doNext() {
        if (this.isNext()) {
            ++this.wizardIndex;
        }
    }

    public void doSingleWizard() {
        if (this.wizardIndex < 0) {
            this.wizardIndex = 0;
        }
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        this.makeCrumbTrail();
        return super.getDataObject(inputObject);
    }

    public SJctrWizardDataController getFirstWizardDataController(Class<? extends SJctrSubWizard> cls) {
        List<SJctrWizardDataController> list;
        SJctrWizardDataController wizardDc = null;
        SJctrSubWizard subWizard = this.subWizardMap.get(cls);
        if (subWizard != null && (list = subWizard.getDataControllerList()).size() > 0) {
            wizardDc = list.get(0);
        }
        return wizardDc;
    }

    public SJctrRelatedDispDataObject getNowDisp() {
        SJctrWizardDataController wizard = this.getNowWizardDataController();
        SJctrRelatedDispDataObject relatedDisp = new SJctrRelatedDispDataObject();
        relatedDisp.dispId(wizard.getDisplayId());
        relatedDisp.uId(wizard.getuId());
        Integer status = wizard.isConstruct() ? Integer.valueOf(1) : Integer.valueOf(0);
        relatedDisp.status(status);
        return relatedDisp;
    }

    public SJctrWizardDataController getNextIndexWizardDataController() {
        SJctrWizardDataController retDc = null;
        if (this.wizardList.size() > this.wizardIndex + 1) {
            retDc = this.wizardList.get(this.wizardIndex + 1);
        }
        return retDc;
    }

    public SJctrWizardDataController getNextWizardDataController() {
        SJctrWizardDataController retDc = null;
        if (this.isNext()) {
            retDc = this.wizardList.get(this.wizardIndex + 1);
        }
        return retDc;
    }

    public SJctrWizardDataController getNowWizardDataController() {
        return this.wizardList.get(this.wizardIndex);
    }

    public Class<? extends SJctrSubWizard> getSubWizard(SJctrWizardDataController wizDc) {
        Class<? extends SJctrSubWizard> subWizClass = null;
        block0: for (Map.Entry<Class<? extends SJctrSubWizard>, SJctrSubWizard> entry : this.subWizardMap.entrySet()) {
            for (SJctrWizardDataController dc : entry.getValue().getDataControllerList()) {
                if (dc != wizDc) continue;
                subWizClass = entry.getKey();
                break block0;
            }
        }
        return subWizClass;
    }

    public Collection<SJctrSubWizard> getSubWizardList() {
        return this.subWizardMap.values();
    }

    public boolean isApply() {
        SJctrWizardDataController wizard = this.getNowWizardDataController();
        SJctrWizardDataController confirm = this.getConfirmDataController();
        return wizard.equals(confirm);
    }

    public boolean isBack() {
        return this.wizardIndex > 0;
    }

    public boolean isFinish() {
        SJctrWizardDataController wizard = this.getNowWizardDataController();
        boolean result = false;
        if (wizard == this.getConfirmDataController()) {
            return true;
        }
        for (SJctrSubWizard subWiz : this.getSubWizardList()) {
            if (!subWiz.isLastDataController(wizard)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isNext() {
        return this.wizardIndex < this.wizardList.size() - 2;
    }

    public void removeSubWizard(Class<? extends SJctrSubWizard> cls) {
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrSubWizard subWizard = this.subWizardMap.remove(cls);
        if (subWizard != null) {
            this.wizardList.removeAll(subWizard.getDataControllerList());
            subWizard.removeWizardDataController(uc);
        }
        if (this.wizardList.size() == 1 && this.wizardList.get(0) instanceof SJctrConfirmDC) {
            SJctrWizardDataController confirmDC = this.wizardList.remove(0);
            uc.removeRelatedDispData(confirmDC.getuId());
        }
    }

    public void rollback() {
        SJctrWizardDataController nowWizard = this.getNowWizardDataController();
        this.rollback(nowWizard);
    }

    private void rollback(SJctrWizardDataController nowWizard) {
        Collection<SJctrSubWizard> subWizards = this.getSubWizardList();
        SJctrSubWizard[] subs = new SJctrSubWizard[subWizards.size()];
        subs = subWizards.toArray(subs);
        SJctrWizardDataController confirm = this.getConfirmDataController();
        if (confirm != null && confirm == nowWizard) {
            return;
        }
        if (confirm != null && confirm.isConstruct()) {
            confirm.rollback();
        }
        for (int i = subs.length - 1; i >= 0; --i) {
            List<SJctrWizardDataController> dcList = subs[i].getDataControllerList();
            boolean delSubWizFlg = false;
            for (int j = dcList.size() - 1; j >= 0; --j) {
                SJctrWizardDataController wizard = dcList.get(j);
                if (wizard == nowWizard) {
                    return;
                }
                if (!wizard.isConstruct()) continue;
                wizard.rollback();
                delSubWizFlg = true;
            }
            if (!delSubWizFlg) continue;
            this.removeSubWizard(subs[i].getClass());
        }
    }

    public void abort() {
        this.rollback(null);
    }

    public boolean isDoRollBack() {
        SJctrWizardDataController wizDc = this.getNextWizardDataController();
        if (wizDc != null && wizDc.isConstruct()) {
            return true;
        }
        SJctrWizardDataController confirm = this.getConfirmDataController();
        return confirm != null && confirm.isConstruct();
    }

    protected List<SJctrWizardDataController> getDataControllerList() {
        return this.wizardList;
    }

    private void makeCrumbTrail() {
        this.removeAllItems();
        StringBuilder buf = new StringBuilder();
        SJctrWizardDataController wizard = this.getNowWizardDataController();
        for (SJctrWizardDataController dc : this.wizardList) {
            String label = dc.getDispName();
            buf.append(label);
            String name = buf.toString();
            this.addItem(name, label);
            HashMap<String, Object> item = this.getItem(name);
            SJctrMenuDataModel.Item.setSelect(item, dc == wizard);
            buf.append("\t");
        }
    }

    private SJctrWizardDataController getConfirmDataController() {
        SJctrWizardDataController retDc = null;
        int size = this.wizardList.size();
        if (size > 0) {
            retDc = this.wizardList.get(size - 1);
        }
        return retDc;
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    String select = (String)event.getChangeObject();
                    int count = 0;
                    int result = 0;
                    int fromIndex = 0;
                    while (result != -1) {
                        result = select.indexOf("\t", fromIndex);
                        fromIndex = result + "\t".length();
                        ++count;
                    }
                    SJctrWizardCrumbTrailModel.this.wizardIndex = count - 1;
                    SJctrWizardCrumbTrailModel.this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MOVE_DISP);
                }
            }
        });
    }

    boolean isConstructIndex() {
        return this.wizardIndex >= 0;
    }
}

