/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.alu.cntl;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.cvs.com.SJctrAluErrorInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.alu.cntl.SJctrCreateLDEVsAluConfirmData;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.cntl.SJctrCreateLDEVsBaseAC;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.cntl.SJctrCreateLDEVsBaseConfirmData;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.com.SJctrCreateLDEVsDef;

public class SJctrCreateLDEVsAluAC
extends SJctrCreateLDEVsBaseAC
implements SJctrCreateLDEVsDef,
SJctrCVSMacro {
    public SJctrCreateLDEVsAluAC(SJctrCreateLDEVsBaseConfirmData confirmData, int iApplyType, SJctrComUtility comUty) {
        super(confirmData, iApplyType, comUty);
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> rtn = new ArrayList<SanRequest>();
        switch (this.iApplyType) {
            case 10: {
                rtn.add(this.setApplyData_ALU());
            }
        }
        return rtn;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        if (resultObject instanceof SanResponse) {
            this.setErrData_ALU((SanResponse)resultObject);
        }
        SJctrLogUty.info(this.title, "setApplyResult", resultObject.toString());
    }

    private void setErrData_ALU(SanResponse kvResponse) {
        SJctrError error;
        List<SJctrLDEVDetail> ldevDetailList = ((SJctrCreateLDEVsAluConfirmData)this.confirmData).getLdevDetailList();
        ArrayList<Object> errList = new ArrayList();
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (!errorInfo.hasLowerNodeError()) {
                if (errorInfo.isOverAll()) {
                    this.setError(errorInfo.createError());
                    return;
                }
                return;
            }
            error = errorInfo.createError();
            this.setError(error);
            SanList kvResultLdevs = kvResponse.getList("Alus");
            errList = SJctrAluErrorInfo.createList(kvResultLdevs, SJctrAluErrorInfo.ATTRI_ALU_CREATE);
        }
        catch (SanDataException ex) {
            error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        this.resultData = new ArrayList();
        Collections.sort(ldevDetailList, new SJctrLdevIndexComparator());
        Collections.sort(errList);
        for (SJctrLDEVDetail ldev : ldevDetailList) {
            SJctrError status = null;
            int found = Collections.binarySearch(errList, ldev);
            if (found >= 0) {
                SJctrAluErrorInfo result = (SJctrAluErrorInfo)errList.get(found);
                status = result.createError();
            } else {
                status = new SJctrError(30, 5, 0);
            }
            this.resultData.add(status);
        }
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    private SanRequest setApplyData_ALU() {
        SJctrLogUty.info(this.title, "setApplyData_ALU", "START");
        SanRequest request = this.newRequest("VVOLcreateAlus");
        List<SJctrLDEVDetail> ApplyList = ((SJctrCreateLDEVsAluConfirmData)this.confirmData).getLdevDetailList();
        try {
            SanList ldevs = request.newList("Alus");
            for (int i = 0; i < ApplyList.size(); ++i) {
                SJctrLDEVDetail ldev = ApplyList.get(i);
                SanObject ldevParameter = ldevs.addObj();
                int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                ldevParameter.putIntArray("LdevId", id);
                ldevParameter.putInt("MpUnitId", (int)ldev.getByCurrentMPBladeID());
                ldevParameter.putInt("Ssid", ldev.getISSID());
                SanObject clpr = ldevParameter.newObj("Clpr");
                clpr.putInt("Id", (int)ldev.getSCLPR());
                SJctrLogUty.info(this.title, "setApplyData_ALU", "LDEVID=" + ldev.getIndexKey() + ",MpUnitId=" + ldev.getByCurrentMPBladeID() + ",Ssid=" + ldev.getISSID() + ",Clpr=" + ldev.getSCLPR());
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        SJctrLogUty.info(this.title, "setApplyData_ALU", "END");
        return request;
    }

    @Override
    public ArrayList getACList() {
        ArrayList<SJctrCreateLDEVsAluAC> rtn = new ArrayList<SJctrCreateLDEVsAluAC>();
        rtn.add(new SJctrCreateLDEVsAluAC(this.confirmData, 10, null));
        return rtn;
    }

    @Override
    public int getLeadTime() {
        List<SJctrLDEVDetail> ApplyList = ((SJctrCreateLDEVsAluConfirmData)this.confirmData).getLdevDetailList();
        int leadTime = 0;
        switch (this.iApplyType) {
            case 10: {
                leadTime = (ApplyList.size() / 800 + 1) * 40;
            }
        }
        return leadTime;
    }
}

