/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.basic.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPhysicalLdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoFb4Pg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;
import sanproject.sn2.model.data.volume.SJmoVdevIndex;
import sanproject.sn2.model.data.volume.SJmoVdevLdevInfo;

public class SJctrPGDetail
extends SJmoPgDetail {
    private static Pattern HDD_TYPE_PATTERN = Pattern.compile("(..)...-(.)(...)..");
    private static final String HDD_TYPE_SSD_MLC = "M";
    private static final String HDD_TYPE_FMD = "P";
    private static final long serialVersionUID = -857567141316915853L;
    private SJmoPdevDetail pdev;
    private ArrayList<SJmoVdevDetail> vdevList = new ArrayList();
    private ArrayList<SJctrFreeDetail> TargetFreeList = new ArrayList();
    private ArrayList<SJctrFreeDetail> AllFreeList = new ArrayList();
    private List LdevList = new ArrayList();
    private SJmoPgEncryptionInfo pgEncription;
    private List statuslist = new ArrayList();
    private ArrayList PgScattered = new ArrayList();
    private List LdevNameList = new ArrayList();
    private SJctrPGDetail ScPGTarget;
    private List LuseList = new ArrayList();
    private SJmoExdVolumeInfoFb4Pg exdInfo;
    private ArrayList RscVdevInfoArry = new ArrayList();
    private boolean bDmAttr = false;

    public SJctrPGDetail() {
    }

    public SJctrPGDetail(int iFB4, int iPG) {
        super.setFB4(iFB4);
        super.setPG(iPG);
    }

    public void setExternalData(List<SJmoExdVolumeInfoFb4Pg> pgList) {
        int pgIndex;
        if (pgList != null && (pgIndex = Collections.binarySearch(pgList, this)) >= 0) {
            SJmoExdVolumeInfoFb4Pg exdInfo;
            this.exdInfo = exdInfo = pgList.get(pgIndex);
        }
    }

    public void setPGDetail(SJmoPgDetail pgDetail) {
        super.setBaseEmulationType(pgDetail.getBaseEmulationType());
        super.setCLPR(pgDetail.getCLPR());
        super.setFB4(pgDetail.getFB4());
        super.setHDDType(pgDetail.getHDDType());
        super.setIDataMode(pgDetail.getIDataMode());
        super.setPDEVCount(pgDetail.getPDEVCount());
        super.setPDEVSize(pgDetail.getPDEVSize());
        super.setPG(pgDetail.getPG());
        super.setPGLBASize(pgDetail.getPGLBASize());
        super.setRaidLevel(pgDetail.getRaidLevel());
        super.setDriveType(pgDetail.getDriveType());
        super.setProtectionLevel(pgDetail.getProtectionLevel());
        super.setHDDrpm(pgDetail.getHDDrpm());
        super.setBOdmSetting(pgDetail.getBOdmSetting());
        super.setCopybackMode(pgDetail.getCopybackMode());
        super.setBVirtMode(pgDetail.getBVirtMode());
        super.setBVirtSupport(pgDetail.getBVirtSupport());
    }

    public void setPdevDetail(SJmoPdevDetail pdev) {
        this.pdev = pdev;
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            pg.setPdevDetail(pdev);
        }
    }

    public void setPgEncription(SJmoPgEncryptionInfo pgEncription) {
        this.pgEncription = pgEncription;
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            pg.setPgEncription(pgEncription);
        }
    }

    public void setLDEVStauts(List<SJmoLdevStatusInfo> statuslist) {
        this.statuslist = statuslist;
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            pg.setLDEVStauts(statuslist);
        }
    }

    public byte createPGLdevStatus(List<SJctrPhysicalLdevDetail> phyList) {
        int rtn = 0;
        boolean bFlg = true;
        for (int i = 0; i < phyList.size(); ++i) {
            SJctrPhysicalLdevDetail ldev = phyList.get(i);
            if (!ldev.isVolume()) continue;
            if (bFlg) {
                rtn = ldev.getByStatus();
                bFlg = false;
                continue;
            }
            if (rtn == ldev.getByStatus()) continue;
            rtn = 127;
            break;
        }
        return (byte)rtn;
    }

    public String getStrDriveTypeRPM(SJctrComUtility comUty) {
        String strDriveRpm = "-";
        String Drive = "";
        String rpm = "";
        if (this.getPDEVCount() != 0) {
            if (this.getDriveType() == 0) {
                Drive = comUty.getGuidance("SAS");
                rpm = this.getStrHDDRpm();
                strDriveRpm = Drive + "/" + rpm;
            } else if (this.getDriveType() == 1) {
                Drive = comUty.getGuidance("SATA");
                rpm = this.getStrHDDRpm();
                strDriveRpm = Drive + "/" + rpm;
            } else if (this.getDriveType() == 5) {
                strDriveRpm = Drive = this.getSsdDriveTypeFromHddType(comUty);
            } else if (this.getDriveType() == 9) {
                strDriveRpm = Drive = comUty.getGuidance("FMC");
            }
        }
        return strDriveRpm;
    }

    private String getSsdDriveTypeFromHddType(SJctrComUtility comUty) {
        Matcher matcher;
        String ssdDrive = comUty.getGuidance("SSD");
        if (this.getHDDType() != null && (matcher = HDD_TYPE_PATTERN.matcher(this.getHDDType().trim())).matches()) {
            String rpmOrCell = matcher.group(2);
            if (HDD_TYPE_FMD.equals(rpmOrCell)) {
                ssdDrive = comUty.getGuidance("FMD");
            } else if (HDD_TYPE_SSD_MLC.equals(rpmOrCell)) {
                ssdDrive = comUty.getGuidance("SSD_MLC");
            }
        }
        return ssdDrive;
    }

    private String getStrHDDRpm() {
        String HDDRpm = "";
        double dHDDRpm = 0.0;
        int iHDDRpm = 0;
        if (this.getHDDrpm() % 1000 != 0) {
            dHDDRpm = (double)this.getHDDrpm() / 1000.0;
            HDDRpm = dHDDRpm + "k";
        } else {
            iHDDRpm = this.getHDDrpm() / 1000;
            HDDRpm = iHDDRpm + "k";
        }
        return HDDRpm;
    }

    public void setLDEVList(List list) {
        this.LdevList = list;
    }

    public void setLuseList(List list) {
        this.LuseList = list;
    }

    public void setVdevDetail(SJmoVdevDetail VDEVList) {
        this.vdevList.add(VDEVList);
    }

    public void initEnd() {
        this.TargetFreeList = new ArrayList();
        int index = 0;
        for (int i = 0; i < this.vdevList.size(); ++i) {
            SJmoVdevDetail vdev = this.vdevList.get(i);
            ArrayList vdevldevList = vdev.getAlVdevLdev();
            for (int j = 0; j < vdevldevList.size(); ++j) {
                SJmoVdevLdevInfo ldev = (SJmoVdevLdevInfo)vdevldevList.get(j);
                if (ldev.getByLdevStatus() != 3) continue;
                SJctrFreeDetail free = new SJctrFreeDetail(vdev, index);
                free.setVDEVLdevInf(ldev, this);
                this.TargetFreeList.add(free);
                if (j + 1 == vdevldevList.size()) {
                    free.setBLastFlg(true);
                }
                ++index;
            }
        }
    }

    public ArrayList getTargetFreeData() {
        return this.TargetFreeList;
    }

    public ArrayList getAllFreeData() {
        return this.AllFreeList;
    }

    public ArrayList getVDEVLDEVList() {
        return this.vdevList;
    }

    public int getLDEVNum() {
        int i;
        int rtn = 0;
        for (i = 0; i < this.vdevList.size(); ++i) {
            SJmoVdevDetail vdev = this.vdevList.get(i);
            ArrayList vdevldevList = vdev.getAlVdevLdev();
            for (int j = 0; j < vdevldevList.size(); ++j) {
                SJmoVdevLdevInfo ldev = (SJmoVdevLdevInfo)vdevldevList.get(j);
                if (ldev.getByLdevStatus() == 3) continue;
                ++rtn;
            }
        }
        for (i = 0; i < this.TargetFreeList.size(); ++i) {
            SJctrFreeDetail free = this.TargetFreeList.get(i);
            rtn += free.getAddLDEVNum();
        }
        for (SJmoVdevDetail Vdev : this.vdevList) {
            int index = Collections.binarySearch(this.RscVdevInfoArry, Vdev);
            if (index < 0) continue;
            SJmoVdevDetail VdevDetail = (SJmoVdevDetail)this.RscVdevInfoArry.get(index);
            rtn += VdevDetail.getAlVdevLdev().size();
        }
        return rtn;
    }

    public boolean delLDEVData(SJctrLDEVDetail ldev) {
        boolean rtn = false;
        for (int i = 0; i < this.TargetFreeList.size(); ++i) {
            SJctrFreeDetail free = this.TargetFreeList.get(i);
            rtn = free.delLDEVDetailList(ldev);
        }
        return rtn;
    }

    public SJctrLDEVDetail getTargetLDEV(SJmoLdevIndex ldev) {
        SJctrFreeDetail free;
        SJctrLDEVDetail rtn = null;
        for (int i = 0; i < this.TargetFreeList.size() && (rtn = (free = this.TargetFreeList.get(i)).getTargetLDEVDetail(ldev)) == null; ++i) {
        }
        return rtn;
    }

    public ArrayList<SJctrPhysicalLdevDetail> getPhysicalLdevList() {
        ArrayList<SJctrPhysicalLdevDetail> rtn = new ArrayList<SJctrPhysicalLdevDetail>();
        int iFreeCnt = 0;
        if (this.vdevList != null) {
            for (int i = 0; i < this.vdevList.size(); ++i) {
                SJmoVdevDetail vdev = this.vdevList.get(i);
                ArrayList vdevldevList = vdev.getAlVdevLdev();
                for (int j = 0; j < vdevldevList.size(); ++j) {
                    int iLdevNameIndex;
                    int iStsIndex;
                    int iLdevIndex;
                    SJmoVdevLdevInfo ldev = (SJmoVdevLdevInfo)vdevldevList.get(j);
                    if (ldev.getByLdevStatus() == 3) {
                        SJctrFreeDetail free = this.TargetFreeList.get(iFreeCnt);
                        for (int k = 0; k < free.getAddLDEV().size(); ++k) {
                            SJctrLDEVDetail ctrLDEV = (SJctrLDEVDetail)free.getAddLDEV().get(k);
                            SJctrPhysicalLdevDetail phLdev = new SJctrPhysicalLdevDetail(rtn.size());
                            phLdev.setDetailExData(ctrLDEV);
                            rtn.add(phLdev);
                        }
                        SJctrPhysicalLdevDetail phLdev = new SJctrPhysicalLdevDetail(rtn.size());
                        phLdev.setFreeDetailData(free, iFreeCnt);
                        ++iFreeCnt;
                        rtn.add(phLdev);
                        continue;
                    }
                    SJctrPhysicalLdevDetail phLdev = new SJctrPhysicalLdevDetail(rtn.size());
                    phLdev.setVdevLdevDetailData(ldev);
                    SJmoLdevIndex indexLdev = new SJmoLdevIndex();
                    indexLdev.setLdevIndex(phLdev.getSLdkc(), phLdev.getSCu(), phLdev.getSLdev());
                    if (this.LdevList != null && (iLdevIndex = Collections.binarySearch(this.LdevList, indexLdev)) >= 0) {
                        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.LdevList.get(iLdevIndex);
                        phLdev.setDetailData(ldevDetail);
                    }
                    if (this.statuslist != null && (iStsIndex = Collections.binarySearch(this.statuslist, indexLdev)) >= 0) {
                        SJmoLdevStatusInfo ldevStatus = (SJmoLdevStatusInfo)this.statuslist.get(iStsIndex);
                        phLdev.setStatusData(ldevStatus);
                    }
                    if (this.LdevNameList != null && (iLdevNameIndex = Collections.binarySearch(this.LdevNameList, indexLdev)) >= 0) {
                        SJmoLdevNicknameInfo ldevNameInf = (SJmoLdevNicknameInfo)this.LdevNameList.get(iLdevNameIndex);
                        phLdev.setStrLdevName(ldevNameInf.getStrNickname());
                    }
                    rtn.add(phLdev);
                }
            }
        }
        return rtn;
    }

    public boolean isEnhanced() {
        boolean rtn = false;
        switch (super.getProtectionLevel()) {
            case 2: {
                rtn = true;
                break;
            }
        }
        return rtn;
    }

    public int getEncriptionData() {
        int rtn = 0;
        if (this.pgEncription != null) {
            rtn = this.pgEncription.getEncrypt();
        }
        return rtn;
    }

    public int getEncriptionKey() {
        int rtn = -1;
        if (this.pgEncription != null && this.pgEncription.getEncrypt() == 1) {
            rtn = this.pgEncription.getByEncryptionKeyNumber();
        }
        return rtn;
    }

    public byte getByPGLdevStatus() {
        return this.createPGLdevStatus(this.getPhysicalLdevList());
    }

    public void setBasicDataList(List<SJmoPgDetail> PGDetail, List<SJmoVdevDetail> VdevDetailList, List<SJmoLdevDetail> LdevDetailList, List<SJmoLdevNicknameInfo> LdevNameList) {
        int pgIndex = Collections.binarySearch(PGDetail, this);
        if (pgIndex >= 0) {
            this.setPGDetail(PGDetail.get(pgIndex));
        }
        this.setVdevLDEVlist(VdevDetailList, LdevDetailList, LdevNameList);
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            pg.setScPG(PGDetail, VdevDetailList, LdevDetailList, this, LdevNameList);
        }
        this.createAllFreeList();
    }

    private void setScPG(List<SJmoPgDetail> PGDetail, List<SJmoVdevDetail> VdevDetailList, List<SJmoLdevDetail> LdevDetailList, SJctrPGDetail pg, List<SJmoLdevNicknameInfo> LdevNameList) {
        this.ScPGTarget = pg;
        this.setBasicDataList(PGDetail, VdevDetailList, LdevDetailList, LdevNameList);
    }

    private void setVdevLDEVlist(List<SJmoVdevDetail> VdevDetailList, List<SJmoLdevDetail> LdevDetailList, List<SJmoLdevNicknameInfo> LdevNameList) {
        int vdevIndex;
        SJmoVdevIndex vdev = new SJmoVdevIndex();
        vdev.setFB4(this.getFB4());
        vdev.setPG(this.getPG());
        vdev.setIVdev(1);
        if (VdevDetailList != null && (vdevIndex = Collections.binarySearch(VdevDetailList, vdev)) >= 0) {
            SJmoVdevDetail vdevDtl = VdevDetailList.get(vdevIndex);
            this.setVdevDetail(vdevDtl);
            this.initEnd();
        }
        if (LdevDetailList != null) {
            this.setLDEVList(LdevDetailList);
        }
        if (LdevNameList != null) {
            this.setLdevNameList(LdevNameList);
        }
    }

    public void setLdevNameList(List list) {
        this.LdevNameList = list;
    }

    private void createAllFreeList() {
        for (int i = 0; i < this.TargetFreeList.size(); ++i) {
            this.AllFreeList.add(this.TargetFreeList.get(i));
        }
        int iFreeIndex = this.AllFreeList.size();
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            ArrayList pgFreeList = pg.getTargetFreeData();
            for (int j = 0; j < pgFreeList.size(); ++j) {
                SJctrFreeDetail free = (SJctrFreeDetail)pgFreeList.get(j);
                free.setSelFreeIndex(iFreeIndex);
                this.AllFreeList.add(free);
                ++iFreeIndex;
            }
        }
    }

    public void setPDEVList(List<SJmoPdevDetail> PdevDetailList) {
        if (PdevDetailList != null) {
            for (int j = 0; j < PdevDetailList.size(); ++j) {
                SJmoPdevDetail pdev = PdevDetailList.get(j);
                if (this.getFB4() != pdev.getFB4() || this.getPG() != pdev.getPG()) continue;
                this.setPdevDetail(pdev);
                break;
            }
        }
    }

    public void setEncriptionList(List<SJmoPgEncryptionInfo> EncriptionList) {
        int pgIndex;
        if (EncriptionList != null && (pgIndex = Collections.binarySearch(EncriptionList, this)) >= 0) {
            SJmoPgEncryptionInfo encDtl = EncriptionList.get(pgIndex);
            this.setPgEncription(encDtl);
        }
    }

    public void setPGScatteredList(List<SJmoPgScatteredInfo> pgList) {
        int pgIndex = Collections.binarySearch(pgList, this);
        if (pgIndex >= 0) {
            SJmoPgScatteredInfo pgScttered = pgList.get(pgIndex);
            ArrayList pgSet = pgScttered.getAlPgIndex();
            for (int i = 0; i < pgSet.size(); ++i) {
                SJmoPgIndex wkPg = (SJmoPgIndex)pgSet.get(i);
                SJctrPGDetail pg = new SJctrPGDetail();
                pg.setFB4(wkPg.getFB4());
                pg.setPG(wkPg.getPG());
                this.PgScattered.add(pg);
            }
        }
        block1: for (int i = 0; i < pgList.size(); ++i) {
            SJmoPgScatteredInfo scPg = pgList.get(i);
            ArrayList pgSet = scPg.getAlPgIndex();
            for (int j = 0; j < pgSet.size(); ++j) {
                SJmoPgIndex wkPg = (SJmoPgIndex)pgSet.get(j);
                if (wkPg.getFB4() != this.getFB4() || wkPg.getPG() != this.getPG()) continue;
                this.ScPGTarget = new SJctrPGDetail();
                this.ScPGTarget.setFB4(scPg.getFB4());
                this.ScPGTarget.setPG(scPg.getPG());
                continue block1;
            }
        }
    }

    public ArrayList getPGScatteredList() {
        return this.PgScattered;
    }

    public long getAllTotalLBA() {
        long rtn = 0L;
        ArrayList PhList = this.getAllPhysicalLocation();
        for (int i = 0; i < PhList.size(); ++i) {
            SJctrPhysicalLdevDetail ldev = (SJctrPhysicalLdevDetail)PhList.get(i);
            if (!ldev.isVolume()) continue;
            long wkCap = ldev.getLLDEVLBASize() / 2L;
            rtn += wkCap * 2L;
        }
        if (this.iFB4 >= 1 && this.iFB4 <= 64 || this.iFB4 >= 101 && this.iFB4 <= 16484) {
            ArrayList freeList = this.getAllFreeData();
            for (int j = 0; j < freeList.size(); ++j) {
                SJctrFreeDetail free = (SJctrFreeDetail)freeList.get(j);
                long wkCap = free.getRemainingTotalLBA() / 2L;
                rtn += wkCap * 2L;
            }
        }
        return rtn;
    }

    public long getAllFreeLBA() {
        long rtn = 0L;
        ArrayList freeList = this.getAllFreeData();
        for (int i = 0; i < freeList.size(); ++i) {
            SJctrFreeDetail free = (SJctrFreeDetail)freeList.get(i);
            rtn += free.getRemainingTotalLBA();
        }
        return rtn;
    }

    public byte getAllByPGStatus() {
        return this.createPGLdevStatus(this.getAllPhysicalLocation());
    }

    public ArrayList getAllPhysicalLocation() {
        ArrayList<SJctrPhysicalLdevDetail> rtn = this.getPhysicalLdevList();
        int iFreeIndex = this.TargetFreeList.size();
        int iPhysicalIndex = rtn.size();
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            ArrayList<SJctrPhysicalLdevDetail> PgScPhyLdev = pg.getPhysicalLdevList();
            for (int j = 0; j < PgScPhyLdev.size(); ++j) {
                SJctrPhysicalLdevDetail pysical = PgScPhyLdev.get(j);
                pysical.setIPhysicalIndex(iPhysicalIndex);
                ++iPhysicalIndex;
                if (!pysical.isVolume()) {
                    pysical.setIFreeIndex(iFreeIndex);
                    ++iFreeIndex;
                }
                rtn.add(pysical);
            }
        }
        return rtn;
    }

    public SJctrPGDetail getTopPGDetail() {
        SJctrPGDetail rtn = this;
        if (this.ScPGTarget != null) {
            rtn = this.ScPGTarget;
        }
        return rtn;
    }

    public boolean isScTopPG() {
        boolean rtn = true;
        if (this.ScPGTarget != null) {
            rtn = false;
        }
        return rtn;
    }

    public void setPGDetailEx(SJctrPGDetail pgDetail) {
        this.setPGDetail(pgDetail);
        this.vdevList = pgDetail.getVDEVLDEVList();
        this.PgScattered = pgDetail.getPGScatteredList();
        this.TargetFreeList = pgDetail.getTargetFreeData();
        this.AllFreeList = pgDetail.getAllFreeData();
        this.LdevList = pgDetail.getLdevDetailList();
        this.pgEncription = null;
        this.statuslist = null;
    }

    public int getUnAllocatedNum(SJctrComCVSUtility uty) {
        int rtn = 0;
        ArrayList PhySicalList = this.getAllPhysicalLocation();
        for (int i = 0; i < PhySicalList.size(); ++i) {
            SJctrPhysicalLdevDetail ph = (SJctrPhysicalLdevDetail)PhySicalList.get(i);
            if (!ph.isVolume() || uty.chkLUPath(ph, this.LdevList, this.LuseList)) continue;
            ++rtn;
        }
        return rtn;
    }

    public String getSubSystemData() {
        String rtn = "- / - / -";
        if (this.exdInfo != null) {
            rtn = this.exdInfo.getRmiExdVolumeInfoFb4Pg().getVendor() + " / " + this.exdInfo.getRmiExdVolumeInfoFb4Pg().getProduct() + " / " + this.exdInfo.getRmiExdVolumeInfoFb4Pg().getSerialNumber();
        }
        return rtn;
    }

    public void setRscVdevInfo(List list) {
        this.RscVdevInfoArry = (ArrayList)list.get(0);
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail PGDetail = (SJctrPGDetail)this.PgScattered.get(i);
            PGDetail.setRscVdevInfo(list);
        }
    }

    public ArrayList getRscVdevInfo() {
        return this.RscVdevInfoArry;
    }

    public List getLdevDetailList() {
        return this.LdevList;
    }

    public String getStrCopyBackMode(SJctrComUtility comUty) {
        String CopyBackMode = "-";
        if (this.getCopybackMode() == 1) {
            CopyBackMode = comUty.getGuidance("ENABLE");
        } else if (this.getCopybackMode() == 2) {
            CopyBackMode = comUty.getGuidance("DISABLE");
        }
        return CopyBackMode;
    }

    public boolean getPdevStatusCheck(int iHDDStatus) {
        boolean ret = true;
        if (this.pdev.getHDDStatus() != iHDDStatus) {
            ret = false;
        } else {
            for (int i = 0; i < this.PgScattered.size(); ++i) {
                SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
                if (pg.getPdevStatusCheck(iHDDStatus)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public void setBDmAttri(boolean bDmAttr) {
        this.bDmAttr = bDmAttr;
    }

    public boolean isDmAttri() {
        return this.bDmAttr;
    }

    public long getBasicUsableCapacity() {
        long rtn = 0L;
        if (this.vdevList != null) {
            for (int i = 0; i < this.vdevList.size(); ++i) {
                SJmoVdevDetail vdev = this.vdevList.get(i);
                rtn += vdev.getLVdevPhyLbaSize();
            }
        }
        return rtn;
    }

    public long getScBasicUsableCapacity() {
        long rtn = this.getBasicUsableCapacity();
        for (int i = 0; i < this.PgScattered.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)this.PgScattered.get(i);
            rtn += pg.getBasicUsableCapacity();
        }
        return rtn;
    }
}

