/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.deletelogicaldevices;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.deletelogicaldevices.SJctrDelDrdErrorInfo;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;

public class SJctrDeleteLogicalDevicesAC2
extends SJctrApplyController
implements SJctrCVSMacro {
    private static final long serialVersionUID = -7730319521361532993L;
    public List<SJctrLDEVDetail> ldevDetailList;
    protected List<SJctrError> resultData = new ArrayList<SJctrError>();
    private static final int WATCH_WAIT_INTERVAL = 60000;
    private static final int ERR_CODE_INDIVIDUAL = 3000;
    private static final int ERR_MESSAGEID_FUNC_CVS = 3022;
    private static final int ERR_CODE_LDEV_UNIMPLEMENTED = 208302;
    private static final int ERR_CODE_VFS_AOU_LOGERR = 208000;
    private static final int MONITOR_BACKGROUND_LOG_INTERVAL = 10;
    private int iMonitorBackgroundLogCnt = 10;
    ArrayList<SJctrDelDrdErrorInfo> errDataList = new ArrayList();

    public SJctrDeleteLogicalDevicesAC2() {
        this.setAsync(true);
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        try {
            Object resultObject = null;
            ArrayList<SJctrLDEVDetail> tergetDRDDpList = this.getDRDlist(0);
            ArrayList<SJctrLDEVDetail> tergetDRDSLUList = this.getDRDlist(1);
            ArrayList<Object> drdDpResultList = new ArrayList();
            ArrayList<Object> drdSluResultList = new ArrayList();
            if (tergetDRDDpList.size() > 0) {
                ArrayList<SanRequest> setDpList = new ArrayList<SanRequest>();
                setDpList.add(this.getDRDDelData(tergetDRDDpList));
                resultObject = supplier.applyStart(this.getLockId(), setDpList);
                drdDpResultList = this.setApplyResult((SanResponse)resultObject, "ThinProvisioningVolumes", null);
            }
            if (this.getError().getError() == -1 && tergetDRDSLUList.size() > 0) {
                ArrayList<SanRequest> setSluList = new ArrayList<SanRequest>();
                setSluList.add(this.getSluDrdDelData(tergetDRDSLUList));
                resultObject = supplier.applyStart(this.getLockId(), setSluList);
                drdSluResultList = this.setApplyResult((SanResponse)resultObject, "Slus", tergetDRDSLUList);
            }
            if (this.getError().getError() == -1) {
                super.setApplyResult(resultObject);
                ArrayList<SJctrLDEVDetail> targetDataList = new ArrayList<SJctrLDEVDetail>();
                targetDataList.addAll(tergetDRDDpList);
                targetDataList.addAll(tergetDRDSLUList);
                this.errDataList = new ArrayList();
                this.errDataList.addAll(drdDpResultList);
                this.errDataList.addAll(drdSluResultList);
                Collections.sort(this.errDataList, new SJctrLdevIndexComparator());
                this.resultData = this.createErrData(this.errDataList);
                if (targetDataList.size() == this.errDataList.size()) {
                    SJctrDelDrdErrorInfo errInfo = this.errDataList.get(0);
                    this.setError(errInfo.createError());
                }
            }
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    private SanRequest getDRDDelData(ArrayList<SJctrLDEVDetail> drdList) {
        SanRequest rtn = this.newRequest("VVOLdeleteDataSavingOfThinProvisioningVolumesAsync");
        try {
            SanList ldevs = rtn.newList("ThinProvisioningVolumes");
            for (SJctrLDEVDetail ldev : drdList) {
                SanObject ldevParameter = ldevs.addObj();
                int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                ldevParameter.putIntArray("Id", id);
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return rtn;
    }

    private SanRequest getSluDrdDelData(ArrayList<SJctrLDEVDetail> sluList) {
        SanRequest rtn = this.newRequest("VVOLdeleteDataSavingOfSlusAsync");
        try {
            SanList ldevs = rtn.newList("Slus");
            for (SJctrLDEVDetail ldev : sluList) {
                SanObject ldevParameter = ldevs.addObj();
                ldevParameter.putByteArray("Id", ldev.getBySluID());
                SJctrLogUty.info(this.title, "getSluDrdDelData", "LDEVID=" + ldev.getIndexKey() + ",SLUID=" + SJctrDelDrdErrorInfo.chgByStr(ldev.getBySluID()));
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return rtn;
    }

    private ArrayList<SJctrDelDrdErrorInfo> setApplyResult(SanResponse kvResponse, String strkvResultLdevs, List<SJctrLDEVDetail> tergetDRDSLUList) {
        ArrayList<SJctrDelDrdErrorInfo> errList = new ArrayList<SJctrDelDrdErrorInfo>();
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (!errorInfo.hasLowerNodeError()) {
                if (errorInfo.isOverAll()) {
                    this.setError(errorInfo.createError());
                    return errList;
                }
                return errList;
            }
            SanList kvResultLdevs = kvResponse.getList(strkvResultLdevs);
            errList = SJctrDelDrdErrorInfo.createList(kvResultLdevs, tergetDRDSLUList);
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        Collections.sort(errList);
        return errList;
    }

    private ArrayList<SJctrLDEVDetail> getDRDlist(int iAttri) {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        for (SJctrLDEVDetail ldevDetail : this.ldevDetailList) {
            if (!ldevDetail.isDRD_Attri(iAttri)) continue;
            rtn.add(ldevDetail);
        }
        return rtn;
    }

    private ArrayList<SJctrError> createErrData(ArrayList errDataList) {
        SJctrLogUty.info(this.title, "createErrData", "START");
        ArrayList<SJctrError> rtn = new ArrayList<SJctrError>();
        Collections.sort(this.ldevDetailList, new SJctrLdevIndexComparator());
        for (SJctrLDEVDetail ldev : this.ldevDetailList) {
            SJctrError status = new SJctrError(32, 5, 0);
            int ldevIndex = Collections.binarySearch(errDataList, ldev);
            if (ldevIndex >= 0) {
                SJctrDelDrdErrorInfo error = (SJctrDelDrdErrorInfo)errDataList.get(ldevIndex);
                status = error.createError();
            }
            rtn.add(status);
        }
        SJctrLogUty.info(this.title, "createErrData", "END");
        return rtn;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    public int getLeadTime() {
        int rtn = 0;
        ArrayList<SJctrLDEVDetail> dpDrdList = this.getDRDlist(0);
        ArrayList<SJctrLDEVDetail> sluDrdList = this.getDRDlist(1);
        rtn += this.getDrdTime(dpDrdList);
        return rtn += this.getDrdTime(sluDrdList);
    }

    private int getDrdTime(ArrayList drdList) {
        long lPageTime = 0L;
        for (int i = 0; i < drdList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)drdList.get(i);
            lPageTime += ldev.getLUsedpage() * 42L;
        }
        long ldevSize = drdList.size() / 256;
        long lSizeTime = ldevSize * 61L;
        if (drdList.size() % 256 > 0) {
            lSizeTime += 61L;
        }
        long totalTime = lPageTime + lSizeTime;
        SJctrLogUty.info(this.title, "getDrdTime", "totalTime=" + totalTime);
        if (totalTime > 30000L) {
            totalTime = 30000L;
        }
        return (int)totalTime;
    }

    public void setWizardSetData(List<SJctrLDEVDetail> ldevDetailList) {
        this.ldevDetailList = ldevDetailList;
    }

    @Override
    public boolean isDelDRD() {
        return true;
    }

    public ArrayList<SJctrLDEVDetail> getTargetLdevList() {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        rtn.addAll(this.getDRDlist(0));
        rtn.addAll(this.getDRDlist(1));
        Collections.sort(rtn);
        return rtn;
    }

    private SJctrError createIndividualData(SJctrError error) {
        SJctrError rtn = error;
        if (rtn.getError() == 0 && this.errDataList.size() > 0) {
            rtn = this.errDataList.get(0).createError();
            ArrayList<ArrayList<SJctrError>> List2 = new ArrayList<ArrayList<SJctrError>>();
            List2.add(this.createErrData(this.errDataList));
            super.setResultObjectInTask(List2);
        }
        return rtn;
    }

    @Override
    public SJctrError monitorBackground() {
        SJctrLogUty.info(this.title, "monitorBackground", "START");
        SJctrError rtn = new SJctrError(201, 22, 0);
        ArrayList<SJctrLDEVDetail> alLdevIn = this.getTargetLdevList();
        for (SJctrDelDrdErrorInfo errInfo : this.errDataList) {
            int iLdevIndex = Collections.binarySearch(alLdevIn, errInfo);
            if (0 > iLdevIndex) continue;
            alLdevIn.remove(iLdevIndex);
        }
        ArrayList<SJctrLDEVDetail> alFinishLdevList = new ArrayList<SJctrLDEVDetail>();
        boolean loop = true;
        while (loop) {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception ex) {
                loop = false;
            }
            try {
                if (!this.isPauseMonitor()) {
                    if (0 < alLdevIn.size()) {
                        SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
                        SanRequest direct = agent.newRequest("VVOLreadDataSavingStatusOfThinProvisioningVolumes");
                        SanList reqLdevsList = direct.newList("ThinProvisioningVolumes");
                        for (int i = 0; i < alLdevIn.size(); ++i) {
                            int[] iLdevId = new int[]{alLdevIn.get(i).getSLdkc(), alLdevIn.get(i).getSCu(), alLdevIn.get(i).getSLdev()};
                            SanObject id = reqLdevsList.addObj();
                            id.putIntArray("Id", iLdevId);
                        }
                        SanResponse responseData = agent.getDataInf(direct, true);
                        SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(responseData);
                        if (errorInfo.isOverAll()) {
                            if (this.checkDeleteAsyncException(errorInfo.createError())) continue;
                            rtn = errorInfo.createError();
                            this.setError(rtn);
                            super.setResultObjectInTask(null);
                            loop = false;
                        } else {
                            int iProgress = this.getProgress(responseData, alFinishLdevList, alLdevIn);
                            if (iProgress >= 100) {
                                this.setProgress(100);
                                loop = false;
                            } else if (iProgress < 100 && iProgress >= 0) {
                                this.setProgress(iProgress);
                            } else {
                                rtn = new SJctrError(33, 5, 1049);
                                this.setError(rtn);
                                super.setResultObjectInTask(null);
                                loop = false;
                            }
                        }
                    } else {
                        this.setProgress(100);
                        loop = false;
                    }
                } else {
                    rtn = new SJctrError(201, 22, -1);
                    loop = false;
                }
                ++this.iMonitorBackgroundLogCnt;
            }
            catch (SanDataException ex) {
                SJctrLogUty.error(this.title, "monitorBackground", "Exception", ex);
                rtn = new SJctrError(33, 5, 1049);
                this.setError(rtn);
                super.setResultObjectInTask(null);
                loop = false;
            }
            catch (SJmoException ex) {
                if (SJctrComUtility.checkSVPException(ex)) continue;
                super.setResultObjectInTask(null);
                loop = false;
                throw ex;
            }
        }
        rtn = this.createIndividualData(rtn);
        SJctrLogUty.info(this.title, "monitorBackground", "END");
        return rtn;
    }

    private int getProgress(SanResponse responseData, ArrayList<SJctrLDEVDetail> alFinishLdevList, ArrayList<SJctrLDEVDetail> alLdevIn) {
        int rtn = 0;
        try {
            SanList list = responseData.getList("ThinProvisioningVolumes");
            int iLdevNum = alLdevIn.size() + alFinishLdevList.size() + this.errDataList.size();
            int iLdevProgress = 0;
            for (SanObject ldev : list) {
                int[] messageId;
                int iDataStatus = ldev.getInt("DataSavingStatus");
                int iDataProgress = ldev.getInt("DataSavingStatusProgress");
                boolean bDataDeletingStatus = ldev.getBoolean("DataSavingAsyncDeletingStatus");
                SJctrDelDrdErrorInfo eiLdev = new SJctrDelDrdErrorInfo(ldev);
                int iLdevIndex = Collections.binarySearch(alLdevIn, eiLdev);
                int iErrorCode = eiLdev.createError().getError();
                if (!(this.iMonitorBackgroundLogCnt != 10 || iErrorCode == 208302 || iDataStatus == 7 && bDataDeletingStatus)) {
                    SJctrLogUty.info(this.title, "getProgress", "LDEVID = " + eiLdev.getIndexKey() + " Status = " + iDataStatus + " MonitorPrg = " + iDataProgress + " DelFlg = " + String.valueOf(bDataDeletingStatus));
                }
                if (iErrorCode != 0) {
                    SJctrLDEVDetail rmLdev = alLdevIn.remove(iLdevIndex);
                    if (iErrorCode != 208302) {
                        if (iErrorCode == 208000) {
                            int[] messageId2 = new int[]{3022, 205236};
                            eiLdev.setErrorInfo(3000, messageId2);
                        }
                        this.errDataList.add(eiLdev);
                        continue;
                    }
                    alFinishLdevList.add(rmLdev);
                    continue;
                }
                if (iDataStatus == 6) {
                    messageId = new int[]{3022, 205234};
                    eiLdev.setErrorInfo(3000, messageId);
                    this.errDataList.add(eiLdev);
                    alLdevIn.remove(iLdevIndex);
                    continue;
                }
                if (iDataStatus == 0 && !bDataDeletingStatus) {
                    messageId = new int[]{3022, 205235};
                    eiLdev.setErrorInfo(3000, messageId);
                    this.errDataList.add(eiLdev);
                    alLdevIn.remove(iLdevIndex);
                    continue;
                }
                if (iDataStatus == 2 && !bDataDeletingStatus) {
                    messageId = new int[]{3022, 205237};
                    eiLdev.setErrorInfo(3000, messageId);
                    this.errDataList.add(eiLdev);
                    alLdevIn.remove(iLdevIndex);
                    continue;
                }
                if (iDataStatus == 5 && iDataProgress == -1) {
                    messageId = new int[]{3022, 205241};
                    eiLdev.setErrorInfo(3000, messageId);
                    this.errDataList.add(eiLdev);
                    alLdevIn.remove(iLdevIndex);
                    continue;
                }
                iLdevProgress += iDataProgress;
            }
            if (this.iMonitorBackgroundLogCnt == 10) {
                SJctrLogUty.info(this.title, "getProgress", "Err = " + this.errDataList.size() + " Finish = " + alFinishLdevList.size() + " Monitor = " + alLdevIn.size() + " MonitorPrgTotal = " + iLdevProgress + " Del = " + iLdevNum);
                this.iMonitorBackgroundLogCnt = 0;
            }
            if ((rtn = ((this.errDataList.size() + alFinishLdevList.size()) * 100 + iLdevProgress) / iLdevNum) == 0 && ((this.errDataList.size() + alFinishLdevList.size()) * 100 + iLdevProgress) % iLdevNum != 0) {
                rtn = 1;
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error(this.title, "getProgress", "Exception", ex);
            rtn = -1;
        }
        return rtn;
    }

    private boolean checkDeleteAsyncException(SJctrError error) {
        boolean bResult = false;
        if (error.getFunc() == 34 && error.getModule() == 5 && error.getError() == 58575) {
            bResult = true;
        }
        return bResult;
    }
}

