/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.dc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.controller.com.SJctrFileDownloadDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.concrete.SJctrEnableDisableRadioButtonModel;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogDef;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogUtility;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrDownloadSyslogButtonModel;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrEditAuditSyslogSettingData;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrSendTestButtonModel;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrSyslogFileDownloadIF;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrSyslogTestResultObject;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogUtility;
import sanproject.sn2.controller.wizard.syslogbase.dc.SJctrSyslogSettingBaseSubDC;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrCertificationFileTextBox;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.syslog.communicator.SyslogCommunicator;
import sanproject.syslog.enums.SyslogServerType;
import sanproject.syslog.enums.SyslogType;

public class SJctrEditSyslogSettingSubDC
extends SJctrSyslogSettingBaseSubDC
implements SJctrEditAuditLogDef {
    protected SJctrEnableDisableRadioButtonModel output;
    protected SJctrSendTestButtonModel testButton;
    protected SJctrSyslogTestResultObject testResult;

    public SJctrEditSyslogSettingSubDC(SJctrTabManageDataController managerDC) throws SJcException {
        super(managerDC, SyslogType.Syslog);
    }

    @Override
    public String getTabName() {
        return this.getOwner().getComUtility().getGuidance("SYSLOG_SN2");
    }

    @Override
    public Map<String, SJctrDataObjectModel<?>> getDataObjects() {
        Map<String, SJctrDataObjectModel<?>> map = this.getBaseDataObjects();
        this.output = new SJctrEnableDisableRadioButtonModel();
        map.put("COM_OUTPUT_DETAIL", this.output);
        map.put("COM_DOWNLOAD_SYSLOG", new SJctrDownloadSyslogButtonModel());
        this.testButton = new SJctrSendTestButtonModel();
        map.put("COM_SEND_TEST_SYSLOG", this.testButton);
        this.testResult = new SJctrSyslogTestResultObject();
        map.put("COM_SYSLOG_TEST_RESULT", this.testResult);
        return map;
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.addMessageEventListener(NOTIFY_AUDIT_SYSLOG_SETTINGS.PUSH_DOWNLOAD_SYSLOG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSyslogSettingSubDC.this.doActionDownloadSyslog();
            }
        });
        this.addMessageEventListener(NOTIFY_AUDIT_SYSLOG_SETTINGS.PUSH_SEND_TEST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSyslogSettingSubDC.this.doActionSendTest();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEditAuditSyslogSettingData data = this.getSyslogSettingData();
        this.transfer.organizeDataModel(data);
        this.primary.initItems();
        this.primary.setSelectEnabled(data.isEnablePrimary());
        this.primarySrv.organizeDataModel(data);
        this.secondary.initItems();
        this.secondary.setSelectEnabled(data.isEnableSecondary());
        this.secondarySrv.organizeDataModel(data);
        this.location.setValue(data.getLocation());
        this.timeout.setValue(Integer.toString(data.getTimeout()));
        this.interval.setValue(Integer.toString(data.getInterval()));
        this.retries.setValue(Integer.toString(data.getNumOfRetries()));
        this.output.initItems();
        this.output.setSelectEnabled(data.isEnableOutput());
        this.checkRequiredFile();
        boolean isAllowed = this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(19);
        if (!isAllowed) {
            this.primary.setEnable(false);
            this.primarySrv.setEnableAll(false);
            this.secondary.setEnable(false);
            this.secondarySrv.setEnableAll(false);
            this.location.setEnable(false);
            this.timeout.setEnable(false);
            this.interval.setEnable(false);
            this.retries.setEnable(false);
            this.output.setEnable(false);
            this.testButton.setEnable(false);
        }
        return true;
    }

    private SJctrEditAuditSyslogSettingData getSyslogSettingData() {
        SJctrEditAuditSyslogSettingData data = new SJctrEditAuditSyslogSettingData(SJctrEditAuditLogUtility.getAuditConfigData());
        ArrayList<SJctrEditAuditSyslogSettingData> array = new ArrayList<SJctrEditAuditSyslogSettingData>();
        array.add(data);
        this.putCache(KEY_CLASS_SYSLOG_SETTING_DATA, array);
        return data;
    }

    @Override
    public boolean checkEndData() {
        this.testResult.clearResult();
        return this.checkEndBaseData();
    }

    @Override
    public void createInheritedData(SJctrMultiInheritedData data) {
        SJctrEditAuditSyslogSettingData syslogData = this.getUpdatedCache();
        SyslogCommunicator communicator = SyslogCommunicator.createCertificateCommitter(SyslogType.Syslog, syslogData.isUploadedClientPrimary(), syslogData.getPassPrimary(), syslogData.isUploadedClientSecondary(), syslogData.getPassSecondary(), syslogData.isUploadedRootPrimary(), syslogData.isUploadedRootSecondary());
        if (syslogData.isEdited() && syslogData.isSelectedTLS()) {
            syslogData.setCommunicator(communicator);
        }
        data.putInheritedData(KEY_CLASS_SYSLOG_SETTING_DATA, this.getCache(KEY_CLASS_SYSLOG_SETTING_DATA));
    }

    private SJctrEditAuditSyslogSettingData getUpdatedCache() {
        List<?> list = this.getCache(KEY_CLASS_SYSLOG_SETTING_DATA);
        SJctrEditAuditSyslogSettingData syslogData = (SJctrEditAuditSyslogSettingData)list.get(0);
        this.setBaseInheritedData(syslogData);
        syslogData.setEnabledOutput(this.output.isSelectedEnable());
        return syslogData;
    }

    private void doActionDownloadSyslog() {
        this.testResult.clearResult();
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = this.createDialog(SJctrFileDownloadDataController.class, null);
        SJctrFileDownloadDataController dialog = (SJctrFileDownloadDataController)uc.getDataController(relatedDisp);
        SJctrSyslogFileDownloadIF download = null;
        if (this.transfer.getSelected() == 1) {
            download = new SJctrSyslogFileDownloadIF(this.getManagerDC(), 1);
        } else if (this.transfer.getSelected() == 2) {
            download = new SJctrSyslogFileDownloadIF(this.getManagerDC(), 2);
        }
        if (download != null) {
            dialog.setFileDownload(download);
            this.addUpdateDisp(relatedDisp);
        }
        this.setDirtyAll();
    }

    private void doActionSendTestPrimary(SJctrEditAuditSyslogSettingData syslogData, String userName, String serialNo, String sessionID) {
        SJcMessage msg = null;
        if (syslogData.getTransportType() == 2) {
            if (this.primary.isSelectedEnable()) {
                msg = SyslogCommunicator.sendTLS(SyslogType.Syslog, SyslogServerType.Primary, syslogData.isUploadedClientPrimary(), syslogData.getPassPrimary(), syslogData.isUploadedRootPrimary(), syslogData.getIpTextPrimary(), syslogData.getPortNumPrimary(), (byte)syslogData.getTimeout(), serialNo, userName, syslogData.getLocation(), sessionID);
            }
        } else if (this.primary.isSelectedEnable()) {
            msg = SyslogCommunicator.sendUDP(SyslogType.Syslog, SyslogServerType.Primary, syslogData.getIpTextPrimary(), syslogData.getPortNumPrimary(), serialNo, userName, syslogData.getLocation(), sessionID);
        }
        this.testResult.setResultPrimary(msg);
    }

    private void doActionSendTestSecondary(SJctrEditAuditSyslogSettingData syslogData, String userName, String serialNo, String sessionID) {
        SJcMessage msg = null;
        if (syslogData.getTransportType() == 2) {
            if (this.secondary.isSelectedEnable()) {
                msg = SyslogCommunicator.sendTLS(SyslogType.Syslog, SyslogServerType.Secondary, syslogData.isUploadedClientSecondary(), syslogData.getPassSecondary(), syslogData.isUploadedRootSecondary(), syslogData.getIpTextSecondary(), syslogData.getPortNumSecondary(), (byte)syslogData.getTimeout(), serialNo, userName, syslogData.getLocation(), sessionID);
            }
        } else if (this.secondary.isSelectedEnable()) {
            msg = SyslogCommunicator.sendUDP(SyslogType.Syslog, SyslogServerType.Secondary, syslogData.getIpTextSecondary(), syslogData.getPortNumSecondary(), serialNo, userName, syslogData.getLocation(), sessionID);
        }
        this.testResult.setResultSecondary(msg);
    }

    private void doActionSendTest() {
        SJctrEditAuditSyslogSettingData syslogData = this.getUpdatedCache();
        String userName = this.getOwner().getUserSession().getUserName();
        int sessionID = this.getOwner().getUserSession().getSessionIdentificationID();
        String strSessionID = String.valueOf(sessionID);
        String serialNo = SJcProductUty.getSerialNumber();
        serialNo = SJctrSyslogUtility.paddingZeroHead(serialNo, 5);
        this.testResult.clearResult();
        this.checkEndBaseData();
        this.doActionSendTestPrimary(syslogData, userName, serialNo, strSessionID);
        this.doActionSendTestSecondary(syslogData, userName, serialNo, strSessionID);
        this.setDirtyAll();
    }

    @Override
    protected void openFileDialog(SJctrCertificationFileTextBox crt) {
        this.testResult.clearResult();
        super.openFileDialog(crt);
    }

    public static enum NOTIFY_AUDIT_SYSLOG_SETTINGS implements SJctrNotifyState
    {
        PUSH_DOWNLOAD_SYSLOG,
        PUSH_SEND_TEST,
        PUSH_SEND_TEST_PRIMARY,
        PUSH_SEND_TEST_SECONDARY;

    }
}

