/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.restorekeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrFileUploadDataController;
import sanproject.sn2.controller.com.SJctrFileUploadInterface;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.encryption.restorekeys.SJctrRestoreEncryptionKeysFileUpload;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;

public class SJctrRestoreKeysDC
extends SJctrWizardDataController {
    protected static final int DISP_ID = 17828193;
    public SJctrSimpleDataModel filenameLabel;
    private SJctrTextBoxDataModel passwordText;
    private SJctrButtonDataModel browsButton = null;
    private SJctrFooterDataModel footer;
    SJctrRestoreEncryptionKeysFileUpload uploadFile = null;
    private byte[] byRstData = null;

    public SJctrRestoreKeysDC() {
        super(17828193);
        this.initDataModel();
        this.initListener();
    }

    public SJctrRestoreKeysDC(int dispId) {
        super(dispId);
        this.initDataModel();
        this.initListener();
    }

    protected void initDataModel() {
        this.filenameLabel = new SJctrSimpleDataModel();
        this.addDataObjectModel("COM_FILE_NAME", this.filenameLabel);
        ((SJctrDataObject)this.filenameLabel.getManageData()).setData("COM_LABEL", "");
        this.passwordText = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_PASSWORD", this.passwordText);
        this.browsButton = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_BROWSE_BTN", this.browsButton);
        this.browsButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrRestoreKeysDC.this.fireMessageEvent(SELECT_RK_MSG.BROWS);
                }
            }
        });
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_RK_MSG.BROWS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRestoreKeysDC.this.browsEvent();
                SJctrRestoreKeysDC.this.chkFinishBtn(true);
            }
        });
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        if (SJcFileUty.exists("enctmp")) {
            SJcFileUty.deleteFile("", "enctmp");
        }
    }

    public void browsEvent() {
        SJctrRelatedDispDataObject encfileUploadDO = null;
        String strOrgFileName = "";
        this.uploadFile = new SJctrRestoreEncryptionKeysFileUpload();
        this.uploadFile.setRestoreKeysData(this);
        encfileUploadDO = this.createFileUpload(this.uploadFile);
        this.addUpdateDisp(encfileUploadDO);
    }

    @Override
    public SJctrRelatedDispDataObject createFileUpload(SJctrFileUploadInterface fileUploadIF) {
        SJctrFileUploadDataController restoreKeysUploadDC = null;
        SJctrRelatedDispDataObject restoreKeysUploadDO = null;
        Object taskData = null;
        Object restoreKeysSubWiz = null;
        restoreKeysUploadDO = this.createDialog(SJctrFileUploadDataController.class, null);
        restoreKeysUploadDC = (SJctrFileUploadDataController)this.getOwner().getDataController(restoreKeysUploadDO);
        restoreKeysUploadDC.setFileUpload(fileUploadIF);
        return restoreKeysUploadDO;
    }

    @Override
    public boolean checkEndData() {
        boolean bRtn = true;
        ArrayList<byte[]> restoreDataList = new ArrayList<byte[]>();
        bRtn = this.getComUtility().getEncryptionKeysUtility().checkStringLength(this.passwordText.getValue(), 6, 255);
        if (!bRtn) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        restoreDataList.add(this.byRstData);
        this.putCache("KEY_RESTORE_DATA", restoreDataList);
        this.chkFinishBtn(false);
        return bRtn;
    }

    @Override
    public String getDispName() {
        String strTaskName = this.getComUtility().getGuidance("RESTORE_KEYS_FROM_FILE");
        return strTaskName;
    }

    public void setRestoreData(byte[] byRestoreData) {
        this.byRstData = byRestoreData;
    }

    @Override
    public boolean checkConstructData() {
        SJmoEncryptionKeyInfoMgr mgr;
        SJmoEncryptionKeyGenerationInfo chkPolicy;
        List<SJmoEncryptionKeyInfoMgr> encKeyMgrList;
        boolean bResult = true;
        int iCnt = 0;
        List<Object> pgEncryptionList = new ArrayList();
        ArrayList<Object> pgLdevList = new ArrayList();
        ArrayList<Object> ldevStatusList = new ArrayList();
        ArrayList pgldevIndexList = new ArrayList();
        pgEncryptionList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_PGENCRYPTION_INFO);
        pgLdevList = new ArrayList(this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_PGLDEV_INFO));
        ldevStatusList = new ArrayList(this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_LDEVSTATUS_INFO));
        Collections.sort(pgLdevList);
        Collections.sort(ldevStatusList);
        if (pgEncryptionList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "pgEncryptionList size 0");
        }
        if ((encKeyMgrList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR)).size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "encKeyMgrList size0");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        if ((chkPolicy = (mgr = (SJmoEncryptionKeyInfoMgr)encKeyMgrList.get(0)).getGenerationInfo()).getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(encKeyMgrList);
        for (iCnt = 0; iCnt < pgEncryptionList.size(); ++iCnt) {
            SJmoPgEncryptionInfo pgEncryption = (SJmoPgEncryptionInfo)pgEncryptionList.get(iCnt);
            if (pgEncryption.getEncrypt() != 1) continue;
            int iIndex = Collections.binarySearch(pgLdevList, pgEncryption);
            if (iIndex >= 0) {
                SJmoPgLdevInfo pgLdev = (SJmoPgLdevInfo)pgLdevList.get(iIndex);
                pgldevIndexList = pgLdev.getAlLdevIndex();
                bResult = this.checkLdevBlocked(pgldevIndexList, ldevStatusList);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "pgIndex not found");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return bResult;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> setReq = super.getModelDirect();
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_PGENCRYPTION_INFO));
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_PGLDEV_INFO));
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_LDEVSTATUS_INFO));
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        return setReq;
    }

    public SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        SJmoGetKind_IF kind = null;
        SJmoGetRange_IF range = null;
        ArrayList filterList = null;
        SJmoGetDirect direct = null;
        try {
            kind = reqClass.newInstance();
            range = null;
            filterList = new ArrayList();
            direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return directWrapper;
    }

    public boolean checkLdevBlocked(List pgLdevIndex, List ldevStatusList) {
        boolean bResult = true;
        int iCnt = 0;
        for (iCnt = 0; iCnt < pgLdevIndex.size(); ++iCnt) {
            SJmoLdevIndex pgldevIndex = (SJmoLdevIndex)pgLdevIndex.get(iCnt);
            int ldevIndex = Collections.binarySearch(ldevStatusList, pgldevIndex);
            if (ldevIndex >= 0) {
                SJmoLdevStatusInfo ldevStatus = (SJmoLdevStatusInfo)ldevStatusList.get(ldevIndex);
                if (ldevStatus.getLDEVStatus() == 2) continue;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLdevBlocked", "LdevStatus is not Blocked. ");
                SJctrEncryptionKeysUtility.createErrorDialog(106088);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLdevBlocked", "ldevIndex not found");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return bResult;
    }

    public void chkFinishBtn(boolean bFlg) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel("COM_FOOTER");
        SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(bFlg);
    }

    public static enum SELECT_RK_MSG implements SJctrNotifyState
    {
        BROWS;

    }
}

