/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.environmental;

import java.io.Serializable;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.wizard.environmental.com.SJctrEnvironmentalDataMacro;

public class SJctrEnvUtility {
    public static final String KEY_ALERTS_POLING = "SN_ALERTS_POLING";
    public static final String KEY_TASK_MODIFY_POLING = "SN_TASK_MODIFY_POLING";
    public static final int POLING_DEF = 60;
    public static final int POLING_MAX = 3600;
    public static final int POLING_MIN = 10;
    public static final int POLING_NOUPDATE = 0;
    static final String LOG_FUNCTION = "EnvUtility";
    static final String LOG_TITLE = "SJctrEnvUtility";
    public static int iFUNCTION_CODE = 0;
    public static int iMODULE_CODE = 22;
    public static int EDITINFO_ERR1 = 107001;

    public static String getUserProperty(SJctrUserController userCtr, String key) {
        String LOG_SUBTITLE = "getUserProperty";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getUserProperty", "Start.");
        String strRet = null;
        if (null == userCtr) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUserProperty", "SJctrUserController is null");
            SJctrError err = new SJctrError(iFUNCTION_CODE, iMODULE_CODE, EDITINFO_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseUserSessionInterface userSession = userCtr.getUserSession();
        if (null == userSession) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUserProperty", "SJbaseUserSessionInterface is null");
            SJctrError err = new SJctrError(iFUNCTION_CODE, iMODULE_CODE, EDITINFO_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        strRet = KEY_ALERTS_POLING == key ? SJctrEnvUtility.getAlertsPoling(userSession, key) : (KEY_TASK_MODIFY_POLING == key ? SJctrEnvUtility.getTaskModifyPoling(userSession, key) : null);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getUserProperty", "End.");
        return strRet;
    }

    public static int getUserPropertyToInt(SJctrUserController userCtr, String key) {
        String LOG_SUBTITLE = "getUserPropertyToInt";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getUserPropertyToInt", "Start.");
        int iRet = Integer.valueOf(SJctrEnvUtility.getUserProperty(userCtr, key));
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getUserPropertyToInt", "End.");
        return iRet;
    }

    private static String getAlertsPoling(SJbaseUserSessionInterface userSession, String key) {
        String LOG_SUBTITLE = "getAlertsPoling";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAlertsPoling", "Start.");
        String strRet = null;
        Serializable serAlertPoling = userSession.getUserProperty(key);
        if (null == serAlertPoling) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAlertsPoling", "serAlertPoling is null");
            int iAlertPoling = SJcEnvUty.getProperty2int(key, 60000);
            if (iAlertPoling < 10000 || iAlertPoling > 3600000) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAlertsPoling", "iAlertPoling is outside the range [" + String.valueOf(iAlertPoling) + "]");
                iAlertPoling = 60000;
            }
            strRet = String.valueOf(iAlertPoling / 1000);
        } else {
            strRet = serAlertPoling.toString();
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAlertsPoling", "End.");
        return strRet;
    }

    private static String getTaskModifyPoling(SJbaseUserSessionInterface userSession, String key) {
        String LOG_SUBTITLE = "getTaskModifyPoling";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getTaskModifyPoling", "Start.");
        String strRet = null;
        Serializable selTaskPoling = userSession.getUserProperty(key);
        if (null == selTaskPoling) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTaskModifyPoling", "selTaskPoling is null");
            int iTaskPoling = SJcEnvUty.getProperty2int(key, 60);
            if ((iTaskPoling < 10 || iTaskPoling > 3600) && 0 != iTaskPoling) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTaskModifyPoling", "iTaskPoling is outside the range [" + String.valueOf(iTaskPoling) + "]");
                iTaskPoling = 60;
            }
            strRet = String.valueOf(iTaskPoling);
        } else {
            strRet = selTaskPoling.toString();
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getTaskModifyPoling", "End.");
        return strRet;
    }

    public static SJcException convEnvLogicErrorException(SJcException e, int errCode) {
        if (e != null) {
            SJcMessage msgObj = e.getMsg();
            if (!msgObj.getFunctionID().equals(Integer.toString(SJctrEnvironmentalDataMacro.iFUNCTION_CODE))) {
                return e;
            }
            if (!msgObj.getModuleID().equals(Integer.toString(SJctrEnvironmentalDataMacro.iMODULE_CODE))) {
                return e;
            }
            if (!msgObj.getMsgID().equals(Integer.toString(107001))) {
                return e;
            }
        }
        return SJctrEnvUtility.makeException(errCode);
    }

    public static SJcException makeException(int errCode) {
        return SJctrEnvUtility.makeError(errCode).createException();
    }

    public static SJctrError makeError(int errCode) {
        SJctrError err = new SJctrError(SJctrEnvironmentalDataMacro.iFUNCTION_CODE, SJctrEnvironmentalDataMacro.iMODULE_CODE, errCode);
        return err;
    }
}

