/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addiscsihosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.column.SJctrHostNameColumnFromPortHostGroupWwnTableKey;
import sanproject.sn2.controller.com.column.SJctrHostWwnColumnFromPortHostGroupWwnTableKey;
import sanproject.sn2.controller.com.column.SJctrNewHostColumnFromAddHostsTableKey;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromAddHostsTableKey;
import sanproject.sn2.controller.com.column.iscsi.SJctrNumIscsiTargetColumnFromPortHostGroupWwnTableKey;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.lunm.addiscsihosts.SJctrAddHostsIscsiDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrModelDataCheck;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrAvailableHostsIscsiTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_PTNAME = "COM_COL_PTNAME";
    public static final String KEY_COL_HBA_ISCSI_NAME = "COM_COL_HBA_ISCSI_NAME";
    public static final String KEY_COL_HTNAME = "COM_COL_HTNAME";
    public static final String KEY_COL_ISCSI_NUM = "COM_COL_ISCSI_NUM";
    public static final String KEY_COL_HTNEW = "COM_COL_HTNEW";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    public static final String KEY_ADDNEWHOST = "COM_ADDNEWHOST";
    public static final int AVAILABLE_DEFAULT_SIZE = 100;
    private HashSet<String> usedIscsiName;
    private HashSet<String> usedNickname;

    public SJctrAvailableHostsIscsiTableModel() {
        this(true);
        this.usedIscsiName = new HashSet(100);
        this.usedNickname = new HashSet(100);
    }

    public SJctrAvailableHostsIscsiTableModel(boolean paging) {
        super(paging);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        ArrayList<SJctrAddHostsTableKey> retList = new ArrayList<SJctrAddHostsTableKey>(100);
        ArrayList<SJmoIscsiName> availableIscsiNameList = new ArrayList<SJmoIscsiName>(100);
        this.getUsedIscsiNameData(this.usedIscsiName, this.usedNickname);
        this.collectPortIscsiTargetInfoIscsiName(this.usedIscsiName, this.usedNickname, retList, availableIscsiNameList);
        this.collectLoginIscsiName(this.usedIscsiName, this.usedNickname, retList, availableIscsiNameList);
        Collections.sort(retList);
        SJctrAddHostsIscsiDC dc = (SJctrAddHostsIscsiDC)this.getDataController();
        dc.availableIscsiNameList = availableIscsiNameList;
        return retList;
    }

    private void getUsedIscsiNameData(HashSet<String> usedIscsiName, HashSet<String> usedNickname) {
        List<SJctrPortHostGroupTableKey> ctrPtItIdx = this.getDataController().getProxy().getCache("KEY_CLASS_PORTITINDEX");
        List<SJmoPortIscsiTargetInfo> mdlAllPtIt = this.getDataController().getProxy().getCache(SJctrAddHostsIscsiDC.KEY_CLASS_MPORTIT);
        SJctrModelDataCheck.getUsedIscsiNameData(ctrPtItIdx, mdlAllPtIt, usedIscsiName, usedNickname);
    }

    private void collectPortIscsiTargetInfoIscsiName(HashSet<String> usedIscsiName, HashSet<String> usedNickname, List<SJctrAddHostsTableKey> retList, List<SJmoIscsiName> availableIscsiNameList) {
        List<?> mdlAllPtIt = this.getDataController().getProxy().getCache(SJctrAddHostsIscsiDC.KEY_CLASS_MPORTIT);
        if (mdlAllPtIt == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "collectPortHostGroupInfoWwn", "SJmoGetPortIscsiTargetInto Not Found in the Cache.");
            mdlAllPtIt = new ArrayList();
        }
        HashSet<String> portIscsiNameKeySet = new HashSet<String>(65025);
        for (SJmoPortIscsiTargetInfo mdlPtIt : mdlAllPtIt) {
            for (SJmoIscsiTargetInfo mdlIt : mdlPtIt.getAlPortIscsiTarget()) {
                for (SJmoIscsiName mdlPtItIscsiName : mdlIt.getAlIscsiName()) {
                    SJctrAddHostsTableKey hostKey;
                    String portIscsiNameKey;
                    String iscsinameStr = mdlPtItIscsiName.getStrIscsiName();
                    String nickName = mdlPtItIscsiName.getStrIscsiNickName();
                    if (usedIscsiName.contains(iscsinameStr) || usedNickname.contains(nickName) || portIscsiNameKeySet.contains(portIscsiNameKey = this.makePortIscsiNameString(hostKey = new SJctrAddHostsTableKey(mdlPtIt, mdlIt, mdlPtItIscsiName, false)))) continue;
                    retList.add(hostKey);
                    availableIscsiNameList.add(mdlPtItIscsiName);
                    portIscsiNameKeySet.add(portIscsiNameKey);
                }
            }
        }
    }

    private void collectLoginIscsiName(HashSet<String> usedIscsiName, HashSet<String> usedNickname, List<SJctrAddHostsTableKey> retList, List<SJmoIscsiName> availableIscsiNameList) {
        HashSet<String> portIscsiNameSet = new HashSet<String>(retList.size() * 4 / 3 + 1);
        for (SJctrAddHostsTableKey addHostsKey : retList) {
            String portIscsiNameKey = this.makePortIscsiNameString(addHostsKey);
            portIscsiNameSet.add(portIscsiNameKey);
        }
        List<?> mdlAllPtIscsiName = this.getDataController().getProxy().getCache(SJctrAddHostsIscsiDC.KEY_CLASS_MPORTISCSINAME);
        if (mdlAllPtIscsiName == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "collectLoginIscsiName", "SJmoGetPortIscsiNameInfo Not Found in the Cache.");
            mdlAllPtIscsiName = new ArrayList();
        }
        for (SJmoPortIscsiNameInfo mdlPtIscsiName : mdlAllPtIscsiName) {
            for (SJmoIscsiName mdlLoginIscsiName : mdlPtIscsiName.getAlPortIscsiName()) {
                String iscsiNameStr = mdlLoginIscsiName.getStrIscsiName();
                String nickName = mdlLoginIscsiName.getStrIscsiNickName();
                if (usedIscsiName.contains(iscsiNameStr) || usedNickname.contains(nickName)) continue;
                short port = mdlPtIscsiName.getSPort();
                SJmoPortIscsiTargetInfo newPtItInfo = new SJmoPortIscsiTargetInfo();
                newPtItInfo.setSPort(port);
                SJmoIscsiTargetInfo newItInfo = new SJmoIscsiTargetInfo();
                SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtItInfo, newItInfo, mdlLoginIscsiName, false);
                String portIscsiNameKey = this.makePortIscsiNameString(hostKey);
                if (portIscsiNameSet.contains(portIscsiNameKey)) continue;
                retList.add(hostKey);
                availableIscsiNameList.add(mdlLoginIscsiName);
            }
        }
    }

    private String makePortIscsiNameString(SJctrAddHostsTableKey addHostsKey) {
        SJmoPortIscsiTargetInfo portIt = addHostsKey.getPortIscsiTargetInfo();
        SJmoIscsiName iscsiNameInfo = addHostsKey.getIscsiNameInfo();
        return SJctrComUtility.toPaddingZeroString(portIt.getSPort(), 5) + iscsiNameInfo.getStrIscsiName();
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromAddHostsTableKey(KEY_COL_PTNAME));
        SJctrHostWwnColumnFromPortHostGroupWwnTableKey iscsiName = new SJctrHostWwnColumnFromPortHostGroupWwnTableKey(KEY_COL_HBA_ISCSI_NAME);
        iscsiName.setPartsId("HBA_ISCSI_NAME");
        this.addColumn(iscsiName);
        this.addColumn(new SJctrHostNameColumnFromPortHostGroupWwnTableKey(KEY_COL_HTNAME));
        this.addColumn(new SJctrNumIscsiTargetColumnFromPortHostGroupWwnTableKey(KEY_COL_ISCSI_NUM));
        this.addColumn(new SJctrNewHostColumnFromAddHostsTableKey(KEY_COL_HTNEW));
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        SJctrButtonDataModel detail = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        this.fireMessageEvent(SJctrAddHostsIscsiDC.NOTIFY_ADD_HOSTS.ADD_NEW_HOST);
                    }
                });
            }
        };
        buttonGroup.addDataModel(KEY_ADDNEWHOST, detail);
        this.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
    }

    public HashSet<String> getUsedIscsiName() {
        return this.usedIscsiName;
    }

    public HashSet<String> getUsedNickname() {
        return this.usedNickname;
    }

    public void setUsedIscsiName(HashSet<String> usedIscsiName) {
        this.usedIscsiName = usedIscsiName;
    }

    public void setUsedNickName(HashSet<String> usedNickname) {
        this.usedNickname = usedNickname;
    }
}

