/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.delhg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrHGInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrConfirmTableModel;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrDelHGConfirmData;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrDelHGConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17870897;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SELECTDELHG = "SELECTDELHG";
    List<SJctrPortHGIndex> targetPortHGIndexList = null;
    ArrayList<SJctrPortHostGroupTableKey> targetPortHGTblKeyList = null;
    ArrayList<SJmoPortDetail> targetPortDetail = null;
    ArrayList<SJmoPortAttributeInfo> targetPortAttribute = null;
    static final SJctrHGInfoComparator HGINFO_COMP = new SJctrHGInfoComparator();
    public static int DELHG_ERR1 = 107001;

    public SJctrDelHGConfirmDC() throws SJcException {
        super(17870897);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrConfirmTableModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> confirmDataList = this.getCache(SJctrDelHGConfirmData.class);
        if (confirmDataList != null && confirmDataList.size() == 1) {
            SJctrDelHGConfirmData confirmData = (SJctrDelHGConfirmData)confirmDataList.get(0);
            List<SJctrPortHostGroupTableKey> portHGTableKey = confirmData.getPortHGTblKeyList();
            List<SJmoPortDetail> portDetail = confirmData.getPortDetailList();
            List<SJmoPortAttributeInfo> portAttr = confirmData.getPortAttributeList();
            if (portHGTableKey == null || portHGTableKey.size() <= 0 || portDetail == null || portDetail.size() <= 0 || portAttr == null || portAttr.size() <= 0) {
                SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            SJctrError err = new SJctrError(10, 22, DELHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrDelHGConfirmDC.this.getDataObjectModel(SJctrDelHGConfirmDC.KEY_TABLE);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrDelHGConfirmDC.this.makeHGProperty(selectedRows);
            }
        });
    }

    private void makeHGProperty(List<Object> selectedRowList) {
        if (selectedRowList.size() == 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
            return;
        }
        if (selectedRowList.size() > 1) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRowList.size());
            return;
        }
        SJctrHGPropertySelectData hgProperty = new SJctrHGPropertySelectData();
        SJctrPortHostGroupTableKey tblKeyData = (SJctrPortHostGroupTableKey)selectedRowList.get(0);
        SJmoPortDetail portDtl = this.searchPortDtl(tblKeyData.getPortHostGroupInfo());
        hgProperty.setData(portDtl, tblKeyData.getHostGroupInfo());
        ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
        dialogList.add(hgProperty);
        HashMap map = new HashMap();
        map.put("HG_PROPERTY_SELECT_DATA", dialogList);
        List<?> confirmDataList = this.getCache(SJctrDelHGConfirmData.class);
        SJctrDelHGConfirmData confirmData = (SJctrDelHGConfirmData)confirmDataList.get(0);
        if (confirmData.getPortAttributeList() != null) {
            map.put("CONFIRM_PORTATTR", confirmData.getPortAttributeList());
        } else {
            map.put("CONFIRM_PORTATTR", new ArrayList());
        }
        if (confirmData.getAllRsgList() != null) {
            map.put("CONFIRM_RSG", confirmData.getAllRsgList());
        } else {
            map.put("CONFIRM_RSG", new ArrayList());
        }
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrHGPropertyDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    SJmoPortDetail searchPortDtl(SJmoPortIndex port) {
        SJmoPortDetail portDtl = null;
        List<?> confirmDataList = this.getCache(SJctrDelHGConfirmData.class);
        SJctrDelHGConfirmData confirmData = (SJctrDelHGConfirmData)confirmDataList.get(0);
        List<SJmoPortDetail> portDtlList = confirmData.getPortDetailList();
        int dtlIndex = Collections.binarySearch(portDtlList, port);
        if (dtlIndex >= 0) {
            portDtl = portDtlList.get(dtlIndex);
        }
        return portDtl;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrDelHGConfirmData.class);
        map.put(SJctrDelHGConfirmData.class, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    public static enum SELECT_HG_MSG implements SJctrNotifyState
    {
        DETAIL;

    }
}

