/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editportsiscsi;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.SJctrEditIscsiPortsData;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrEditIscsiPortsChapUsersAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;
    private List<SJmoPortDetail> mPortDetailList = null;
    private HashSet<SJctrEditIscsiPortsData.CHECKBOX_ITEM> mCheckBoxSet;
    List<SJctrError> resultData = null;
    SanResponse result = null;
    private Map<String, SJctrIscsiOperationError> errorMap = new TreeMap<String, SJctrIscsiOperationError>();
    private SJctrError representativeError = null;

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003 + 5.0;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    public void setApplyList(List<SJmoPortDetail> portDetailList, HashSet<SJctrEditIscsiPortsData.CHECKBOX_ITEM> checkBoxSet) {
        this.mPortDetailList = portDetailList;
        this.mCheckBoxSet = checkBoxSet;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null || this.mPortDetailList == null || this.mCheckBoxSet == null) {
            SJctrLogUty.error("SJctrEditIscsiPortsInitiatorUsersAC", "applyStart", "Parameter is invalid.");
            return;
        }
        try {
            SanRequest requestData = supplier.newRequest("iSCSIupdateiScsiInitiatorUsers");
            SanList reqPortList = requestData.newList("iScsiPorts");
            for (SJmoPortDetail portDetail : this.mPortDetailList) {
                SanObject iscsiPorts = reqPortList.addObj();
                iscsiPorts.putInt("Id", (int)portDetail.getSPort());
                SanObject iscsiInitiator = iscsiPorts.newObj("iScsiInitiator");
                SanObject iscsiUser = iscsiInitiator.newObj("iScsiUser");
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.CHAP_USER_NAME)) {
                    iscsiUser.putString("UserId", portDetail.getStrUserName());
                }
                if (!this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.SECRET)) continue;
                iscsiUser.putString("Secret", portDetail.getStrSecret());
            }
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (iSCSIupdateiScsiInitiatorUsers)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (iSCSIupdateiScsiInitiatorUsers)");
            this.getErrorMapInfo(resultObject);
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfaced error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.error(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private void getErrorMapInfo(Object resultObject) throws SanDataException {
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        SanList iScsiPortList = responseData.getList("iScsiPorts");
        for (SanObject iScsiPort : iScsiPortList) {
            SanObject errInfo = iScsiPort.getObj("ErrorInfo");
            int[] errMsgId2 = errInfo.getIntArray("MessageId");
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort((short)iScsiPort.getInt("Id"));
            String errorPortIndex = portIndex.toString();
            if (this.errorMap.containsKey(errorPortIndex)) continue;
            if (0 != errMsgId2[1]) {
                SJctrLogUty.info(this.title, "getMapPortErrorInfo", "Port : " + errorPortIndex + ", Error : " + errMsgId2);
            }
            SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2, portIndex);
            this.errorMap.put(errorPortIndex, iscsiError);
        }
    }

    protected void setApplyResult() {
        SJctrLogUty.info(this.title, "setApplyResult", "start.");
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (this.errorMap.size() > 0) {
            this.resultData = new ArrayList<SJctrError>(this.mPortDetailList.size());
            for (SJmoPortIndex sJmoPortIndex : this.mPortDetailList) {
                SJctrError error = this.errorMap.get(sJmoPortIndex.toString());
                this.resultData.add(error);
            }
        }
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

