/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames.SJctrConfirmSelectedLoginIscsiNamesTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames.SJctrDeleteLoginIscsiNamesAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames.SJctrDeleteLoginIscsiNamesConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames.SJctrDeleteLoginIscsiNamesConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLoginIscsiNameInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoPortLoginIscsiNameInfo;

public class SJctrDeleteLoginIscsiNamesSubWizard
extends SJctrSubWizard {
    public static final String KEY_DISP_TITLE = "DEL_ISCSI_NAMES";
    private static final Class<?> CONFIRM_DC = SJctrDeleteLoginIscsiNamesConfirmDC.class;

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLoginIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject relDispDataObj = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relDispDataObj);
            List<SJmoIscsiName> selDataList = dc.getProxy().getCache("KEY_SELECTED_ISCSI_NAMES");
            if (null == selDataList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(12, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selDataList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(12, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoPortLoginIscsiNameInfo> portLoginIscsiNameInfoList = SJctrIscsiUtility.getSJmoPortLoginIscsiNameInfoList(dc);
            Collections.sort(portLoginIscsiNameInfoList);
            TreeMap<String, SJmoPortIndex> portIndexMap = new TreeMap<String, SJmoPortIndex>();
            for (SJmoIscsiName iscsiNameInfo : selDataList) {
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(iscsiNameInfo.getSPort());
                portIndexMap.put(portIndex.getIndexKey(), portIndex);
            }
            ArrayList<SJmoPortIndex> portIndexList = new ArrayList<SJmoPortIndex>(portIndexMap.values());
            List<SJmoIscsiName> iscsiNameList = this.getIscsiNamesFromPortLoginIscsiNames(portLoginIscsiNameInfoList, portIndexList);
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selDataList.size());
            for (SJmoIscsiName iscsiNameInfo : selDataList) {
                int index = Collections.binarySearch(iscsiNameList, iscsiNameInfo);
                if (index >= 0) continue;
                dc.getLogUty().putlog("constructConfirmData", "Selected Login iScsi name info is not exist.");
                SJctrError err = new SJctrError(12, 22, 206514);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(iscsiNameInfo, err);
                errList.add(errData);
            }
            this.createError(dc, selDataList, errList);
            SJctrDeleteLoginIscsiNamesConfirmData confirmData = new SJctrDeleteLoginIscsiNamesConfirmData();
            confirmData.setLoginIscsiNameList(iscsiNameList);
            confirmData.setNeedData(dc);
            confirmData.setPortIndexList(portIndexList);
            ArrayList<SJctrDeleteLoginIscsiNamesConfirmData> confirmDataList = new ArrayList<SJctrDeleteLoginIscsiNamesConfirmData>();
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrDeleteLoginIscsiNamesConfirmData.class, confirmDataList);
            SJctrDeleteLoginIscsiNamesAC ac = new SJctrDeleteLoginIscsiNamesAC();
            ac.setApplyData(confirmData);
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", KEY_DISP_TITLE);
        return guidance;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    private List<SJmoIscsiName> getIscsiNamesFromPortLoginIscsiNames(List<SJmoPortLoginIscsiNameInfo> portLoginIscsiNameInfoList, List<SJmoPortIndex> portIndexList) {
        ArrayList<SJmoIscsiName> retList = new ArrayList<SJmoIscsiName>();
        for (SJmoPortIndex portIndex : portIndexList) {
            int index = Collections.binarySearch(portLoginIscsiNameInfoList, portIndex);
            if (index < 0) continue;
            SJmoPortLoginIscsiNameInfo portLoginIscsiNameInfo = portLoginIscsiNameInfoList.get(index);
            ArrayList<SJmoIscsiName> iscsiLoginNameList = portLoginIscsiNameInfo.getAlPortIscsiName();
            retList.addAll(iscsiLoginNameList);
        }
        Collections.sort(retList);
        return retList;
    }

    private void createError(SJctrWizardWindowDC dc, List<SJmoIscsiName> transInfoList, List<SJctrErrorColumnData> errList) {
        if (!errList.isEmpty()) {
            SJctrConfirmSelectedLoginIscsiNamesTableModel errTable = new SJctrConfirmSelectedLoginIscsiNamesTableModel();
            errTable.setPaging(false);
            errTable.setDataController(dc);
            errTable.setBasicDataList(transInfoList);
            errTable.initGuidance(this.getComUtility());
            errTable.createModelDirect();
            errTable.divideModelData(dc.getProxy().getModelDataMap());
            errTable.makeDataModel();
            SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
            errDc.setParameter(errTable, errList);
            SJctrError errInfo = errDc.getRepresentativeError(errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }
}

