/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.editchapuser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.editchapuser.SJctrEditChapUserApplyInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.editchapuser.SJctrEditChapUserConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;

public class SJctrEditChapUserDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17832033;
    private static final String DISP_TITLE = "EDIT_CHAP_USER";
    private static final String KEY_PORT_ID = "COM_PORT_ID";
    private static final String KEY_USER_NAME_TITLE = "COM_USER_NAME_TITLE";
    private static final String KEY_USER_NAME_TXT = "COM_USER_NAME_TXT";
    private static final String KEY_SECRET_TITLE = "COM_SECRET_TITLE";
    private static final String KEY_SECRET_TXT = "COM_SECRET_TXT";
    private static final String KEY_RE_ENTER_SECRET_TXT = "COM_RE_ENTER_SECRET_TXT";
    private static final String KEY_CHECKBOX = "COM_CHECKBOX";
    private Set<String> CHAP_USER_NAME_SET = new HashSet<String>();
    private SJmoChapUserInfo OLD_CHAP_USER_INFO = new SJmoChapUserInfo();

    public SJctrEditChapUserDC() throws SJcException {
        super(17832033);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortChapUserInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    protected void initDataModel() {
        SJctrSimpleDataModel userNameTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_USER_NAME_TITLE, userNameTitle);
        userNameTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_CHAP_USER_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_USER_NAME_TXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_CHAP_USER_MSG.SEL_CHANGE));
        SJctrSimpleDataModel secretTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_SECRET_TITLE, secretTitle);
        secretTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_CHAP_USER_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_SECRET_TXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_CHAP_USER_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_RE_ENTER_SECRET_TXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_CHAP_USER_MSG.SEL_CHANGE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    protected void initListener() {
        this.addMessageEventListener(EDIT_CHAP_USER_MSG.SEL_CHANGE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> chapUserList = this.getCache("KEY_SELECTED_CHAP_USERS");
        if (chapUserList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (chapUserList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoPortDetail> mPortDetailList = SJctrIscsiUtility.getSJmoPortDetailList(this);
            List<SJmoPortChapUserInfo> mChapUserList = SJctrIscsiUtility.getSJmoPortChapUserInfoList(this);
            SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            List<?> editChapUserList = this.getCache("KEY_SELECTED_CHAP_USERS");
            SJmoChapUserInfo editChapUser = null;
            Object selectedChapUserInfo = editChapUserList.get(0);
            editChapUser = selectedChapUserInfo instanceof SJctrChapUserWithTgInfo ? ((SJctrChapUserWithTgInfo)selectedChapUserInfo).getChapUserInfo() : (SJmoChapUserInfo)selectedChapUserInfo;
            List<SJmoChapUserInfo> chapUserList = SJctrIscsiUtility.getSpecifiedPortChapUserInfo(mChapUserList, editChapUser.getSPort());
            int chapUserIndex = Collections.binarySearch(chapUserList, editChapUser);
            if (chapUserIndex < 0) {
                this.logUty.putlog("checkConstructData", "Inherited CHAP user info is not exist.");
                throw SJctrIscsiUtility.makeException(206515);
            }
            for (SJmoChapUserInfo chapUserInfo : chapUserList) {
                if (editChapUser.getStrUserName().equals(chapUserInfo.getStrUserName())) {
                    this.OLD_CHAP_USER_INFO = chapUserInfo;
                    continue;
                }
                this.CHAP_USER_NAME_SET.add(chapUserInfo.getStrUserName());
            }
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(mPortDetailList, editChapUser);
            SJctrDataObject mgrData = this.getManageData();
            mgrData.setData(KEY_PORT_ID, portDetail.getStrPortDisplayName());
            this.initializeUserNameArea(editChapUser);
            this.initializeSecretArea();
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrSimpleDataModel secretTitle;
            SJctrCheckBoxDataModel secretCheck;
            SJctrEditChapUserConfirmData confirmData = new SJctrEditChapUserConfirmData();
            SJctrEditChapUserApplyInfo newChapUserInfo = new SJctrEditChapUserApplyInfo();
            newChapUserInfo.setSPort(this.OLD_CHAP_USER_INFO.getSPort());
            newChapUserInfo.setStrUserName(this.OLD_CHAP_USER_INFO.getStrUserName());
            newChapUserInfo.setOldChapUserName(this.OLD_CHAP_USER_INFO.getStrUserName());
            newChapUserInfo.setAlIscsiTargets(this.OLD_CHAP_USER_INFO.getAlIscsiTargets());
            SJctrSimpleDataModel userNameTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_USER_NAME_TITLE);
            SJctrCheckBoxDataModel userNameCheck = (SJctrCheckBoxDataModel)userNameTitle.getDataModel(KEY_CHECKBOX);
            if (userNameCheck.isSelect()) {
                SJctrTextBoxDataModel userNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
                if (userNameTextBox.getValue().length() == 0) {
                    throw SJctrIscsiUtility.makeException(206197);
                }
                newChapUserInfo.setStrUserName(this.checkAndGetUserNameArea());
                newChapUserInfo.setEditChapUserName(true);
            }
            if ((secretCheck = (SJctrCheckBoxDataModel)(secretTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SECRET_TITLE)).getDataModel(KEY_CHECKBOX)).isSelect()) {
                newChapUserInfo.setStrSecret(this.checkSecretAndReEntSecretAndGetSecretArea());
            }
            ArrayList<SJctrEditChapUserApplyInfo> newChapUserInfoList = new ArrayList<SJctrEditChapUserApplyInfo>(1);
            newChapUserInfoList.add(newChapUserInfo);
            confirmData.setEditNewChapUserInfoList(newChapUserInfoList);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditChapUserConfirmData> confirmDataList = new ArrayList<SJctrEditChapUserConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditChapUserConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
            List<SJmoPortDetail> portDetailList = this.getCache(SJmoGetPortDetail.class);
            SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
            iscsiUtil.checkPortSecurityMsg(portDetailList, this.OLD_CHAP_USER_INFO.getAlIscsiTargets(), this);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    private void initializeUserNameArea(SJmoChapUserInfo chapUser) {
        SJctrSimpleDataModel userNameTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_USER_NAME_TITLE);
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)userNameTitle.getDataModel(KEY_CHECKBOX);
        checkBox.setSelect(false);
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        textBox.setValue(chapUser.getStrUserName());
        textBox.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
    }

    private void initializeSecretArea() {
        SJctrSimpleDataModel secretTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SECRET_TITLE);
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)secretTitle.getDataModel(KEY_CHECKBOX);
        checkBox.setSelect(false);
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        SJctrTextBoxDataModel reEnterTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_RE_ENTER_SECRET_TXT);
        secretTextBox.setTrim(false);
        reEnterTextBox.setTrim(false);
        secretTextBox.setValue("");
        reEnterTextBox.setValue("");
        secretTextBox.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
    }

    private String checkAndGetUserNameArea() {
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TXT);
        String newUserName = textBox.getValue();
        if (this.CHAP_USER_NAME_SET.contains(newUserName)) {
            throw SJctrIscsiUtility.makeException(206215);
        }
        return newUserName;
    }

    private String checkSecretAndReEntSecretAndGetSecretArea() {
        String newReEntSecret;
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TXT);
        SJctrTextBoxDataModel reEnterTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_RE_ENTER_SECRET_TXT);
        String newSecret = secretTextBox.getValue();
        if (newSecret.compareTo(newReEntSecret = reEnterTextBox.getValue()) != 0) {
            throw SJctrIscsiUtility.makeException(206221);
        }
        return newSecret;
    }

    public static enum EDIT_CHAP_USER_MSG implements SJctrNotifyState
    {
        SEL_CHANGE;

    }
}

