/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsConfirmTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrEditIscsiTargetsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17831839;
    private static final String KEY_TABLE_SEL_ISCSI_TARGETS = "COM_TABLE_ISCSI_TARGETS";
    private static final String KEY_DETAIL = "COM_DETAIL";

    public SJctrEditIscsiTargetsConfirmDC() throws SJcException {
        super(17831839);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrEditIscsiTargetsConfirmTableModel tblIscsi = new SJctrEditIscsiTargetsConfirmTableModel();
        tblIscsi.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS, tblIscsi);
        this.addDataObjectModel(KEY_DETAIL, SJctrIscsiUtility.addItemSelectEventListener(new SJctrButtonDataModel(), EDIT_TARGETS_CNF_MSG.SELECT_DETAIL));
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_TARGETS_CNF_MSG.SELECT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsConfirmDC.this.detailAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        List<?> listConfirmData = this.getCache(SJctrEditIscsiTargetsConfirmData.class);
        if (listConfirmData == null || listConfirmData.size() == 0) {
            this.getLogUty().putlog("checkStartData", "Confirmation data list is invalid.");
            throw SJctrIscsiUtility.makeException(107005);
        }
        SJctrEditIscsiTargetsConfirmData confirmData = (SJctrEditIscsiTargetsConfirmData)listConfirmData.get(0);
        if (confirmData == null) {
            this.getLogUty().putlog("checkStartData", "Confirmation data is null.");
            throw SJctrIscsiUtility.makeException(107005);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEditIscsiTargetsConfirmData confirmData = (SJctrEditIscsiTargetsConfirmData)this.getProxy().getCache(SJctrEditIscsiTargetsConfirmData.class).get(0);
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
        if (table instanceof SJctrEditIscsiTargetsConfirmTableModel) {
            ((SJctrEditIscsiTargetsConfirmTableModel)table).setBasicDataList(confirmData.getIscsiTargetList());
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        List<?> listConfirmData = this.getCache(SJctrEditIscsiTargetsConfirmData.class);
        HashMap retMap = new HashMap();
        retMap.put(SJctrEditIscsiTargetsConfirmData.class.getName(), listConfirmData);
        return retMap;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) {
        List<?> confirmDataList = this.getCache(SJctrEditIscsiTargetsConfirmData.class);
        SJctrEditIscsiTargetsConfirmData confirmData = (SJctrEditIscsiTargetsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    private void detailAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
            List<Object> rowData = table.getSelectedRowData();
            HashMap param = new HashMap();
            param.put("KEY_SELECTED_ISCSI_TARGETS", rowData);
            param.put(SJmoGetPortDetail.class.getName(), SJctrIscsiUtility.getSJmoPortDetailList(this));
            param.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this));
            SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrIscsiTargetPropertiesDC.class, param);
            this.addUpdateDisp(dialogRelated);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        SJctrEditIscsiTargetsConfirmData confirmData = (SJctrEditIscsiTargetsConfirmData)this.getProxy().getCache(SJctrEditIscsiTargetsConfirmData.class).get(0);
        List<SJmoIscsiTargetInfo> rowDataList = confirmData.getIscsiTargetList();
        SJctrEditIscsiTargetsConfirmTableModel confirmTable = (SJctrEditIscsiTargetsConfirmTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
        confirmTable.setBasicDataList(rowDataList);
        confirmTable.setBasicData(SJmoGetPortDetail.class, confirmData.getNeedDataMap().get(SJmoGetPortDetail.class.getName()));
        confirmTable.setBasicData(SJmoGetPortAttributeInfo.class, confirmData.getNeedDataMap().get(SJmoGetPortAttributeInfo.class.getName()));
        confirmTable.makeDataModel();
        List tempList = (List)destErrorList.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        ArrayList<SJmoIscsiTargetInfo> searchRowDataList = new ArrayList<SJmoIscsiTargetInfo>(rowDataList);
        Collections.sort(searchRowDataList);
        for (SJctrIscsiOperationError error : errorList) {
            SJmoIscsiTargetIndex iscsiTgIndex = (SJmoIscsiTargetIndex)error.getKey();
            int index = Collections.binarySearch(searchRowDataList, iscsiTgIndex);
            if (0 > index) continue;
            SJmoIscsiTargetInfo editIscsiTgInfo = (SJmoIscsiTargetInfo)searchRowDataList.get(index);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(editIscsiTgInfo, error);
            errColumnList.add(errColumn);
        }
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS, errTable);
        errTable.initialize(confirmTable, errColumnList, new SJctrErrorColumnDataComparator());
    }

    public static enum EDIT_TARGETS_CNF_MSG implements SJctrNotifyState
    {
        SELECT_DETAIL;

    }
}

