/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.hostproperties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.hostproperties.SJctrHostPropertiesSummaryModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.hostproperties.SJctrHostPropertiesTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrHostPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664548;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE_ISCSI_TARGETS = "COM_TABLE_ISCSI_TARGETS";
    public static final String KEY_SELECTED_ISCSI_NAME = "KEY_SELECTED_HOSTS";

    public SJctrHostPropertiesDC() throws SJcException {
        super(34664548);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> hostList = this.getCache(KEY_SELECTED_ISCSI_NAME);
        if (null == hostList) {
            this.logUty.putlog("checkStartData", "Host information list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == hostList.size()) {
            this.logUty.putlog("checkStartData", "Size of Host information list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<?> hostList = this.getCache(KEY_SELECTED_ISCSI_NAME);
            SJmoIscsiName iscsiNameInfo = (SJmoIscsiName)hostList.get(0);
            List<SJmoPortIscsiTargetInfo> portIscsiList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            List<SJmoPortDetail> portDetailInfo = SJctrIscsiUtility.getSJmoPortDetailList(this);
            SJctrHostPropertiesSummaryModel summary = (SJctrHostPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.setHbaIscsiName(iscsiNameInfo);
            summary.setHostName(iscsiNameInfo);
            summary.setPortID(portDetailInfo, iscsiNameInfo);
            summary.setNumberOfIscsiTargets(iscsiNameInfo);
            SJctrHostPropertiesTableModel tbl = (SJctrHostPropertiesTableModel)this.getDataObjectModel(KEY_TABLE_ISCSI_TARGETS);
            ArrayList<SJmoIscsiTargetInfo> basicDataList = new ArrayList<SJmoIscsiTargetInfo>();
            ArrayList<SJmoIscsiTargetIndex> iscsiList = iscsiNameInfo.getAlIscsiTargets();
            for (SJmoIscsiTargetIndex index : iscsiList) {
                SJmoIscsiTargetInfo iscsiTargetInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, index);
                if (iscsiTargetInfo == null) continue;
                basicDataList.add(iscsiTargetInfo);
            }
            if (iscsiList.size() != basicDataList.size()) {
                this.getLogUty().putlog("checkConstructData", "No iSCSI Target in the list.");
                throw SJctrIscsiUtility.makeException(206513);
            }
            Collections.sort(basicDataList, new SJctrIscsiTargetAliasComparator());
            tbl.setBasicDataList(basicDataList);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrHostPropertiesSummaryModel());
        SJctrHostPropertiesTableModel iscsiTargetsTable = new SJctrHostPropertiesTableModel();
        iscsiTargetsTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_ISCSI_TARGETS, iscsiTargetsTable);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

